/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.ValueMap;
import java.awt.Color;
import java.util.Map;

public abstract class ColorMap
extends ValueMap {
    protected ColorVector uniqueValueVector = new ColorVector();
    private ColorVector missingColorVector = new ColorVector();
    private StringVector missingLabelVector = new StringVector();
    public final ColorPipe uniqueValue = this.uniqueValueVector;
    public final ColorPipe missingColor = this.missingColorVector;
    public final StringPipe missingLabel = this.missingLabelVector;
    protected Color missingReplacement = ColorProperty.getDefaultColor();

    public ColorMap() {
        this.uniqueValueVector.setOwner(this);
        this.missingColorVector.setOwner(this);
        this.missingLabelVector.setOwner(this);
    }

    public void setMissingReplacement(Color c) {
        if (c == null) {
            throw new IllegalArgumentException("Color can not be null.");
        }
        this.missingReplacement = c;
        this.setModified();
    }

    public Color getMissingReplacement() {
        return this.missingReplacement;
    }

    public void setMissingReplacement(Color c, MissingValues missingValue) {
        this.setMissingReplacementImpl(c, missingValue);
    }

    public Color getMissingReplacement(MissingValues missingValue) {
        Color result = this.missingReplacement;
        Color c = (Color)this.getMissingReplacementImpl(missingValue);
        if (c != null) {
            result = c;
        }
        return result;
    }

    @Override
    public void setReplaceMissingValues(boolean replace) {
        super.setReplaceMissingValues(replace);
    }

    @Override
    public void setReplaceMissingValues(boolean replace, MissingValues missingValue) {
        super.setReplaceMissingValues(replace, missingValue);
    }

    protected ColorVector getMissingColorVector() {
        return this.missingColorVector;
    }

    protected StringVector getMissingLabelVector() {
        return this.missingLabelVector;
    }

    protected void initMissingValueVectors() {
        this.missingColorVector.removeAllValues();
        this.missingLabelVector.removeAllValues();
        if (this.isLabelMissingValuesAny()) {
            if (this.isLabelMissingValues()) {
                this.missingColorVector.addValue(this.getMissingReplacement());
                this.missingLabelVector.addValue(this.getMissingValueLabel());
            } else {
                Map m = this.getMissingValueInfoTable();
                for (Map.Entry e : m.entrySet()) {
                    ValueMap.MissingValueInfoEntry entry = (ValueMap.MissingValueInfoEntry)e.getValue();
                    if (!entry.isLabelVisible()) continue;
                    Color replacement = (Color)entry.getReplacement();
                    if (replacement == null) {
                        replacement = this.getMissingReplacement();
                    }
                    this.missingColorVector.addValue(replacement);
                    this.missingLabelVector.addValue(entry.getLabel());
                }
            }
        }
    }
}

