/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Accumulator;
import com.sas.graphics.util.gtk.MissingValueException;

public class BidirectionalAccumulator
extends Accumulator {
    private double upperTotal;
    private double lowerTotal;

    public BidirectionalAccumulator() {
        double sv;
        this.upperTotal = sv = this.getStartValue();
        this.lowerTotal = sv;
    }

    @Override
    protected void reset() {
        double sv;
        this.upperTotal = sv = this.getStartValue();
        this.lowerTotal = sv;
        this.lastIndex = -1;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        double r;
        if (index == this.lastIndex) {
            return this.lastValue;
        }
        double value = this.input.getValue(index);
        if (value >= this.getStartValue()) {
            value = Math.abs(value);
            if (this.getPostAccumulate()) {
                r = this.upperTotal;
                this.upperTotal += value;
            } else {
                this.upperTotal += value;
                r = this.upperTotal;
            }
        } else {
            value = Math.abs(value);
            if (this.getPostAccumulate()) {
                r = this.lowerTotal;
                this.lowerTotal -= value;
            } else {
                this.lowerTotal -= value;
                r = this.lowerTotal;
            }
        }
        this.lastIndex = index;
        this.lastValue = r;
        return r;
    }

    public double[] getAccumulation() {
        AInitAction ia = new AInitAction();
        this.init(ia);
        int n = ia.getValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                this.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        double[] result = new double[]{this.lowerTotal, this.upperTotal};
        return result;
    }
}

