/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.Style;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.TickMarkStyle;
import java.awt.Color;

public class AxisStyle
extends Style {
    public static final int LENGTH_UNITS_FONT_HEIGHT_PERCENTAGE = 3;
    public static final int LENGTH_UNITS_WORLD_COORDINATE = 4;
    protected Color axisLineColor;
    protected boolean titleOn;
    protected boolean labelsOn;
    protected boolean secondaryLabelsOn;
    protected boolean axisLineOn;
    protected boolean majorTickMarksOn;
    protected boolean minorTickMarksOn;
    protected boolean showThinnedTicks;
    private TextStyle titleStyle;
    private TextStyle labelStyle;
    private TextStyle secondaryLabelStyle;
    private TickMarkStyle majorTickStyle;
    private TickMarkStyle minorTickStyle;
    private int lineWidth;
    private double titleSpace;
    private double titleEndSpace;
    private double verticalLabelSpace;
    private double horizontalLabelSpace;
    private double labelStaggerSpace;
    private int minimumLabelFontSize = 8;
    private int titleMarkerId;
    private boolean titleMarkerVisible = false;
    private int titleMarkerSize;
    private double titleMarkerSpace = 4.0;
    private int stipplePattern = 65280;
    private int stippleFactor = 0;
    private boolean titlePositionedAtMax = false;
    private int lengthUnits = 3;
    private boolean tickBoxOn;
    private LineStyle tickBoxStyle;
    private Color tickBoxBackground;
    private Color background = null;

    public AxisStyle() {
        this.axisLineColor = Color.black;
        this.titleOn = true;
        this.labelsOn = true;
        this.axisLineOn = true;
        this.majorTickMarksOn = true;
        this.minorTickMarksOn = false;
        this.showThinnedTicks = true;
        this.titleStyle = new TextStyle();
        this.labelStyle = new TextStyle();
        this.secondaryLabelStyle = new TextStyle();
        this.majorTickStyle = new TickMarkStyle();
        this.majorTickStyle.setLength(0.5);
        this.minorTickStyle = new TickMarkStyle();
        this.minorTickStyle.setLength(0.25);
        this.lineWidth = 1;
        this.titleSpace = 0.25;
        this.titleEndSpace = 0.0;
        this.verticalLabelSpace = 0.0;
        this.horizontalLabelSpace = 0.25;
        this.labelStaggerSpace = 0.0;
        this.tickBoxOn = false;
        this.tickBoxStyle = new LineStyle();
        this.tickBoxBackground = null;
    }

    public AxisStyle(AxisStyle as) {
        this.axisLineColor = as.axisLineColor;
        this.titleOn = as.titleOn;
        this.labelsOn = as.labelsOn;
        this.axisLineOn = as.axisLineOn;
        this.majorTickMarksOn = as.majorTickMarksOn;
        this.minorTickMarksOn = as.minorTickMarksOn;
        this.titleStyle = new TextStyle(as.titleStyle);
        this.labelStyle = new TextStyle(as.labelStyle);
        this.secondaryLabelStyle = new TextStyle(as.secondaryLabelStyle);
        this.majorTickStyle = new TickMarkStyle(as.majorTickStyle);
        this.minorTickStyle = new TickMarkStyle(as.minorTickStyle);
        this.lineWidth = as.lineWidth;
    }

    public void setAxisLineColor(Color color) {
        this.axisLineColor = color;
    }

    public void setTitleOn(boolean trueOrFalse) {
        this.titleOn = trueOrFalse;
    }

    public void setLabelsOn(boolean trueOrFalse) {
        this.labelsOn = trueOrFalse;
    }

    public void setAxisLineOn(boolean trueOrFalse) {
        this.axisLineOn = trueOrFalse;
    }

    public void setMajorTickMarksOn(boolean trueOrFalse) {
        this.majorTickMarksOn = trueOrFalse;
    }

    public void setMinorTickMarksOn(boolean trueOrFalse) {
        this.minorTickMarksOn = trueOrFalse;
    }

    public void setTitleStyle(TextStyle style) {
        this.titleStyle = style;
    }

    public void setLabelStyle(TextStyle style) {
        this.labelStyle = style;
    }

    public void setSecondaryLabelStyle(TextStyle style) {
        this.secondaryLabelStyle = style;
    }

    public void setMajorTickStyle(TickMarkStyle style) {
        this.majorTickStyle = style;
    }

    public void setMinorTickStyle(TickMarkStyle style) {
        this.minorTickStyle = style;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public void setLineStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getLineStipplePattern() {
        return this.stipplePattern;
    }

    public int getLineStippleFactor() {
        return this.stippleFactor;
    }

    public Color getAxisLineColor() {
        return this.axisLineColor;
    }

    public boolean isTitleOn() {
        return this.titleOn;
    }

    public boolean isLabelsOn() {
        return this.labelsOn;
    }

    public boolean isAxisLineOn() {
        return this.axisLineOn;
    }

    public boolean isMajorTickMarksOn() {
        return this.majorTickMarksOn;
    }

    public boolean isMinorTickMarksOn() {
        return this.minorTickMarksOn;
    }

    public TextStyle getTitleStyle() {
        return this.titleStyle;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public TextStyle getSecondaryLabelStyle() {
        return this.secondaryLabelStyle;
    }

    public TickMarkStyle getMajorTickStyle() {
        return this.majorTickStyle;
    }

    public TickMarkStyle getMinorTickStyle() {
        return this.minorTickStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public double getTitleSpace() {
        return this.titleSpace;
    }

    public void setTitleSpace(double titleSpace) {
        this.titleSpace = titleSpace;
    }

    public double getTitleEndSpace() {
        return this.titleEndSpace;
    }

    public void setTitleEndSpace(double titleEndSpace) {
        this.titleEndSpace = titleEndSpace;
    }

    public double getVerticalLabelSpace() {
        return this.verticalLabelSpace;
    }

    public void setVerticalLabelSpace(double verticalLabelSpace) {
        this.verticalLabelSpace = verticalLabelSpace;
    }

    public double getHorizontalLabelSpace() {
        return this.horizontalLabelSpace;
    }

    public void setHorizontalLabelSpace(double horizontalLabelSpace) {
        this.horizontalLabelSpace = horizontalLabelSpace;
    }

    public double getLabelStaggerSpace() {
        return this.labelStaggerSpace;
    }

    public void setLabelStaggerSpace(double labelStaggerSpace) {
        this.labelStaggerSpace = labelStaggerSpace;
    }

    public boolean isShowThinnedTicks() {
        return this.showThinnedTicks;
    }

    public void setShowThinnedTicks(boolean showThinnedTicks) {
        this.showThinnedTicks = showThinnedTicks;
    }

    public int getMinimumLabelFontSize() {
        return this.minimumLabelFontSize;
    }

    public void setMinimumLabelFontSize(int minimumLabelFontSize) {
        this.minimumLabelFontSize = minimumLabelFontSize;
    }

    public int getTitleMarkerId() {
        return this.titleMarkerId;
    }

    public int getTitleMarkerSize() {
        return this.titleMarkerSize;
    }

    public boolean isTitleMarkerVisible() {
        return this.titleMarkerVisible;
    }

    public void setTitleMarkerId(int titleMarkerId) {
        this.titleMarkerId = titleMarkerId;
    }

    public void setTitleMarkerSize(int titleMarkerSize) {
        this.titleMarkerSize = titleMarkerSize;
    }

    public void setTitleMarkerVisible(boolean titleMarkerVisible) {
        this.titleMarkerVisible = titleMarkerVisible;
    }

    public double getTitleMarkerSpace() {
        return this.titleMarkerSpace;
    }

    public void setTitleMarkerSpace(double space) {
        this.titleMarkerSpace = space;
    }

    public boolean isSecondaryLabelsOn() {
        return this.secondaryLabelsOn;
    }

    public void setSecondaryLabelsOn(boolean b) {
        this.secondaryLabelsOn = b;
    }

    public boolean isTitlePositionedAtMax() {
        return this.titlePositionedAtMax;
    }

    public void setTitlePositionedAtMax(boolean titlePositionedAtMax) {
        this.titlePositionedAtMax = titlePositionedAtMax;
    }

    public int getLengthUnits() {
        return this.lengthUnits;
    }

    public void setLengthUnits(int lengthType) {
        if (lengthType != 3 && lengthType != 4) {
            throw new IllegalArgumentException("Length type must be one of AxisStyle.LENGTH_UNITS_FONT_HEIGHT_PERCENTAGE or AxisStyle.LENGTH_TYPE_PIXEL");
        }
        this.lengthUnits = lengthType;
    }

    public boolean isTickBoxOn() {
        return this.tickBoxOn;
    }

    public void setTickBoxOn(boolean on) {
        this.tickBoxOn = on;
    }

    public LineStyle getTickBoxStyle() {
        return this.tickBoxStyle;
    }

    public void setTickBoxStyle(LineStyle style) {
        this.tickBoxStyle = style;
    }

    public Color getTickBoxBackground() {
        return this.tickBoxBackground;
    }

    public void setTickBoxBackground(Color c) {
        this.tickBoxBackground = c;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c) {
        this.background = c;
    }
}

