/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.gl.Axis;
import java.awt.Color;
import java.awt.Font;

public class AxisMetrics {
    private double lineLength;
    private double lowExtender;
    private double highExtender;
    private double insideLength;
    private double outsideLength;
    private double width;
    private double height;
    private String fitAlgorithm;
    private boolean titleTruncated;
    private boolean titleSplit;
    private String displayTitle;
    private boolean labelsThinned;
    private int[] visibleLabelIndices;
    private Font labelFont;

    public double getHeight() {
        return this.height;
    }

    public double getHighExtender() {
        return this.highExtender;
    }

    public double getInsideLength() {
        return this.insideLength;
    }

    public double getLineLength() {
        return this.lineLength;
    }

    public double getLowExtender() {
        return this.lowExtender;
    }

    public double getOutsideLength() {
        return this.outsideLength;
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setHighExtender(double highExtender) {
        this.highExtender = highExtender;
    }

    public void setInsideLength(double insideLength) {
        this.insideLength = insideLength;
    }

    public void setLineLength(double lineLength) {
        this.lineLength = lineLength;
    }

    public void setLowExtender(double lowExtender) {
        this.lowExtender = lowExtender;
    }

    public void setOutsideLength(double outsideLength) {
        this.outsideLength = outsideLength;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public String getFittingAlgorithm() {
        return this.fitAlgorithm;
    }

    public void setFittingAlgorithm(String fitAlgorithm) {
        this.fitAlgorithm = fitAlgorithm;
    }

    public static void drawMetrics(Channel channel, AxisMetrics am, Axis axis) {
        channel.glPolygonMode(2);
        double lineOffset = axis.getLineOffset();
        channel.glPushAttrib(0);
        if (axis.getOrientation() == 1) {
            double sign = axis.isPrimary() ? -1.0 : 1.0;
            channel.glDisable(6);
            channel.glColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            channel.glBegin(2);
            channel.glVertex(lineOffset, 0.0);
            channel.glVertex(lineOffset + am.getLineLength(), 0.0);
            channel.glVertex(lineOffset + am.getLineLength(), sign * am.getHeight());
            channel.glVertex(lineOffset, sign * am.getHeight());
            channel.glEnd();
            channel.glEnable(6);
            int pattern = 4;
            channel.glLineStipple(SASLinePatterns.getStippleFactor((int)pattern), SASLinePatterns.getStipplePattern((int)pattern));
            channel.glColor(new Color(0.0f, 1.0f, 0.0f, 0.5f));
            channel.glBegin(1);
            channel.glVertex(-am.getLowExtender() + lineOffset, 0.0);
            channel.glVertex(-am.getLowExtender() + lineOffset + am.getWidth(), 0.0);
            channel.glVertex(-am.getLowExtender() + lineOffset + am.getWidth(), sign * am.getHeight());
            channel.glVertex(-am.getLowExtender() + lineOffset, sign * am.getHeight());
            channel.glVertex(-am.getLowExtender() + lineOffset, 0.0);
            channel.glEnd();
        } else if (axis.getOrientation() == 2) {
            double sign = axis.isPrimary() ? -1.0 : 1.0;
            channel.glDisable(6);
            channel.glColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            channel.glBegin(2);
            channel.glVertex(0.0, lineOffset);
            channel.glVertex(sign * am.getWidth(), lineOffset);
            channel.glVertex(sign * am.getWidth(), lineOffset + am.getLineLength());
            channel.glVertex(0.0, lineOffset + am.getLineLength());
            channel.glEnd();
            channel.glEnable(6);
            int pattern = 4;
            channel.glLineStipple(SASLinePatterns.getStippleFactor((int)pattern), SASLinePatterns.getStipplePattern((int)pattern));
            channel.glColor(new Color(0.0f, 1.0f, 0.0f, 0.5f));
            channel.glBegin(1);
            channel.glVertex(0.0, -am.getLowExtender() + lineOffset);
            channel.glVertex(sign * am.getWidth(), -am.getLowExtender() + lineOffset);
            channel.glVertex(sign * am.getWidth(), -am.getLowExtender() + am.getHeight() + lineOffset);
            channel.glVertex(0.0, -am.getLowExtender() + am.getHeight() + lineOffset);
            channel.glVertex(0.0, -am.getLowExtender() + lineOffset);
            channel.glEnd();
        } else if (axis.getOrientation() == 3) {
            double sign = axis.isPrimary() ? -1.0 : 1.0;
            channel.glDisable(6);
            channel.glColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            channel.glBegin(2);
            channel.glVertex(0.0, 0.0, lineOffset);
            channel.glVertex(0.0, 0.0, lineOffset + am.getLineLength());
            channel.glVertex(0.0, sign * am.getHeight(), lineOffset + am.getLineLength());
            channel.glVertex(0.0, sign * am.getHeight(), lineOffset);
            channel.glEnd();
            channel.glEnable(6);
            int pattern = 4;
            channel.glLineStipple(SASLinePatterns.getStippleFactor((int)pattern), SASLinePatterns.getStipplePattern((int)pattern));
            channel.glColor(new Color(0.0f, 1.0f, 0.0f, 0.5f));
            channel.glBegin(1);
            channel.glVertex(0.0, 0.0, -am.getLowExtender() + lineOffset);
            channel.glVertex(0.0, 0.0, -am.getLowExtender() + lineOffset + am.getWidth());
            channel.glVertex(0.0, sign * am.getHeight(), -am.getLowExtender() + lineOffset + am.getWidth());
            channel.glVertex(0.0, sign * am.getHeight(), -am.getLowExtender() + lineOffset);
            channel.glVertex(0.0, 0.0, -am.getLowExtender() + lineOffset);
            channel.glEnd();
        }
        channel.glColor(Color.blue);
        channel.setMarkerSize(10);
        channel.setMarkerType(1);
        channel.glBegin(4);
        channel.glVertex(0.0, 0.0);
        channel.glEnd();
        channel.glPopAttrib();
    }

    public void setTitleTruncated(boolean titleTruncated) {
        this.titleTruncated = titleTruncated;
    }

    public boolean isTitleTruncated() {
        return this.titleTruncated;
    }

    public void setTitleSplit(boolean titleSplit) {
        this.titleSplit = titleSplit;
    }

    public boolean isTitleSplit() {
        return this.titleSplit;
    }

    public void setDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public void setLabelsThinned(boolean labelsThinned) {
        this.labelsThinned = labelsThinned;
    }

    public boolean labelsHaveBeenThinned() {
        return this.labelsThinned;
    }

    public void setVisibleLabelIndices(int[] visibleLabelIndices) {
        this.visibleLabelIndices = visibleLabelIndices;
    }

    public int[] getVisibleLabelIndices() {
        return this.visibleLabelIndices;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }
}

