/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import java.util.Vector;

public abstract class ASwitch
extends Element {
    private Vector choices = new Vector();
    public final NumericProperty whichChoice = new NumericProperty(this, true);

    public ASwitch(ATransform transform) {
        super(transform);
    }

    @Override
    public void init(AInitAction initAction) {
        int n = this.choices.size();
        super.init(initAction);
        for (int i = 0; i < n; ++i) {
            Element e = (Element)this.choices.elementAt(i);
            if (e == null) continue;
            e.init(initAction);
        }
    }

    @Override
    public void reset(AResetAction resetAction) {
        int n = this.choices.size();
        super.reset(resetAction);
        for (int i = 0; i < n; ++i) {
            Element e = (Element)this.choices.elementAt(i);
            if (e == null) continue;
            e.reset(resetAction);
        }
    }

    public void addChoice(Element aChoice) {
        this.choices.addElement(aChoice);
    }

    public Element getChoice(int i) {
        Element result = null;
        int size = this.choices.size();
        if (size != 0) {
            if (i > size - 1) {
                i = size - 1;
            }
            result = (Element)this.choices.elementAt(i);
        }
        return result;
    }

    public boolean removeChoice(Element aChoice) {
        return this.choices.removeElement(aChoice);
    }

    public void removeAllChoices() {
        this.choices.removeAllElements();
    }

    public int getChoiceCount() {
        return this.choices.size();
    }

    @Override
    public void render(ABuildAction buildAction) {
        try {
            int choiceIndex = (int)this.whichChoice.getValue(buildAction.getValueIndex());
            Element choice = this.getChoice(choiceIndex);
            if (choice != null) {
                choice.buildOne(buildAction);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    @Override
    protected void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
    }

    @Override
    protected boolean canHaveSelectDetails() {
        return false;
    }
}

