/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.MissingValueException;

public abstract class ASplineConnector
extends FilledLineConnector {
    protected double[][] cardinalBasis;
    protected double[] controlPointX;
    protected double[] controlPointY;
    protected double[] controlPointZ;
    protected double splineTension = 0.25;
    protected int precision = 10;
    protected int cPtCount = 1;
    protected int[] observations;
    BoundingBox scratchBB = new BoundingBox();

    public ASplineConnector(ATransform transform) {
        super(transform);
        this.calculateBasisFunctions();
    }

    public void setSplineTension(double spt) {
        this.splineTension = spt;
        this.calculateBasisFunctions();
    }

    public double getSplineTension() {
        return this.splineTension;
    }

    public void setPrecision(int nsegs) {
        this.precision = nsegs;
        this.calculateBasisFunctions();
    }

    public int getPrecision() {
        return this.precision;
    }

    protected void calculateBasisFunctions() {
        this.cardinalBasis = new double[this.precision][4];
        double s = (1.0 - this.splineTension) / 2.0;
        double inc = 1.0 / (double)this.precision;
        for (int i = 0; i < this.precision; ++i) {
            double u = (double)i * inc;
            double uu = u * u;
            double uuu = uu * u;
            this.cardinalBasis[i][0] = -s * uuu + 2.0 * s * uu - s * u;
            this.cardinalBasis[i][1] = (2.0 - s) * uuu + (s - 3.0) * uu + 1.0;
            this.cardinalBasis[i][2] = (s - 2.0) * uuu + (3.0 - 2.0 * s) * uu + s * u;
            this.cardinalBasis[i][3] = s * uuu - s * uu;
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        int index = bBoxAction.getValueIndex();
        try {
            this.controlPointX[this.cPtCount] = this.pointX.getValue(index);
            this.controlPointY[this.cPtCount] = this.pointY.getValue(index);
            this.controlPointZ[this.cPtCount] = this.pointZ.getValue(index);
        }
        catch (MissingValueException mve) {
            this.controlPointX[this.cPtCount] = Double.POSITIVE_INFINITY;
            this.controlPointY[this.cPtCount] = Double.POSITIVE_INFINITY;
            this.controlPointZ[this.cPtCount] = Double.POSITIVE_INFINITY;
        }
        if (this.cPtCount <= 1) {
            this.controlPointX[0] = this.controlPointX[1];
            this.controlPointY[0] = this.controlPointY[1];
            this.controlPointZ[0] = this.controlPointZ[1];
        }
        if (this.cPtCount > 2) {
            this.addToBoundingBox(bBoxAction);
            for (int i = 0; i < 3; ++i) {
                this.controlPointX[i] = this.controlPointX[i + 1];
                this.controlPointY[i] = this.controlPointY[i + 1];
                this.controlPointZ[i] = this.controlPointZ[i + 1];
            }
        } else {
            ++this.cPtCount;
        }
    }

    private void addToBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d v = null;
        Vec3d center = null;
        double d = 0.0;
        int index = bBoxAction.getValueIndex();
        boolean filled = false;
        if (!(Double.isInfinite(this.controlPointX[0]) || Double.isInfinite(this.controlPointX[1]) || Double.isInfinite(this.controlPointX[2]) || Double.isInfinite(this.controlPointX[3]))) {
            try {
                filled = this.fillOn.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            Vec3d point = bBoxAction.pt1;
            BoundingBox box = bBoxAction.getElementBoundingBox();
            if (filled) {
                center = bBoxAction.pt2;
                d = this.fillToPlane.getDistance();
                v = this.fillToPlane.getNormal();
            }
            for (int i = 0; i < this.precision; ++i) {
                point.x = this.controlPointX[0] * this.cardinalBasis[i][0] + this.controlPointX[1] * this.cardinalBasis[i][1] + this.controlPointX[2] * this.cardinalBasis[i][2] + this.controlPointX[3] * this.cardinalBasis[i][3];
                point.y = this.controlPointY[0] * this.cardinalBasis[i][0] + this.controlPointY[1] * this.cardinalBasis[i][1] + this.controlPointY[2] * this.cardinalBasis[i][2] + this.controlPointY[3] * this.cardinalBasis[i][3];
                point.z = this.controlPointZ[0] * this.cardinalBasis[i][0] + this.controlPointZ[1] * this.cardinalBasis[i][1] + this.controlPointZ[2] * this.cardinalBasis[i][2] + this.controlPointZ[3] * this.cardinalBasis[i][3];
                if (filled) {
                    center.set(point.x, point.y, point.z);
                    if (v.x != 0.0) {
                        center.x = (point.x + d) / 2.0;
                        this.scratchBB.setSize(Math.abs(d - point.x), 0.0, 0.0);
                    } else if (v.y != 0.0) {
                        center.y = (point.y + d) / 2.0;
                        this.scratchBB.setSize(0.0, Math.abs(d - point.y), 0.0);
                    } else if (v.z != 0.0) {
                        center.z = (point.z + d) / 2.0;
                        this.scratchBB.setSize(0.0, 0.0, Math.abs(d - point.z));
                    }
                    this.scratchBB.setCenter(center);
                    this.scratchBB.intersection(this.fillBoundingBox);
                    box.union(this.scratchBB);
                }
                box.union(point);
            }
        }
    }
}

