/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;

public abstract class ARectangle
extends Element {
    public final NumericProperty sizeX = new NumericProperty(this, true);
    public final NumericProperty sizeY = new NumericProperty(this, true);
    public final NumericProperty coordX = new NumericProperty(this, true);
    public final NumericProperty coordY = new NumericProperty(this, true);
    public final NumericProperty coordZ = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final IntegerProperty edgeWidth = new IntegerProperty(this, true);
    public final IntegerProperty edgePattern = new IntegerProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final IntegerProperty origin = new IntegerProperty(this, true);
    public static final int ORIGIN_CENTER = 0;
    public static final int ORIGIN_CENTER_BOTTOM = 1;
    public static final int ORIGIN_CENTER_TOP = 2;
    public static final int ORIGIN_CENTER_LEFT = 3;
    public static final int ORIGIN_CENTER_RIGHT = 4;
    public static final int ORIGIN_LOWER_LEFT = 5;
    private boolean two2D = false;

    public ARectangle(ATransform transform) {
        super(transform);
        this.origin.setValue(0);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
        this.edgePattern.setValue(-1);
        this.sizeX.setValue(1.0);
        this.sizeY.setValue(1.0);
    }

    public void set2D(boolean trueOrFalse) {
        this.two2D = trueOrFalse;
    }

    public boolean is2D() {
        return this.two2D;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double dx = this.sizeX.getValue(index);
        double dy = this.sizeY.getValue(index);
        size.set(dx, dy, 0.0);
        ARectangle.computeCenter(dx, dy, this.origin.getValue(index), center);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    public static void computeCenter(double sizeX, double sizeY, int origin, Vec3d center) {
        ARectangle.computeCenter(sizeX, sizeY, 0.0, 0.0, 0.0, origin, center);
    }

    public static void computeCenter(double sizeX, double sizeY, double coordX, double coordY, double coordZ, int origin, Vec3d center) {
        double sXHalf = sizeX / 2.0;
        double sYHalf = sizeY / 2.0;
        switch (origin) {
            default: {
                center.set(coordX, coordY + sYHalf, coordZ + 0.0);
                break;
            }
            case 0: {
                center.set(coordX, coordY, coordZ);
                break;
            }
            case 2: {
                center.set(coordX, coordY - sYHalf, coordZ);
                break;
            }
            case 3: {
                center.set(coordX + sXHalf, coordY, coordZ);
                break;
            }
            case 4: {
                center.set(coordX - sXHalf, coordY, coordZ);
                break;
            }
            case 5: {
                center.set(coordX + sXHalf, coordY + sYHalf, coordZ);
            }
        }
    }
}

