/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;

public abstract class ALineSegment
extends Element {
    public final NumericProperty beginX = new NumericProperty(this, true);
    public final NumericProperty beginY = new NumericProperty(this, true);
    public final NumericProperty beginZ = new NumericProperty(this, true);
    public final NumericProperty endX = new NumericProperty(this, true);
    public final NumericProperty endY = new NumericProperty(this, true);
    public final NumericProperty endZ = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final NumericProperty lineWidth = new NumericProperty(this, true);
    public final BooleanProperty disableAntialiasingForHorizontalOrVerticalLines = new BooleanProperty(this, true);
    public final IntegerProperty linePattern = new IntegerProperty(this, true);
    public final NumericProperty drawCount = new NumericProperty(this, true);
    protected int stipplePattern;
    protected int stippleFactor;
    protected double stippleScaleFactor = 1.0;
    protected int skinType = 0;
    protected float DPIScaleFactor = 1.0f;

    public ALineSegment(ATransform transform) {
        super(transform);
        this.lineWidth.setValue(1.0);
        this.stipplePattern = 65280;
        this.stippleFactor = 0;
        this.linePattern.setValue(-1);
        this.disableAntialiasingForHorizontalOrVerticalLines.setValue(false);
        this.drawCount.setValue(1.0);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        BoundingBox box = bBoxAction.getElementBoundingBox();
        bBoxAction.pt1.set(this.beginX.getValue(index), this.beginY.getValue(index), this.beginZ.getValue(index));
        box.union(bBoxAction.pt1);
        bBoxAction.pt1.set(this.endX.getValue(index), this.endY.getValue(index), this.endZ.getValue(index));
        box.union(bBoxAction.pt1);
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    public void setStippleScaleFactor(double fac) {
        this.stippleScaleFactor = fac;
    }

    public double getStippleScaleFactor() {
        return this.stippleScaleFactor;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setDPIScaleFactor(float fac) {
        this.DPIScaleFactor = fac;
    }

    public float getDPIScaleFactor() {
        return this.DPIScaleFactor;
    }
}

