/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.StringProperty;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;

public abstract class ALabel
extends Element {
    public final NumericProperty coordX = new NumericProperty(this, true);
    public final NumericProperty coordY = new NumericProperty(this, true);
    public final NumericProperty coordZ = new NumericProperty(this, true);
    public final StringProperty fontName = new StringProperty(this, true);
    public final IntegerProperty fontStyle = new IntegerProperty(this, true);
    public final IntegerProperty fontSize = new IntegerProperty(this, true);
    public final IntegerProperty minimumFontSize = new IntegerProperty(this, true);
    public final NumericProperty angle = new NumericProperty(this, true);
    public final IntegerProperty horizontalJustification = new IntegerProperty(this, true);
    public final IntegerProperty verticalJustification = new IntegerProperty(this, true);
    public final BooleanProperty fit = new BooleanProperty(this, true);
    public final BooleanProperty truncate = new BooleanProperty(this, true);
    public final NumericProperty maxHeight = new NumericProperty(this, true);
    public final NumericProperty maxWidth = new NumericProperty(this, true);
    public final BooleanProperty trimOn = new BooleanProperty(this, true);
    public final StringProperty string = new StringProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty backgroundColor = new ColorProperty(this, true);
    public final BooleanProperty backgroundColorOn = new BooleanProperty(this, true);
    public final BooleanProperty shadowOn = new BooleanProperty(this, true);
    public final ColorProperty shadowColor = new ColorProperty(this, true);
    public final IntegerProperty shadowOffsetX = new IntegerProperty(this, true);
    public final IntegerProperty shadowOffsetY = new IntegerProperty(this, true);
    public final BooleanProperty outlineOn = new BooleanProperty(this, true);
    public final IntegerProperty outlineWidth = new IntegerProperty(this, true);
    public final NumericProperty backlight = new NumericProperty(this, true);
    public final BooleanProperty backgroundEdgeOn = new BooleanProperty(this, true);
    public final ColorProperty backgroundEdgeColor = new ColorProperty(this, true);
    public Insets backgroundPad = new Insets(0, 0, 0, 0);
    private Font font = null;
    public boolean originalAlignments = false;
    private static double[] ranges = new double[]{0.39269908169872414, 1.1780972450961724, 1.9634954084936207, 2.748893571891069, 3.5342917352885173, 4.319689898685965, 5.105088062083414, 5.890486225480862, 6.675884388878311};
    private static int[] hJustification = new int[]{0, 0, 1, 2, 2, 2, 1, 0, 0, 0, 0, 1, 2};
    private static int[] vJustification = new int[]{1, 3, 3, 3, 1, 0, 0, 0, 1, 1, 3, 3, 3};

    public ALabel(ATransform transform) {
        super(transform);
        this.angle.setValue(0.0);
        this.horizontalJustification.setValue(0);
        this.verticalJustification.setValue(2);
        this.trimOn.setValue(false);
        this.fit.setValue(false);
        this.truncate.setValue(false);
        this.maxHeight.setValue(Double.MAX_VALUE);
        this.maxWidth.setValue(Double.MAX_VALUE);
        Font f = FontManager.getDefaultFont();
        this.fontName.setValue(f.getName());
        this.fontStyle.setValue(f.getStyle());
        this.fontSize.setValue(f.getSize());
        this.backgroundColorOn.setValue(false);
        this.backgroundColor.setValue(Color.white);
        this.backgroundEdgeOn.setValue(false);
        this.backgroundEdgeColor.setValue(Color.black);
        this.shadowOn.setValue(false);
        this.shadowColor.setValue(Color.black);
        this.shadowOffsetX.setValue(2);
        this.shadowOffsetY.setValue(2);
        this.coordX.setValue(0.0);
        this.coordY.setValue(0.0);
        this.coordZ.setValue(0.0);
        this.outlineOn.setValue(false);
        this.outlineWidth.setValue(1);
        this.backlight.setValue(0.0);
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontName.setValue(font.getName());
        this.fontStyle.setValue(font.getStyle());
        this.fontSize.setValue(font.getSize());
    }

    public Font getFont() {
        Font result = this.font;
        if (result == null) {
            result = FontManager.getFont((String)this.fontName.getValue(), (int)this.fontStyle.getValue(), (int)this.fontSize.getValue());
        }
        return result;
    }

    public Font getFont(int index) throws MissingValueException {
        if (this.fontName.getPipe() != null || this.fontStyle.getPipe() != null || this.fontSize.getPipe() != null) {
            try {
                return FontManager.getFont((String)this.fontName.getValue(index), (int)this.fontStyle.getValue(index), (int)this.fontSize.getValue(index));
            }
            catch (MissingValueException e) {
                throw new MissingValueException();
            }
        }
        return this.getFont();
    }

    public static void getJustificationByAngle(double angle, int[] justifications) {
        int i;
        double offset = angle % (Math.PI * 2);
        if (offset < 0.0) {
            offset += Math.PI * 2;
        }
        for (i = 0; i < ranges.length && offset > ranges[i]; ++i) {
        }
        justifications[0] = hJustification[i];
        justifications[1] = vJustification[i];
    }
}

