/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MismatchedValueCountException;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import java.awt.Color;

public abstract class AIndexedSet
extends Element {
    public static final int PRIMITIVE_END = -1;
    public static final int EDGE_OFF = -2;
    public static final int PER_VERTEX = 0;
    public static final int PER_PRIMITIVE = 1;
    public static final int PER_SET = 2;
    public final NumericProperty coordX = new NumericProperty(this, false);
    public final NumericProperty coordY = new NumericProperty(this, false);
    public final NumericProperty coordZ = new NumericProperty(this, false);
    public final NumericProperty coordIndex = new NumericProperty(this, false);
    public final ColorProperty color = new ColorProperty(this, false);
    public final NumericProperty colorIndex = new NumericProperty(this, false);
    protected int colorScope;
    protected int numCoords;
    protected int numCoordIndexes;
    protected int numColorIndexes;
    protected int numColors;
    protected int greatestCoordIndex;
    protected int numPrimitives;

    protected AIndexedSet(ATransform transform) {
        super(transform);
        this.coordX.setValue(0.0);
        this.coordY.setValue(0.0);
        this.coordZ.setValue(0.0);
        this.color.setValue(Color.black);
        this.coordIndex.setValue(-1.0);
        this.colorIndex.setValue(-1.0);
        this.colorScope = 0;
        this.numCoordIndexes = 0;
        this.numColorIndexes = 0;
        this.greatestCoordIndex = 0;
        this.numPrimitives = 0;
    }

    @Override
    public void init(AInitAction initAction) {
        int greatestColorIndex = 0;
        int valueCount = 0;
        this.numColors = 0;
        this.greatestCoordIndex = 0;
        this.numPrimitives = 0;
        super.init(initAction);
        valueCount = initAction.getValueCount();
        initAction.pushValueCount();
        this.coordX.init(initAction);
        this.coordY.init(initAction);
        this.coordZ.init(initAction);
        this.numCoords = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.color.init(initAction);
        this.numColors = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.coordIndex.init(initAction);
        this.numCoordIndexes = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.colorIndex.init(initAction);
        this.numColorIndexes = initAction.getValueCount();
        initAction.popValueCount();
        if (this.colorScope == 2 && this.numColors != -1 && valueCount > this.numColors) {
            throw new MismatchedValueCountException("The number of indexed sets is greater than the number of colors");
        }
        try {
            if (this.numCoordIndexes != -1) {
                int i;
                int index = -1;
                for (i = 0; i < this.numCoordIndexes; ++i) {
                    index = (int)this.coordIndex.getValue(i);
                    this.greatestCoordIndex = Math.max(index, this.greatestCoordIndex);
                    if (index != -1) continue;
                    ++this.numPrimitives;
                }
                if (index != -1) {
                    ++this.numPrimitives;
                }
                if (this.numCoords != -1 && this.greatestCoordIndex >= this.numCoords) {
                    throw new MismatchedValueCountException("One or more indexes in the coordIndex property are greater than the number of coordinates");
                }
                if (this.numColors != -1) {
                    if (this.numColorIndexes == -1) {
                        switch (this.colorScope) {
                            case 0: {
                                if (this.greatestCoordIndex < this.numColors) break;
                                throw new MismatchedValueCountException("One or more indexes in the coordIndex property are greater than the number of colors");
                            }
                            case 1: {
                                if (this.numColors >= this.numPrimitives) break;
                                throw new RuntimeException("More primitives than colors.");
                            }
                        }
                    } else {
                        for (i = 0; i < this.numColorIndexes; ++i) {
                            index = (int)this.colorIndex.getValue(i);
                            greatestColorIndex = Math.max(index, greatestColorIndex);
                            if (index >= 0) continue;
                            if (this.colorScope == 0) {
                                if (!(this.coordIndex.getValue(i) >= 0.0)) continue;
                                throw new RuntimeException("Out of order primitive marker.");
                            }
                            if (this.colorScope != 1) continue;
                            throw new RuntimeException("Negative color index.");
                        }
                        if (greatestColorIndex >= this.numColors) {
                            throw new RuntimeException("Color index greater than number of colors");
                        }
                        if (this.colorScope == 0) {
                            if (this.numColorIndexes < this.numCoordIndexes) {
                                throw new RuntimeException("Not enough per vertex color indices.");
                            }
                        } else if (this.colorScope == 1 && this.numColorIndexes < this.numPrimitives) {
                            throw new RuntimeException("More primitives than colors.");
                        }
                    }
                }
            }
        }
        catch (MissingValueException mve) {
            throw new RuntimeException("A missing value was found in either the normalIndex or colorIndex Properties. These properties can not have missing values.");
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d pt = bBoxAction.pt1;
        BoundingBox box = bBoxAction.getElementBoundingBox();
        int coordI = 0;
        block7: for (int i = 0; i < this.numCoordIndexes; ++i) {
            try {
                coordI = (int)this.coordIndex.getValue(i);
                switch (coordI) {
                    case -2: 
                    case -1: {
                        break;
                    }
                    default: {
                        pt.x = this.coordX.getValue(coordI);
                        pt.y = this.coordY.getValue(coordI);
                        pt.z = this.coordZ.getValue(coordI);
                        box.union(pt);
                        break;
                    }
                }
                continue;
            }
            catch (MissingValueException mve) {
                while (i < this.numCoordIndexes) {
                    try {
                        if ((int)this.coordIndex.getValue(i) == -1) {
                            continue block7;
                        }
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    }

    public IndexDescriptor getCoordinateIndex(int primIndex) {
        IndexDescriptor indexDescriptor = new IndexDescriptor();
        indexDescriptor.firstIndex = -1;
        indexDescriptor.numIndices = 0;
        try {
            int i;
            int pi = 0;
            int index = 0;
            for (i = 0; i < this.numCoordIndexes && pi < primIndex; ++i) {
                if (this.coordIndex.getValue(i) != -1.0) continue;
                ++pi;
                index = i + 1;
            }
            if (index <= this.numCoordIndexes) {
                indexDescriptor.firstIndex = index;
                for (i = index; i < this.numCoordIndexes && this.coordIndex.getValue(i) != -1.0; ++i) {
                    ++indexDescriptor.numIndices;
                }
            }
            return indexDescriptor;
        }
        catch (MissingValueException mve) {
            Debug.println((String)"AIndexedSet: getCoordinateIndex() found a missing value");
            return indexDescriptor;
        }
    }

    public IndexDescriptor getColorIndex(int primIndex, IndexDescriptor coord) {
        IndexDescriptor indexDescriptor;
        switch (this.colorScope) {
            case 1: {
                indexDescriptor = new IndexDescriptor();
                if (this.numColors <= 0) {
                    indexDescriptor.firstIndex = -1;
                    indexDescriptor.numIndices = 0;
                    break;
                }
                indexDescriptor.firstIndex = primIndex;
                indexDescriptor.numIndices = 1;
                break;
            }
            case 2: {
                indexDescriptor = new IndexDescriptor();
                indexDescriptor.firstIndex = -1;
                indexDescriptor.numIndices = 0;
                break;
            }
            default: {
                indexDescriptor = coord;
            }
        }
        return indexDescriptor;
    }

    public void setColorScope(int scope) {
        if (scope >= 0 && scope <= 2) {
            this.colorScope = scope;
        }
    }

    public int getColorScope() {
        return this.colorScope;
    }

    public class IndexDescriptor {
        int numIndices = 0;
        int firstIndex = -1;
    }
}

