/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;

public abstract class ACone
extends Element {
    public final NumericProperty bottomRadius = new NumericProperty(this, true);
    public final NumericProperty height = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final BooleanProperty sideVisible = new BooleanProperty(this, true);
    public final BooleanProperty bottomVisible = new BooleanProperty(this, true);
    public final IntegerProperty precision = new IntegerProperty(this, true);
    public final IntegerProperty origin = new IntegerProperty(this, true);
    public static final int ORIGIN_CENTER = 0;
    public static final int ORIGIN_CENTER_LEFT = 1;
    public static final int ORIGIN_CENTER_RIGHT = 2;
    public static final int ORIGIN_CENTER_BOTTOM = 3;
    public static final int ORIGIN_CENTER_TOP = 4;
    protected static double[] x;
    protected static double[] z;
    protected static int lastPrecision;

    protected ACone(ATransform transform) {
        super(transform);
        this.fillOn.setValue(true);
        this.edgeOn.setValue(false);
        this.precision.setValue(16);
        this.bottomRadius.setValue(1.0);
        this.height.setValue(2.0);
        this.sideVisible.setValue(true);
        this.bottomVisible.setValue(true);
        this.origin.setValue(0);
    }

    protected static void computeCenter(double radius, double height, int origin, Vec3d center) {
        double thgt = height / 2.0;
        double bhgt = -1.0 * thgt;
        switch (origin) {
            case 1: {
                center.set(radius, 0.0, 0.0);
                break;
            }
            case 2: {
                center.set(-radius, 0.0, 0.0);
                break;
            }
            case 3: {
                center.set(0.0, thgt, 0.0);
                break;
            }
            case 4: {
                center.set(0.0, bhgt, 0.0);
                break;
            }
            default: {
                center.set(0.0, 0.0, 0.0);
            }
        }
    }

    protected static void calculatePoints(int precision) {
        x = new double[precision + 1];
        z = new double[precision + 1];
        double angle = 0.0;
        for (int i = 0; i <= precision; ++i) {
            angle = (double)i / (double)precision * (Math.PI * 2);
            ACone.x[i] = Math.cos(angle);
            ACone.z[i] = -Math.sin(angle);
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double radius = this.bottomRadius.getValue(index);
        double hgt = this.height.getValue(index);
        size.x = size.z = radius * 2.0;
        size.y = hgt;
        ACone.computeCenter(radius, hgt, this.origin.getValue(index), center);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    static {
        lastPrecision = -1;
        x = null;
        z = null;
    }
}

