/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public abstract class AAxis
extends Element {
    public final StringProperty labels = new StringProperty(this, false);
    public final StringProperty secondaryLabels = new StringProperty(this, false);
    public final NumericProperty labelOffset = new NumericProperty(this, false);
    public final NumericProperty minorTickOffset = new NumericProperty(this, false);
    public final NumericProperty majorTickOffset = new NumericProperty(this, false);
    public final ColorProperty labelColor = new ColorProperty(this, false);
    public final StringProperty title = new StringProperty(this, true);
    public final StringProperty shortTitle = new StringProperty(this, true);
    public final NumericProperty length = new NumericProperty(this, true);
    protected int orientation;
    protected AxisStyle style;
    protected int rawLabelCount = 0;
    protected Vector originalProcessedLabels = new Vector();
    protected double origin = 0.0;
    protected boolean primary = true;
    protected int labelOrientation = 2;
    protected int titlePosition = 1;
    public static final int TITLE_POSITION_BEGINNING = 0;
    public static final int TITLE_POSITION_CENTER = 1;
    public static final int TITLE_POSITION_END = 2;
    public static final int TITLE_POSITION_DATACENTER = 3;
    protected int titleFitPolicy = 0;
    public static final int TITLE_FIT_TRUNCATE = 0;
    public static final int TITLE_FIT_SPLIT = 1;
    public static final int TITLE_FIT_SPLITALWAYS = 2;
    protected int labelMargin = 2;
    protected boolean dropOn;
    protected int dropModValue;
    private Vec3d maximumSize = null;
    private Vec3d maximumTitleSize = null;
    public static final String NOLABELS = "nolabels";
    public static final String REVERTSIZE = "revertsize";
    public static final String STAGGER = "stagger";
    public static final String SPLIT = "split";
    public static final String TRUNCATE = "truncate";
    public static final String SHRINK = "shrink";
    public static final String TRUNCATEDROP = "truncatedrop";
    public static final String EXTENDEDSPLIT = "extendedsplit";
    public static final String EXTENDEDSPLITALWAYS = "extendedsplitalways";
    public static final String UNDOFORCEFIT = "undoforcefit";
    public static final String THIN = "thin";
    public static final String THINKEEPEND = "thinkeepend";
    public static final String THIN_INSIDE_TO_OUTSIDE = "thin_inside_to_outside";
    public static final String THIN_BEGINNING_TO_END = "thin_beginning_to_end";
    public static final String THIN_END_TO_BEGINNING = "thin_end_to_beginning";
    public static final String ANGLE45 = "angle45";
    public static final String ANGLE90 = "angle90";
    public static final String ANGLE270 = "angle270";
    public static final String ANGLE315 = "angle315";
    private Comparator labelAlignmentComparator;
    private int minorTickOffsetCount;
    private int majorTickOffsetCount;
    private int secondaryLabelCount;
    private boolean useLabelColorFromStyle = false;
    private PostFitProcessor postFitProcessor;
    protected boolean autoAlignTitle = false;
    protected boolean ignoreTitleAlignment = false;
    protected double dataLength;
    protected boolean hotelText = false;

    protected AAxis(ATransform transform) {
        super(transform);
        this.style = new AxisStyle();
        this.secondaryLabels.setValue("");
        this.labelAlignmentComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                LabelAlignment la1 = (LabelAlignment)o1;
                LabelAlignment la2 = (LabelAlignment)o2;
                if (la1.offset == la2.offset) {
                    return 0;
                }
                if (la1.offset < la2.offset) {
                    return -1;
                }
                return 1;
            }
        };
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        initAction.pushValueCount();
        this.labels.init(initAction);
        this.labelOffset.init(initAction);
        this.labelColor.init(initAction);
        this.rawLabelCount = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.minorTickOffset.init(initAction);
        this.minorTickOffsetCount = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.majorTickOffset.init(initAction);
        this.majorTickOffsetCount = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.secondaryLabels.init(initAction);
        this.secondaryLabelCount = initAction.getValueCount();
        initAction.popValueCount();
        if (this.secondaryLabelCount > 0 && this.secondaryLabelCount != this.rawLabelCount) {
            throw new IllegalStateException("secondaryLabels count (" + this.secondaryLabelCount + ") != label count (" + this.rawLabelCount + ")");
        }
    }

    public int getTitleFitPolicy() {
        return this.titleFitPolicy;
    }

    public void setTitleFitPolicy(int policy) {
        this.titleFitPolicy = policy;
    }

    public void setAutoAlignTitle(boolean auto) {
        this.autoAlignTitle = auto;
    }

    public boolean isAutoAlignTitle() {
        return this.autoAlignTitle;
    }

    public void setLength(double l) {
        if (!Double.isNaN(l)) {
            this.length.setValue(l);
        }
    }

    public double getLength() {
        try {
            double l = this.length.getValue(0);
            return l;
        }
        catch (MissingValueException e) {
            return 0.0;
        }
    }

    public void setUseLabelFromStyle(boolean useLabelColorFromStyle) {
        this.useLabelColorFromStyle = useLabelColorFromStyle;
    }

    public boolean isUseLabelFromStyle() {
        return this.useLabelColorFromStyle;
    }

    protected void orient(Vec3d v, double x, double y, double z) {
        this.orient(v, x, y, z, this.orientation);
    }

    protected abstract void orient(Vec3d var1, double var2, double var4, double var6, int var8);

    protected void drawLabel(LabelAlignment la, Vec3d pos, TextStyle tStyle, int textAngle, boolean changeFont, boolean useStyleColor) {
        try {
            Color c = useStyleColor ? tStyle.getColor() : this.labelColor.getValue(la.observation);
            this.drawLabel(la.observation, la.theLabel, pos.x, pos.y, pos.z, tStyle, c, 0.0, 0.0, textAngle, changeFont);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    protected void drawTitle(String label, double atX, double atY, double atZ, TextStyle tStyle) {
        this.drawLabel(-1, label, atX, atY, atZ, tStyle, tStyle.getColor(), 0.0, 0.0, tStyle.getAngle(), false);
    }

    protected abstract void drawLabel(int var1, String var2, double var3, double var5, double var7, TextStyle var9, Color var10, double var11, double var13, double var15, boolean var17);

    protected abstract void drawMajorTickMark(double var1, double var3, double var5, double var7, double var9, double var11, Color var13, int var14);

    protected abstract void drawMinorTickMark(double var1, double var3, double var5, double var7, double var9, double var11, Color var13, int var14);

    protected abstract void setLabelStyle(TextStyle var1);

    protected abstract void setJustificationStyles();

    public void setTitlePosition(int position) {
        this.titlePosition = position >= 0 && position <= 3 ? position : 1;
    }

    public void setOrientation(int anOrientation) {
        if (anOrientation >= 1 && anOrientation <= 3) {
            this.orientation = anOrientation;
            this.setJustificationStyles();
        }
    }

    public void setLabelOrientation(int anOrientation) {
        if (anOrientation >= 1 && anOrientation <= 3) {
            this.labelOrientation = anOrientation;
        }
    }

    public void setPrimary(boolean trueOrFalse) {
        this.primary = trueOrFalse;
    }

    public void setOrigin(double origin) {
        this.origin = origin;
    }

    public int getLabelOrientation() {
        return this.labelOrientation;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public double getOrigin() {
        return this.origin;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public void setDropOn(boolean trueOrFalse) {
        this.dropOn = trueOrFalse;
    }

    public boolean isDropOn() {
        return this.dropOn;
    }

    public void setDropModValue(int value) {
        if (value > 0) {
            this.dropModValue = value;
        }
    }

    public int getDropModValue() {
        return this.dropModValue;
    }

    protected void sortLabelsByOffset() {
        String secondaryLabel = "";
        this.originalProcessedLabels.setSize(this.rawLabelCount);
        this.originalProcessedLabels.trimToSize();
        for (int thisObs = 0; thisObs < this.rawLabelCount; ++thisObs) {
            double thisOffset;
            String thisLabel;
            try {
                thisLabel = this.labels.getValue(thisObs);
                thisOffset = this.labelOffset.getValue(thisObs);
            }
            catch (MissingValueException mve) {
                throw new IllegalStateException("Axis labels and offsets are not allowed to be missing.");
            }
            try {
                secondaryLabel = "";
                if (this.style.isSecondaryLabelsOn()) {
                    secondaryLabel = this.secondaryLabels.getValue(thisObs);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            LabelAlignment la = (LabelAlignment)this.originalProcessedLabels.get(thisObs);
            if (la == null) {
                la = new LabelAlignment(thisObs, thisLabel, thisOffset, secondaryLabel);
                this.originalProcessedLabels.set(thisObs, la);
                continue;
            }
            la.init(thisObs, thisLabel, thisOffset, secondaryLabel);
        }
        if (this.rawLabelCount > 0) {
            Collections.sort(this.originalProcessedLabels, this.labelAlignmentComparator);
        }
    }

    @Override
    public void reset(AResetAction resetAction) {
        super.reset(resetAction);
        this.labels.reset(resetAction);
        this.labelOffset.reset(resetAction);
    }

    protected void setLabels(StringPipe labels) {
        this.labels.connectFrom(labels);
    }

    protected void setLabelOffset(NumericPipe values) {
        this.labelOffset.connectFrom(values);
    }

    public void setStyle(AxisStyle aStyle) {
        if (aStyle != null) {
            this.style = aStyle;
        }
    }

    public void setLabelMargin(int margin) {
        this.labelMargin = margin;
    }

    public int getLabelMargin() {
        return this.labelMargin;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public AxisStyle getStyle() {
        return this.style;
    }

    public Vec3d getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Vec3d maximumSize) {
        this.maximumSize = maximumSize;
        this.setModified();
    }

    public void setMaximumTitleSize(Vec3d maximumTitleSize) {
        this.maximumTitleSize = maximumTitleSize;
    }

    public Vec3d getMaximumTitleSize() {
        return this.maximumTitleSize;
    }

    public void setDataLength(double l) {
        this.dataLength = l;
    }

    public double getDataLength() {
        return this.dataLength;
    }

    public void setHotelText(boolean b) {
        this.hotelText = b;
    }

    public boolean isHotelText() {
        return this.hotelText;
    }

    protected int getMinorTickOffsetCount() {
        return this.minorTickOffsetCount;
    }

    protected int getMajorTickOffsetCount() {
        return this.majorTickOffsetCount;
    }

    protected int getSecondaryLabelCount() {
        return this.secondaryLabelCount;
    }

    public void setPostFitProcessor(PostFitProcessor processor) {
        this.postFitProcessor = processor;
    }

    public PostFitProcessor getPostFitProcessor() {
        return this.postFitProcessor;
    }

    public static interface PostFitContext {
        public boolean isRendering();

        public String getFittingAlgorithm();

        public boolean labelsHaveBeenThinned();

        public int[] getVisibleLabelIndices();

        public void setDisplayLabels(String[] var1, double[] var2);

        public void setDisplayTitles(String var1, String var2);
    }

    public static interface PostFitProcessor {
        public void postFitUpdate(PostFitContext var1);
    }

    protected class LabelAlignment {
        public int observation;
        public double offset;
        public double space;
        public double width;
        public double height;
        public String rawLabel;
        public String theLabel;
        public boolean adjacentToAxis;
        public boolean drop;
        public double angleOffset;
        public Rectangle deviceCoords = new Rectangle();
        public boolean secondaryLabelDrop;
        public String secondaryLabel;
        public double secondaryLabelWidth;
        public double secondaryLabelHeight;

        public LabelAlignment(int anObservation, String label, double anOffset, String secondaryLabel) {
            this.init(anObservation, label, anOffset, secondaryLabel);
        }

        public LabelAlignment(LabelAlignment la) {
            this.set(la);
        }

        public void init(int anObservation, String label, double anOffset, String secondaryLabel) {
            this.rawLabel = label.trim();
            this.observation = anObservation;
            this.offset = anOffset;
            this.space = 0.0;
            this.height = 0.0;
            this.width = 0.0;
            this.angleOffset = 0.0;
            this.adjacentToAxis = true;
            this.drop = false;
            this.secondaryLabel = secondaryLabel == null ? null : secondaryLabel.trim();
            this.secondaryLabelWidth = 0.0;
            this.secondaryLabelHeight = 0.0;
            this.secondaryLabelDrop = false;
        }

        public void set(LabelAlignment la) {
            this.observation = la.observation;
            this.offset = la.offset;
            this.space = la.space;
            this.width = la.width;
            this.height = la.height;
            this.rawLabel = la.rawLabel;
            this.theLabel = la.theLabel;
            this.drop = la.drop;
            this.adjacentToAxis = la.adjacentToAxis;
            this.deviceCoords.setRect(la.deviceCoords);
            this.secondaryLabel = la.secondaryLabel;
            this.secondaryLabelWidth = la.secondaryLabelWidth;
            this.secondaryLabelHeight = la.secondaryLabelHeight;
            this.secondaryLabelDrop = la.secondaryLabelDrop;
        }
    }
}

