/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.client.BackupServiceConstants;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.dao.BackupNodeHelper;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.spi.BackupServiceHelper;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.backup.spi.SessionManager;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class PurgeProcessor {
    @Autowired
    @Qualifier(value="BackupService")
    BackupService backupService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration deploymentBackupConfig;
    @Autowired
    private BackupNodeHelper nodeHelper;
    UserServiceInterface userService;
    SessionServiceInterface sessionService;
    String username;
    String password;
    Lock lock;
    @Autowired
    BackupServerHelperDAO backupServer;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    @Autowired
    BackupServiceHelper helper;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    private UserConfigurationServiceInterface userConfService;
    private static Logger logger = LogManager.getLogger(PurgeProcessor.class);

    public Lock getLock() {
        return this.lock;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UserServiceInterface getUserService() {
        return this.userService;
    }

    public void setUserService(UserServiceInterface userService) {
        this.userService = userService;
    }

    public SessionServiceInterface getSessionService() {
        return this.sessionService;
    }

    public void setSessionService(SessionServiceInterface sessionService) {
        this.sessionService = sessionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        logger.info("Trying to aquire geode lock.");
        if (this.lock == null || this.lock.tryLock()) {
            logger.info("Purging old backups...");
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            BackupServiceSession session = null;
            try {
                SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)new User(this.username, this.password, true, true, true, true, Arrays.asList(new GrantedAuthority[0])), (Object)"aBigSecret"));
                List availableSASTiers = runtimeSASEnvironment.getAvailableTiers();
                List unreachableTiers = runtimeSASEnvironment.getUnreachableTiers();
                logger.debug("Get List of unreachable tiers during purge");
                ArrayList<String> unreachableHost = new ArrayList<String>();
                for (Object tiers : unreachableTiers) {
                    logger.debug("HostName::" + tiers.getHostName());
                    unreachableHost.add(tiers.getHostName());
                }
                logger.debug("Get List of actual reachable tiers");
                ArrayList<SASTier> actualReachableTiers = new ArrayList<SASTier>();
                for (SASTier tier : availableSASTiers) {
                    if (unreachableHost.contains(tier.getHostName())) continue;
                    actualReachableTiers.add(tier);
                    logger.debug("HostName::" + tier.getHostName());
                }
                this.helper.removeExcludedTiersFromSASTierList(actualReachableTiers);
                Set<BackupSourceNode> uniqueSourceNodes = this.nodeHelper.getUniqueElements(this.configBeanConverter.sasTierToBackupSourceNodeList(actualReachableTiers, runtimeSASEnvironment.getPrimaryMetdataTier()));
                logger.info("starting purge session");
                session = this.sessionManager.startSession(uniqueSourceNodes, "Purge");
                int daysToRetainBackups = this.deploymentBackupConfig.getRetentionPeriod();
                logger.debug("Retention period: " + daysToRetainBackups);
                List availableBackups = this.backupService.getAvailableBackups(session);
                Date currentDate = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
                Date purgeBeforeDate = DateUtils.addDays((Date)currentDate, (int)(-daysToRetainBackups));
                logger.info("Finding backups which were started before  " + BackupServiceConstants.iso8601format.format(purgeBeforeDate));
                if (!BackupServiceUtils.isEmpty(availableBackups)) {
                    boolean found = false;
                    for (BackupDetails backup : availableBackups) {
                        Date backupStartDate = backup.getStartTime();
                        if (!backupStartDate.before(purgeBeforeDate)) continue;
                        found = true;
                        String backupSessionId = backup.getName();
                        logger.debug("Purging backup with name: " + backupSessionId);
                        boolean purgeResult = this.backupServer.purge(uniqueSourceNodes, backupSessionId, session);
                        if (purgeResult) {
                            backup.setExpiredDate(new Date());
                            this.backupService.addToHistory(backup);
                            continue;
                        }
                        logger.warn(Message.format((String)RB.getStringResource("PurgeProcessor.unable.to.purge.backup.fmt"), (Object)backupSessionId));
                    }
                    if (found) {
                        logger.info(RB.getStringResource("PurgeProcessor.purge.operation.completed.txt"));
                    } else {
                        logger.info("None of the available backups meet purge criteria. Exiting.");
                    }
                } else {
                    logger.info("No backups are available. Exiting.");
                }
                this.purgeRemainingFiles(session, uniqueSourceNodes, purgeBeforeDate);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
            finally {
                try {
                    this.sessionManager.endSession(session, "Purge", false);
                    BackupServiceUtils.deleteTempDir();
                    if (this.lock != null) {
                        logger.info("Releasing geode lock.");
                        this.lock.unlock();
                    }
                }
                catch (Exception e) {
                    logger.error("Exception in finally block while purging", (Throwable)e);
                }
            }
        } else {
            logger.info("Unable to aquire geode lock. Exiting.");
        }
    }

    private void purgeRemainingFiles(BackupServiceSession session, Set<BackupSourceNode> uniqueSourceNodes, Date purgeBeforeDate) {
        try {
            if (purgeBeforeDate != null && session != null && purgeBeforeDate != null) {
                boolean purgeRemainingFiles = this.backupServer.purgeRemainingFiles(uniqueSourceNodes, session, new SimpleDateFormat("dd/MM/yyyy").format(purgeBeforeDate));
                if (purgeRemainingFiles) {
                    logger.info("Purging of remaining files created before purge date successful");
                } else {
                    logger.warn("Purging of remaining files created before purge date failed");
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occured while purging remaining files. Error:" + e.getMessage());
        }
    }
}

