/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.solstice.platform.core.access.IResults;
import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerContext;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.DeploymentAgentClient;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.spi.BackupSupportService;
import com.sas.svcs.backup.spi.RB;
import com.sas.text.Message;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Service(value="CONFIGDIR")
public class LevconfigBackupSupportService
implements BackupSupportService {
    private static final Logger logger = LogManager.getLogger(LevconfigBackupSupportService.class);
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfiguration;
    @Autowired
    @Qualifier(value="BackupServerHelperDAO")
    BackupServerHelperDAO helperDAO;

    @Override
    public BackupSourceDetails doSourceBackup(RuntimeSASEnvironment runtimeSASEnvironment, BackupTask backupTask, BackupOptions backupOptions, BackupServiceSession<?> session) throws BackupException {
        BackupSourceDetails srcBackupDetails = null;
        try {
            String excludesFilter;
            logger.info(RB.getStringResource("LevconfigBackupSupportService.starting.levconfig.backup.txt"));
            LinkedHashMap<String, String> optionalProps = new LinkedHashMap<String, String>();
            String configDir = BackupServiceUtils.getQuotedString(backupTask.getPerformOn().getSasConfig());
            optionalProps.put("-configdir", configDir);
            Properties properties = backupTask.getProperties();
            String sourceDir = this.createSourceDirString(properties);
            optionalProps.put("-sourcedirs", sourceDir);
            String includesFilter = properties.getProperty("includefilter");
            if (!BackupServiceUtils.isEmpty(includesFilter)) {
                optionalProps.put("-includefilter", includesFilter);
            }
            if (!BackupServiceUtils.isEmpty(excludesFilter = properties.getProperty("excludefilter"))) {
                optionalProps.put("-excludefilter", excludesFilter);
            }
            srcBackupDetails = this.helperDAO.backup(runtimeSASEnvironment, backupTask, session, optionalProps, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_BACKUP_FAILED);
            logger.info(RB.getStringResource("LevconfigBackupSupportService.levconfig.backup.completed.txt"));
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_BACKUP_FAILED.getErrorCode());
        }
        return srcBackupDetails;
    }

    @Override
    public Map<String, List<String>> getContentDetails(BackupSourceConfig sourceConfig, String operationName, BackupServiceSession session) throws BackupException {
        HashMap<String, List<String>> contentDetails = null;
        try {
            String centralVault = this.backupConfiguration.getSharedVaultLocation();
            BackupSourceConfig.BackupSource sourceType = sourceConfig.getSourceType();
            BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
            String hostName = sourceNode.getHostName();
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode, sourceType);
            String backupServerPath = context.getBackupServerPath();
            String sourceDetailsLoc = this.getContentFilestempLocation(backupServerPath, hostName, operationName, sourceType, centralVault);
            contentDetails = new HashMap<String, List<String>>();
            this.getCMUContentDetails(contentDetails, sourceDetailsLoc);
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException("Error encountered while trying to fetch levconfig content details. ", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        return contentDetails;
    }

    private String getContentFilestempLocation(String backupServerPath, String hostName, String operationName, BackupSourceConfig.BackupSource sourceType, String centralVault) throws BackupException {
        String tempcontentDetailsPath = null;
        String contentDetailsPath = null;
        try {
            File tempDir = BackupServiceUtils.getTempDir();
            String vaultBaselocation = backupServerPath + "/" + "Results";
            contentDetailsPath = vaultBaselocation + "/" + operationName + "/" + "backup" + "/" + BackupServerHelperDAO.BackupServerCommandConstants.SOURCE_TYPE_PARAMS.get(sourceType.toString()) + "/" + "packagedFiles";
            tempcontentDetailsPath = tempDir.getCanonicalPath() + "/" + operationName + "/" + BackupServerHelperDAO.BackupServerCommandConstants.SOURCE_TYPE_PARAMS.get(sourceType.toString()) + "/" + "packagedFiles";
            String[] paramsGetResult = new String[]{"pullFolder", hostName, contentDetailsPath, tempcontentDetailsPath};
            logger.debug("Trying to copy " + contentDetailsPath);
            IResults copyResult = DeploymentAgentClient.handleArgLine(paramsGetResult, paramsGetResult);
            if (copyResult.getStatus() != 0) {
                logger.error(Message.format((String)RB.getStringResource("LevconfigBackupSupportService.error.copying.packaged.folder.fmt"), (Object)contentDetailsPath, (Object)hostName));
            }
        }
        catch (IOException e) {
            logger.error(Message.format((String)RB.getStringResource("LevconfigBackupSupportService.error.copying.packaged.folder.fmt"), contentDetailsPath, (Object)hostName));
            throw new BackupException(Message.format((String)RB.getStringResource("LevconfigBackupSupportService.error.copying.packaged.folder.fmt"), contentDetailsPath, (Object)hostName), (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        return tempcontentDetailsPath;
    }

    private void prepareContentDetails(Document doc, Map<String, List<String>> contentDetails) {
        NodeList allPkgdFiles = doc.getElementsByTagName("PackagedFiles");
        if (allPkgdFiles != null) {
            for (int i = 0; i < allPkgdFiles.getLength(); ++i) {
                Node pkgdFiles = allPkgdFiles.item(i);
                String[] files = this.getAttributeValue(pkgdFiles, "List").split(",");
                if (files == null || files.length <= 0 || files.length == 1 && files[0].equals("")) continue;
                List<String> filesList = Arrays.asList(files);
                Node subDir = pkgdFiles.getParentNode();
                String subDirNameRelativePath = this.getAttributeValue(subDir, "RelativePath");
                Node Dir = subDir.getParentNode();
                String dirPath = this.getAttributeValue(Dir, "Path");
                File tmpDir = new File(dirPath);
                String fullPath = (dirPath = tmpDir.getParent()) + File.separator + subDirNameRelativePath;
                List<String> dirs = contentDetails.get(fullPath);
                if (dirs == null) {
                    dirs = new ArrayList<String>();
                }
                if (fullPath == null || contentDetails.containsKey(fullPath) || filesList == null || filesList.size() <= 0) continue;
                contentDetails.put(fullPath, filesList);
            }
        }
    }

    private void getCMUContentDetails(Map<String, List<String>> contentDetails, String sourceDetailsLoc) throws BackupException {
        File sourceDetailsDir = new File(sourceDetailsLoc);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("PackagedFiles");
            }
        };
        logger.debug("list of files:" + sourceDetailsDir.list());
        File[] CMUPackagaedFiles = sourceDetailsDir.listFiles(filter);
        if (CMUPackagaedFiles != null) {
            for (File CMUPackagaedFile : CMUPackagaedFiles) {
                try {
                    String ext = FilenameUtils.getExtension((String)CMUPackagaedFile.getCanonicalPath());
                    if (!"xml".equalsIgnoreCase(ext)) continue;
                    Document mainDoc = null;
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = null;
                    try {
                        db = dbf.newDocumentBuilder();
                        logger.info("Writing History to " + CMUPackagaedFile.getCanonicalPath());
                        mainDoc = db.parse(CMUPackagaedFile);
                        this.prepareContentDetails(mainDoc, contentDetails);
                    }
                    catch (IOException e) {
                        logger.error("Exception getting path of content file " + CMUPackagaedFile.getName(), (Throwable)e);
                        throw new BackupException("Error encountered while trying to fetch levconfig backup contents.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
                    }
                    catch (ParserConfigurationException e3) {
                        logger.error((Object)e3);
                        throw new BackupException("Error encountered while trying to fetc;h levconfig backup contents.", (Throwable)e3, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
                    }
                    catch (SAXException e) {
                        logger.error((Object)e);
                        throw new BackupException("Error encountered while trying to fetch levconfig backup contents.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
                    }
                }
                catch (IOException e) {
                    logger.error("Exception getting path of content file " + CMUPackagaedFile.getName(), (Throwable)e);
                    throw new BackupException("Error encountered while trying to fetch levconfig backup contents.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
                }
            }
        }
    }

    private String getAttributeValue(Node node, String attrName) {
        String textVal = null;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && attrs.getNamedItem(attrName) != null) {
            textVal = attrs.getNamedItem(attrName).getNodeValue();
        }
        return textVal;
    }

    private String createSourceDirString(Properties properties) {
        StringBuffer contextString = new StringBuffer();
        for (String string : properties.keySet()) {
            String dir = properties.getProperty(string);
            if (string.startsWith("SERVERCONTEXT:")) {
                logger.debug("Context Name = " + string + ", Context Dir = " + dir);
                if (contextString.length() > 0) {
                    contextString.append(",,");
                }
                contextString.append(dir);
                continue;
            }
            if ("includefilter".equals(string) || "excludefilter".equals(string)) continue;
            if (contextString.length() > 0) {
                contextString.append(",,");
            }
            contextString.append(dir);
        }
        return contextString.toString();
    }

    @Override
    public BackupSourceDetails doSourceRecovery(String backupId, RecoveryOptions recoveryOptions, BackupSourceDetails sourceBackup, BackupServiceSession session) throws BackupException {
        BackupSourceDetails sourceRecovery = null;
        try {
            logger.info(RB.getStringResource("LevconfigBackupSupportService.starting.levconfig.recovery.txt"));
            BackupSourceConfig srcConfig = sourceBackup.getSourceConfig();
            LinkedHashMap<String, String> optionalProps = new LinkedHashMap<String, String>();
            String configDir = srcConfig.getBackupSourceNode().getConfigDirPath();
            if (configDir.contains(" ")) {
                configDir = "\"" + configDir + "\"";
            }
            optionalProps.put("-configdir", configDir);
            optionalProps.put("-backupid", backupId);
            sourceRecovery = this.helperDAO.recover(sourceBackup, session, optionalProps, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_RECOVERY_FAILED);
            logger.info(RB.getStringResource("LevconfigBackupSupportService.levconfig.recovery.completed.txt"));
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_RECOVERY_FAILED.getErrorCode());
        }
        return sourceRecovery;
    }
}

