/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorLogger;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupNodeHelper;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.svcs.mail.client.Mail;
import com.sas.svcs.mail.client.MailAddress;
import com.sas.svcs.mail.client.MailServiceInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class BackupMailServiceImpl {
    private MailServiceInterface mailService;
    @Autowired
    @Qualifier(value="BackupErrorXmlLogger")
    BackupErrorLogger backupErrorXmlLogger;
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfigComponent;
    @Autowired
    private BackupNodeHelper nodeHelper;
    private static final String SENDER = "sender";
    private static final String RECEIVER = "receiver";
    private static final String EMAIL_SENDER_DEFAULT_PROPERTY = "Email.DefaultFrom";
    private static final String SAS_APP_PROPERTY_NAME = "Application Configuration";
    private static final String SAS_APP_SOFTWARE_COMPONENT_NAME = "SAS Application Infrastructure";
    private boolean flag = false;
    private final Logger logger = LogManager.getLogger(BackupMailServiceImpl.class);
    @Autowired
    ConfigBeanConverter configBeanConverter;

    public MailServiceInterface getMailService() {
        return this.mailService;
    }

    public void setMailService(MailServiceInterface msi) {
        this.mailService = msi;
    }

    private boolean send(Mail email) {
        if (this.mailService != null) {
            this.logger.info("Sending email...");
            this.mailService.send(email);
            this.flag = true;
        } else {
            this.logger.info("Mail service not initialized hence can't send notification.");
        }
        return this.flag;
    }

    private Map<String, String> getEmailSenderProperty() {
        HashMap<String, String> globalProps;
        block15: {
            globalProps = new HashMap<String, String>();
            try {
                if (!this.backupConfigComponent.getConfigurationProperties().isEmpty() && this.backupConfigComponent.getConfigurationProperties().containsKey(EMAIL_SENDER_DEFAULT_PROPERTY)) {
                    globalProps.put(SENDER, this.backupConfigComponent.getConfigurationProperties().get(EMAIL_SENDER_DEFAULT_PROPERTY));
                    break block15;
                }
                String sender = null;
                PropertySet propertySet = null;
                List softwareComponents = this.backupConfigComponent.getSoftwareComponents("svrbakupevm");
                SoftwareComponentInterface backupComponent = null;
                SoftwareComponent sasAppObject = null;
                if (softwareComponents.size() > 0) {
                    backupComponent = (SoftwareComponentInterface)softwareComponents.get(0);
                }
                if (backupComponent == null) {
                    throw new BackupException("NOTFOUND: Backup Component not found", BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
                }
                SoftwareComponent jomaObj = this.backupConfigComponent.getSoftwareComponent(backupComponent);
                try {
                    AssociationList props = jomaObj.getImplementedObjects();
                    if (props == null || props.size() == 0) {
                        throw new BackupException("NOTFOUND: Backup Component's implemented object properties", BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
                    }
                    sasAppObject = (SoftwareComponent)props.get(0);
                    if (sasAppObject == null) {
                        throw new BackupException("NOTFOUND: SAS Application Infrastructure Software component", BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
                    }
                    AssociationList sasAppObjectList = sasAppObject.getPropertySets(true);
                    if (SAS_APP_SOFTWARE_COMPONENT_NAME.equals(sasAppObject.getName())) {
                        AssociationList propertyList;
                        for (int i = 0; i < sasAppObjectList.size(); ++i) {
                            if (!SAS_APP_PROPERTY_NAME.equals(((PropertySet)sasAppObjectList.get(i)).getName())) continue;
                            propertySet = (PropertySet)sasAppObjectList.get(i);
                            break;
                        }
                        if ((propertyList = propertySet.getSetProperties(true)).size() > 0) {
                            for (int i = 0; i < propertyList.size(); ++i) {
                                Property property = (Property)propertyList.get(i);
                                if (!EMAIL_SENDER_DEFAULT_PROPERTY.equals(property.getName())) continue;
                                sender = property.getDefaultValue();
                                break;
                            }
                        }
                        if (sender != null) {
                            globalProps.put(SENDER, sender);
                        }
                    }
                }
                catch (RemoteException e) {
                    this.logger.error(e.getMessage());
                    throw new BackupException("Error encountered while trying to get metdata properties of SAS Application Infrastructure Platform for email sender address", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_EMAIL_NOTIFICATION_FAILED.getErrorCode());
                }
                catch (MdException e) {
                    this.logger.error(e.getMessage());
                    throw new BackupException("Error encountered while trying to get metdata properties of SAS Application Infrastructure Platform for email sender address", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_EMAIL_NOTIFICATION_FAILED.getErrorCode());
                }
            }
            catch (BackupException e1) {
                e1.printStackTrace();
            }
        }
        return globalProps;
    }

    public void sendEmailNotification(BackupServiceResult<?> backupServiceResult) throws BackupException {
        BackupErrorDetails errorDetails = null;
        backupServiceResult.generateErrorDetails(this.backupErrorXmlLogger);
        errorDetails = backupServiceResult.getErrorDetails();
        this.sendEmailNotification(backupServiceResult, errorDetails);
    }

    public void sendEmailNotification(BackupServiceResult<?> backupServiceResult, BackupErrorDetails errorDetails) throws BackupException {
        Map<String, String> prop = this.getEmailSenderProperty();
        String subject = null;
        String emailFrom = null;
        StringBuffer htmlText = new StringBuffer();
        String[] emailTo = null;
        OperationDetails operationDetails = null;
        OperationDetails.OperationStatus operationStatus = null;
        try {
            Object actualResult;
            if (backupServiceResult != null && (actualResult = backupServiceResult.getActualResult()) != null && actualResult instanceof OperationDetails) {
                operationDetails = (OperationDetails)actualResult;
                operationStatus = operationDetails.getStatus();
            }
            if (prop != null) {
                emailFrom = prop.get(SENDER);
            }
            if ((emailTo = this.backupConfigComponent.getEmailToList()) != null && emailTo.length > 0 && emailFrom != null && emailFrom.trim().length() > 0) {
                Mail email;
                boolean mailSent;
                this.logger.info("Got required users to send notification mail.");
                List<String> list = this.removeNullValues(emailTo);
                emailTo = list.toArray(new String[list.size()]);
                subject = this.getEmailSubject(backupServiceResult);
                this.addStartingTextToEmailBody(htmlText, operationDetails);
                if (operationDetails != null) {
                    String user;
                    if (operationDetails instanceof BackupDetails) {
                        if (operationDetails.isScheduled()) {
                            htmlText.append("\n").append(RB.getStringResource("BackupMailServicesImpl.scheduled.backup.note.txt"));
                        }
                        if (!operationStatus.canBeRecovered()) {
                            htmlText.append("\n").append(RB.getStringResource("BackupMailServicesImpl.run.another.backup.note.txt"));
                        }
                    }
                    if ((user = operationDetails.getRunBy()) != null) {
                        htmlText.append("\n\n").append(Message.format((String)RB.getStringResource("BackupMailServicesImpl.runby.fmt"), (Object)user));
                    }
                }
                if (!BackupServiceUtils.isEmpty(errorDetails)) {
                    this.addErrorDetailsToEmailBody(htmlText, errorDetails, operationStatus);
                }
                if (backupServiceResult.getAnalysisResult() != null && backupServiceResult.getAnalysisResult().hasRealErrors()) {
                    this.addAnanlysisErrorsToEmailBody(htmlText, backupServiceResult);
                }
                if (mailSent = this.send(email = this.prepareMailObject(subject, emailFrom, emailTo, htmlText))) {
                    if (errorDetails != null) {
                        errorDetails.setMailSubject(subject);
                        errorDetails.setMailToAddress(list.toString());
                        errorDetails.setNotified(true);
                    }
                    this.logger.info("Email sent.");
                }
            } else {
                this.logger.info("Not able to send notification as receiver or sender is not provided");
            }
        }
        catch (BackupException e) {
            if (errorDetails != null) {
                errorDetails.setNotified(false);
            }
            throw e;
        }
        catch (Throwable t) {
            if (errorDetails != null) {
                errorDetails.setNotified(false);
            }
            BackupException be = new BackupException("Error encountered while trying to send notification.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_EMAIL_NOTIFICATION_FAILED.getErrorCode());
            throw be;
        }
        finally {
            try {
                if (backupServiceResult != null && errorDetails != null) {
                    backupServiceResult.setErrorDetails(errorDetails);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private void addAnanlysisErrorsToEmailBody(StringBuffer htmlText, BackupServiceResult<?> backupServiceResult) {
        AnalysisResult analysisResult = backupServiceResult.getAnalysisResult();
        String analysisErrors = null;
        if (analysisResult != null && analysisResult.hasRealErrors()) {
            analysisErrors = analysisResult.getDisplayString();
        }
        if (!BackupServiceUtils.isEmpty(analysisErrors)) {
            htmlText.append("\n\n").append(RB.getStringResource("BackupMailServicesImpl.analysis.result.txt")).append(" ").append(analysisErrors);
        }
    }

    private void addErrorDetailsToEmailBody(StringBuffer htmlText, BackupErrorDetails errorDetails, OperationDetails.OperationStatus operationStatus) {
        String errorLog = null;
        if (errorDetails != null) {
            String xmlMessage = this.backupErrorXmlLogger.generateCompleteErrorMessage(errorDetails);
            errorLog = errorDetails.getDisplayString();
        }
        if (BackupServiceUtils.isEmpty(errorLog) && operationStatus.isNotificationRequired() && !OperationDetails.OperationStatus.WARN.equals((Object)operationStatus) && !OperationDetails.OperationStatus.ANALYSIS_WARN.equals((Object)operationStatus)) {
            errorLog = "Backup service failed due to unknown reasons.";
        }
        if (!BackupServiceUtils.isEmpty(errorLog)) {
            htmlText.append("\n\n").append(RB.getStringResource("BackupMailServicesImpl.exception.txt")).append(" ").append(errorLog);
        }
    }

    private Mail prepareMailObject(String subject, String from, String[] to, StringBuffer body) {
        Mail email = new Mail();
        email.setFromAddress(new MailAddress(from, null));
        MailAddress[] mailAddress = new MailAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            mailAddress[i] = new MailAddress(to[i], null);
        }
        if (mailAddress.equals("")) {
            this.logger.error("Not able to send notification as receiver email id is not specified");
        }
        email.setToAddresses(mailAddress);
        email.setSubject(subject);
        email.setTextMessage(body.toString());
        return email;
    }

    private List<String> removeNullValues(String[] runBy) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : runBy) {
            if (s == null || s.length() <= 0) continue;
            list.add(s);
        }
        return list;
    }

    private void addStartingTextToEmailBody(StringBuffer htmlText, OperationDetails operationDetails) {
        if (operationDetails != null && operationDetails.getName() != null) {
            if (operationDetails instanceof BackupDetails) {
                htmlText.append(Message.format((String)RB.getStringResource("BackupMailServicesImpl.backup.email.htmlText.fmt"), (Object)operationDetails.getName()));
            } else if (operationDetails instanceof RecoveryDetails) {
                htmlText.append(Message.format((String)RB.getStringResource("BackupMailServicesImpl.recovery.email.htmlText.fmt"), (Object)operationDetails.getName()));
            } else {
                htmlText.append(Message.format((String)RB.getStringResource("BackupMailServicesImpl.operation.email.htmlText.fmt"), (Object)operationDetails.getName()));
            }
            if (operationDetails != null && operationDetails.getStatus() != null) {
                htmlText.append("\n\n").append(Message.format((String)RB.getStringResource("BackupMailServicesImpl.operation.status.fmt"), (Object)operationDetails.getStatus()));
            }
            if (operationDetails != null && operationDetails.getStartTime() != null) {
                htmlText.append("\n\n").append(Message.format((String)RB.getStringResource("BackupMailServicesImpl.operation.starttime.fmt"), (Object)operationDetails.getStartTime()));
            }
            this.addSASEnvironmentDetails(htmlText, operationDetails);
        } else if (operationDetails != null && operationDetails.getName() == null) {
            htmlText.append(RB.getStringResource("BackupMailServicesImpl.nooperation.email.htmlText.txt"));
            if (operationDetails != null && operationDetails.getStatus() != null) {
                htmlText.append("\n\n").append(Message.format((String)RB.getStringResource("BackupMailServicesImpl.operation.status.fmt"), (Object)operationDetails.getStatus()));
            }
        } else {
            htmlText.append(RB.getStringResource("BackupMailServicesImpl.nooperation.email.htmlText.txt"));
        }
    }

    private void addSASEnvironmentDetails(StringBuffer htmlText, OperationDetails operationDetails) {
        List sasTiers;
        RuntimeSASEnvironment runtimeSASEnvironment = operationDetails.getRuntimeEnvironment();
        List list = sasTiers = runtimeSASEnvironment != null ? runtimeSASEnvironment.getAllTiers() : null;
        if (!BackupServiceUtils.isEmpty(sasTiers)) {
            int j = 1;
            for (SASTier tier : sasTiers) {
                htmlText.append("\n\n").append(RB.getStringResource("BackupMailServicesImpl.environment.detail.txt")).append(" ").append(j).append(" :  ").append(tier.toString());
                ++j;
            }
        } else {
            Set<BackupSourceNode> sourceNodes = this.nodeHelper.getUniqueSourceNodes(operationDetails.getConfig());
            int j = 1;
            for (BackupSourceNode node : sourceNodes) {
                htmlText.append("\n\n").append(RB.getStringResource("BackupMailServicesImpl.environment.detail.txt")).append(" ").append(j).append(" :  ").append(node.toString());
                ++j;
            }
        }
    }

    private String getEmailSubject(BackupServiceResult<?> backupServiceResult) {
        return RB.getStringResource("BackupMailServicesImpl.backup.email.subject.txt");
    }
}

