/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.svcs.backup.analyze.BackupRequestContext;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupSchedule;
import com.sas.svcs.backup.client.BackupServiceConstants;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceEntryDetails;
import com.sas.svcs.backup.client.BackupSourceInstanceDetails;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.DeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.RB;
import com.sas.svcs.backup.dao.XMLOperationDAO;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import com.sas.svcs.backup.spi.BackupServiceHelper;
import com.sas.svcs.backup.util.JaxbMarshallerHelper;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Repository(value="XMLOperationDAO")
public class XMLOperationDAOImpl
implements XMLOperationDAO {
    private static final Logger logger = LogManager.getLogger(XMLOperationDAOImpl.class);
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private DeploymentBackupConfiguration configData;
    @Autowired
    BackupConfigurationService configurationService;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    @Autowired
    BackupServiceHelper helper;
    @Autowired
    BackupRequestContext backupRequestContext;
    private String historyFile = null;
    private String configFile = null;

    public String getHistoryFile() throws BackupException {
        if (this.historyFile == null) {
            this.historyFile = this.configData.getAppHomePath() + File.separator + "BackupHistory.xml";
        }
        return this.historyFile;
    }

    public void setHistoryFile(String historyFile) {
        this.historyFile = historyFile;
    }

    public String getBackupConfigurationFile() throws BackupException {
        return this.configData.getAppHomePath() + File.separator + "NewBackupConfiguration.xml";
    }

    public String getConfigFile() throws BackupException {
        if (this.configFile == null) {
            this.configFile = this.configData.getAppHomePath() + File.separator + "BackupConfiguration.xml";
        }
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void addOperationToHistory(OperationDetails details) throws BackupException {
        String fileName = this.getHistoryFile();
        if (fileName != null && details != null) {
            File file = new File(fileName);
            Document mainDoc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            boolean result = false;
            try {
                db = dbf.newDocumentBuilder();
                logger.info(Message.format((String)RB.getStringResource("XMLOperationDAOImpl.writing.history.fmt"), (Object)file.getCanonicalPath()));
                if (!file.exists()) {
                    mainDoc = db.newDocument();
                    Element root1 = mainDoc.createElement("Backups");
                    mainDoc.appendChild(root1);
                    mainDoc.getDocumentElement().appendChild(mainDoc.importNode(this.createOperationElement(mainDoc, details), true));
                } else {
                    mainDoc = db.parse(file);
                    HashMap<String, String> attribsToCompare = new HashMap<String, String>();
                    attribsToCompare.put("Name", details.getName());
                    Node existingChild = this.SearchForChildNode(this.getRootNode(mainDoc), attribsToCompare);
                    if (existingChild != null) {
                        mainDoc.getDocumentElement().replaceChild(mainDoc.importNode(this.createOperationElement(mainDoc, details), true), existingChild);
                    } else {
                        mainDoc.getDocumentElement().appendChild(mainDoc.importNode(this.createOperationElement(mainDoc, details), true));
                    }
                }
                result = this.writeXML(mainDoc, fileName, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
                if (!result) {
                    logger.error(RB.getStringResource("XMLOperationDAOImpl.error.writing.historyfile.txt"));
                    throw new BackupException(RB.getStringResource("XMLOperationDAOImpl.error.writing.historyfile.txt"), BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
                }
                logger.debug(RB.getStringResource("XMLOperationDAOImpl.file.saved.txt"));
            }
            catch (SAXException e1) {
                logger.error((Object)e1.getCause());
                throw new BackupException((Throwable)e1, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)e.getCause());
                throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
            }
            catch (TransformerFactoryConfigurationError e) {
                logger.error((Object)e.getCause());
                throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
            }
            catch (IOException e) {
                logger.error((Object)e.getCause());
                throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
            }
        }
    }

    private Element createOperationElement(Document doc, OperationDetails operation) {
        if (operation instanceof BackupDetails) {
            return this.createBackupElement(doc, (BackupDetails)operation);
        }
        if (operation instanceof RecoveryDetails) {
            return this.createRecoveryElement(doc, (RecoveryDetails)operation);
        }
        return null;
    }

    private Element createBackupElement(Document doc, BackupDetails backupDetails) {
        Element backOperDetailsElement = null;
        if (backupDetails != null && doc != null) {
            backOperDetailsElement = this.createOperationBaseElement(doc, (OperationDetails)backupDetails);
            Element nSources = null;
            NodeList children = backOperDetailsElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("Sources")) continue;
                nSources = (Element)child;
                break;
            }
            if (nSources == null) {
                nSources = doc.createElement("Sources");
            }
            List bckSourceDetails = backupDetails.getSourceDetails();
            for (BackupSourceDetails bckDetials : bckSourceDetails) {
                BackupSourceConfig srcCnfg = bckDetials.getSourceConfig();
                String type = null;
                String hostName = null;
                String configDir = null;
                Node existingSrcNode = null;
                if (srcCnfg != null) {
                    BackupSourceNode sourceNode = srcCnfg.getBackupSourceNode();
                    type = srcCnfg.getSourceType().name();
                    hostName = sourceNode.getHostName();
                    configDir = sourceNode.getConfigDirPath();
                }
                if (type != null && hostName != null) {
                    HashMap<String, String> attribsToCompare = new HashMap<String, String>();
                    attribsToCompare.put("Type", type);
                    attribsToCompare.put("HostName", hostName);
                    attribsToCompare.put("ConfigDir", configDir);
                    existingSrcNode = this.SearchForChildNode(nSources, attribsToCompare);
                }
                if (existingSrcNode != null) {
                    nSources.replaceChild(this.createSourceElement(doc, bckDetials), existingSrcNode);
                    continue;
                }
                nSources.appendChild(this.createSourceElement(doc, bckDetials));
            }
            backOperDetailsElement.appendChild(nSources);
        }
        return backOperDetailsElement;
    }

    private Element createRecoveryElement(Document doc, RecoveryDetails recoveryDetails) {
        Element recoveryElement = null;
        if (recoveryDetails != null && doc != null) {
            recoveryElement = this.createOperationBaseElement(doc, (OperationDetails)recoveryDetails);
            Element sourcesNode = null;
            NodeList children = recoveryElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("Sources")) continue;
                sourcesNode = (Element)child;
                break;
            }
            if (sourcesNode == null) {
                sourcesNode = doc.createElement("Sources");
            }
            List sourceDetails = recoveryDetails.getSourceDetails();
            for (BackupSourceDetails sourceRecovery : sourceDetails) {
                BackupSourceConfig srcCnfg = sourceRecovery.getSourceConfig();
                String type = null;
                String hostName = null;
                Node existingSrcNode = null;
                if (srcCnfg != null) {
                    type = srcCnfg.getSourceType().name();
                    hostName = srcCnfg.getBackupSourceNode().getHostName();
                }
                if (type != null && hostName != null) {
                    HashMap<String, String> attribsToCompare = new HashMap<String, String>();
                    attribsToCompare.put("Type", type);
                    attribsToCompare.put("HostName", hostName);
                    existingSrcNode = this.SearchForChildNode(sourcesNode, attribsToCompare);
                }
                if (existingSrcNode != null) {
                    sourcesNode.replaceChild(this.createSourceElement(doc, sourceRecovery), existingSrcNode);
                    continue;
                }
                sourcesNode.appendChild(this.createSourceElement(doc, sourceRecovery));
            }
            recoveryElement.appendChild(sourcesNode);
        }
        return recoveryElement;
    }

    private Element createBackupSourceEntryDetails(Document doc, BackupSourceEntryDetails backupSourceEntryDetails) {
        Element bckSourceEntryDetails = null;
        if (backupSourceEntryDetails != null && doc != null) {
            bckSourceEntryDetails = doc.createElement("SourceEntry");
            Attr attr = doc.createAttribute("Name");
            if (backupSourceEntryDetails.getName() != null) {
                attr.setValue(backupSourceEntryDetails.getName());
            } else {
                attr.setValue("");
            }
            bckSourceEntryDetails.setAttributeNode(attr);
            attr = doc.createAttribute("Status");
            if (backupSourceEntryDetails.getStatus() != null) {
                attr.setValue(backupSourceEntryDetails.getStatus().toString());
            } else {
                attr.setValue("");
            }
            bckSourceEntryDetails.setAttributeNode(attr);
            attr = doc.createAttribute("Size");
            Long size = backupSourceEntryDetails.getSize();
            if (size != null) {
                attr.setValue(size.toString());
            } else {
                attr.setValue(Long.toString(0L));
            }
            bckSourceEntryDetails.setAttributeNode(attr);
        }
        return bckSourceEntryDetails;
    }

    private Element createSourceElement(Document doc, BackupSourceDetails backSourceDetails) {
        Element bckSourceDetials = null;
        Element bckSubSources = null;
        if (backSourceDetails != null && doc != null) {
            Map instanceDetails;
            bckSourceDetials = doc.createElement("Source");
            Attr attr = doc.createAttribute("Type");
            if (backSourceDetails.getSourceConfig().getSourceType() != null) {
                attr.setValue(backSourceDetails.getSourceConfig().getSourceType().name());
            } else {
                attr.setValue("");
            }
            bckSourceDetials.setAttributeNode(attr);
            attr = doc.createAttribute("LogFilePath");
            if (backSourceDetails.getLogFilePath() != null) {
                attr.setValue(backSourceDetails.getLogFilePath().toString());
            } else {
                attr.setValue("");
            }
            bckSourceDetials.setAttributeNode(attr);
            if (backSourceDetails.getServerSideErrorCode() != 0) {
                attr = doc.createAttribute("ServerSideReturnCode");
                attr.setValue(String.valueOf(backSourceDetails.getServerSideErrorCode()));
                bckSourceDetials.setAttributeNode(attr);
            }
            attr = doc.createAttribute("Size");
            Long size = backSourceDetails.getSize();
            if (size != null) {
                attr.setValue(size.toString());
            } else {
                attr.setValue(Long.toString(0L));
            }
            bckSourceDetials.setAttributeNode(attr);
            BackupSourceNode sourceNode = backSourceDetails.getSourceConfig().getBackupSourceNode();
            attr = doc.createAttribute("HostName");
            String hostName = sourceNode.getHostName();
            if (hostName != null) {
                attr.setValue(hostName);
            } else {
                attr.setValue("");
            }
            bckSourceDetials.setAttributeNode(attr);
            attr = doc.createAttribute("ConfigDir");
            String configDir = sourceNode.getConfigDirPath();
            if (configDir != null) {
                attr.setValue(configDir);
            } else {
                attr.setValue("");
            }
            bckSourceDetials.setAttributeNode(attr);
            if (backSourceDetails.getSourceBackupName() != null) {
                String backupName = backSourceDetails.getSourceBackupName();
                attr = doc.createAttribute("SourceBackupName");
                attr.setValue(backupName);
                bckSourceDetials.setAttributeNode(attr);
            }
            if (backSourceDetails.getBackupLocation() != null) {
                String backupLocation = backSourceDetails.getBackupLocation();
                attr = doc.createAttribute("BackupLocation");
                attr.setValue(backupLocation);
                bckSourceDetials.setAttributeNode(attr);
            }
            if (backSourceDetails.getStatus() != null) {
                String status = backSourceDetails.getStatus().toString();
                attr = doc.createAttribute("Status");
                attr.setValue(status);
                bckSourceDetials.setAttributeNode(attr);
            }
            if ((instanceDetails = backSourceDetails.getSourceInstances()) != null) {
                Set instanceKeys = instanceDetails.keySet();
                bckSubSources = doc.createElement("SourceInstances");
                for (String key : instanceKeys) {
                    BackupSourceInstanceDetails instanceDetail = (BackupSourceInstanceDetails)instanceDetails.get(key);
                    bckSubSources.appendChild(this.createBackupSourceInstanceDetialsElement(doc, instanceDetail));
                }
                bckSourceDetials.appendChild(bckSubSources);
            }
            this.setIncludedPaths(doc, backSourceDetails, bckSourceDetials);
        }
        return bckSourceDetials;
    }

    private void setIncludedPaths(Document doc, BackupSourceDetails backSourceDetails, Element bckSourceDetials) {
        List includedPaths = backSourceDetails.getConfigurablePaths();
        if (!BackupServiceUtils.isEmpty(includedPaths)) {
            Element includedPathsElement = doc.createElement("IncludedPaths");
            for (String includedPath : includedPaths) {
                if (BackupServiceUtils.isEmpty(includedPath)) continue;
                Element includedPathElement = doc.createElement("IncludedPath");
                includedPathElement.setAttribute("PathValue", includedPath);
                includedPathsElement.appendChild(includedPathElement);
            }
            bckSourceDetials.appendChild(includedPathsElement);
        }
    }

    private Element createBackupSourceInstanceDetialsElement(Document doc, BackupSourceInstanceDetails instanceDetail) {
        Element bckSourceInstanceDetails = null;
        if (instanceDetail != null && doc != null) {
            bckSourceInstanceDetails = doc.createElement("SourceInstance");
            Attr attr = doc.createAttribute("InstanceName");
            if (instanceDetail.getInstanceName() != null) {
                attr.setValue(instanceDetail.getInstanceName());
            } else {
                attr.setValue("");
            }
            bckSourceInstanceDetails.setAttributeNode(attr);
            attr = doc.createAttribute("Host");
            if (instanceDetail.getHost() != null) {
                attr.setValue(instanceDetail.getHost());
            } else {
                attr.setValue("");
            }
            bckSourceInstanceDetails.setAttributeNode(attr);
            attr = doc.createAttribute("Port");
            if (instanceDetail.getPort() != null) {
                attr.setValue(instanceDetail.getPort());
            } else {
                attr.setValue("");
            }
            bckSourceInstanceDetails.setAttributeNode(attr);
            attr = doc.createAttribute("BkupHoldingHost");
            if (instanceDetail.getBackupHoldingNode() != null) {
                attr.setValue(instanceDetail.getBackupHoldingNode());
            } else {
                attr.setValue("");
            }
            bckSourceInstanceDetails.setAttributeNode(attr);
            List subSources = instanceDetail.getSourceEntries();
            Element bckSourceEntries = null;
            if (subSources != null && !subSources.isEmpty()) {
                bckSourceEntries = doc.createElement("SourceEntries");
                for (BackupSourceEntryDetails subSource : subSources) {
                    bckSourceEntries.appendChild(this.createBackupSourceEntryDetails(doc, subSource));
                }
                bckSourceInstanceDetails.appendChild(bckSourceEntries);
            }
        }
        return bckSourceInstanceDetails;
    }

    private Node getRootNode(Document doc) {
        if (doc != null) {
            return doc.getFirstChild();
        }
        return null;
    }

    private Node SearchForChildNode(Node rootNode, Map<String, String> attribsToCompare) {
        NodeList childs = rootNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node nestedChild;
            Node child = childs.item(i);
            boolean found = true;
            for (Map.Entry<String, String> entry : attribsToCompare.entrySet()) {
                String attributeName = entry.getKey();
                String attributeValue = entry.getValue();
                String id = this.getAttribValue(child, attributeName);
                if (id != null && !("HostName".equalsIgnoreCase(attributeName) ? !BackupServiceUtils.isHostsEqual(attributeValue, id) : !id.equals(attributeValue))) continue;
                found = false;
                break;
            }
            if (found) {
                return child;
            }
            if (!child.hasChildNodes() || (nestedChild = this.SearchForChildNode(child, attribsToCompare)) == null) continue;
            return nestedChild;
        }
        return null;
    }

    private String getAttribValue(Node node, String attribName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap attribs = node.getAttributes();
        if (attribs != null) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                Node attrib = attribs.item(i);
                if (!attrib.getNodeName().equals(attribName)) continue;
                return attrib.getNodeValue();
            }
        }
        return null;
    }

    private Element createOperationBaseElement(Document doc, OperationDetails backOperDetails) {
        Element opertionDetails = null;
        Node rootNode = this.getRootNode(doc);
        if (backOperDetails != null) {
            Long size;
            Attr attr;
            HashMap<String, String> attribsToCompare;
            if (backOperDetails instanceof BackupDetails) {
                attribsToCompare = new HashMap<String, String>();
                attribsToCompare.put("Name", backOperDetails.getName());
                opertionDetails = (Element)this.SearchForChildNode(rootNode, attribsToCompare);
                if (opertionDetails == null) {
                    opertionDetails = doc.createElement("Backup");
                }
                if ((attr = opertionDetails.getAttributeNode("Restored")) == null) {
                    attr = doc.createAttribute("Restored");
                }
                attr.setValue(Boolean.toString(((BackupDetails)backOperDetails).isRecovered()));
                opertionDetails.setAttributeNode(attr);
                attr = opertionDetails.getAttributeNode("Offline");
                if (attr == null) {
                    attr = doc.createAttribute("Offline");
                }
                attr.setValue(Boolean.toString(((BackupDetails)backOperDetails).isOffline()));
                opertionDetails.setAttributeNode(attr);
                if (((BackupDetails)backOperDetails).getExpiredDate() != null) {
                    attr = opertionDetails.getAttributeNode("Expired");
                    if (attr == null) {
                        attr = doc.createAttribute("Expired");
                    }
                    attr.setValue(BackupServiceConstants.iso8601format.format(((BackupDetails)backOperDetails).getExpiredDate()));
                    opertionDetails.setAttributeNode(attr);
                }
                if (((BackupDetails)backOperDetails).getVerifiedDate() != null) {
                    attr = opertionDetails.getAttributeNode("VerifiedDate");
                    if (attr == null) {
                        attr = doc.createAttribute("VerifiedDate");
                    }
                    attr.setValue(BackupServiceConstants.iso8601format.format(((BackupDetails)backOperDetails).getVerifiedDate()));
                    opertionDetails.setAttributeNode(attr);
                }
            } else if (backOperDetails instanceof RecoveryDetails) {
                attribsToCompare = new HashMap();
                attribsToCompare.put("Name", backOperDetails.getName());
                opertionDetails = (Element)this.SearchForChildNode(rootNode, attribsToCompare);
                if (opertionDetails == null) {
                    opertionDetails = doc.createElement("Recovery");
                }
                if ((attr = opertionDetails.getAttributeNode("BackupName")) == null) {
                    attr = doc.createAttribute("BackupName");
                }
                attr.setValue(((RecoveryDetails)backOperDetails).getBackupDetails().getName());
                opertionDetails.setAttributeNode(attr);
                attr = opertionDetails.getAttributeNode("PauseComment");
                if (attr == null) {
                    attr = doc.createAttribute("PauseComment");
                }
                attr.setValue(((RecoveryDetails)backOperDetails).getPauseComments());
                opertionDetails.setAttributeNode(attr);
            }
            attr = opertionDetails.getAttributeNode("Type");
            if (attr == null) {
                attr = doc.createAttribute("Type");
            }
            attr.setValue(backOperDetails.getType().toString());
            opertionDetails.setAttributeNode(attr);
            attr = opertionDetails.getAttributeNode("RunBy");
            if (attr == null) {
                attr = doc.createAttribute("RunBy");
            }
            attr.setValue(backOperDetails.getRunBy().toString());
            opertionDetails.setAttributeNode(attr);
            attr = opertionDetails.getAttributeNode("Scheduled");
            if (attr == null) {
                attr = doc.createAttribute("Scheduled");
            }
            attr.setValue(Boolean.toString(backOperDetails.isScheduled()));
            opertionDetails.setAttributeNode(attr);
            attr = opertionDetails.getAttributeNode("StartDateTime");
            if (attr == null) {
                attr = doc.createAttribute("StartDateTime");
            }
            attr.setValue(BackupServiceConstants.iso8601format.format(backOperDetails.getStartTime()));
            opertionDetails.setAttributeNode(attr);
            Date endTime = backOperDetails.getEndTime();
            if (endTime != null) {
                attr = opertionDetails.getAttributeNode("EndDateTime");
                if (attr == null) {
                    attr = doc.createAttribute("EndDateTime");
                }
                attr.setValue(BackupServiceConstants.iso8601format.format(endTime));
                opertionDetails.setAttributeNode(attr);
            }
            if ((attr = opertionDetails.getAttributeNode("Comment")) == null) {
                attr = doc.createAttribute("Comment");
            }
            attr.setValue(backOperDetails.getComment());
            opertionDetails.setAttributeNode(attr);
            attr = opertionDetails.getAttributeNode("Size");
            if (attr == null) {
                attr = doc.createAttribute("Size");
            }
            if ((size = Long.valueOf(backOperDetails.getSize())) != null) {
                attr.setValue(size.toString());
            } else {
                attr.setValue("0");
            }
            opertionDetails.setAttributeNode(attr);
            attr = opertionDetails.getAttributeNode("Name");
            if (attr == null) {
                attr = doc.createAttribute("Name");
            }
            attr.setValue(backOperDetails.getName().toString());
            opertionDetails.setAttributeNode(attr);
            if (backOperDetails.getSlug() != null && !backOperDetails.getSlug().equals("")) {
                attr = opertionDetails.getAttributeNode("Slug");
                if (attr == null) {
                    attr = doc.createAttribute("Slug");
                }
                attr.setValue(backOperDetails.getSlug());
                opertionDetails.setAttributeNode(attr);
            }
            if ((attr = opertionDetails.getAttributeNode("Status")) == null) {
                attr = doc.createAttribute("Status");
            }
            attr.setValue(backOperDetails.getStatus().toString());
            opertionDetails.setAttributeNode(attr);
        }
        return opertionDetails;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToXML(String fileName, Document doc) throws BackupException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        OutputStreamWriter fileWriter = null;
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "5");
            DOMSource source = new DOMSource(doc);
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName)), "UTF-8");
            StreamResult result = new StreamResult(fileWriter);
            transformer.transform(source, result);
            if (fileWriter == null) return;
        }
        catch (IOException exception) {
            try {
                logger.error((Object)exception.getCause());
                throw new BackupException((Throwable)exception, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
                catch (TransformerException e) {
                    logger.error((Object)e.getCause());
                    throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
                }
            }
            catch (Throwable throwable) {
                if (fileWriter == null) throw throwable;
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    @Override
    public List<OperationDetails> getHistory() throws BackupException {
        String file = this.getHistoryFile();
        ArrayList<OperationDetails> operDetails = new ArrayList<OperationDetails>();
        if (file == null || !new File(file).exists()) {
            return operDetails;
        }
        OperationDetails details = null;
        Document doc = null;
        File fXmlFile = new File(file);
        doc = this.parseXmlFile(fXmlFile, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
        if (doc == null) {
            logger.error(RB.getStringResource("XMLOperationDAOImpl.history.file.does.not.exists.txt"));
            return null;
        }
        doc.getDocumentElement().normalize();
        Node rotNode = this.getRootNode(doc);
        NodeList nList = null;
        if (rotNode != null) {
            nList = rotNode.getChildNodes();
        }
        if (nList != null && nList.getLength() > 0) {
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                details = this.createBackupRecoveryDetails(nNode);
                operDetails.add(details);
            }
        }
        if (operDetails != null) {
            Collections.sort(operDetails, new Comparator<OperationDetails>(){

                @Override
                public int compare(OperationDetails o1, OperationDetails o2) {
                    return o2.getStartTime().compareTo(o1.getStartTime());
                }
            });
        }
        return operDetails;
    }

    private OperationDetails createBackupRecoveryDetails(Node backupNode) throws BackupException {
        BackupDetails backupRecoveryDetails = null;
        String type = this.getAttributeValue(backupNode, "Type");
        String configID = this.getAttributeValue(backupNode, "ConfigId");
        BackupConfiguration config = this.getConfig(configID);
        try {
            if (type.equalsIgnoreCase("Backup")) {
                backupRecoveryDetails = new BackupDetails(config);
                backupRecoveryDetails.setSize(Long.parseLong(this.getAttributeValue(backupNode, "Size")));
                backupRecoveryDetails.setRecovered(new Boolean(this.getAttributeValue(backupNode, "Restored")).booleanValue());
                backupRecoveryDetails.setExpiredDate(BackupServiceUtils.parseISO8601DateTime(this.getAttributeValue(backupNode, "Expired")));
                backupRecoveryDetails.setVerifiedDate(BackupServiceUtils.parseISO8601DateTime(this.getAttributeValue(backupNode, "VerifiedDate")));
            } else {
                BackupDetails backup = this.getBackup(this.getAttributeValue(backupNode, "BackupName"));
                backupRecoveryDetails = new RecoveryDetails(backup);
            }
            backupRecoveryDetails.setType(type);
            backupRecoveryDetails.setStatus(OperationDetails.OperationStatus.valueOf((String)this.getAttributeValue(backupNode, "Status")));
            backupRecoveryDetails.setRunBy(this.getAttributeValue(backupNode, "RunBy"));
            backupRecoveryDetails.setName(this.getAttributeValue(backupNode, "Name"));
            backupRecoveryDetails.setSlug(this.getAttributeValue(backupNode, "Slug"));
            backupRecoveryDetails.setComment(this.getAttributeValue(backupNode, "Comment"));
            backupRecoveryDetails.setScheduled(new Boolean(this.getAttributeValue(backupNode, "Scheduled")).booleanValue());
            backupRecoveryDetails.setSourceDetails(this.getSourceDetails(backupNode, config));
            backupRecoveryDetails.setStartTime(BackupServiceUtils.parseISO8601DateTime(this.getAttributeValue(backupNode, "StartDateTime")));
            backupRecoveryDetails.setEndTime(BackupServiceUtils.parseISO8601DateTime(this.getAttributeValue(backupNode, "EndDateTime")));
        }
        catch (ParseException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return backupRecoveryDetails;
    }

    private List<BackupSourceDetails> getSourceDetails(Node backupNode, BackupConfiguration config) {
        List sourceConfigs = config.getSources();
        ArrayList<BackupSourceDetails> bkSrcList = new ArrayList<BackupSourceDetails>();
        if (backupNode instanceof Element) {
            NodeList srcNodeList = ((Element)backupNode).getElementsByTagName("Source");
            for (int temp = 0; temp < srcNodeList.getLength(); ++temp) {
                String status;
                String bkLocation;
                String backupName;
                String size;
                String serverSideErrorCode;
                BackupSourceDetails backSourceDetails = null;
                Node nNode = srcNodeList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                String type = this.getAttributeValue(nNode, "Type");
                String hostName = this.getAttributeValue(nNode, "HostName");
                String configDir = this.getAttributeValue(nNode, "ConfigDir");
                BackupSourceNode sourceNode = new BackupSourceNode(hostName, configDir);
                boolean isSourceNodeTierExcluded = false;
                if (hostName != null) {
                    isSourceNodeTierExcluded = this.helper.isTierHostExcluded(hostName);
                }
                if (type != null && hostName != null && !isSourceNodeTierExcluded) {
                    for (BackupSourceConfig sourceConfig : sourceConfigs) {
                        BackupSourceNode sourceNodeInQuestion = sourceConfig.getBackupSourceNode();
                        boolean isTierExcluded = this.helper.isTierHostExcluded(sourceNodeInQuestion.getHostName());
                        if (isTierExcluded || !type.equalsIgnoreCase(sourceConfig.getSourceType().name()) || !sourceNode.equals((Object)sourceNodeInQuestion) && !BackupSourceConfig.BackupSource.METADATASERVER.name().equals(type) && !BackupSourceConfig.BackupSource.CONTENTSERVER.name().equals(type)) continue;
                        backSourceDetails = new BackupSourceDetails(sourceConfig);
                    }
                    if (backSourceDetails == null) {
                        BackupSourceConfig sourceConfig = new BackupSourceConfig();
                        sourceConfig.setSourceType(BackupSourceConfig.BackupSource.valueOf((String)type.toUpperCase()));
                        SASTier tier = BackupServiceUtils.createSASTierInstance(hostName + "|" + configDir);
                        RuntimeSASEnvironment runtimeSASEnvironment = this.backupRequestContext.getCachedRuntimeSASEnvironment();
                        List availableTiers = runtimeSASEnvironment.getAvailableTiers();
                        this.helper.removeExcludedTiersFromSASTierList(availableTiers);
                        boolean isTierExcluded = this.helper.isTierHostExcluded(tier.getHostName());
                        SASTier actualTier = null;
                        if (!isTierExcluded) {
                            actualTier = BackupServiceUtils.retrieveObject(availableTiers, tier);
                        }
                        if (actualTier != null) {
                            sourceNode = this.configBeanConverter.sasTierToBackupSourceNode(actualTier);
                            sourceConfig.setBackupSourceNode(sourceNode);
                            backSourceDetails = new BackupSourceDetails(sourceConfig);
                            sourceConfigs.add(sourceConfig);
                        }
                    }
                }
                if (backSourceDetails == null) continue;
                String logFilePath = this.getAttributeValue(nNode, "LogFilePath");
                if (logFilePath != null) {
                    backSourceDetails.setLogFilePath(logFilePath);
                }
                if ((serverSideErrorCode = this.getAttributeValue(nNode, "ServerSideReturnCode")) != null) {
                    backSourceDetails.setServerSideErrorCode(Integer.parseInt(serverSideErrorCode));
                }
                if ((size = this.getAttributeValue(nNode, "Size")) != null) {
                    backSourceDetails.setSize(Long.parseLong(size));
                }
                if ((backupName = this.getAttributeValue(nNode, "SourceBackupName")) != null) {
                    backSourceDetails.setSourceBackupName(backupName);
                }
                if ((bkLocation = this.getAttributeValue(nNode, "BackupLocation")) != null) {
                    backSourceDetails.setBackupLocation(bkLocation);
                }
                if ((status = this.getAttributeValue(nNode, "Status")) != null) {
                    backSourceDetails.setStatus(OperationDetails.OperationStatus.valueOf((String)status));
                }
                backSourceDetails.setSourceInstances(this.getSourceInstanceDetails(nNode));
                backSourceDetails.setConfigurablePaths(this.getIncludedPaths(nNode));
                bkSrcList.add(backSourceDetails);
            }
        }
        return bkSrcList;
    }

    private List<String> getIncludedPaths(Node backupSourceNode) {
        NodeList includedPathNodes;
        ArrayList<String> includedPaths = null;
        if (backupSourceNode instanceof Element && !BackupServiceUtils.isEmpty(includedPathNodes = ((Element)backupSourceNode).getElementsByTagName("IncludedPath"))) {
            for (int temp = 0; temp < includedPathNodes.getLength(); ++temp) {
                Node nNode = includedPathNodes.item(temp);
                String pathValue = this.getAttributeValue(nNode, "PathValue");
                if (includedPaths == null) {
                    includedPaths = new ArrayList<String>();
                }
                includedPaths.add(pathValue);
            }
        }
        return includedPaths;
    }

    private Map<String, BackupSourceInstanceDetails> getSourceInstanceDetails(Node backupSourceNode) {
        HashMap<String, BackupSourceInstanceDetails> instanceDetails = null;
        if (backupSourceNode instanceof Element) {
            NodeList srcInstanceNodeList = ((Element)backupSourceNode).getElementsByTagName("SourceInstance");
            for (int temp = 0; temp < srcInstanceNodeList.getLength(); ++temp) {
                Node nNode = srcInstanceNodeList.item(temp);
                String instanceName = this.getAttributeValue(nNode, "InstanceName");
                String host = this.getAttributeValue(nNode, "Host");
                String port = this.getAttributeValue(nNode, "Port");
                String bkup_holding_host = this.getAttributeValue(nNode, "BkupHoldingHost");
                BackupSourceInstanceDetails instanceDetail = new BackupSourceInstanceDetails(instanceName, host, port);
                instanceDetail.setBackupHoldingNode(bkup_holding_host);
                instanceDetail.setSourceEntries(this.getSourceEntryDetails(nNode));
                String instanceId = instanceName + "#" + host + "#" + port;
                if (instanceDetails == null) {
                    instanceDetails = new HashMap<String, BackupSourceInstanceDetails>();
                }
                instanceDetails.put(instanceId, instanceDetail);
            }
        }
        return instanceDetails;
    }

    private List<BackupSourceEntryDetails> getSourceEntryDetails(Node backupSourceInstanceNode) {
        ArrayList<BackupSourceEntryDetails> bkSrcList = new ArrayList<BackupSourceEntryDetails>();
        if (backupSourceInstanceNode instanceof Element) {
            NodeList srcNodeList = ((Element)backupSourceInstanceNode).getElementsByTagName("SourceEntry");
            for (int temp = 0; temp < srcNodeList.getLength(); ++temp) {
                String size;
                String name;
                BackupSourceEntryDetails backSourceEntryDetails = new BackupSourceEntryDetails();
                Node nNode = srcNodeList.item(temp);
                String status = this.getAttributeValue(nNode, "Status");
                if (status != null) {
                    backSourceEntryDetails.setStatus(OperationDetails.OperationStatus.valueOf((String)status));
                }
                if ((name = this.getAttributeValue(nNode, "Name")) != null) {
                    backSourceEntryDetails.setName(name);
                }
                if ((size = this.getAttributeValue(nNode, "Size")) != null) {
                    backSourceEntryDetails.setSize(Long.parseLong(size));
                }
                bkSrcList.add(backSourceEntryDetails);
            }
        }
        return bkSrcList;
    }

    private Document parseXmlFile(File file, int errorCode) throws BackupException {
        Document doc = null;
        FileInputStream fis = null;
        try {
            if (file.exists()) {
                fis = new FileInputStream(file);
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fis, "UTF-8");
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getCause());
            throw new BackupException((Throwable)e, errorCode);
        }
        catch (SAXException e) {
            logger.error((Object)e.getCause());
            throw new BackupException((Throwable)e, errorCode);
        }
        catch (IOException e) {
            logger.error((Object)e.getCause());
            throw new BackupException((Throwable)e, errorCode);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return doc;
    }

    private String getAttributeValue(Node node, String attrName) {
        String textVal = null;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && attrs.getNamedItem(attrName) != null) {
            textVal = attrs.getNamedItem(attrName).getNodeValue();
        }
        return textVal;
    }

    @Override
    public BackupConfiguration getConfig() throws BackupException {
        return this.getConfig("Default");
    }

    public BackupConfiguration getConfig(String configId) throws BackupException {
        String file = this.getConfigFile();
        BackupConfiguration config = null;
        Document doc = null;
        File fXmlFile = new File(file);
        try {
            logger.info(Message.format((String)RB.getStringResource("XMLOperationDAOImpl.reading.conf.file.fmt"), (Object)fXmlFile.getCanonicalPath()));
            doc = this.parseXmlFile(fXmlFile, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            if (doc == null) {
                logger.error(Message.format((String)RB.getStringResource("XMLOperationDAOImpl.conf.file.not.found.fmt"), (Object)fXmlFile.getCanonicalPath()));
                throw new BackupException(Message.format((String)RB.getStringResource("XMLOperationDAOImpl.conf.file.not.found.fmt"), (Object)fXmlFile.getCanonicalPath()), BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            }
        }
        catch (IOException e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
        }
        doc.getDocumentElement().normalize();
        Element docEle = doc.getDocumentElement();
        NodeList nList = docEle.getElementsByTagName("BackupConfiguration");
        if (nList != null && nList.getLength() > 0) {
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1 && !configId.equalsIgnoreCase(this.getAttributeValue(nNode, "ConfigId"))) continue;
                config = new BackupConfiguration();
                config.setDaysToRetainBackups(Integer.parseInt(this.getAttributeValue(nNode, "DaysToRetainBackups")));
                if (this.getAttributeValue(nNode, "RunScheduledBackups").equalsIgnoreCase("Y")) {
                    config.setScheduledBackupsAllowed(true);
                }
                config.setVaultLocation(this.getAttributeValue(nNode, "BackupLocation"));
                config.setId(this.getAttributeValue(nNode, "ConfigId"));
                NodeList sourceNodes = ((Element)nNode).getElementsByTagName("Source");
                if (sourceNodes == null || sourceNodes.getLength() <= 0) continue;
                ArrayList<BackupSourceConfig> sourceConfigs = new ArrayList<BackupSourceConfig>();
                for (int i = 0; i < sourceNodes.getLength(); ++i) {
                    Node srcNode = sourceNodes.item(i);
                    if (srcNode.getNodeType() != 1) continue;
                    sourceConfigs.add(this.createBackupSourceConfig(srcNode));
                }
                config.setSources(sourceConfigs);
            }
        }
        return config;
    }

    private BackupSourceConfig createBackupSourceConfig(Node srcNode) {
        Node hostNode = srcNode.getParentNode();
        BackupSourceConfig srcConfig = new BackupSourceConfig();
        String type = this.getAttributeValue(srcNode, "Type");
        srcConfig.setSourceType(this.getSourceType(type));
        String hostName = this.getAttributeValue(hostNode, "HostName");
        String tierName = this.getAttributeValue(hostNode, "Tier");
        String configDir = this.getAttributeValue(hostNode, "ConfigDir");
        BackupSourceNode backupSourceNode = new BackupSourceNode(hostName, configDir);
        backupSourceNode.setNickName(tierName);
        backupSourceNode.setSasHome(this.getAttributeValue(hostNode, "SASHome"));
        backupSourceNode.setOsType(this.getAttributeValue(hostNode, "OsType"));
        backupSourceNode.setMidTier(Boolean.valueOf(this.getAttributeValue(hostNode, "IsMidTier")).booleanValue());
        srcConfig.setBackupSourceNode(backupSourceNode);
        if (BackupSourceConfig.BackupSource.METADATASERVER.equals((Object)BackupSourceConfig.BackupSource.valueOf((String)type))) {
            backupSourceNode.setMetadataTier(true);
        }
        return srcConfig;
    }

    private BackupSourceConfig.BackupSource getSourceType(String type) {
        BackupSourceConfig.BackupSource src = null;
        BackupSourceConfig.BackupSource[] srctypes = BackupSourceConfig.BackupSource.values();
        for (int i = 0; i < srctypes.length; ++i) {
            src = srctypes[i];
            if (!src.name().equalsIgnoreCase(type)) continue;
            return src;
        }
        return null;
    }

    @Override
    public void setConfig(BackupConfiguration config) throws BackupException {
        String file = this.getConfigFile();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document doc = null;
        String rootName = "BackupConfigurations";
        File fFile = new File(file);
        try {
            boolean flag = true;
            if (!fFile.exists()) {
                flag = fFile.createNewFile();
            }
            if (flag) {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                doc = documentBuilder.newDocument();
                Element rootElement = doc.createElement(rootName);
                doc.appendChild(rootElement);
                ArrayList<BackupConfiguration> ConfigBackList = new ArrayList<BackupConfiguration>();
                ConfigBackList.add(config);
                for (BackupConfiguration backConfiguration : ConfigBackList) {
                    if (backConfiguration == null) continue;
                    Element backConfNode = this.CreateBackUpConfigrationDetails(doc, backConfiguration);
                    if (backConfiguration.getSources().size() > 0) {
                        Element hostsNode = doc.createElement("Hosts");
                        List bckSourceConfig = backConfiguration.getSources();
                        for (BackupSourceConfig bckDetials : bckSourceConfig) {
                            BackupSourceNode hostNode = bckDetials.getBackupSourceNode();
                            String hostName = null;
                            String configDir = null;
                            if (hostNode != null) {
                                hostName = hostNode.getHostName();
                                configDir = hostNode.getConfigDirPath();
                            }
                            HashMap<String, String> attribsToCompare = new HashMap<String, String>();
                            attribsToCompare.put("HostName", hostName);
                            attribsToCompare.put("ConfigDir", configDir);
                            Node host = this.SearchForChildNode(hostsNode, attribsToCompare);
                            Element newHost = null;
                            if (host == null) {
                                newHost = this.createNewHostNode(doc, hostNode);
                                newHost.appendChild(XMLOperationDAOImpl.createBackConfigDetails(doc, bckDetials));
                                hostsNode.appendChild(newHost);
                                continue;
                            }
                            Node updatedHost = host.cloneNode(true);
                            updatedHost.appendChild(XMLOperationDAOImpl.createBackConfigDetails(doc, bckDetials));
                            hostsNode.replaceChild(updatedHost, host);
                        }
                        backConfNode.appendChild(hostsNode);
                    }
                    rootElement.appendChild(backConfNode);
                    this.writeToXML(file, doc);
                }
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getCause());
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
        catch (IOException e) {
            logger.error((Object)e.getCause());
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
    }

    private Element createNewHostNode(Document docNode, BackupSourceNode hostNode) {
        String sasHome;
        String osType;
        String configDir;
        String hostName;
        Element hostXMLNode = docNode.createElement("Host");
        Attr attr = null;
        String tierName = hostNode.getNickName();
        if (tierName != null) {
            attr = docNode.createAttribute("Tier");
            attr.setValue(tierName);
            hostXMLNode.setAttributeNode(attr);
        }
        if ((hostName = hostNode.getHostName()) != null) {
            attr = docNode.createAttribute("HostName");
            attr.setValue(hostName);
            hostXMLNode.setAttributeNode(attr);
        }
        if ((configDir = hostNode.getConfigDirPath()) != null) {
            attr = docNode.createAttribute("ConfigDir");
            attr.setValue(configDir);
            hostXMLNode.setAttributeNode(attr);
        }
        if ((osType = hostNode.getOsType()) != null) {
            attr = docNode.createAttribute("OsType");
            attr.setValue(osType);
            hostXMLNode.setAttributeNode(attr);
        }
        if ((sasHome = hostNode.getSasHome()) != null) {
            attr = docNode.createAttribute("SASHome");
            attr.setValue(sasHome);
            hostXMLNode.setAttributeNode(attr);
        }
        return hostXMLNode;
    }

    private static Element createBackConfigDetails(Document doc, BackupSourceConfig bckConfig) {
        Element bckSourceConfig = null;
        if (bckConfig != null) {
            bckSourceConfig = doc.createElement("Source");
            Attr attr = doc.createAttribute("Type");
            if (bckConfig.getSourceType() != null) {
                attr.setValue(bckConfig.getSourceType().name());
            } else {
                attr.setValue(" ");
            }
            bckSourceConfig.setAttributeNode(attr);
        }
        return bckSourceConfig;
    }

    private Element CreateBackUpConfigrationDetails(Document doc, BackupConfiguration backConfiguration) {
        Element bckConfigDetails = null;
        if (backConfiguration != null) {
            bckConfigDetails = doc.createElement("BackupConfiguration");
            Attr attr = doc.createAttribute("DaysToRetainBackups");
            attr.setValue(Integer.toString(backConfiguration.getDaysToRetainBackups()));
            bckConfigDetails.setAttributeNode(attr);
            attr = doc.createAttribute("RunScheduledBackups");
            attr.setValue(backConfiguration.isScheduledBackupsAllowed() ? "Y" : "N");
            bckConfigDetails.setAttributeNode(attr);
            attr = doc.createAttribute("VaultLocation");
            attr.setValue(backConfiguration.getVaultLocation().toString());
            bckConfigDetails.setAttributeNode(attr);
            attr = doc.createAttribute("ConfigId");
            attr.setValue(backConfiguration.getId() == null ? "Default" : backConfiguration.getId());
            bckConfigDetails.setAttributeNode(attr);
        }
        return bckConfigDetails;
    }

    private BackupDetails getBackup(String backName) throws BackupException {
        OperationDetails oprDetails = this.getDetails(backName, "Backup", "Name");
        if (oprDetails != null && oprDetails instanceof BackupDetails) {
            return (BackupDetails)oprDetails;
        }
        return null;
    }

    private RecoveryDetails getRecovery(String recoveryName) throws BackupException {
        OperationDetails oprDetails = this.getDetails(recoveryName, "Recovery", "Name");
        if (oprDetails != null && oprDetails instanceof RecoveryDetails) {
            return (RecoveryDetails)oprDetails;
        }
        return null;
    }

    @Override
    public OperationDetails getDetails(String nodeByName, String type, String identifier) throws BackupException {
        String xmlFileName = this.getHistoryFile();
        OperationDetails operDetails = null;
        File fXmlFile = new File(xmlFileName);
        Document doc = this.parseXmlFile(fXmlFile, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
        if (doc == null) {
            logger.error(RB.getStringResource("XMLOperationDAOImpl.history.file.does.not.exists.txt"));
            return null;
        }
        doc.getDocumentElement().normalize();
        Element docEle = doc.getDocumentElement();
        try {
            boolean found = false;
            NodeList nList = docEle.getElementsByTagName(type);
            if (nList != null && nList.getLength() > 0) {
                for (int temp = 0; temp < nList.getLength(); ++temp) {
                    Node nNode = nList.item(temp);
                    Node tempAttrNode = nNode.getAttributes().getNamedItem(identifier);
                    if (tempAttrNode == null || !tempAttrNode.getNodeValue().equals(nodeByName)) continue;
                    found = true;
                    operDetails = this.createBackupRecoveryDetails(nNode);
                }
            }
        }
        catch (DOMException e) {
            logger.error((Object)e.getCause());
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
        }
        return operDetails;
    }

    @Override
    public BackupDetails getMostRecentBackup() throws BackupException {
        String historyFilePath = this.getHistoryFile();
        if (historyFilePath == null || !new File(historyFilePath).exists()) {
            return null;
        }
        BackupDetails operDetails = null;
        File fXmlFile = new File(historyFilePath);
        Document doc = this.parseXmlFile(fXmlFile, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
        if (doc == null) {
            logger.error(RB.getStringResource("XMLOperationDAOImpl.history.file.does.not.exists.txt"));
            return null;
        }
        doc.getDocumentElement().normalize();
        Element docEle = doc.getDocumentElement();
        NodeList nList = docEle.getElementsByTagName("Backup");
        if (nList != null && nList.getLength() > 0) {
            Node nNode = nList.item(nList.getLength() - 1);
            operDetails = (BackupDetails)this.createBackupRecoveryDetails(nNode);
        }
        return operDetails;
    }

    @Override
    public RecoveryDetails getMostRecentRecovery() throws BackupException {
        String historyFilePath = this.getHistoryFile();
        RecoveryDetails operDetails = null;
        File fXmlFile = new File(historyFilePath);
        Document doc = this.parseXmlFile(fXmlFile, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
        if (doc == null) {
            logger.error(RB.getStringResource("XMLOperationDAOImpl.history.file.does.not.exists.txt"));
            return null;
        }
        doc.getDocumentElement().normalize();
        Element docEle = doc.getDocumentElement();
        NodeList nList = docEle.getElementsByTagName("Recovery");
        if (nList != null && nList.getLength() > 0) {
            Node nNode = nList.item(nList.getLength() - 1);
            operDetails = (RecoveryDetails)this.createBackupRecoveryDetails(nNode);
        }
        return operDetails;
    }

    @Override
    public BackupDetails getBackupBySlugName(String slug) throws BackupException {
        OperationDetails oprDetails = this.getDetails(slug, "Backup", "Slug");
        if (oprDetails != null && oprDetails instanceof BackupDetails) {
            return (BackupDetails)oprDetails;
        }
        return null;
    }

    @Override
    public RecoveryDetails getRecoveryBySlugName(String slug) throws BackupException {
        OperationDetails oprDetails = this.getDetails(slug, "Recovery", "Slug");
        if (oprDetails != null && oprDetails instanceof BackupDetails) {
            return (RecoveryDetails)oprDetails;
        }
        return null;
    }

    @Override
    public BackupDetails getBackupByName(String name) throws BackupException {
        return this.getBackup(name);
    }

    @Override
    public RecoveryDetails getRecoveryByName(String name) {
        return null;
    }

    private Element updateScheduleElement(Element scheduleElement, List<BackupSchedule> backupSchedule) {
        String[] schedule = new String[7];
        if (backupSchedule != null) {
            for (BackupSchedule event : backupSchedule) {
                int day = event.getDayOfweek().ordinal();
                StringBuffer value = new StringBuffer();
                if (schedule[day] != null) {
                    value.append(schedule[day]);
                    value.append(";");
                }
                if (event.getHour() < 10) {
                    value.append("0");
                }
                value.append(Integer.toString(event.getHour()));
                if (event.getMinute() < 10) {
                    value.append("0");
                }
                value.append(Integer.toString(event.getMinute()));
                schedule[day] = value.toString();
            }
        }
        for (int day = 0; day < 7; ++day) {
            String attrName = "Weekday" + Integer.toString(day + 1);
            if (schedule[day] != null) {
                scheduleElement.setAttribute(attrName, schedule[day]);
                continue;
            }
            scheduleElement.setAttribute(attrName, "");
        }
        return scheduleElement;
    }

    @Override
    public void setSchedule(List<BackupSchedule> backupSchedule) throws BackupException {
        String file = this.getConfigFile();
        Element scheduleElement = null;
        File fXmlFile = new File(file);
        if (fXmlFile.exists()) {
            Document doc = null;
            try {
                logger.info(Message.format((String)RB.getStringResource("XMLOperationDAOImpl.reading.schedule.fmt"), (Object)fXmlFile.getCanonicalPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            doc = this.parseXmlFile(fXmlFile, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            doc.getDocumentElement().normalize();
            Element docEle = doc.getDocumentElement();
            Element schedules = null;
            NodeList SchedulesList = docEle.getElementsByTagName("Schedules");
            if (SchedulesList != null && SchedulesList.getLength() == 1) {
                schedules = (Element)SchedulesList.item(0);
            } else {
                schedules = doc.createElement("Schedules");
                docEle.appendChild(schedules);
            }
            NodeList nList = schedules.getElementsByTagName("Schedule");
            if (nList != null && nList.getLength() == 1) {
                scheduleElement = (Element)nList.item(0);
                this.updateScheduleElement(scheduleElement, backupSchedule);
                schedules.replaceChild(doc.importNode(scheduleElement, true), scheduleElement);
            } else {
                scheduleElement = doc.createElement("Schedule");
                this.updateScheduleElement(scheduleElement, backupSchedule);
                schedules.appendChild(scheduleElement);
            }
            this.writeXML(doc, file, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
    }

    private boolean writeXML(Document doc, String file, int errorCode) throws BackupException {
        Transformer transformer = null;
        OutputStreamWriter fileWriter = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            StreamResult result = null;
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            result = new StreamResult(fileWriter);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)e.getCause());
            throw new BackupException((Throwable)e, errorCode);
        }
        catch (TransformerException e) {
            logger.error((Object)e.getCause());
            throw new BackupException((Throwable)e, errorCode);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void clearInprogressNodes() throws BackupException {
        NodeList nList;
        String historyFilePath = this.getHistoryFile();
        File fXmlFile = new File(historyFilePath);
        Document doc = this.parseXmlFile(fXmlFile, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
        if (doc == null) {
            logger.info(RB.getStringResource("XMLOperationDAOImpl.history.file.not.found.txt"));
            return;
        }
        doc.getDocumentElement().normalize();
        Node rootNode = this.getRootNode(doc);
        if (rootNode != null && (nList = rootNode.getChildNodes()) != null && nList.getLength() > 0) {
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                int removeNode;
                Node nNode = nList.item(temp);
                if (!this.inProgressNode(nNode) || (removeNode = temp) == -1) continue;
                rootNode.removeChild(nNode);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer tFormer = null;
            try {
                tFormer = tFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                doc.replaceChild(doc.importNode(rootNode, true), rootNode);
                doc.normalizeDocument();
                StreamResult dest = new StreamResult(fXmlFile);
                tFormer.transform(source, dest);
            }
            catch (TransformerConfigurationException e) {
                logger.error((Object)e.getCause());
                throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
            }
            catch (TransformerException e) {
                logger.error((Object)e.getCause());
                throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
            }
        }
    }

    private boolean inProgressNode(Node nNode) {
        String id;
        return nNode != null && (id = this.getAttribValue(nNode, "Status")) != null && id.equalsIgnoreCase("INPROGRESS");
    }

    @Override
    public UserSourceConfiguration getBackupSourceConfiguration(BackupSourceConfig.BackupSource sourceType) throws BackupException {
        UserSourceConfiguration sourceConfig = null;
        logger.info("reading backup source configuration for the source :" + sourceType);
        File sourceConfigFile = new File(this.getBackupSourceConfigFile(sourceType));
        if (sourceConfigFile.exists()) {
            logger.info("reading source configuration from file :" + sourceConfigFile.getAbsolutePath());
            JaxbMarshallerHelper<UserSourceConfiguration> jaxbHelper = new JaxbMarshallerHelper<UserSourceConfiguration>();
            sourceConfig = jaxbHelper.unMarshallXMLToObject(new UserSourceConfiguration(), sourceConfigFile);
            logger.info("Backup Source Configuration for source " + sourceType + " has been read succesfully !");
        }
        return sourceConfig;
    }

    @Override
    public void setBackupSourceConfiguration(UserSourceConfiguration sourceConfig, BackupSourceConfig.BackupSource sourceType) throws BackupException {
        if (sourceConfig != null) {
            logger.info("setting backup source configuration for the source " + sourceType);
            File sourceConfigFile = new File(this.getBackupSourceConfigFile(sourceType));
            logger.info("Writing source configuration to file :" + sourceConfigFile.getAbsolutePath());
            JaxbMarshallerHelper<UserSourceConfiguration> jaxbHelper = new JaxbMarshallerHelper<UserSourceConfiguration>();
            jaxbHelper.marshallObjectToXML(sourceConfig, sourceConfigFile);
            logger.info("Backup Source Configuration for source " + sourceType + " has been written succesfully !");
        }
    }

    private String getBackupSourceConfigFile(BackupSourceConfig.BackupSource sourceType) throws BackupException {
        return this.configData.getAppHomePath() + File.separator + sourceType + ".xml";
    }

    private String getSASTierConfigFile() throws BackupException {
        return this.configData.getAppHomePath() + File.separator + "SASTiers.xml";
    }

    @Override
    public void setSASTiers(SASTiers sasTiers) throws BackupException {
        if (sasTiers != null) {
            logger.trace("setting sasTiers...");
            File sasTiersFile = new File(this.getSASTierConfigFile());
            logger.trace("Writing sasTiers to file :" + sasTiersFile.getAbsolutePath());
            JaxbMarshallerHelper<SASTiers> jaxbHelper = new JaxbMarshallerHelper<SASTiers>();
            jaxbHelper.marshallObjectToXML(sasTiers, sasTiersFile);
            logger.trace("SASTiers are written to file successfully !!");
        }
    }

    @Override
    public SASTiers getSASTiers() throws BackupException {
        logger.trace("reading sasTiers...");
        File sasTiersFile = new File(this.getSASTierConfigFile());
        SASTiers sasTiers = null;
        if (sasTiersFile.exists()) {
            logger.trace("reading sasTiers from file :" + sasTiersFile.getAbsolutePath());
            JaxbMarshallerHelper<SASTiers> jaxbHelper = new JaxbMarshallerHelper<SASTiers>();
            sasTiers = jaxbHelper.unMarshallXMLToObject(new SASTiers(), sasTiersFile);
            logger.trace("SASTiers have been read from file successfully !!");
        }
        return sasTiers;
    }
}

