/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.servers.DataServerInterface;
import com.sas.services.information.metadata.servers.SASInfrastructureDataServerUtil;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.ConfigurationFilter;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.OMRBackupSourceSupportService;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.RB;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="OMRDATABASE")
public class OMRPostgresSupportService
extends OMRBackupSourceSupportService {
    private static final Logger logger = LogManager.getLogger(OMRPostgresSupportService.class);
    @Autowired
    private FoundationServicesUserSessionFactory userSessionFactory;
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfigComponent;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    UserConfigurationServiceInterface userBackupConfig;
    @Autowired
    private DeploymentDiscoveryService discoverer;
    @Autowired
    private ConfigBeanConverter configBeanConverter;

    @Override
    public List<AnalysisResult.AnalysisProblem> analyze(RuntimeSASEnvironment sasEnvironment) throws BackupException {
        ArrayList<AnalysisResult.AnalysisProblem> analysisProblems = new ArrayList<AnalysisResult.AnalysisProblem>();
        try {
            List dataServers = this.userBackupConfig.getConfigurableServers(BackupSourceConfig.BackupSource.DATABASE);
            if (!BackupServiceUtils.isEmpty(dataServers)) {
                this.analyzeDataServers(analysisProblems, dataServers);
            } else {
                analysisProblems.add(AnalysisResult.createError((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)RB.getStringResource("OMRPostgresSupportService.analyze.error.wip.dataserver.notfound.txt")));
            }
        }
        catch (RemoteException e) {
            String message = Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.failed.with.unknown.error.fmt"), (Object)BackupSourceConfig.BackupSource.DATABASE);
            logger.error(message, (Throwable)e);
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)message));
        }
        catch (ServiceException e) {
            String message = Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.failed.with.unknown.error.fmt"), (Object)BackupSourceConfig.BackupSource.DATABASE);
            logger.error(message, (Throwable)e);
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)message));
        }
        return analysisProblems;
    }

    private List<AnalysisResult.AnalysisProblem> analyzeDataServers(List<AnalysisResult.AnalysisProblem> analysisProblems, List<ConfigurableServer> solutionDataServers) throws RemoteException, ServiceException {
        for (ConfigurableServer configurableDataServer : solutionDataServers) {
            if (this.userBackupConfig.isCanonicalExclude(configurableDataServer, BackupSourceConfig.BackupSource.DATABASE)) continue;
            ServerComponentInterface dataServer = this.discoverer.getServerComponent(configurableDataServer.getEntityId());
            if (dataServer != null) {
                this.analyzeDataServer(analysisProblems, configurableDataServer);
                continue;
            }
            analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSupportService.analyze.error.server.component.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
        }
        return analysisProblems;
    }

    private List<AnalysisResult.AnalysisProblem> analyzeDataServer(List<AnalysisResult.AnalysisProblem> analysisProblems, ConfigurableServer configurableDataServer) throws RemoteException, ServiceException {
        Map<String, String> serverProperties;
        ServerComponentInterface dataServer = this.discoverer.getServerComponent(configurableDataServer.getEntityId());
        if (BackupServiceUtils.isEmpty(configurableDataServer.getSasTier())) {
            analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.sastier.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
        }
        if ((serverProperties = this.getDataServerProperties(dataServer)) != null) {
            String authDomain;
            String serverPort;
            String serverHost = serverProperties.get("SERVER");
            if (serverHost == null) {
                analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.host.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
            }
            if ((serverPort = serverProperties.get("PORT")) == null) {
                analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.port.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
            }
            if ((authDomain = serverProperties.get("AUTHDOMAIN")) != null) {
                this.analyzeDataServerAuthDomain(analysisProblems, authDomain, configurableDataServer);
            } else {
                analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.authdomain.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
            }
        } else {
            analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.propeties.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
        }
        return analysisProblems;
    }

    private Map<String, String> getDataServerProperties(ServerComponentInterface dataServer) {
        Map<String, String> serverProperties = new HashMap<String, String>();
        try {
            SASInfrastructureDataServerUtil util = new SASInfrastructureDataServerUtil(this.userSessionFactory.getLocalSession());
            DataServerInterface datserverInterface = util.getServerByName(dataServer.getName());
            serverProperties = datserverInterface.getServerProperties();
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return serverProperties;
    }

    private List<AnalysisResult.AnalysisProblem> analyzeDataServerAuthDomain(List<AnalysisResult.AnalysisProblem> analysisProblems, String authDomain, ConfigurableServer configurableDataServer) {
        String userId = null;
        String password = null;
        BackupServiceUtils.Tuple<String, String> userPrincipal = BackupServiceUtils.getUserPrincipal((MetadataServerInterface)this.backupConfigComponent.getServer(), authDomain);
        if (userPrincipal != null) {
            userId = userPrincipal.getKey();
            if (userId == null) {
                analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.user.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
            }
            if ((password = userPrincipal.getValue()) == null) {
                analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.user.password.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
            }
        } else {
            analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableDataServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.user.credentials.notfound.fmt"), (Object)configurableDataServer.getObjectName())));
        }
        return analysisProblems;
    }

    @Override
    public List<BackupTask> getBackupTasks(RuntimeSASEnvironment request) throws BackupException {
        ArrayList<BackupTask> databaseBackupTasks = new ArrayList<BackupTask>();
        StringBuilder connectionURLs = null;
        List sasTiers = request.getAvailableTiers();
        for (SASTier sasTier : sasTiers) {
            List configurablesolServers = this.userBackupConfig.getConfigurableServers(BackupSourceConfig.BackupSource.DATABASE, sasTier);
            if (configurablesolServers == null || configurablesolServers.isEmpty()) continue;
            connectionURLs = new StringBuilder();
            BackupTask.BackupTaskBuilder taskBuilder = BackupTask.getBackupNodeTaskBuilder(BackupSourceConfig.BackupSource.DATABASE, sasTier);
            for (ConfigurableServer server : configurablesolServers) {
                if (!this.userBackupConfig.isExcluded(server, BackupSourceConfig.BackupSource.DATABASE)) {
                    if (!request.hasErrors(BackupSourceConfig.BackupSource.DATABASE, server)) {
                        String connectionUrl;
                        ConfigurationFilter filter = this.userBackupConfig.getConfigurationFilter(server, BackupSourceConfig.BackupSource.DATABASE);
                        Map<String, String> connectionInfo = this.getDataServerProperties(this.discoverer.getServerComponent(server.getEntityId()));
                        ConnectionURLBuilder builder = new ConnectionURLBuilder(server.getObjectName(), connectionInfo);
                        if (filter != null) {
                            builder.filter(filter);
                        }
                        if ((connectionUrl = builder.buildURL()) != null) {
                            if (!connectionURLs.toString().isEmpty()) {
                                connectionURLs.append(",");
                            }
                            connectionURLs.append(connectionUrl);
                            continue;
                        }
                        logger.warn("Unable to build connection URL for server : " + server.getObjectName());
                        continue;
                    }
                    logger.warn("Removing the configurable server as it had errors while analysis : ");
                    continue;
                }
                logger.info("Excluded by user configuration ");
            }
            if (connectionURLs == null || connectionURLs.length() <= 0) continue;
            taskBuilder.addParam("connecturl", connectionURLs.toString());
            taskBuilder.addParam("host", sasTier.getHostName());
            databaseBackupTasks.add(taskBuilder.build());
        }
        return databaseBackupTasks;
    }

    @Override
    public List<BackupTask> getRestoreTasks(RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        return null;
    }

    @Override
    public void reloadSourceConfig(BackupSourceConfig sourceConfig) throws BackupException {
        Properties postgresprops = sourceConfig.getProperties();
        try {
            Map<String, String> connectionInfo = null;
            BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
            SASTier sasTier = this.configBeanConverter.sourceNodeToSASTier(sourceNode);
            List configurableServers = this.userBackupConfig.getConfigurableServers(BackupSourceConfig.BackupSource.DATABASE, sasTier);
            if (configurableServers != null && !configurableServers.isEmpty()) {
                StringBuilder connectionURLs = new StringBuilder();
                for (ConfigurableServer server : configurableServers) {
                    if (!this.userBackupConfig.isExcluded(server, BackupSourceConfig.BackupSource.DATABASE)) {
                        connectionInfo = this.getDataServerProperties(this.discoverer.getServerComponent(server.getEntityId()));
                        ConnectionURLBuilder builder = new ConnectionURLBuilder(server.getObjectName(), connectionInfo);
                        String connectionUrl = builder.buildURL();
                        if (connectionUrl != null) {
                            if (!connectionURLs.toString().isEmpty()) {
                                connectionURLs.append(",");
                            }
                            connectionURLs.append(connectionUrl);
                            continue;
                        }
                        logger.warn("Unable to build connection URL for server : " + server.getObjectName());
                        continue;
                    }
                    logger.info("Excluded by user configuration ");
                }
                if (connectionURLs != null && connectionURLs.length() > 0) {
                    postgresprops.setProperty("connecturl", connectionURLs.toString());
                    postgresprops.setProperty("host", sourceNode.getHostName());
                }
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException(RB.getStringResource("OMRPostgresSupportService.error.reload.configuration.failed.txt"), (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode());
        }
        sourceConfig.setProperties(postgresprops);
    }

    private class ConnectionURLBuilder {
        private StringBuilder urlBuilder;
        private String name;

        private ConnectionURLBuilder(String name, Map<String, String> connectionInfo) throws BackupException {
            if (connectionInfo != null) {
                this.urlBuilder = new StringBuilder();
                try {
                    this.name = name;
                    this.urlBuilder.append(name);
                    this.urlBuilder.append("://");
                    String serverHost = connectionInfo.get("SERVER");
                    String serverPort = connectionInfo.get("PORT");
                    String AuthDomain = connectionInfo.get("AUTHDOMAIN");
                    MetadataServerInterface metadataServer = (MetadataServerInterface)OMRPostgresSupportService.this.backupConfigComponent.getServer();
                    List loginAuthDoamin = metadataServer.getLoginsForAuthDomain(AuthDomain);
                    if (loginAuthDoamin.size() > 0) {
                        UserIdentityInterface uid = (UserIdentityInterface)loginAuthDoamin.get(0);
                        String userName = uid.getPrincipal().toString();
                        String password = uid.getCredential().toString();
                        this.urlBuilder.append(userName);
                        this.urlBuilder.append("@@");
                        this.urlBuilder.append(serverHost);
                        this.urlBuilder.append(":");
                        this.urlBuilder.append(serverPort);
                        this.urlBuilder.append("::");
                        this.urlBuilder.append(password);
                    }
                }
                catch (RemoteException e) {
                    logger.error(RB.getStringResource("OMRPostgresSupportService.error.credentials.notfound.txt"), (Throwable)e);
                    logger.error(e.getMessage());
                    throw new BackupException(RB.getStringResource("OMRPostgresSupportService.error.credentials.notfound.txt"), (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode());
                }
                catch (ServiceException exception) {
                    logger.error(RB.getStringResource("OMRPostgresSupportService.error.credentials.notfound.txt"), (Throwable)exception);
                    logger.error(exception.getMessage());
                    throw new BackupException(RB.getStringResource("OMRPostgresSupportService.error.credentials.notfound.txt"), (Throwable)exception, BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_DISCOVERY_FAILED.getErrorCode());
                }
            }
        }

        private ConnectionURLBuilder filter(ConfigurationFilter filter) {
            if (filter.getIncludes() != null || filter.getExcludes() != null) {
                String includes;
                this.urlBuilder.append("?");
                String excludes = BackupServiceUtils.listtoString(filter.getExcludes(), "|", this.name + "@");
                if (excludes != null && !excludes.trim().isEmpty()) {
                    this.urlBuilder.append("excludes=");
                    this.urlBuilder.append(excludes);
                }
                if ((includes = BackupServiceUtils.listtoString(filter.getIncludes(), "|", this.name + "@")) != null && !includes.trim().isEmpty()) {
                    this.urlBuilder.append("&includes=");
                    this.urlBuilder.append(includes);
                }
            }
            return this;
        }

        private String buildURL() {
            if (this.urlBuilder != null) {
                return this.urlBuilder.toString();
            }
            return null;
        }
    }
}

