/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.deployment.agent.access.Control;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.util.DeploymentAgentUtil;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.solstice.platform.core.access.IResults;
import com.sas.solstice.platform.core.dao.Results;
import com.sas.solstice.platform.core.password.SasPasswordEncodingException;
import com.sas.solstice.platform.core.password.SasPasswordString;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentAgentClient {
    private static OperationDetails.OperationStatus status = null;
    private static final String SAS_DEPLOY_AGENT_CLIENT_CONFIG = "sas.deployment.agent.client.config";
    private static final Logger logger = LogManager.getLogger(DeploymentAgentClient.class);

    public OperationDetails.OperationStatus getStatus() {
        return status;
    }

    public void setStatus(OperationDetails.OperationStatus status) {
        DeploymentAgentClient.status = status;
    }

    private static IResults createBadResult() {
        String str = RB.getStringResource("DeploymentAgentClient.Enter.correct.parameters.txt");
        logger.warn(str);
        Results localResults = new Results();
        localResults.setMessage(str);
        localResults.setStatus(4);
        return localResults;
    }

    public static List<String> getUnreachableHosts(List<String> hosts) {
        ArrayList<String> failedHosts = new ArrayList<String>();
        for (String host : hosts) {
            if (DeploymentAgentClient.isAgentRunning(host)) continue;
            logger.info("Unable to connect to SAS Deployment Agent on machine " + host);
            failedHosts.add(host);
        }
        return failedHosts;
    }

    public static boolean isAgentRunning(String host) {
        boolean isRunning = false;
        String port = null;
        Properties cltProps = null;
        try {
            cltProps = DeploymentAgentClient.getClientProperties(host);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!BackupServiceUtils.isEmpty(cltProps)) {
            port = cltProps.getProperty("solstice.agent.jmx.port");
        }
        Control localControl = null;
        localControl = BackupServiceUtils.isEmpty(port) ? DeploymentAgentClient.getControl(host) : DeploymentAgentClient.getControl(host + ":" + port);
        logger.trace("LocalControl to set connection properties for agent" + localControl.getHost() + ":" + localControl.getPort());
        Results localResults1 = DeploymentAgentClient.setConnectionProperties(localControl);
        if (localResults1.isOk()) {
            isRunning = localControl.connect();
        }
        return isRunning;
    }

    public static IResults handleArgLine(String[] paramArrayOfString1, String[] paramArrayOfString2) {
        if (paramArrayOfString2.length > 0 && paramArrayOfString2[0].equalsIgnoreCase("quit")) {
            logger.debug("Good bye.");
            return null;
        }
        if (paramArrayOfString2.length < 2) {
            return DeploymentAgentClient.createBadResult();
        }
        String str1 = paramArrayOfString2[0];
        String host = paramArrayOfString2[1];
        String port = null;
        Properties cltProps = null;
        try {
            cltProps = DeploymentAgentClient.getClientProperties(host);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!BackupServiceUtils.isEmpty(cltProps)) {
            port = cltProps.getProperty("solstice.agent.jmx.port");
        }
        Control localControl = null;
        localControl = BackupServiceUtils.isEmpty(port) ? DeploymentAgentClient.getControl(paramArrayOfString2[1]) : DeploymentAgentClient.getControl(host + ":" + port);
        Results localResults1 = DeploymentAgentClient.setConnectionProperties(localControl);
        if (!localResults1.isOk()) {
            return localResults1;
        }
        IResults localObject1 = null;
        Results localObject2 = null;
        if (str1.equalsIgnoreCase("doExec")) {
            if (paramArrayOfString2.length < 3) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject2 = Arrays.copyOfRange(paramArrayOfString2, 2, paramArrayOfString2.length);
            String[] arrayOfString = Arrays.copyOfRange(paramArrayOfString2, 2, paramArrayOfString2.length);
            localObject1 = localControl.doExec(arrayOfString);
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("doExecAsUser")) {
            if (paramArrayOfString2.length < 6) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject2 = Arrays.copyOfRange(paramArrayOfString2, 5, paramArrayOfString2.length);
            String[] arrayOfString = Arrays.copyOfRange(paramArrayOfString2, 5, paramArrayOfString2.length);
            try {
                String str2 = SasPasswordString.encode((String)paramArrayOfString1[2]);
                String str4 = SasPasswordString.encode((String)paramArrayOfString1[3]);
                localObject1 = localControl.doExecAsUser(str2, str4, paramArrayOfString1[4], arrayOfString);
            }
            catch (SasPasswordEncodingException localSasPasswordEncodingException1) {
                Results localResults2 = new Results();
                localResults2.setException((Exception)((Object)localSasPasswordEncodingException1));
                localResults2.setStatus(4);
                localObject1 = localResults2;
            }
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("doExecTimed")) {
            if (paramArrayOfString2.length < 4) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject2 = Arrays.copyOfRange(paramArrayOfString2, 3, paramArrayOfString2.length);
            String[] arrayOfString = Arrays.copyOfRange(paramArrayOfString2, 3, paramArrayOfString2.length);
            int i = new Integer(paramArrayOfString1[2]);
            localObject1 = localControl.doExec(arrayOfString, i);
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("doExecAsUserTimed")) {
            if (paramArrayOfString2.length < 7) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject2 = Arrays.copyOfRange(paramArrayOfString2, 6, paramArrayOfString2.length);
            String[] arrayOfString = Arrays.copyOfRange(paramArrayOfString2, 6, paramArrayOfString2.length);
            try {
                String str3 = SasPasswordString.encode((String)paramArrayOfString1[3]);
                String str5 = SasPasswordString.encode((String)paramArrayOfString1[4]);
                int j = new Integer(paramArrayOfString1[2]);
                localObject1 = localControl.doExecAsUser(str3, str5, paramArrayOfString1[5], arrayOfString, j);
            }
            catch (SasPasswordEncodingException localSasPasswordEncodingException2) {
                Results localResults3 = new Results();
                localResults3.setException((Exception)((Object)localSasPasswordEncodingException2));
                localResults3.setStatus(4);
                localObject1 = localResults3;
            }
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("pullFile")) {
            if (paramArrayOfString2.length < 4 || paramArrayOfString2.length > 5) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject2 = paramArrayOfString2[2];
            String str3 = paramArrayOfString2[3];
            if (paramArrayOfString2.length == 4) {
                localObject1 = localControl.pullFile((String)localObject2, str3);
            } else if (paramArrayOfString2.length == 5) {
                boolean bool2 = Boolean.parseBoolean(paramArrayOfString2[4]);
                localObject1 = localControl.pullFile((String)localObject2, str3, bool2);
            }
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("pullFolder")) {
            if (paramArrayOfString2.length != 4) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject1 = localControl.pullFolder(paramArrayOfString2[2], paramArrayOfString2[3]);
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("pullFolderFiles")) {
            if (paramArrayOfString2.length != 4) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject1 = localControl.pullFolderFiles(paramArrayOfString2[2], paramArrayOfString2[3]);
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("copyFile")) {
            if (paramArrayOfString2.length < 4 || paramArrayOfString2.length > 5) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject2 = paramArrayOfString2[2];
            String str3 = paramArrayOfString2[3];
            if (paramArrayOfString2.length == 4) {
                localObject1 = localControl.copyFile((String)localObject2, str3);
            } else if (paramArrayOfString2.length == 5) {
                boolean bool2 = Boolean.parseBoolean(paramArrayOfString2[4]);
                localObject1 = localControl.copyFile((String)localObject2, str3, bool2);
            }
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("copyFolder")) {
            if (paramArrayOfString2.length != 4) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject1 = localControl.copyFolder(paramArrayOfString2[2], paramArrayOfString2[3]);
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("pullFolderList")) {
            if (paramArrayOfString2.length != 3) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject2 = new Results();
            try {
                DeploymentAgentClient.printStringList(localControl.pullFolderList(paramArrayOfString2[2], true));
            }
            catch (IOException localIOException1) {
                localObject2.setStatus(4);
                localObject2.setException((Exception)localIOException1);
                localObject1 = localObject2;
            }
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("pullFolderFileList")) {
            if (paramArrayOfString2.length != 3) {
                return DeploymentAgentClient.createBadResultAndDispose(localControl);
            }
            localObject2 = new Results();
            try {
                DeploymentAgentClient.printStringList(localControl.pullFolderList(paramArrayOfString2[2], false));
            }
            catch (IOException localIOException2) {
                localObject2.setStatus(4);
                localObject2.setException((Exception)localIOException2);
                localObject1 = localObject2;
            }
            DeploymentAgentClient.printResult(localObject1);
        } else if (str1.equalsIgnoreCase("isHostAvailable")) {
            localObject2 = new Results();
            localObject2.setStatus(0);
            localObject2.setMessage("Host is available");
            boolean bool1 = localControl.isHostAvailable();
            if (!bool1) {
                localObject2.setMessage("Host is not available");
            }
            DeploymentAgentClient.printResult((IResults)localObject2);
            localObject1 = localObject2;
        } else {
            localObject2 = new Results();
            localObject2.setMessage(RB.getStringResource("DeploymentAgentClient.unknown.command.txt"));
            localObject2.setStatus(4);
            DeploymentAgentClient.printResult((IResults)localObject2);
            localObject1 = localObject2;
        }
        localControl.disconnect();
        return localObject1;
    }

    private static IResults createBadResultAndDispose(Control paramControl) {
        paramControl.disconnect();
        return DeploymentAgentClient.createBadResult();
    }

    private static Control getControl(String paramString) {
        String str1 = DeploymentAgentClient.getHost(paramString);
        String str2 = DeploymentAgentClient.getPort(paramString);
        if (str2.length() > 0) {
            return new Control(str1, str2);
        }
        return new Control(str1);
    }

    private static String getHost(String paramString) {
        int i = paramString.indexOf(":");
        if (i == -1) {
            return paramString;
        }
        if (i == 0) {
            return "";
        }
        return paramString.substring(0, i);
    }

    private static String getPort(String paramString) {
        int i = paramString.indexOf(":");
        if (i == -1) {
            return "";
        }
        return paramString.substring(i + 1);
    }

    private static Results setConnectionProperties(Control paramControl) {
        Properties localProperties = null;
        try {
            localProperties = DeploymentAgentClient.getClientProperties(paramControl.getHost());
        }
        catch (Exception exception) {
            String str2 = exception.getMessage();
            logger.warn(str2, (Throwable)exception);
            Results localResults = new Results();
            localResults.setMessage(str2);
            localResults.setStatus(4);
            return new Results();
        }
        if (!BackupServiceUtils.isEmpty(localProperties)) {
            paramControl.setConnectionProperties(localProperties);
            logger.trace("Done setting of connection properties for SAS Deployment Agent.");
        } else {
            logger.info("SAS Deployment Agent will be invoked with default properties.");
        }
        return new Results();
    }

    private static void printStringList(List<String> paramList) {
        for (String str : paramList) {
            logger.debug(str);
        }
    }

    public static void printResult(IResults paramIResults) {
        if (paramIResults == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        if (paramIResults.getStatus() != 0) {
            logger.error(Message.format((String)RB.getStringResource("DeploymentAgentClient.command.status.fmt"), (Object)paramIResults.getStatus()));
        } else {
            logger.info(RB.getStringResource("DeploymentAgentClient.command.successfull.txt"));
        }
        logger.info("Status Code:" + paramIResults.getStatus() + "  Message:" + paramIResults.getMessage() + "  Exception: " + paramIResults.getException());
        if (paramIResults.getMessage() != null) {
            logger.info(paramIResults.getMessage());
        }
        if (paramIResults.getException() != null) {
            logger.info((Object)paramIResults.getException());
            paramIResults.getException().printStackTrace();
        }
    }

    public static Properties getClientProperties(String host) throws BackupException {
        Properties properties = null;
        try {
            String str1 = System.getProperty(SAS_DEPLOY_AGENT_CLIENT_CONFIG);
            if (BackupServiceUtils.isEmpty(str1)) {
                logger.warn("sas.deployment.agent.client.config system property not set.");
                return null;
            }
            logger.trace("sas.deployment.agent.client.config=" + str1);
            ServerInterface authServer = OMRDeploymentBackupConfiguration.getAuthServer();
            logger.trace("Retrieving SAS Remote Deployment Agent Client properties. ");
            MdFactory factory = null;
            if (authServer != null && authServer instanceof OMIServer) {
                factory = ((OMIServer)authServer).getMdFactory();
            }
            if (!BackupServiceUtils.isEmpty(properties = DeploymentAgentUtil.getDeploymentAgentProperties(factory, (String)host))) {
                logger.trace("Got SAS Remote Deployment Agent Client properties.");
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!"solstice.agent.jmx.port".equalsIgnoreCase(key.trim())) continue;
                    logger.trace("solstice.agent.jmx.port =" + value);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrive SAS Remote Deployment Agent Client properties.", (Throwable)e);
            throw new BackupException("Error encountered while trying to fetch deployment agent client properties", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_DEPLOYMENT_AGENT_COMMUNICATION_FAILURE.getErrorCode());
        }
        return properties;
    }
}

