/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.svcs.backup.dao.RB;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Repository;

@Repository(value="ConfigurationDAO")
public class ConfigurationDAOImpl {
    Logger logger = LogManager.getLogger(ConfigurationDAOImpl.class);
    private Properties configurableProps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getConfigProperties() {
        block13: {
            this.configurableProps = new Properties();
            File propFile = new File("backupservice_config.properties");
            if (!propFile.exists()) {
                return this.configurableProps;
            }
            FileInputStream fis = null;
            try {
                this.logger.info(Message.format((String)RB.getStringResource("ConfigurationDAOImpl.loading.prpoertiesfile.fmt"), (Object)propFile.getCanonicalPath()));
                if (propFile.exists()) {
                    fis = new FileInputStream(propFile);
                    this.configurableProps.load(fis);
                    break block13;
                }
                throw new FileNotFoundException(propFile.getCanonicalPath() + " does not exist!");
            }
            catch (IOException iOException) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.configurableProps;
    }

    public String getSCSUser() {
        return this.getConfigProperties().getProperty("scs.user");
    }

    public String getSCSPassword() {
        return this.getConfigProperties().getProperty("scs.password");
    }

    public String getSCSHost() {
        return this.getConfigProperties().getProperty("scs.host");
    }

    public String getSCSPort() {
        return this.getConfigProperties().getProperty("scs.port");
    }

    public String getSCSDefaultRepos() {
        return this.getConfigProperties().getProperty("scs.defaultrepos");
    }

    public String getSCSRoot() {
        return this.getConfigProperties().getProperty("scs.scsroot");
    }

    public String getPostgresUser() {
        return this.getConfigProperties().getProperty("postgres.user");
    }

    public String getPostgresPassword() {
        return this.getConfigProperties().getProperty("postgres.password");
    }

    public String getPostgresDBName() {
        return this.getConfigProperties().getProperty("postgres.dbname");
    }

    public String getPostgresBinPath() {
        return this.getConfigProperties().getProperty("postgres.binpath");
    }

    public String getPostgresHostName() {
        return this.getConfigProperties().getProperty("postgres.host");
    }

    public String getPostgresPort() {
        return this.getConfigProperties().getProperty("postgres.port");
    }
}

