/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class BackupServiceThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Logger logger = LogManager.getLogger(BackupServiceThreadPoolTaskExecutor.class);
    private static final long serialVersionUID = -8368522567884961296L;

    public void execute(final Runnable task) {
        logger.debug("Trying to propogate security context to called thread.");
        final Authentication a = SecurityContextHolder.getContext().getAuthentication();
        super.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SecurityContext ctx = SecurityContextHolder.createEmptyContext();
                    ctx.setAuthentication(a);
                    SecurityContextHolder.setContext((SecurityContext)ctx);
                    logger.debug("Security context set for called thread");
                    task.run();
                }
                finally {
                    SecurityContextHolder.clearContext();
                }
            }
        });
    }
}

