/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.analyze;

import com.sas.svcs.backup.analyze.OperationRequest;
import com.sas.svcs.backup.analyze.RB;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.OMRBackupSourceSupportService;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeploymentAnalyzer {
    @Autowired
    BackupConfigurationService backupConfigurationService;

    public AnalysisResult analyze(RuntimeSASEnvironment runtimeSASEnvironment, OperationRequest<?> operationRequest) {
        AnalysisResult analysisResult = AnalysisResult.getInstance();
        this.ensureEnvIntegrity(runtimeSASEnvironment, analysisResult);
        this.analyzeBackupSources(runtimeSASEnvironment, analysisResult);
        return analysisResult;
    }

    private AnalysisResult ensureEnvIntegrity(RuntimeSASEnvironment runtimeSASEnvironment, AnalysisResult analysisResult) {
        this.ensureNotAllTiersUnavailable(runtimeSASEnvironment);
        this.ensurePrimaryMetdataTierIsAssigned(runtimeSASEnvironment, analysisResult);
        return analysisResult;
    }

    private void ensureNotAllTiersUnavailable(RuntimeSASEnvironment runtimeSASEnvironment) {
        if (runtimeSASEnvironment.getAvailableTiers().isEmpty()) {
            String message = RB.getStringResource("DeploymentAnalyzer.no.tiers.available.txt");
            throw new BackupException.BackupExceptionBuilder(BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode()).setMessage(message).build();
        }
    }

    private AnalysisResult analyzeBackupSources(RuntimeSASEnvironment runtimeSASEnvironment, AnalysisResult analysisResult) {
        for (BackupSourceConfig.BackupSource sourceType : BackupSourceConfig.BackupSource.values()) {
            OMRBackupSourceSupportService omrSupportService = this.backupConfigurationService.getOMRSupportService(sourceType);
            List<AnalysisResult.AnalysisProblem> analysisProblems = omrSupportService.analyze(runtimeSASEnvironment);
            if (analysisProblems == null || analysisProblems.isEmpty()) continue;
            analysisResult.addAllProblems(sourceType, analysisProblems);
        }
        return analysisResult;
    }

    private AnalysisResult ensurePrimaryMetdataTierIsAssigned(RuntimeSASEnvironment runtimeSASEnvironment, AnalysisResult analysisResult) {
        if (!runtimeSASEnvironment.isPrimaryMetdataTierPresent()) {
            String message = RB.getStringResource("DeploymentAnalyzer.primary.metadata.not.reachable.txt");
            throw new BackupException.BackupExceptionBuilder(BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode()).setMessage(message).build();
        }
        return analysisResult;
    }
}

