/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.ssl;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.RB;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import javax.net.ssl.SSLSocketFactory;

@SASScope
public final class SSLRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 487646882453068374L;
    private static final int HASH_CODE_PRIME = 31;
    private Boolean _isReuseAddress;

    public SSLRMIClientSocketFactory() {
    }

    public SSLRMIClientSocketFactory(Boolean isReuseAddress) {
        this._isReuseAddress = isReuseAddress;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Socket socket = factory.createSocket(host, port);
        if (null != this._isReuseAddress) {
            boolean isReuseAddress = this._isReuseAddress;
            if (socket.getReuseAddress() != isReuseAddress) {
                socket.setReuseAddress(isReuseAddress);
            }
        }
        return socket;
    }

    public int hashCode() {
        return 0x1F ^ Long.valueOf(487646882453068374L).hashCode() + (null == this._isReuseAddress ? 0 : this._isReuseAddress.hashCode());
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (this == object) {
            isEqual = true;
        } else {
            try {
                SSLRMIClientSocketFactory other = (SSLRMIClientSocketFactory)object;
                if (other != null) {
                    Boolean isReuseAddress = other._isReuseAddress;
                    isEqual = null == this._isReuseAddress ? isReuseAddress == null : this._isReuseAddress.equals(isReuseAddress);
                }
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    static {
        try {
            SSLSocketFactory.getDefault();
        }
        catch (NoClassDefFoundError e) {
            System.err.println(RB.getStringResource("SSLRMIServerSocketFactory.jsseJarIsNotAvailableInJRE.ex.txt"));
            throw e;
        }
    }
}

