/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.ssl;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.RB;
import java.security.PrivilegedAction;

@SASScope
final class GetPropertyAction
implements PrivilegedAction<String> {
    private String _propertyName;
    private String _propertyValue;
    private String _propertyDefaultValue;

    GetPropertyAction(String propertyName) {
        this.setPropertyName(propertyName);
    }

    GetPropertyAction(String propertyName, String propertyDefaultValue) throws IllegalArgumentException {
        this(propertyName);
        this._propertyDefaultValue = propertyDefaultValue;
    }

    private void setPropertyName(String propertyName) throws IllegalArgumentException {
        if (null == propertyName) {
            throw new IllegalArgumentException(RB.getStringResource("GetPropertyAction.specifyPropertyName.ex.txt"));
        }
        this._propertyName = propertyName;
    }

    String getValue() {
        return this._propertyValue;
    }

    @Override
    public String run() {
        String string = this._propertyValue = this._propertyName != null && this._propertyName.trim().length() > 0 ? System.getProperty(this._propertyName) : null;
        if (null == this._propertyValue) {
            this._propertyValue = this._propertyDefaultValue;
        }
        return this._propertyValue;
    }
}

