/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.rmi;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.rmi.AbstractRemoteObjectExporter;
import com.sas.net.rmi.RB;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ActivatableExporter
extends AbstractRemoteObjectExporter
implements RemoteObjectExporterInterface {
    private ActivationID _activationId;

    public ActivatableExporter(Remote remoteObject, int portNumber, RMIClientSocketFactory rmiClientSocketFactory, RMIServerSocketFactory rmiServerSocketFactory, boolean isForcibleUnexport, ActivationID activationId) throws IllegalArgumentException {
        super(remoteObject, portNumber, rmiClientSocketFactory, rmiServerSocketFactory, isForcibleUnexport);
        this.setActivationId(activationId);
    }

    private final void setActivationId(ActivationID activationId) throws IllegalArgumentException {
        if (null == activationId) {
            throw new IllegalArgumentException(RB.getStringResource("ActivatableExporter.invalidActivationID.ex.txt"));
        }
        this._activationId = activationId;
    }

    @Override
    protected final Remote exportObject(Remote remoteObject, int portNumber, RMIClientSocketFactory rmiClientSocketFactory, RMIServerSocketFactory rmiServerSocketFactory) throws RemoteException {
        return Activatable.exportObject((Remote)remoteObject, (ActivationID)this._activationId, (int)portNumber, (RMIClientSocketFactory)rmiClientSocketFactory, (RMIServerSocketFactory)rmiServerSocketFactory);
    }

    @Override
    protected final boolean unexportObject(Remote exportedRemoteObjectStub, boolean isForcibleUnexport) throws NoSuchObjectException {
        return Activatable.unexportObject((Remote)exportedRemoteObjectStub, (boolean)isForcibleUnexport);
    }
}

