/*
 * Decompiled with CFR 0.152.
 */
package org.castor.core.nature;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.castor.core.nature.Nature;
import org.castor.core.nature.PropertyHolder;

public abstract class BaseNature
implements Nature {
    private PropertyHolder _holder = null;

    protected BaseNature(PropertyHolder holder) {
        if (holder == null) {
            throw new NullPointerException("Holder must be set");
        }
        if (!holder.hasNature(this.getId())) {
            throw new IllegalStateException(this.getId() + " Nature must be set before");
        }
        this._holder = holder;
    }

    protected final Object getProperty(String key) {
        return this._holder.getProperty(this.addPrefix(key));
    }

    protected final void setProperty(String key, Object property) {
        if (key != null) {
            this._holder.setProperty(this.addPrefix(key), property);
        }
    }

    private String addPrefix(String key) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getId());
        buf.append(key);
        return buf.toString();
    }

    protected final boolean getBooleanPropertyDefaultFalse(String propertyName) {
        Boolean b = (Boolean)this.getProperty(propertyName);
        if (b == null) {
            return false;
        }
        return b;
    }

    protected final PropertyHolder getHolder() {
        return this._holder;
    }

    protected List getPropertyAsList(String property) {
        LinkedList list = (LinkedList)this.getProperty(property);
        if (list == null) {
            list = new LinkedList();
            this.setProperty(property, list);
        }
        return list;
    }

    protected Map getPropertyAsMap(String property) {
        HashMap map = (HashMap)this.getProperty(property);
        if (map == null) {
            map = new HashMap();
            this.setProperty(property, map);
        }
        return map;
    }
}

