/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.extra;

import com.atomikos.jms.extra.MessageConsumerSession;
import com.atomikos.jms.extra.MessageConsumerSessionProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;

class BatchingConsumerSession
extends MessageConsumerSession {
    private int maxBatchSize = 50;
    private int currentBatchSize = 1;

    protected BatchingConsumerSession(MessageConsumerSessionProperties properties, int maxBatchSize) {
        super(properties);
        this.maxBatchSize = maxBatchSize;
    }

    protected int getCurrentBatchSize() {
        return this.currentBatchSize;
    }

    private synchronized void increaseCurrentBatchSizeIfPossible() {
        if (this.currentBatchSize < this.maxBatchSize) {
            ++this.currentBatchSize;
        }
    }

    private synchronized void resetCurrentBatchSize() {
        this.currentBatchSize = 1;
    }

    @Override
    protected Message receiveNextMessage(MessageConsumer receiver) throws JMSException {
        BatchedMessage batch = new BatchedMessage(this.currentBatchSize);
        boolean firstInBatch = true;
        while (batch.canAdd()) {
            Message msg = this.receiveMessage(receiver, firstInBatch);
            batch.add(msg);
            firstInBatch = false;
        }
        return batch;
    }

    private Message receiveMessage(MessageConsumer receiver, boolean firstInBatch) throws JMSException {
        if (firstInBatch) {
            return super.receiveNextMessage(receiver);
        }
        return receiver.receiveNoWait();
    }

    @Override
    protected void processMessage(Message message) throws JMSException {
        BatchedMessage msg = (BatchedMessage)message;
        List<Message> messages = msg.getMessages();
        for (Message m : messages) {
            try {
                super.processMessage(m);
            }
            catch (JMSException e) {
                this.resetCurrentBatchSize();
                throw e;
            }
            catch (RuntimeException e) {
                this.resetCurrentBatchSize();
                throw e;
            }
            catch (Error e) {
                this.resetCurrentBatchSize();
                throw e;
            }
        }
        this.increaseCurrentBatchSizeIfPossible();
    }

    static class BatchedMessage
    implements Message {
        private boolean complete = false;
        private List<Message> messages = new ArrayList<Message>();
        private int size;

        public BatchedMessage(int size) {
            this.size = size;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public boolean canAdd() {
            return !this.complete && this.messages.size() < this.size;
        }

        public void add(Message msg) {
            if (msg != null) {
                this.messages.add(msg);
            } else {
                this.complete = true;
            }
        }

        public String getJMSMessageID() throws JMSException {
            return null;
        }

        public void setJMSMessageID(String id) throws JMSException {
        }

        public long getJMSTimestamp() throws JMSException {
            return 0L;
        }

        public void setJMSTimestamp(long timestamp) throws JMSException {
        }

        public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
            return null;
        }

        public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        }

        public void setJMSCorrelationID(String correlationID) throws JMSException {
        }

        public String getJMSCorrelationID() throws JMSException {
            return null;
        }

        public Destination getJMSReplyTo() throws JMSException {
            return null;
        }

        public void setJMSReplyTo(Destination replyTo) throws JMSException {
        }

        public Destination getJMSDestination() throws JMSException {
            return null;
        }

        public void setJMSDestination(Destination destination) throws JMSException {
        }

        public int getJMSDeliveryMode() throws JMSException {
            return 0;
        }

        public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        }

        public boolean getJMSRedelivered() throws JMSException {
            return false;
        }

        public void setJMSRedelivered(boolean redelivered) throws JMSException {
        }

        public String getJMSType() throws JMSException {
            return null;
        }

        public void setJMSType(String type) throws JMSException {
        }

        public long getJMSExpiration() throws JMSException {
            return 0L;
        }

        public void setJMSExpiration(long expiration) throws JMSException {
        }

        public int getJMSPriority() throws JMSException {
            return 0;
        }

        public void setJMSPriority(int priority) throws JMSException {
        }

        public void clearProperties() throws JMSException {
        }

        public boolean propertyExists(String name) throws JMSException {
            return false;
        }

        public boolean getBooleanProperty(String name) throws JMSException {
            return false;
        }

        public byte getByteProperty(String name) throws JMSException {
            return 0;
        }

        public short getShortProperty(String name) throws JMSException {
            return 0;
        }

        public int getIntProperty(String name) throws JMSException {
            return 0;
        }

        public long getLongProperty(String name) throws JMSException {
            return 0L;
        }

        public float getFloatProperty(String name) throws JMSException {
            return 0.0f;
        }

        public double getDoubleProperty(String name) throws JMSException {
            return 0.0;
        }

        public String getStringProperty(String name) throws JMSException {
            return null;
        }

        public Object getObjectProperty(String name) throws JMSException {
            return null;
        }

        public Enumeration getPropertyNames() throws JMSException {
            return null;
        }

        public void setBooleanProperty(String name, boolean value) throws JMSException {
        }

        public void setByteProperty(String name, byte value) throws JMSException {
        }

        public void setShortProperty(String name, short value) throws JMSException {
        }

        public void setIntProperty(String name, int value) throws JMSException {
        }

        public void setLongProperty(String name, long value) throws JMSException {
        }

        public void setFloatProperty(String name, float value) throws JMSException {
        }

        public void setDoubleProperty(String name, double value) throws JMSException {
        }

        public void setStringProperty(String name, String value) throws JMSException {
        }

        public void setObjectProperty(String name, Object value) throws JMSException {
        }

        public void acknowledge() throws JMSException {
        }

        public void clearBody() throws JMSException {
        }

        public int size() {
            return this.messages.size();
        }

        public String toString() {
            return "A message batch of size " + this.size();
        }
    }
}

