/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.pool.ConnectionPool;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.ConnectionPoolWithConcurrentValidation;
import com.atomikos.datasource.pool.ConnectionPoolWithSynchronizedValidation;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.PoolExhaustedException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.xa.XAResourcePreferenceHolder;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.event.XAResourceDetectedEvent;
import com.atomikos.datasource.xa.jms.JmsTransactionalResource;
import com.atomikos.icatch.OrderedLifecycleComponent;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.event.Event;
import com.atomikos.jms.internal.AtomikosJMSException;
import com.atomikos.jms.internal.AtomikosPooledJmsConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.publish.EventPublisher;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.IntraVmObjectFactory;
import com.atomikos.util.IntraVmObjectRegistry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class AtomikosConnectionFactoryBean
implements ConnectionFactory,
ConnectionPoolProperties,
Referenceable,
Serializable,
OrderedLifecycleComponent {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosConnectionFactoryBean.class);
    private static final long serialVersionUID = 1L;
    private String uniqueResourceName;
    private int maxPoolSize = 1;
    private int minPoolSize = 1;
    private String xaConnectionFactoryClassName;
    private int borrowConnectionTimeout = 30;
    private Properties xaProperties = new Properties();
    private transient ConnectionPool<Connection> connectionPool;
    private transient XAConnectionFactory xaConnectionFactory;
    private int maintenanceInterval = 60;
    private int maxIdleTime = 60;
    private int reapTimeout = 0;
    private boolean localTransactionMode;
    private int maxLifetime = 0;
    private boolean ignoreSessionTransactedFlag = true;
    private Set<String> xaPropertyNamesToHide = new HashSet<String>();
    private final XAResourcePreferenceHolder xaResourcePreferenceHolder = new XAResourcePreferenceHolder();
    private boolean failOnInitIfBrokerDown;
    private boolean enableConcurrentConnectionValidation = true;

    protected String printXaProperties() {
        return PropertyUtils.printProperties((Properties)this.xaProperties, this.xaPropertyNamesToHide);
    }

    private void throwAtomikosJMSException(String msg) throws AtomikosJMSException {
        this.throwAtomikosJMSException(msg, null);
    }

    private void throwAtomikosJMSException(String msg, Throwable cause) throws AtomikosJMSException {
        AtomikosJMSException.throwAtomikosJMSException(msg, cause);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setPoolSize(int minAndMaxSize) {
        this.setMinPoolSize(minAndMaxSize);
        this.setMaxPoolSize(minAndMaxSize);
    }

    public String getUniqueResourceName() {
        return this.uniqueResourceName;
    }

    public void setUniqueResourceName(String resourceName) {
        this.uniqueResourceName = resourceName;
    }

    public String getXaConnectionFactoryClassName() {
        return this.xaConnectionFactoryClassName;
    }

    public void setXaConnectionFactoryClassName(String xaConnectionFactoryClassName) {
        this.xaConnectionFactoryClassName = xaConnectionFactoryClassName;
    }

    public Properties getXaProperties() {
        return this.xaProperties;
    }

    public void setXaProperties(Properties xaProperties) {
        this.xaProperties = xaProperties;
    }

    public XAConnectionFactory getXaConnectionFactory() {
        return this.xaConnectionFactory;
    }

    public void setXaConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
    }

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public synchronized void init() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logInfo(this + ": init...");
        }
        if (this.connectionPool != null) {
            return;
        }
        if (this.maxPoolSize < 1) {
            this.throwAtomikosJMSException("Property 'maxPoolSize' of class AtomikosConnectionFactoryBean must be greater than 0, was: " + this.maxPoolSize);
        }
        if (this.minPoolSize < 0 || this.minPoolSize > this.maxPoolSize) {
            this.throwAtomikosJMSException("Property 'minPoolSize' of class AtomikosConnectionFactoryBean must be at least 0 and at most maxPoolSize, was: " + this.minPoolSize);
        }
        if (this.getUniqueResourceName() == null) {
            this.throwAtomikosJMSException("Property 'uniqueResourceName' of class AtomikosConnectionFactoryBean cannot be null.");
        }
        try {
            com.atomikos.datasource.pool.ConnectionFactory<Connection> cf = this.doInit();
            this.connectionPool = this.enableConcurrentConnectionValidation ? new ConnectionPoolWithConcurrentValidation(cf, (ConnectionPoolProperties)this) : new ConnectionPoolWithSynchronizedValidation(cf, (ConnectionPoolProperties)this);
            if (this.getFailOnInitIfBrokerDown() && this.brokerDownDetected()) {
                this.throwAtomikosJMSException("Broker down and failOnInitIfBrokerDown was set");
            }
            this.getReference();
        }
        catch (AtomikosJMSException e) {
            throw e;
        }
        catch (Exception ex) {
            this.throwAtomikosJMSException("Cannot initialize AtomikosConnectionFactoryBean", ex);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": init done.");
        }
    }

    private boolean brokerDownDetected() {
        boolean ret = false;
        if (this.connectionPool != null && this.poolAvailableSize() == 0 && this.getMinPoolSize() > 0) {
            ret = true;
        }
        return ret;
    }

    private com.atomikos.datasource.pool.ConnectionFactory<Connection> doInit() throws Exception {
        if (this.xaConnectionFactory == null) {
            if (this.xaConnectionFactoryClassName == null) {
                this.throwAtomikosJMSException("Property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean cannot be null.");
            }
            if (this.xaProperties == null) {
                this.throwAtomikosJMSException("Property 'xaProperties' of class AtomikosConnectionFactoryBean cannot be null.");
            }
        }
        LOGGER.logInfo(this + ": initializing with [ xaConnectionFactory=" + this.xaConnectionFactory + ", xaConnectionFactoryClassName=" + this.xaConnectionFactoryClassName + ", uniqueResourceName=" + this.getUniqueResourceName() + ", maxPoolSize=" + this.getMaxPoolSize() + ", minPoolSize=" + this.getMinPoolSize() + ", borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + ", maxIdleTime=" + this.getMaxIdleTime() + ", reapTimeout=" + this.getReapTimeout() + ", maintenanceInterval=" + this.getMaintenanceInterval() + ", xaProperties=" + this.printXaProperties() + ", localTransactionMode=" + this.localTransactionMode + ", maxLifetime=" + this.maxLifetime + ", ignoreSessionTransactedFlag=" + this.ignoreSessionTransactedFlag + ", startNewXaBranchFlags=" + this.getStartNewXaBranchFlags() + ", propagateJtaTimeoutToXaResource=" + this.getPropagateJtaTimeoutToXaResource() + ", joinExistingXaBranchFlags=" + this.getJoinExistingXaBranchFlags() + ", resumeExistingXaBranchFlags=" + this.getResumeExistingXaBranchFlags() + ", suspendExistingXaBranchFlags=" + this.getSuspendExistingXaBranchFlags() + ", enableConcurrentConnectionValidation=" + this.enableConcurrentConnectionValidation + ", supportsTmJoin=" + this.getSupportsTmJoin() + ", endExistingXaBranchFlags=" + this.getEndExistingXaBranchFlags() + "]");
        if (this.xaConnectionFactory == null) {
            try {
                Class xaClass = ClassLoadingHelper.loadClass((String)this.xaConnectionFactoryClassName);
                this.xaConnectionFactory = (XAConnectionFactory)xaClass.newInstance();
            }
            catch (ClassNotFoundException notFound) {
                AtomikosJMSException.throwAtomikosJMSException("The class '" + this.xaConnectionFactoryClassName + "' specified by property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean could not be found in the classpath. Please make sure the spelling in your setup is correct, and that the required jar(s) are in the classpath.", notFound);
            }
            catch (ClassCastException cce) {
                AtomikosJMSException.throwAtomikosJMSException("The class '" + this.xaConnectionFactoryClassName + "' specified by property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean does not implement the required interface javax.jms.XAConnectionFactory. Please make sure the spelling in your setup is correct, and check your JMS driver vendor's documentation.");
            }
            PropertyUtils.setProperties((Object)this.xaConnectionFactory, (Map)this.xaProperties);
        }
        JmsTransactionalResource tr = new JmsTransactionalResource(this.getUniqueResourceName(), this.xaResourcePreferenceHolder, this.xaConnectionFactory);
        AtomikosJmsXAConnectionFactory cf = new AtomikosJmsXAConnectionFactory(this.xaConnectionFactory, tr, this);
        Configuration.addResource((RecoverableResource)tr);
        EventPublisher.INSTANCE.publish((Event)new XAResourceDetectedEvent(this.xaConnectionFactoryClassName, this.xaProperties, this.xaPropertyNamesToHide, XAResourceDetectedEvent.ResourceType.JMS, this.getUniqueResourceName()));
        return cf;
    }

    public int getBorrowConnectionTimeout() {
        return this.borrowConnectionTimeout;
    }

    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getReapTimeout() {
        if (this.reapTimeout == 0) {
            return this.getMaxLifetime();
        }
        return this.reapTimeout;
    }

    public String getTestQuery() {
        return null;
    }

    public void setBorrowConnectionTimeout(int timeout) {
        this.borrowConnectionTimeout = timeout;
    }

    public void setMaintenanceInterval(int interval) {
        this.maintenanceInterval = interval;
    }

    public void setMaxIdleTime(int time) {
        this.maxIdleTime = time;
    }

    public void setReapTimeout(int timeout) {
        this.reapTimeout = timeout;
    }

    public boolean getLocalTransactionMode() {
        return this.localTransactionMode;
    }

    public void setLocalTransactionMode(boolean mode) {
        this.localTransactionMode = mode;
    }

    public int getDefaultIsolationLevel() {
        return -1;
    }

    public synchronized void close() {
        block6: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logInfo(this + ": close...");
            }
            if (this.connectionPool != null) {
                this.connectionPool.destroy();
                this.connectionPool = null;
            }
            try {
                IntraVmObjectRegistry.removeResource((String)this.getUniqueResourceName());
            }
            catch (NameNotFoundException e) {
                if (!LOGGER.isTraceEnabled()) break block6;
                LOGGER.logTrace(this + ": error removing from JNDI", (Throwable)e);
            }
        }
        RecoverableResource res = Configuration.getResource((String)this.getUniqueResourceName());
        if (res != null) {
            Configuration.removeResource((String)this.getUniqueResourceName());
            res.close();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": close done.");
        }
    }

    public String toString() {
        return this.getUniqueResourceName();
    }

    public Connection createConnection() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": createConnection()...");
        }
        Connection ret = null;
        try {
            this.init();
            ret = (Connection)this.connectionPool.borrowConnection();
        }
        catch (CreateConnectionException ex) {
            this.throwAtomikosJMSException("Failed to create a connection", ex);
        }
        catch (PoolExhaustedException e) {
            this.throwAtomikosJMSException("Connection pool exhausted - try increasing 'maxPoolSize' and/or 'borrowConnectionTimeout' on the AtomikosConnectionFactoryBean.", e);
        }
        catch (ConnectionPoolException e) {
            this.throwAtomikosJMSException("Error borrowing connection", e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": createConnection() returning " + ret);
        }
        return ret;
    }

    public Connection createConnection(String user, String password) throws JMSException {
        LOGGER.logWarning(this + ": createConnection ( user , password ) ignores authentication - returning default connection");
        return this.createConnection();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ret = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getReference()...");
        }
        ret = IntraVmObjectFactory.createReference((Serializable)this, (String)this.getUniqueResourceName());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": getReference() returning " + ret);
        }
        return ret;
    }

    public int poolAvailableSize() {
        return this.connectionPool.availableSize();
    }

    public int poolTotalSize() {
        return this.connectionPool.totalSize();
    }

    public void refreshPool() {
        if (this.connectionPool != null) {
            this.connectionPool.refresh();
        }
    }

    public boolean getIgnoreSessionTransactedFlag() {
        return this.ignoreSessionTransactedFlag;
    }

    public void setIgnoreSessionTransactedFlag(boolean value) {
        this.ignoreSessionTransactedFlag = value;
    }

    public void setConcurrentConnectionValidation(boolean value) {
        this.enableConcurrentConnectionValidation = value;
    }

    public boolean getConcurrentConnectionValidation() {
        return this.enableConcurrentConnectionValidation;
    }

    public Set<String> getXaPropertyNamesToHide() {
        return this.xaPropertyNamesToHide;
    }

    public void setXaPropertyNamesToHide(Set<String> xaPropertyNamesToHide) {
        this.xaPropertyNamesToHide = xaPropertyNamesToHide;
    }

    public int getStartNewXaBranchFlags() {
        return this.xaResourcePreferenceHolder.startNewXaBranchFlags;
    }

    public void setStartNewXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.startNewXaBranchFlags = vendorSpecificFlags;
    }

    public boolean getPropagateJtaTimeoutToXaResource() {
        return this.xaResourcePreferenceHolder.propagateJtaTimeoutToXaResource;
    }

    public void setPropagateJtaTimeoutToXaResource(boolean value) {
        this.xaResourcePreferenceHolder.propagateJtaTimeoutToXaResource = value;
    }

    public int getJoinExistingXaBranchFlags() {
        return this.xaResourcePreferenceHolder.joinExistingXaBranchFlags;
    }

    public void setJoinExistingXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.joinExistingXaBranchFlags = vendorSpecificFlags;
    }

    public int getResumeExistingXaBranchFlags() {
        return this.xaResourcePreferenceHolder.resumeExistingXaBranchFlags;
    }

    public void setResumeExistingXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.resumeExistingXaBranchFlags = vendorSpecificFlags;
    }

    public int getSuspendExistingXaBranchFlags() {
        return this.xaResourcePreferenceHolder.suspendExistingXaBranchFlags;
    }

    public void setSuspendExistingXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.suspendExistingXaBranchFlags = vendorSpecificFlags;
    }

    public int getEndExistingXaBranchFlags() {
        return this.xaResourcePreferenceHolder.endExistingXaBranchFlags;
    }

    public void setEndExistingXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.endExistingXaBranchFlags = vendorSpecificFlags;
    }

    public boolean getSupportsTmJoin() {
        return this.xaResourcePreferenceHolder.supportsTmJoin;
    }

    public void setSupportsTmJoin(boolean value) {
        this.xaResourcePreferenceHolder.supportsTmJoin = value;
    }

    public boolean getUseDriverBasedConnectionValidation() {
        return false;
    }

    public boolean getFailOnInitIfBrokerDown() {
        return this.failOnInitIfBrokerDown;
    }

    public void setFailOnInitIfBrokerDown(boolean value) {
        this.failOnInitIfBrokerDown = value;
    }

    public long getConnectionValidationInterval() {
        return 0L;
    }

    private static class AtomikosJmsXAConnectionFactory
    implements com.atomikos.datasource.pool.ConnectionFactory<Connection> {
        private final XAConnectionFactory xaConnectionFactory;
        private final JmsTransactionalResource jmsTransactionalResource;
        private final AtomikosConnectionFactoryBean atomikosConnectionFactory;

        private AtomikosJmsXAConnectionFactory(XAConnectionFactory xaConnectionFactory, JmsTransactionalResource jmsTransactionalResource, AtomikosConnectionFactoryBean atomikosConnectionFactory) {
            this.xaConnectionFactory = xaConnectionFactory;
            this.jmsTransactionalResource = jmsTransactionalResource;
            this.atomikosConnectionFactory = atomikosConnectionFactory;
        }

        public XPooledConnection<Connection> createPooledConnection() throws CreateConnectionException {
            try {
                XAConnection xac = this.xaConnectionFactory.createXAConnection();
                return new AtomikosPooledJmsConnection(this.atomikosConnectionFactory.getIgnoreSessionTransactedFlag(), xac, (XATransactionalResource)this.jmsTransactionalResource, this.atomikosConnectionFactory);
            }
            catch (JMSException ex) {
                throw new CreateConnectionException("error creating JMS connection", (Exception)((Object)ex));
            }
        }
    }
}

