/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.job;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.externalfile.ExternalFileConnectionType;
import com.sas.metadata.logical.job.BusinessRuleFlowConnectionType;
import com.sas.metadata.logical.job.JobConnectionManager;
import com.sas.metadata.logical.job.JobUtil;
import com.sas.metadata.logical.job.MiningResultConnectionType;
import com.sas.metadata.logical.job.RB;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.messagequeue.MessageQueueConnectionType;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.logical.server.FilePathSubstitutionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.TransportException;
import com.sas.workspace.SCDType2Utilities;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.StringHolder;

public class JobImportListener
extends AbstractImportListener {
    JobConnectionManager m_manager = new JobConnectionManager();
    protected static final Class[] CONNECTION_TYPES = PrivateObjectImportUtility.appendPromptConnectionTypes((Class[])new Class[]{AppServerConnectionType.class, OtherServerConnectionType.class, MessageQueueConnectionType.class, LibraryConnectionType.class, TableConnectionType.class, ExternalFileConnectionType.class, MiningResultConnectionType.class, BusinessRuleFlowConnectionType.class});
    protected static final Class[] SUBSTITUTION_TYPES = new Class[]{FilePathSubstitutionType.class, DirectoryPathSubstitutionType.class};
    static final String APPLICATION_SERVER = ".ApplicationServer";
    static final String MAIN_JOB_FILE_PATH = "JobSrcCodeFile.FilePath";
    static final String JOB_PREPROCESS_FILE_PATH = "JobPreProcess.FilePath";
    static final String JOB_POSTPROCESS_FILE_PATH = "JobPostProcess.FilePath";
    static final String JOB_STEP_FILE_PATH = "JobStep.FilePath";
    public static final String PROPERTY_SUFFIX_DIRPATH = "DirPath";

    public JobImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public Class[] getSubstitutionTypes() {
        return SUBSTITUTION_TYPES;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        if (operation.getPackageFileVersion() < 9200) {
            this.m_manager.analyzeJobFileContentImport(this, operation, objects);
        }
        iRC = this.analyzeAndDisableValidations(operation, objects, iRC);
        return iRC |= this.m_manager.analyzeJobObjectConnectionsOnImport(this, operation, objects);
    }

    private int analyzeAndDisableValidations(ImportOperationInterface operation, List objects, int iRC) {
        int index = 1;
        int count = objects.size();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        for (ImportItemInterface importItem : objects) {
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
            if (importItem.getTypeInterface() == null || !"Job".equals(importItem.getTypeInterface().getPublicType())) continue;
            try {
                List subs;
                Map mapContentStreams = contentHandler.getBinaryContent(importItem.getID());
                if (mapContentStreams.isEmpty() || (subs = importItem.getSubstitutions()) == null) continue;
                for (SubstitutionInterface subItem : subs) {
                    if (!"FilePath".equals(subItem.getSubstitutionType().getSubstitutionTypeName())) continue;
                    subItem.setOption(1, (Object)Boolean.FALSE);
                }
            }
            catch (TransportException e) {
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ErrorRetrievingExternalFile.fmt"), (Object)e.getMessage()));
                iRC |= 8;
            }
            catch (IOException e) {
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ErrorRetrievingExternalFile.fmt"), (Object)e.getMessage()));
                iRC |= 8;
            }
        }
        return iRC;
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int localRC = 0;
        try {
            localRC |= this.m_manager.updateMiningResultTables(operation, operation.getMetadataFactory(), operation.getConnectionManager().getConnections(true), connections);
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        return localRC |= this.m_manager.updateColumnAssociations(operation, operation.getMetadataFactory(), operation.getConnectionManager().getConnections(true), connections);
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        Log importLogger = operation.getLogger();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        int iRC = 0;
        HashMap mapContentInfo = new HashMap();
        int iOptions = 284;
        for (ImportItemInterface jobImportItem : objects) {
            Map mapContentStreams = contentHandler.getBinaryContent(jobImportItem.getID());
            if (mapContentStreams.isEmpty()) continue;
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ContentStatusIndicator.fmt"), (Object)jobImportItem.getName()));
            importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ContentInfo.fmt"), (Object)jobImportItem.getName()));
            try {
                Job mdJob = (Job)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "Job", jobImportItem.getTargetID(), null, null, "<Templates><AbstractTransformation><JobActivities/><SourceCode/><Steps/><Transformations/><TransformationSources/><TransformationTargets/></AbstractTransformation><File><DeployedComponents/></File></Templates>", iOptions);
                if (mdJob == null) continue;
                this.searchJobForContent(jobImportItem, mdJob, mapContentInfo, mapContentStreams, importLogger);
            }
            catch (MdException mde) {
                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ErrorRetrievingJob.fmt"), (Object)jobImportItem.getName(), (Object)mde.getMessage()));
                iRC |= 8;
            }
        }
        for (ServerContext mdSC : mapContentInfo.keySet()) {
            List lContentInfo = (List)mapContentInfo.get(mdSC);
            if (lContentInfo == null || lContentInfo.isEmpty()) continue;
            this.fireDisplayMessage(RB.getStringResource("JobImportListener.WritingContent.txt"));
            int iTempRC = this.writeContentToServer(mdSC, lContentInfo, operation, importLogger);
            if (iTempRC <= iRC) continue;
            iRC = iTempRC;
        }
        return iRC;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        try {
            Log importLogger = operation.getLogger();
            this.fireDisplayMessage(StatusMessageUtil.createDefaultUpdatingMessage((TypeInterface)this.getTypeInterface()));
            int iRC = this.updateJobMetadata(operation, objects, importLogger);
            return iRC |= this.validateJobMetadata(operation, objects);
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
    }

    private int validateJobMetadata(ImportOperationInterface operation, List objects) throws MetadataPromotionException, RemoteException {
        int iRC = 0;
        int iOptions = 268;
        Log importLogger = operation.getLogger();
        MdObjectStore mdStore = operation.getMetadataFactory().createObjectStore(null, "JobImportListener:validateJobMetadata");
        try {
            for (ImportItemInterface jobImportItem : objects) {
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ValidateStatusIndicator.fmt"), (Object)jobImportItem.getName()));
                importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ValidateInfo.fmt"), (Object)jobImportItem.getName()));
                Job mdJob = this.getJobMetadatObject(mdStore, jobImportItem, iOptions);
                AssociationList lActivities = mdJob.getJobActivities();
                if (lActivities.isEmpty()) continue;
                TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
                AssociationList lSteps = mdActivity.getSteps();
                for (TransformationStep mdStep : lSteps) {
                    Prototype mdPrototype;
                    if (mdStep == null || !"TransformationStep2".equals(mdStep.getTransformRole()) || (mdPrototype = JobUtil.getGeneratedTransform(mdStep)) != null) continue;
                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.missingGeneratedXForms.fmt"), (Object)mdStep.getName()));
                    iRC |= 4;
                }
            }
        }
        catch (MdException mde) {
            throw new MetadataPromotionException((Throwable)mde);
        }
        finally {
            mdStore.dispose();
        }
        return iRC;
    }

    private int updateJobMetadata(ImportOperationInterface operation, List objects, Log importLogger) throws MetadataPromotionException, RemoteException {
        int iRC = 0;
        int iOptions = 268;
        MdObjectStore mdStore = operation.getMetadataFactory().createObjectStore(null, "JobImportListener:updateJobMetadata");
        try {
            for (ImportItemInterface jobImportItem : objects) {
                AssociationList lActivities;
                Job mdJob;
                block14: {
                    this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.StatusIndicator.fmt"), (Object)jobImportItem.getName()));
                    importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.UpdateInfo.fmt"), (Object)jobImportItem.getName()));
                    mdJob = this.getJobMetadatObject(mdStore, jobImportItem, iOptions);
                    String ptype = mdJob.getPublicType();
                    if (ptype == null || ptype.length() == 0) {
                        UtilMetadata.setPublicType((PrimaryType)mdJob, (String)jobImportItem.getTypeInterface().getPublicType());
                    }
                    PromotionUtil.removeDuplicatesProductInfo((Root)mdJob, (ImportOperationInterface)operation);
                    PromotionUtil.updateProductInfo((Root)mdJob, (ImportOperationInterface)operation);
                    lActivities = mdJob.getJobActivities();
                    if (!lActivities.isEmpty()) break block14;
                    int n = iRC;
                    return n;
                }
                try {
                    TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
                    AssociationList lSteps = mdActivity.getSteps();
                    for (TransformationStep mdStep : lSteps) {
                        PrivateObjectImportUtility.updatePromptsForImportChanges((ImportOperationInterface)operation, (Root)mdStep);
                        AssociationList lTransformations = mdStep.getTransformations();
                        for (Transformation mdTransformation : lTransformations) {
                            if (!(mdTransformation instanceof ClassifierMap)) continue;
                            SCDType2Utilities.createDimensionXrefTableProperties((ClassifierMap)((ClassifierMap)mdTransformation));
                        }
                    }
                    PrivateObjectImportUtility.updatePromptsForImportChanges((ImportOperationInterface)operation, (Root)mdJob);
                    this.setUnknownServerForFiles(operation, mdStore, mdJob, jobImportItem);
                }
                catch (Exception e) {
                    iRC = 8;
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.UpdateError.fmt"), (Object)jobImportItem.getName(), (Object)e.getMessage()));
                }
            }
            mdStore.updatedMetadataAll();
        }
        catch (MdException mde) {
            throw new MetadataPromotionException((Throwable)mde);
        }
        finally {
            if (mdStore != null && !mdStore.isDisposed()) {
                mdStore.dispose();
            }
        }
        return iRC;
    }

    private int setUnknownServerForFiles(ImportOperationInterface operation, MdObjectStore store, Job mdJob, ImportItemInterface jobImportItem) throws RemoteException, MdException {
        int iRC = 0;
        String unknownServerName = RB.getStringResource("JobImportListener.UNKNOWN.Object.fmt.txt");
        List connectionPoints = jobImportItem.getConnectionPoints();
        for (ConnectionPointInterface cp : connectionPoints) {
            AssociationList lActivities;
            AssociationList lJobTargets;
            AssociationList lJobSources;
            File jobFile;
            AssociationList depComps;
            String tId;
            if (!cp.isUnknown() || !"ServerContext".equals(cp.getMetadataType()) || !cp.getName().equals(unknownServerName) || (tId = cp.getTargetID()) == null) continue;
            int options = 268;
            ServerContext server = (ServerContext)store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, "ServerContext", tId, null, null, "", options);
            if (server == null) continue;
            Text srcCode = mdJob.getSourceCode();
            if (srcCode != null && srcCode instanceof File && (depComps = (jobFile = (File)srcCode).getDeployedComponents()) != null && depComps.size() == 0) {
                depComps.add(server);
                operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ReplacedUNKNOWNServer.fmt.txt"), (Object)unknownServerName, (Object)server.getName(), (Object)jobFile.getFileName()));
            }
            if ((lJobSources = mdJob.getTransformationSources()) != null) {
                for (int i = 0; i < lJobSources.size(); ++i) {
                    File mdFile;
                    AssociationList depComps2;
                    Text mdText;
                    Object mdJobSource = lJobSources.get(i);
                    if (!(mdJobSource instanceof AbstractTransformation) || !((mdText = ((AbstractTransformation)mdJobSource).getSourceCode()) instanceof File) || (depComps2 = (mdFile = (File)mdText).getDeployedComponents()) == null || depComps2.size() != 0) continue;
                    depComps2.add(server);
                    operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ReplacedUNKNOWNServer.fmt.txt"), (Object)unknownServerName, (Object)server.getName(), (Object)mdFile.getFileName()));
                }
            }
            if ((lJobTargets = mdJob.getTransformationTargets()) != null) {
                for (int i = 0; i < lJobTargets.size(); ++i) {
                    File mdFile;
                    AssociationList depComps3;
                    Text mdText;
                    Object mdJobTarget = lJobTargets.get(i);
                    if (!(mdJobTarget instanceof AbstractTransformation) || !((mdText = ((AbstractTransformation)mdJobTarget).getSourceCode()) instanceof File) || (depComps3 = (mdFile = (File)mdText).getDeployedComponents()) == null || depComps3.size() != 0) continue;
                    depComps3.add(server);
                    operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ReplacedUNKNOWNServer.fmt.txt"), (Object)unknownServerName, (Object)server.getName(), (Object)mdFile.getFileName()));
                }
            }
            if ((lActivities = mdJob.getJobActivities()).isEmpty()) continue;
            TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
            AssociationList lSteps = mdActivity.getSteps();
            for (int i = 0; i < lSteps.size(); ++i) {
                AssociationList lStepTargets;
                AssociationList lStepSources;
                File mdFile;
                AssociationList depComps4;
                TransformationStep mdStep = (TransformationStep)lSteps.get(i);
                Text stepSourceFile = mdStep.getSourceCode();
                if (stepSourceFile instanceof File && (depComps4 = (mdFile = (File)stepSourceFile).getDeployedComponents()) != null && depComps4.size() == 0) {
                    depComps4.add(server);
                    operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ReplacedUNKNOWNServer.fmt.txt"), (Object)unknownServerName, (Object)server.getName(), (Object)mdFile.getFileName()));
                }
                if ((lStepSources = mdStep.getTransformationSources()) != null) {
                    for (int j = 0; j < lStepSources.size(); ++j) {
                        File mdFile2;
                        AssociationList depComps5;
                        Text mdText;
                        Object mdStepSource = lStepSources.get(j);
                        if (!(mdStepSource instanceof AbstractTransformation) || !((mdText = ((AbstractTransformation)mdStepSource).getSourceCode()) instanceof File) || (depComps5 = (mdFile2 = (File)mdText).getDeployedComponents()) == null || depComps5.size() != 0) continue;
                        depComps5.add(server);
                        operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ReplacedUNKNOWNServer.fmt.txt"), (Object)unknownServerName, (Object)server.getName(), (Object)mdFile2.getFileName()));
                    }
                }
                if ((lStepTargets = mdStep.getTransformationTargets()) != null) {
                    for (int j = 0; j < lStepTargets.size(); ++j) {
                        File mdFile3;
                        AssociationList depComps6;
                        Text mdText;
                        Object mdStepTarget = lStepTargets.get(j);
                        if (!(mdStepTarget instanceof AbstractTransformation) || !((mdText = ((AbstractTransformation)mdStepTarget).getSourceCode()) instanceof File) || (depComps6 = (mdFile3 = (File)mdText).getDeployedComponents()) == null || depComps6.size() != 0) continue;
                        depComps6.add(server);
                        operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ReplacedUNKNOWNServer.fmt.txt"), (Object)unknownServerName, (Object)server.getName(), (Object)mdFile3.getFileName()));
                    }
                }
                AssociationList lTransformations = mdStep.getTransformations();
                for (int k = 0; k < lTransformations.size(); ++k) {
                    File mdFile4;
                    AssociationList depComps7;
                    Text mdText;
                    Transformation mdTransformation = (Transformation)lTransformations.get(k);
                    if (mdTransformation instanceof Job || !((mdText = mdTransformation.getSourceCode()) instanceof File) || (depComps7 = (mdFile4 = (File)mdText).getDeployedComponents()) == null || depComps7.size() != 0) continue;
                    depComps7.add(server);
                    operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ReplacedUNKNOWNServer.fmt.txt"), (Object)unknownServerName, (Object)server.getName(), (Object)mdFile4.getFileName()));
                }
            }
        }
        return iRC;
    }

    private void searchJobForContent(ImportItemInterface jobImportItem, Job mdJob, Map mapContentInfo, Map mapContentStreams, Log importLogger) throws MdException, RemoteException {
        AssociationList lActivities;
        AssociationList lJobTargets;
        String sJobName = mdJob.getName();
        this.addContentInfoToMap(jobImportItem, mapContentInfo, mapContentStreams, (AbstractTransformation)mdJob, sJobName, importLogger);
        AssociationList lJobSources = mdJob.getTransformationSources();
        if (lJobSources != null) {
            for (Object mdJobSource : lJobSources) {
                if (!(mdJobSource instanceof AbstractTransformation)) continue;
                this.addContentInfoToMap(jobImportItem, mapContentInfo, mapContentStreams, (AbstractTransformation)mdJobSource, sJobName, importLogger);
            }
        }
        if ((lJobTargets = mdJob.getTransformationTargets()) != null) {
            for (Object mdJobTarget : lJobTargets) {
                if (!(mdJobTarget instanceof AbstractTransformation)) continue;
                this.addContentInfoToMap(jobImportItem, mapContentInfo, mapContentStreams, (AbstractTransformation)mdJobTarget, sJobName, importLogger);
            }
        }
        if ((lActivities = mdJob.getJobActivities()).isEmpty()) {
            return;
        }
        TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
        AssociationList lSteps = mdActivity.getSteps();
        for (TransformationStep mdStep : lSteps) {
            AssociationList lStepTargets;
            this.addContentInfoToMap(jobImportItem, mapContentInfo, mapContentStreams, (AbstractTransformation)mdStep, sJobName, importLogger);
            AssociationList lStepSources = mdStep.getTransformationSources();
            if (lStepSources != null) {
                for (Object mdStepSource : lStepSources) {
                    if (!(mdStepSource instanceof AbstractTransformation)) continue;
                    this.addContentInfoToMap(jobImportItem, mapContentInfo, mapContentStreams, (AbstractTransformation)mdStepSource, sJobName, importLogger);
                }
            }
            if ((lStepTargets = mdStep.getTransformationTargets()) != null) {
                for (Object mdStepTarget : lStepTargets) {
                    if (!(mdStepTarget instanceof AbstractTransformation)) continue;
                    this.addContentInfoToMap(jobImportItem, mapContentInfo, mapContentStreams, (AbstractTransformation)mdStepTarget, sJobName, importLogger);
                }
            }
            AssociationList lTransformations = mdStep.getTransformations();
            for (Transformation mdTransformation : lTransformations) {
                if (mdTransformation instanceof Job) continue;
                this.addContentInfoToMap(jobImportItem, mapContentInfo, mapContentStreams, (AbstractTransformation)mdTransformation, sJobName, importLogger);
            }
        }
    }

    private void addContentInfoToMap(ImportItemInterface jobImportItem, Map mapContentInfo, Map mapContentStreams, AbstractTransformation mdAT, String sJobName, Log importLogger) throws MdException, RemoteException {
        Text mdText = mdAT.getSourceCode();
        if (mdText instanceof File) {
            File mdFile = (File)mdText;
            AssociationList lSCs = mdFile.getDeployedComponents();
            if (lSCs.isEmpty()) {
                if (importLogger.isDebugEnabled()) {
                    importLogger.debug((Object)("No ServerContext found on File object " + mdFile.getFQID()));
                }
                return;
            }
            ServerContext mdSC = (ServerContext)lSCs.get(0);
            ArrayList<JobContentInfo> lContentInfo = (ArrayList<JobContentInfo>)mapContentInfo.get(mdSC);
            if (lContentInfo == null) {
                lContentInfo = new ArrayList<JobContentInfo>();
                mapContentInfo.put(mdSC, lContentInfo);
            }
            String sFileName = mdFile.getFileName();
            List subs = jobImportItem.getSubstitutions();
            for (SubstitutionInterface sub : subs) {
                String targetFileName = sub.getTargetValue();
                if (targetFileName == null || !sFileName.equals(targetFileName)) continue;
                sFileName = sub.getSourceValue();
            }
            if (sFileName != null) {
                InputStream inStream;
                if (!sFileName.equals(mdFile.getFileName())) {
                    importLogger.debug((Object)("Using new filename \"" + mdFile.getFileName() + "\" for import content file \"" + sFileName + "\""));
                }
                if ((inStream = (InputStream)mapContentStreams.get(sFileName)) != null) {
                    lContentInfo.add(new JobContentInfo(inStream, mdFile.getFileName(), sJobName));
                } else if (importLogger.isDebugEnabled()) {
                    importLogger.debug((Object)("No content stream found for " + sFileName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeContentToServer(ServerContext mdSC, List lContentInfo, ImportOperationInterface operation, Log importLogger) throws RemoteException {
        int iRC = 0;
        WsAppServer appServer = null;
        try {
            appServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)mdSC);
            ContentHandlerInterface contentHandler = operation.getContentHandler();
            int iCounter = 0;
            HashSet<String> processedFilePaths = new HashSet<String>();
            HashMap<InputStream, ByteArrayOutputStream> processedInStreams = new HashMap<InputStream, ByteArrayOutputStream>();
            for (JobContentInfo jobContentInfo : lContentInfo) {
                if (processedFilePaths.contains(jobContentInfo.m_sPath)) continue;
                processedFilePaths.add(jobContentInfo.m_sPath);
                InputStream inOrigStream = jobContentInfo.m_inStream;
                try {
                    byte[] data;
                    ByteArrayOutputStream outStream;
                    Object cachedStream = processedInStreams.get(inOrigStream);
                    if (cachedStream == null) {
                        outStream = this.readStream(inOrigStream);
                        processedInStreams.put(inOrigStream, outStream);
                        inOrigStream.close();
                        data = outStream.toByteArray();
                    } else {
                        outStream = (ByteArrayOutputStream)cachedStream;
                        data = outStream.toByteArray();
                    }
                    ByteArrayInputStream inputCachedStream = new ByteArrayInputStream(data);
                    IFileService fileService = appServer.getWorkspace().FileService();
                    IFileref fileRef = fileService.AssignFileref("TEMP" + iCounter++, "DISK", jobContentInfo.m_sPath, "", new StringHolder());
                    IBinaryStream outStream2 = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
                    contentHandler.writeToBinaryStream((InputStream)inputCachedStream, outStream2);
                    importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ImportInfo.fmt"), (Object)jobContentInfo.m_sPath, (Object)mdSC.getName(), (Object)jobContentInfo.m_sJobName));
                }
                catch (Exception e) {
                    iRC = 8;
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ImportError.fmt"), (Object)jobContentInfo.m_sPath, (Object)mdSC.getName(), (Object)jobContentInfo.m_sJobName, (Object)e.getMessage()));
                }
            }
        }
        catch (WsAppServerFailException e) {
            iRC = 8;
            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("JobImportListener.ServerError.fmt"), (Object)mdSC.getName(), (Object)e.getMessage()));
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
        }
        return iRC;
    }

    private ByteArrayOutputStream readStream(InputStream stream) throws IOException {
        int bytesRead = 0;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((bytesRead = stream.read(buffer)) > 0) {
            os.write(buffer, 0, bytesRead);
        }
        return os;
    }

    private Job getJobMetadatObject(MdObjectStore mdStore, ImportItemInterface jobImportItem, int iOptions) throws RemoteException, MdException {
        return (Job)mdStore.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Job", jobImportItem.getTargetID(), null, null, "<Templates><Job><JobActivities/></Job><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Transformations/></TransformationStep></Templates>", iOptions);
    }

    String fixKeyForCount(String fileLocationName, int count) {
        String returnValue = fileLocationName;
        if (count > 0) {
            int insertIndex = fileLocationName.indexOf(".FilePath");
            returnValue = fileLocationName.subSequence(0, insertIndex) + "[" + count + "].FilePath";
        }
        return returnValue;
    }

    private class JobContentInfo {
        InputStream m_inStream;
        String m_sPath;
        String m_sJobName;

        JobContentInfo(InputStream inStream, String sPath, String sJobName) {
            this.m_inStream = inStream;
            this.m_sPath = sPath;
            this.m_sJobName = sJobName;
        }
    }
}

