/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.generatedtransform;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.externalfile.ExternalFileConnectionType;
import com.sas.metadata.logical.generatedtransform.GeneratedTransformImportItem;
import com.sas.metadata.logical.generatedtransform.GeneratedTransformUtil;
import com.sas.metadata.logical.generatedtransform.RB;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.server.FilePathSubstitutionType;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;

public class GeneratedTransformImportListener
extends AbstractImportListener
implements PromotionOptionsInterface {
    private static final String ENTITY_SET_PROPERTY_NAME = "EntitySet";
    public static final String CLASS_PROPERTY_NAME = "Class";
    protected static final Class[] CONNECTION_TYPES = PrivateObjectImportUtility.appendPromptConnectionTypes((Class[])new Class[]{LibraryConnectionType.class, TableConnectionType.class, ExternalFileConnectionType.class});
    protected static final Class[] SUBSTITUTION_TYPES = new Class[]{FilePathSubstitutionType.class};
    private static final String[] DI_STUDIO_GUIDS = new String[]{"bc5ac953-0a17-0c86-018e-18a359caad3e", "bc64bec3-0a17-0c86-00cf-e0499e662a78", "6da3c8fa-0a1a-0b30-0082-e4f3f27a69c0", "bc68ee4c-0a17-0c86-00cf-e04915e867ce", "6da3c6a8-0a1a-0b30-0082-e4f3bf2404ca", "6da3ca13-0a1a-0b30-0082-e4f3d278309e", "6da3c7a2-0a1a-0b30-0082-e4f3768cee0b", "6da3c7f0-0a1a-0b30-0082-e4f3167822ec"};

    public GeneratedTransformImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new GeneratedTransformImportItem(name, id, type);
    }

    public JPanel getOptionsPanel(ExportItemInterface[] aItems, ExportOperationInterface exportHandler) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] aItems, ImportOperationInterface importHandler) {
        return null;
    }

    public void saveSettings() {
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public Class[] getSubstitutionTypes() {
        return SUBSTITUTION_TYPES;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException, MetadataPromotionException {
        try {
            if (operation.getPromotionType() != 1) {
                return 0;
            }
            Map mapPrototypes = operation.getAssociationsForObjects(objects, "<Template><Prototype><PropertySets><PropertySet Desc=\"\"/></PropertySets><Properties><Property PropertyRole=\"\" PropertyName=\"\" DefaultValue=\"\" ><StoredConfiguration><TextStore StoredText=\"\"/></StoredConfiguration></Property></Properties></Prototype></Template>");
            int iOptions = 260;
            try {
                int index = 1;
                int count = objects.size();
                for (ImportItemInterface importItem : objects) {
                    Map mapPrototype;
                    this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)this.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
                    if (importItem.getImportState() != 1) {
                        mapPrototype = (Map)mapPrototypes.get(importItem.getID());
                        if (operation.getPackageFileVersion() < 9200) {
                            this.validateUniqueGUIDEntityBased(operation, iOptions, importItem, mapPrototype);
                            continue;
                        }
                        this.validateUniqueGUIDPromptBased(operation, iOptions, importItem, mapPrototype);
                        continue;
                    }
                    mapPrototype = (Map)mapPrototypes.get(importItem.getID());
                    if (operation.getPackageFileVersion() < 9200) {
                        this.validateNewUniqueGUIDEntityBased(operation, importItem, mapPrototype);
                        continue;
                    }
                    this.validateNewUniqueGUIDPromptBased(operation, importItem, mapPrototype);
                }
            }
            catch (MdException mde) {
                throw new MetadataPromotionException((Throwable)mde);
            }
            return 0;
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
    }

    private void validateNewUniqueGUIDEntityBased(ImportOperationInterface operation, ImportItemInterface importItem, Map mapPrototype) throws RemoteException, MdException, MetadataPromotionException {
        List lProperties = (List)mapPrototype.get("Properties");
        for (Map mapProperty : lProperties) {
            if (!"GetXML".equals(mapProperty.get("PropertyRole"))) continue;
            List lTextStores = (List)mapProperty.get("StoredConfiguration");
            Map mapTextStore = (Map)lTextStores.get(0);
            String sStoredText = (String)mapTextStore.get("StoredText");
            sStoredText = sStoredText.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"");
            sStoredText = operation.getMetadataFactory().getOMIUtil().cleanStringForXML(sStoredText);
            Pattern pattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
            Matcher matcher = pattern.matcher(sStoredText);
            String strGUID = null;
            if (matcher.find()) {
                strGUID = matcher.group();
            }
            if (strGUID != null && this.isDeprecatedDIStudioGUID(strGUID)) {
                throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.ExistingGUIDError.fmt"), (Object)importItem.getName()));
            }
            if (!GeneratedTransformationUtilities.isTransformLoaded((String)sStoredText, (MdFactory)operation.getMetadataFactory())) continue;
            throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.ExistingGUIDError.fmt"), (Object)importItem.getName()));
        }
    }

    private void validateNewUniqueGUIDPromptBased(ImportOperationInterface operation, ImportItemInterface importItem, Map mapPrototype) throws MdException, RemoteException, MetadataPromotionException {
        List lProperties = (List)mapPrototype.get("Properties");
        for (Map mapProperty : lProperties) {
            if (!CLASS_PROPERTY_NAME.equals(mapProperty.get("Name"))) continue;
            String sNewGUID = (String)mapProperty.get("DefaultValue");
            if (this.isDeprecatedDIStudioGUID(sNewGUID)) {
                throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.ExistingGUIDError.fmt"), (Object)importItem.getName()));
            }
            GeneratedTransformUtil.validateUniqueGUID(operation, sNewGUID, importItem);
        }
    }

    private void validateUniqueGUIDEntityBased(ImportOperationInterface operation, int iOptions, ImportItemInterface importItem, Map mapPrototype) throws MdException, RemoteException, MetadataPromotionException {
        List lPropertySets = (List)mapPrototype.get("PropertySets");
        for (Map mapPropertySet : lPropertySets) {
            if (!ENTITY_SET_PROPERTY_NAME.equals(mapPropertySet.get("Name"))) continue;
            String sNewGUID = (String)mapPropertySet.get("Desc");
            if (this.isDeprecatedDIStudioGUID(sNewGUID)) {
                throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.ExistingGUIDError.fmt"), (Object)importItem.getName()));
            }
            Prototype mdPrototype = (Prototype)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "Prototype", importItem.getTargetID(), null, null, "<Templates><Prototype Name=\"\"><Properties/><PropertySets/></Prototype><Property PropertyRole=\"\" PropertyName=\"\" DefaultValue=\"\"><StoredConfiguration/></Property><PropertySet Name=\"\" Desc=\"\"/><TextStore StoredText=\"\"/></Templates>", iOptions);
            AssociationList lMDPropertySets = mdPrototype.getPropertySets();
            for (PropertySet mdPropertySet : lMDPropertySets) {
                if (!ENTITY_SET_PROPERTY_NAME.equals(mdPropertySet.getName())) continue;
                String sOldGUID = mdPropertySet.getDesc();
                if (sNewGUID == null || sNewGUID.equals(sOldGUID)) continue;
                throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.NewGUIDError.fmt"), (Object)importItem.getName()));
            }
            AssociationList properties = mdPrototype.getProperties();
            for (Property prop : properties) {
                if (!CLASS_PROPERTY_NAME.equals(prop.getPropertyName())) continue;
                String sOldGUID = prop.getDefaultValue();
                if (sNewGUID == null || sNewGUID.equals(sOldGUID)) continue;
                throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.NewGUIDError.fmt"), (Object)importItem.getName()));
            }
        }
    }

    private boolean isDeprecatedDIStudioGUID(String newGUID) {
        boolean returnValue = false;
        for (int i = 0; i < DI_STUDIO_GUIDS.length && !returnValue; ++i) {
            String diGUID = DI_STUDIO_GUIDS[i];
            if (!diGUID.equals(newGUID)) continue;
            returnValue = true;
        }
        return returnValue;
    }

    private void validateUniqueGUIDPromptBased(ImportOperationInterface operation, int iOptions, ImportItemInterface importItem, Map mapPrototype) throws MdException, RemoteException, MetadataPromotionException {
        List lProperties = (List)mapPrototype.get("Properties");
        for (Map mapProperties : lProperties) {
            if (!CLASS_PROPERTY_NAME.equals(mapProperties.get("Name"))) continue;
            String sNewGUID = (String)mapProperties.get("DefaultValue");
            if (this.isDeprecatedDIStudioGUID(sNewGUID)) {
                throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.ExistingGUIDError.fmt"), (Object)importItem.getName()));
            }
            Prototype mdPrototype = (Prototype)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "Prototype", importItem.getTargetID(), null, null, "<Templates><Prototype Name=\"\"><Properties/><PropertySets/></Prototype><Property PropertyRole=\"\" PropertyName=\"\" DefaultValue=\"\"><StoredConfiguration/></Property><PropertySet Name=\"\" Desc=\"\"/><TextStore StoredText=\"\"/></Templates>", iOptions);
            AssociationList properties = mdPrototype.getProperties();
            for (Property prop : properties) {
                if (!CLASS_PROPERTY_NAME.equals(prop.getName())) continue;
                String sOldGUID = prop.getDefaultValue();
                if (sNewGUID == null || sNewGUID.equals(sOldGUID)) continue;
                throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.NewGUIDError.fmt"), (Object)importItem.getName()));
            }
        }
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        try {
            int iTempRC;
            int iRC = 0;
            this.fireDisplayMessage(StatusMessageUtil.createDefaultUpdatingMessage((TypeInterface)this.getTypeInterface()));
            if (operation.getPromotionType() != 1) {
                iRC = this.updateGUIDs(operation, objects);
            }
            if (operation.getPromotionType() != 2 && (iTempRC = this.updateOptions(operation, objects)) > iRC) {
                iRC |= iTempRC;
            }
            if ((iTempRC = this.updateAttributes(operation, objects)) > iRC) {
                iRC = iTempRC;
            }
            return iRC;
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
    }

    private int updateAttributes(ImportOperationInterface operation, List objects) {
        int rc = 0;
        Iterator iterator = objects.iterator();
        while (iterator.hasNext()) {
            String name;
            boolean bMetadataChanged = false;
            ImportItemInterface importItem = (ImportItemInterface)iterator.next();
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.AttributeStatusIndicator.fmt"), (Object)importItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.AttributeInfo.fmt"), (Object)importItem.getName()));
            try {
                Prototype protoObj = this.getMetadataObject(operation, importItem.getTargetID());
                PromotionUtil.updateProductInfo((Root)protoObj, (ImportOperationInterface)operation);
                bMetadataChanged = true;
                boolean publicTypeChanged = UtilMetadata.setPublicType((PrimaryType)protoObj, (String)"GeneratedTransform");
                if (publicTypeChanged) {
                    bMetadataChanged = true;
                }
                if (!bMetadataChanged) continue;
                bMetadataChanged = false;
                protoObj.updateMetadataAll();
            }
            catch (RemoteException e) {
                String type = importItem.getTypeInterface().getDisplayType();
                name = importItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.errorValidatingMetadata.txt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
            catch (MdException e) {
                String type = importItem.getTypeInterface().getDisplayType();
                name = importItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.errorValidatingMetadata.txt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateGUIDs(ImportOperationInterface operation, List objects) throws RemoteException {
        Log importLogger = operation.getLogger();
        int iRC = 0;
        int iOptions = 260;
        MdObjectStore mdStore = null;
        try {
            for (GeneratedTransformImportItem importItem : objects) {
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.StatusIndicator.fmt"), (Object)importItem.getName()));
                importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.GUIDsInfo.fmt"), (Object)importItem.getName()));
                if (mdStore == null) {
                    mdStore = operation.getMetadataFactory().createObjectStore(null, "GeneratedTransform: updateGUIDs");
                }
                try {
                    Prototype mdPrototype = (Prototype)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Prototype", importItem.getTargetID(), null, null, "<Templates><Prototype Name=\"\"><Properties/><PropertySets/></Prototype><Property PropertyRole=\"\" PropertyName=\"\" DefaultValue=\"\"><StoredConfiguration/></Property><PropertySet Name=\"\" Desc=\"\"/><TextStore StoredText=\"\"/></Templates>", iOptions);
                    MacroPluginUtilities.setNewGuid((Prototype)mdPrototype);
                    mdStore.updatedMetadataAll();
                }
                catch (Exception e) {
                    iRC = 8;
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.GUIDsError.fmt"), (Object)importItem.getName(), (Object)e.getMessage()));
                }
            }
        }
        finally {
            if (mdStore != null) {
                mdStore.dispose();
            }
        }
        return iRC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateOptions(ImportOperationInterface operation, List objects) throws RemoteException {
        Log importLogger = operation.getLogger();
        int iRC = 0;
        boolean bPasteSpecial = operation.getPromotionType() == 3;
        int iOptions = 260;
        MdObjectStore mdStore = null;
        try {
            for (GeneratedTransformImportItem importItem : objects) {
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.OptionsStatusIndicator.fmt"), (Object)importItem.getName()));
                Map mapSavedOptions = importItem.m_mapOptionValues;
                if (!bPasteSpecial && (mapSavedOptions == null || mapSavedOptions.isEmpty()) && operation.getPackageFileVersion() < 9200) {
                    if (mdStore == null) {
                        mdStore = operation.getMetadataFactory().createObjectStore(null, "GeneratedTransform: updateObjects");
                    }
                    int n = iRC;
                    return n;
                }
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.StatusIndicator.fmt"), (Object)importItem.getName()));
                importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.OptionsInfo.fmt"), (Object)importItem.getName()));
                if (mdStore == null) {
                    mdStore = operation.getMetadataFactory().createObjectStore(null, "GeneratedTransform: updateObjects");
                }
                try {
                    Prototype mdPrototype = (Prototype)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Prototype", importItem.getTargetID(), null, null, "<Templates><Prototype><PropertySets/></Prototype><Property DefaultValue=\"\" Desc=\"\" Name=\"\" PropertyName=\"\"><OwningType/><PrimaryPropertyGroup/><StoredConfiguration/></Property><PropertyGroup><PropertySets/></PropertyGroup><PropertySet Name=\"\"><Properties/><SetProperties/></PropertySet><PropertyType Name=\"\"/><TextStore StoredText=\"\"/></Templates>", iOptions);
                    PrivateObjectImportUtility.updatePromptsForImportChanges((ImportOperationInterface)operation, (Root)mdPrototype);
                    mdStore.updatedMetadataAll();
                }
                catch (Exception e) {
                    iRC = 8;
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("GeneratedTransformImportListener.OptionsError.fmt"), (Object)importItem.getName(), (Object)e.getMessage()));
                }
            }
        }
        finally {
            if (mdStore != null) {
                mdStore.dispose();
            }
        }
        return iRC;
    }

    private Prototype getMetadataObject(ImportOperationInterface operation, String fqid) throws MdException, RemoteException {
        String type = "Prototype";
        String template = "<Templates><Prototype Name=\"\"><Properties/><PropertySets/></Prototype><Property PropertyRole=\"\" PropertyName=\"\" DefaultValue=\"\"><StoredConfiguration/></Property><PropertySet Name=\"\" Desc=\"\"/><TextStore StoredText=\"\"/></Templates>";
        int options = 268;
        CMetadata object = operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), type, fqid, null, null, template, options);
        return (Prototype)object;
    }
}

