/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.condition;

import com.sas.entities.GUID;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.condition.RB;
import com.sas.metadata.logical.conditionactionset.ConditionActionSetUtil;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Condition;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class ConditionImportListener
extends AbstractImportListener {
    public ConditionImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        if (operation.getPromotionType() != 1) {
            return 0;
        }
        Map casMaps = operation.getAssociationsForObjects(objects, "<Template><Condition UniqueIdentifier=\"\"></Condition></Template>");
        try {
            int index = 1;
            int count = objects.size();
            for (ImportItemInterface importItem : objects) {
                this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)this.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
                if (importItem.getImportState() != 1) {
                    try {
                        String oldGUID;
                        Condition condition = this.getConditionMetadataObject(operation.getStore(), importItem, importItem.getTargetID());
                        Map casSource = (Map)casMaps.get(importItem.getID());
                        if (casSource == null || (oldGUID = (String)casSource.get("UniqueIdentifier")) == null || oldGUID.equals(condition.getUniqueIdentifier())) continue;
                        throw new MetadataPromotionException(UtilMisc.getMessage((String)RB.getStringResource("ConditionImportListener.NewGUIDError.fmt"), (Object)importItem.getName()));
                    }
                    catch (MdException me) {
                        throw new MetadataPromotionException((Throwable)me);
                    }
                }
                Map casSource = (Map)casMaps.get(importItem.getID());
                if (casSource == null) continue;
                String oldGUID = (String)casSource.get("UniqueIdentifier");
                ConditionActionSetUtil.validateUniqueIdentifier(operation, oldGUID, importItem);
            }
            return 0;
        }
        catch (RemoteException re) {
            throw new MetadataPromotionException((Throwable)re);
        }
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        for (ImportItemInterface docItem : objects) {
            String type;
            this.fireDisplayMessage(StatusMessageUtil.createUpdatingMessage((TypeInterface)this.getTypeInterface(), (String)docItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("ConditionImportListener.MetadataInfo.fmt"), (Object)docItem.getName()));
            boolean bMetadataChanged = false;
            try {
                String id = docItem.getTargetID();
                if (id == null || id.length() == 0) {
                    id = docItem.getID();
                }
                Condition docObject = this.getConditionMetadataObject(operation.getStore(), docItem, id);
                if (operation.getPromotionType() != 1) {
                    String guid = GUID.newGUID();
                    docObject.setUniqueIdentifier(guid);
                }
                PromotionUtil.updateProductInfo((Root)docObject, (ImportOperationInterface)operation);
                bMetadataChanged = true;
                boolean publicTypeChanged = UtilMetadata.setPublicType((PrimaryType)docObject, (String)"Condition");
                if (publicTypeChanged) {
                    bMetadataChanged = true;
                }
                if (!bMetadataChanged) continue;
                bMetadataChanged = false;
                docObject.updateMetadataAll();
            }
            catch (MdException e) {
                type = docItem.getTypeInterface().getDisplayType();
                String name = docItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ConditionImportListener.errorValidatingMetadata.txt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
            catch (RemoteException e) {
                type = docItem.getTypeInterface().getDisplayType();
                String name = docItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ConditionImportListener.errorValidatingMetadata.txt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
        }
        return rc;
    }

    private Condition getConditionMetadataObject(MdObjectStore store, ImportItemInterface importItem, String fqid) throws MdException, RemoteException {
        String type = importItem.getTypeInterface().getMetadataType();
        String template = "<Templates><Condition></Condition></Templates>";
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        if (object instanceof Condition) {
            return (Condition)object;
        }
        throw new MdException("Invalid type returned from metadata for Condition: " + object.getCMetadataType());
    }
}

