/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.zos;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.tasks.MvsextractTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.SSNResource;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZosMain {
    private static final String[] VALID_ENCODINGS = new String[]{"C0", "F0", "R0", "W0", "W2", "W3", "W5", "W6", "W7", "W8", "W9", "WA", "WB", "WU"};
    protected static SSNResource BUNDLE = new SSNResource(ZosMain.class);

    public static void main(String[] args) throws Exception {
        if (TaskHelper.getOS() != 8) {
            throw new IllegalStateException("This cannot run on any platform other than z/OS.");
        }
        MvsextractTask.setupLoggingForMain();
        int count = args.length;
        for (int i = 0; i < count; ++i) {
            String arg = args[i];
            int next = i + 1;
            if (arg.equalsIgnoreCase("-hlq")) {
                if (count > next && !args[next].startsWith("-")) {
                    arg = args[next];
                    if (ZosMain.isValidHighLevelQualifier(arg)) {
                        MvsextractTask.UserParams.put("CUSTPRODQUAL", arg);
                        ++i;
                        continue;
                    }
                    throw new IllegalArgumentException("The high-level qualifier '" + arg + "' is invalid. Each qualifier level is 1 to 8 characters, the first of which must be alphabetic (A - Z) or national (# @ $). The remaining characters are either aphabetic, numeric (0 - 9), national, or a hyphen (-). Levels are separated by a single period (.). The total length of the qualifier cannot exceed 23 characters.");
                }
                throw new IllegalArgumentException("The '-hlq' argument must be followed by a valid MVS high-level qualifier.");
            }
            if (arg.equalsIgnoreCase("-encoding")) {
                if (count > next && !args[next].startsWith("-")) {
                    arg = args[next].toUpperCase();
                    if (ZosMain.isValidEncoding(arg)) {
                        MvsextractTask.UserParams.put("ORDERENCODING", arg);
                        ++i;
                        continue;
                    }
                    throw new IllegalArgumentException("The specified encoding '" + arg + "' is invalid. The encoding must be one of these values: " + ZosMain.validEncodingsToString());
                }
                throw new IllegalArgumentException("The '-encoding' argument must be followed by a valid 2-character code.");
            }
            if (arg.equalsIgnoreCase("-language")) {
                if (count > next && !args[next].startsWith("-")) {
                    arg = args[next].toUpperCase();
                    if (ZosMain.isValidLanguage(arg)) {
                        MvsextractTask.UserParams.put("LANGCODE", arg);
                        ++i;
                        continue;
                    }
                    throw new IllegalArgumentException("The specified language '" + arg + "' is invalid. The language must be a valid 2-character ISO language code.");
                }
                throw new IllegalArgumentException("The '-language' argument must be followed by a valid 2-character ISO language code.");
            }
            throw new IllegalArgumentException("The specified argument '" + arg + "' is not recognized. Valid arguments are '-hlq', '-encoding', and '-language'. Each must be followed by a valid value.");
        }
        if (null == MvsextractTask.UserParams.get("CUSTPRODQUAL") || null == MvsextractTask.UserParams.get("ORDERENCODING") || null == MvsextractTask.UserParams.get("LANGCODE")) {
            throw new IllegalArgumentException("Missing arguments - you must specify '-hlq', '-encoding', and '-language'. Each must be followed by a valid value.");
        }
        new Controller();
        MvsextractTask.updateValidJobDrivers();
    }

    private static boolean isValidHighLevelQualifier(String hlq) {
        if (hlq.length() > 23) {
            return false;
        }
        String highLevelQualifier = hlq.toUpperCase();
        if (highLevelQualifier.startsWith(".") || highLevelQualifier.endsWith(".") || highLevelQualifier.contains("..")) {
            return false;
        }
        String patternString = "[A-Z\\$\\#\\@][A-Z0-9\\-\\$\\#\\@]*";
        Pattern p = Pattern.compile(patternString);
        String token = null;
        StringTokenizer tokens = new StringTokenizer(highLevelQualifier, ".");
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.length() > 8) {
                return false;
            }
            Matcher m = p.matcher(token);
            if (m.matches()) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidEncoding(String enc) {
        if (enc.length() != 2) {
            return false;
        }
        for (String e : VALID_ENCODINGS) {
            if (!e.equalsIgnoreCase(enc)) continue;
            return true;
        }
        return false;
    }

    private static String validEncodingsToString() {
        StringBuffer sb = new StringBuffer();
        for (String e : VALID_ENCODINGS) {
            sb.append(e);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static boolean isValidLanguage(String lang) {
        String[] validLangs = Locale.getISOLanguages();
        if (lang.length() != 2) {
            return false;
        }
        for (String l : validLangs) {
            if (!l.equalsIgnoreCase(lang)) continue;
            return true;
        }
        return false;
    }
}

