/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.zos;

import com.ibm.jzos.RcException;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.it.schema.mvsdsdata.gen.DSTable;
import com.sas.tools.installs.it.schema.mvsdsdata.gen.DatasetType;
import com.sas.tools.installs.it.tasks.ApplySASLicenseTask;
import com.sas.tools.installs.it.tasks.MvsextractTask;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.it.zos.DatasetHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class JavaEditX {
    protected String _templateName;
    protected HashMap<String, String> _overriddenSymbols;
    protected HashMap<String, Document> _dataTables;
    protected HashMap<String, String> _dataTableKeys;
    public static DSTable dsTable;
    public static HashMap<String, DatasetType> datasetMap;
    protected boolean _sasedtxMode = false;
    protected boolean _passMode = false;
    protected Set<String> _targets;
    protected DatasetType _tableData;
    protected Vector<String> _processedInstances;
    protected StringBuffer _instanceSummary;
    protected boolean _exceptionForEmptySymbol = false;
    protected BufferedReader _reader;
    protected boolean _evalutedInstancesExist = false;
    protected boolean _lastInstanceQualified = false;
    protected Vector<String> loopLines = null;
    protected Vector<String> _qualifiedProducts = new Vector();
    protected int loopIndex = 0;
    protected StringBuffer _jobBuffer = new StringBuffer();
    protected StringBuffer _jobDescriptionBuffer = new StringBuffer();
    protected static Logger log;
    public static final String BEGIN = "#BEGIN";
    public static final String END = "#END";
    public static final String END_JOB_FORM = "#ENDJOBFORM";
    public static final String JOB_INFO = "#JOBINFO";
    public static final String PREFIX = "PREFIX";
    public static final String SUFFIX = "SUFFIX";
    public static final String INSTANCE = "INSTANCE";
    public static final String INSTANCE_QUALIFIERS = "INSTANCEQUALIFIERS";
    public static final String STATIC_INSTANCES = "STATICINSTANCES";
    public static final String COMMENT = "#/";
    public static final String SYMBOL_CALLS = "#SYMBOLCALLS";
    public static final String IFEQ = "#IFEQ";
    public static final String IF = "#IF";
    public static final String IFNOTEQ = "#IFNOTEQ";
    public static final String NON_DIRECTIVE = "#:";
    public static final String THEN = "#THEN";
    public static final String IF_NOT = "#IFNOT";
    public static final String SET = "#SET";
    public static final String SET4 = "#SET4";
    public static final String TABLEFIX = "#TABLEFIX";
    public static final String BUCKET_INSERT = "#BUCKETINSERT";
    public static final String JOBBOUNDARY = "#JOBBOUNDARY";
    public static final String INSTANCE_UNIQUE_KEY = "#INSTANCEUNIQUEKEY";
    public static final String STATIC_INSTANCE = "#STATICINSTANCE";
    public static final String NOT_UNIQUE = "#NOTUNIQUE";
    public static final String CREATE_INSTANCE_FROM_ENTRY = "#CREATEINSTANCEFROMENTRY";
    public static final String FORALL = "#FORALL";
    public static final String END_FORALL = "#ENDFORALL";
    public static final String SNIPPET_INSERT = "#SNIPPETINSERT";
    public static final String INSTANCES_CONTAIN_PRODUCT = "#INSTANCESCONTAINPRODUCT";
    public static final String INSTANCES_MISSING_PRODUCT = "#INSTANCESMISSINGPRODUCT";
    public static final String EXCEPTION_FOR_MISSING_SYMBOL = "#EXCEPTIONFORMISSINGSYMBOL";
    public static final String RESTRICT_TO_BASE_ZERO_ALTSKU = "#RESTRICTTOBASEZEROALTSKU";
    public static final String EXCLUDE_BBS_CONTENT = "#EXCLUDEBBSCONTENT";
    public static final String END_RESTRICT_TO_BASE_ZERO_ALTSKU = "#ENDRESTRICTTOBASEZEROALTSKU";
    public static final String END_EXCLUDE_BBS_CONTENT = "#ENDEXCLUDEBBSCONTENT";
    public static final String PROMOTE_PROCESSING = "#PROMOTEPROCESSING";
    public static final String END_PROMOTE_PROCESSING = "#ENDPROMOTEPROCESSING";
    public static final String PROCESS_INSTANCES = "#PROCESSINSTANCES";
    public static final String PASS = "#PASS";
    public static final String RESUME = "#RESUME";
    public static final String DIRBLOCKSNEEDED = "#DIRBLOCKSNEEDED";
    public static final String DIRBLOCKSACTUAL = "#DIRBLOCKSACTUAL";
    public static final String ADDNAME = "%/ADDNAME.";
    public static final String ADD_NAME = "./ ADD NAME";
    public static final Properties defaults;
    public static final Properties overrides;
    protected int bucketInsertCount = 0;
    protected static SSNResource BUNDLE;
    protected static SSNResource EN_BUNDLE;
    protected Vector<String> _jobs;
    protected Vector<String> _jobDescriptions;
    protected String line;
    protected int lineNumber;
    protected Element _currentEntry;

    public JavaEditX() {
        this.setInstanceSummary(new StringBuffer());
        this.setTargets(new HashSet<String>());
        this.setProcessedInstances(new Vector<String>());
        this.setJobs(new Vector<String>());
        this.setJobDescriptions(new Vector<String>());
        this.setOverriddenSymbols(new HashMap<String, String>());
        this.getOverriddenSymbols().put("SASHOME", System.getProperty("SASHome"));
    }

    public JavaEditX(String templateName) {
        this();
        this.setTemplateName(templateName);
        if (!MvsextractTask.isHotfix() && !MvsextractTask.UserParams.get("UPDATEMODE").equals("TRUE")) {
            String setinitLoc = ApplySASLicenseTask.extractLicenseSetinit().getAbsolutePath();
            int length = setinitLoc.length();
            this.getOverriddenSymbols().put("SETINIT_LOCATION1", setinitLoc.substring(0, length / 3));
            this.getOverriddenSymbols().put("SETINIT_LOCATION2", setinitLoc.substring(length / 3, length / 3 * 2));
            this.getOverriddenSymbols().put("SETINIT_LOCATION3", setinitLoc.substring(length / 3 * 2, length));
        }
        this.processTemplateSection("DEFS", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        InputStream is;
        String inputFileName;
        block21: {
            boolean pdsout = false;
            MvsextractTask.setupLoggingForMain();
            if (args.length < 2) {
                String msg = String.format("The argument list was either incomplete or invalid: %s", args);
                log.error(msg);
                throw new IllegalArgumentException(msg);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].length() != 0) continue;
                String msg = String.format("The argument list was either incomplete or invalid: %s", args);
                log.error(msg);
                throw new IllegalArgumentException(msg);
            }
            inputFileName = args[0];
            String outputFileName = args[1];
            JavaEditX.validateArguments(inputFileName, outputFileName);
            log.info("Processing file " + inputFileName + " with output to " + outputFileName);
            if (outputFileName.startsWith("//'")) {
                pdsout = true;
            }
            String props = null;
            try {
                props = System.getProperty("SASHome") + "/install.properties";
                FileInputStream propsInput = new FileInputStream(new File(props));
                Properties installProps = new Properties();
                installProps.load(propsInput);
                ((InputStream)propsInput).close();
                MvsextractTask.setInstallProperties(installProps);
                props = System.getProperty("SASHome") + "/InstallMisc/OVRPCFE.txt";
                propsInput = new FileInputStream(new File(props));
                overrides.load(propsInput);
                ((InputStream)propsInput).close();
                props = System.getProperty("SASHome") + "/InstallMisc/PRDMIT.txt";
                propsInput = new FileInputStream(new File(props));
                overrides.load(propsInput);
                ((InputStream)propsInput).close();
                props = System.getProperty("SASHome") + "/InstallMisc/SYMLIST.txt";
                propsInput = new FileInputStream(new File(props));
                overrides.load(propsInput);
                ((InputStream)propsInput).close();
                log.debug("overrides set to:");
                Enumeration<Object> overridesEnum = overrides.keys();
                while (overridesEnum.hasMoreElements()) {
                    String key = (String)overridesEnum.nextElement();
                    log.debug(key + "=>" + overrides.get(key));
                }
            }
            catch (FileNotFoundException ex) {
                throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.PropertyLoadFailure", props), EN_BUNDLE.messageString("JavaEditX.PropertyLoadFailure", props), ex);
            }
            JavaEditX editx = new JavaEditX();
            editx.setSasedtxMode(true);
            editx.setJobBuffer(new StringBuffer());
            is = null;
            String memberName = "DUMMY";
            String content = null;
            try {
                is = inputFileName.startsWith("//'") ? editx.setupReaderForMVSDataset(inputFileName) : editx.setupReaderForFile(inputFileName);
                String inputLine = "";
                int inputLineNumber = 0;
                try {
                    inputLine = editx.getReader().readLine();
                    while (inputLine != null) {
                        ++inputLineNumber;
                        if (inputLine.startsWith(ADDNAME) || inputLine.startsWith(ADD_NAME)) {
                            if (editx.getJobBuffer().length() > 0) {
                                content = editx.getJobBuffer().toString();
                                if (pdsout) {
                                    String datasetName = JavaEditX.getDatasetName(outputFileName);
                                    MvsextractTask.writeTextToDatasetMember(content, datasetName, memberName, false);
                                } else {
                                    editx.writeBufferToFile(content, outputFileName, memberName);
                                }
                                editx.setJobBuffer(new StringBuffer());
                            }
                            int s = inputLine.indexOf("=") + 1;
                            int e = inputLine.length();
                            memberName = inputLine.substring(s, e).trim();
                            log.info("memberName is now " + memberName);
                        } else {
                            editx.line = inputLine;
                            editx.processLine(null);
                        }
                        inputLine = editx.getReader().readLine();
                    }
                }
                catch (IOException e) {
                    throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileReadFailure", inputFileName, inputLineNumber), EN_BUNDLE.messageString("JavaEditX.FileReadFailure", inputFileName, inputLineNumber), e);
                }
                content = editx.getJobBuffer().toString();
                if (pdsout) {
                    String datasetName = JavaEditX.getDatasetName(outputFileName);
                    MvsextractTask.writeTextToDatasetMember(content, datasetName, memberName, false);
                    break block21;
                }
                editx.writeBufferToFile(content, outputFileName, memberName);
            }
            catch (Throwable throwable) {
                try {
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileCloseFailure", inputFileName), EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", inputFileName), e);
                }
            }
        }
        try {
            if (is == null) return;
            is.close();
            return;
        }
        catch (IOException e) {
            throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileCloseFailure", inputFileName), EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", inputFileName), e);
        }
    }

    private static void validateArguments(String inFileName, String outFileName) {
        String datasetName;
        if (inFileName.startsWith("//'")) {
            datasetName = inFileName.substring(2);
            if (!MvsextractTask.datasetExists(datasetName)) {
                throw new IllegalArgumentException("Input data set '" + datasetName + "' was not found.");
            }
        } else {
            File inFile = new File(inFileName);
            if (!inFile.exists()) {
                throw new IllegalArgumentException("Input file '" + inFileName + "' was not found.");
            }
        }
        if (outFileName.startsWith("//'")) {
            datasetName = JavaEditX.getDatasetName(outFileName);
            if (datasetName.contains("(") && datasetName.endsWith(")")) {
                throw new IllegalArgumentException("Output data set '" + datasetName + "' specifies a PDS member name. A member name is not allowed.");
            }
            if (!MvsextractTask.datasetExists(datasetName)) {
                throw new IllegalArgumentException("Output dataset '" + datasetName + "' was not found.");
            }
        } else {
            File outFile = new File(outFileName);
            if (!outFile.exists()) {
                throw new IllegalArgumentException("Output directory '" + outFileName + "' was not found.");
            }
            if (!outFile.isDirectory()) {
                throw new IllegalArgumentException("Output path '" + outFileName + "' is not a directory.");
            }
        }
    }

    private static String getDatasetName(String outputFileName) {
        int start = outputFileName.indexOf("'") + 1;
        int end = outputFileName.lastIndexOf("'");
        return outputFileName.substring(start, end);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeBufferToFile(String buffer, String dirName, String fileName) {
        String output = dirName + File.separator + fileName;
        File of = new File(output);
        log.info("writing current content to " + of.getAbsolutePath());
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(of)));
            out.write(buffer);
            out.close();
        }
        catch (Exception e) {
            try {
                throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileWriteFailure", of.getAbsolutePath()), EN_BUNDLE.messageString("JavaEditX.FileWriteFailure", of.getAbsolutePath()), e);
            }
            catch (Throwable throwable) {
                try {
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileCloseFailure", of.getAbsolutePath()), EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", of.getAbsolutePath()), e2);
                }
            }
        }
        try {
            if (out == null) return;
            out.close();
            return;
        }
        catch (IOException e) {
            throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileCloseFailure", of.getAbsolutePath()), EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", of.getAbsolutePath()), e);
        }
    }

    public InputStream setupReaderForTemplate(String templateName) {
        FileInputStream retval = null;
        try {
            retval = new FileInputStream(new File(MvsextractTask.getTemplateLoc(), templateName));
            InputStreamReader isr = new InputStreamReader(retval);
            this.setReader(new BufferedReader(isr));
        }
        catch (Exception e) {
            throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.TemplateLoadingError", templateName), EN_BUNDLE.messageString("JavaEditX.TemplateLoadingError", templateName), e);
        }
        return retval;
    }

    public InputStream setupReaderForFile(String fileName) {
        FileInputStream retval = null;
        try {
            retval = new FileInputStream(new File(fileName));
            InputStreamReader isr = new InputStreamReader(retval);
            this.setReader(new BufferedReader(isr));
        }
        catch (Exception e) {
            throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.TemplateLoadingError", fileName), EN_BUNDLE.messageString("JavaEditX.TemplateLoadingError", fileName), e);
        }
        return retval;
    }

    public InputStream setupReaderForMVSDataset(String datasetName) {
        File tempFile = null;
        boolean failure = false;
        Exception exception = null;
        try {
            String line;
            tempFile = File.createTempFile("datasetReadTempFile", ".txt");
            tempFile.deleteOnExit();
            log.info("copying content to " + tempFile.getAbsolutePath() + " for read access");
            String[] cmdArray = new String[]{"/bin/cp", datasetName, tempFile.getAbsolutePath()};
            Process p = Runtime.getRuntime().exec(cmdArray, null, null);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            log.info("about to run /bin/cp \"" + datasetName + "\"" + tempFile.getAbsolutePath());
            int retval = p.waitFor();
            if (retval != 0) {
                failure = true;
            }
            log.info("====================output streams begin=====================");
            while ((line = input.readLine()) != null) {
                log.info("stdout:" + line);
            }
            while ((line = error.readLine()) != null) {
                log.info("stderr:" + line);
            }
            log.info("====================output streams end=====================");
        }
        catch (Exception e) {
            failure = true;
            exception = e;
        }
        if (failure) {
            String path = tempFile.getAbsolutePath();
            throw new InstallException(1, null, BUNDLE.messageString("JavaEditX.FileCreationFailure", path), EN_BUNDLE.messageString("JavaEditX.FileCreationFailure", path), exception);
        }
        return this.setupReaderForFile(tempFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public StringBuffer processTemplateSection(String sectionSymbol, HashMap<String, String> args, Element entry) {
        this.setLastInstanceQualified(false);
        JavaEditX.log.info("processing " + sectionSymbol + " of " + this.getTemplateName() + " with args " + args);
        this.setCurrentEntry(entry);
        this.setJobBuffer(new StringBuffer());
        is = null;
        try {
            is = this.setupReaderForTemplate(this.getTemplateName());
            this.line = "";
            processingStarted = sectionSymbol == null;
            this.lineNumber = 0;
            while (this.line != null) {
                try {
                    this.line = this.getReader().readLine();
                    ++this.lineNumber;
                    if (this.line == null) {
                        break;
                    }
                }
                catch (IOException e) {
                    throw new InstallException(3, null, JavaEditX.BUNDLE.messageString("JavaEditX.FileReadFailure", new Object[]{this.getTemplateName(), this.lineNumber}), JavaEditX.EN_BUNDLE.messageString("JavaEditX.FileReadFailure", new Object[]{this.getTemplateName(), this.lineNumber}), e);
                }
                if (sectionSymbol == null) break block21;
                if (!processingStarted) {
                    if (!this.line.startsWith("#BEGIN" + sectionSymbol) || !(m = (p = Pattern.compile("#BEGIN" + sectionSymbol + "\\b.*")).matcher(this.line)).matches()) continue;
                    processingStarted = true;
                    JavaEditX.log.info("skipped lines 1 - " + this.lineNumber + " in search of " + "#BEGIN" + sectionSymbol + ".  Begin " + sectionSymbol + " processing for " + this.getTemplateName());
                    continue;
                }
                if (!this.line.startsWith("#BEGIN")) ** GOTO lbl50
                JavaEditX.log.info("end " + sectionSymbol + " processing for " + this.getTemplateName());
                if (sectionSymbol != null && ("INSTANCE".equals(sectionSymbol) || "#STATICINSTANCE".equals(sectionSymbol))) {
                    this.getInstanceSummary().append(this.getJobBuffer());
                }
                var6_7 = this.getJobBuffer();
            }
        }
        catch (Throwable var8_12) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new InstallException(3, null, JavaEditX.BUNDLE.messageString("JavaEditX.FileCloseFailure", new Object[]{this.getTemplateName()}), JavaEditX.EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", new Object[]{this.getTemplateName()}), e);
            }
            throw var8_12;
        }
        {
            block21: {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new InstallException(3, null, JavaEditX.BUNDLE.messageString("JavaEditX.FileCloseFailure", new Object[]{this.getTemplateName()}), JavaEditX.EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", new Object[]{this.getTemplateName()}), e);
                }
                return var6_7;
            }
            if (this.line.startsWith("#BEGIN")) continue;
lbl50:
            // 2 sources

            if (!this.processLine(args)) continue;
            var6_7 = this.getJobBuffer();
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new InstallException(3, null, JavaEditX.BUNDLE.messageString("JavaEditX.FileCloseFailure", new Object[]{this.getTemplateName()}), JavaEditX.EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", new Object[]{this.getTemplateName()}), e);
            }
            return var6_7;
        }
        try {
            if (is == null) ** GOTO lbl65
            is.close();
        }
        catch (IOException e) {
            throw new InstallException(3, null, JavaEditX.BUNDLE.messageString("JavaEditX.FileCloseFailure", new Object[]{this.getTemplateName()}), JavaEditX.EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", new Object[]{this.getTemplateName()}), e);
        }
lbl65:
        // 2 sources

        if (sectionSymbol != null && sectionSymbol.equals("INSTANCE")) {
            this.getInstanceSummary().append(this.getJobBuffer());
        }
        return this.getJobBuffer();
    }

    public boolean symbolCalls() {
        Pattern p = Pattern.compile("#SYMBOLCALLS\\s*(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String list = m.group(1).trim();
            Vector<String> requiredParams = new Vector<String>(Arrays.asList(list.split(";")));
            for (String requiredParam : requiredParams) {
                if (MvsextractTask.UserParams.get(requiredParam) != null || overrides.get(requiredParam) != null) continue;
                throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.InsufficientParams", requiredParam), EN_BUNDLE.messageString("JavaEditX.InsufficientParams", requiredParam), null);
            }
        }
        return false;
    }

    public boolean then() {
        Pattern p = Pattern.compile("#THEN\\s*(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String target = m.group(1).trim();
            this.getTargets().add(target);
            log.info("unconditional jump to symbol:  " + target);
            this.lineNumber = this.skipToSymbol(target);
            return false;
        }
        return false;
    }

    public void evaluateForTargets(String snippet) {
        Pattern p = Pattern.compile("\\s*#THEN\\s*(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(snippet);
        if (m.matches()) {
            String target = m.group(1).trim();
            this.getTargets().add(target);
        }
    }

    public boolean ifEq() {
        Pattern p = Pattern.compile("#IFEQ\\s*([[^#]&&[\\S]]*)\\s*([[^#]&&[\\S]]*)\\s*(.*?)");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String evaluationLine = m.group(3).trim();
            if (m.group(1).equals(m.group(2))) {
                this.line = evaluationLine;
                return this.processLine(null);
            }
            log.info("terms unequal.  Not evaluating " + evaluationLine);
            this.evaluateForTargets(evaluationLine);
        }
        return false;
    }

    public boolean ifNotEq() {
        Pattern p = Pattern.compile("#IFNOTEQ\\s*([[^#]&&[\\S]]*)\\s*([[^#]&&[\\S]]*)\\s*(.*?)");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String evaluationLine = m.group(3).trim();
            if (!m.group(1).equals(m.group(2))) {
                this.line = evaluationLine;
                return this.processLine(null);
            }
            log.info("terms equal.  Not evaluating " + evaluationLine);
            this.evaluateForTargets(evaluationLine);
        }
        return false;
    }

    public boolean ifNot() {
        Pattern p = Pattern.compile("#IFNOT\\s*([[^#]&&[\\S]]*)\\s*(.*?)");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String evaluationLine = m.group(2).trim();
            if (m.group(1).length() == 0) {
                this.line = evaluationLine;
                return this.processLine(null);
            }
            log.info("term exists.  Not evaluating " + evaluationLine);
            this.evaluateForTargets(evaluationLine);
        }
        return false;
    }

    public boolean ifStatement() {
        Pattern p = Pattern.compile("#IF\\s*([[^#]&&[\\S]]*)\\s*(.*?)");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String evaluationLine = m.group(2).trim();
            if (m.group(1).length() > 0) {
                this.line = evaluationLine;
                return this.processLine(null);
            }
            log.info("term exists.  Not evaluating " + evaluationLine);
            this.evaluateForTargets(evaluationLine);
        }
        return false;
    }

    public boolean jobInfo() {
        Pattern p = Pattern.compile("#JOBINFO\\s*?(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            this.getJobDescriptionBuffer().append(m.group(1).trim() + "\n");
        }
        return false;
    }

    public boolean set(HashMap<String, String> args) {
        String value;
        String key;
        Pattern p = Pattern.compile("#SET\\s*\\[([^\\]]*)\\]\\s*(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        if (m.matches() && m.groupCount() > 1) {
            key = m.group(1);
            value = m.group(2).trim();
            if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
        } else {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), "Improper parameters for #SET while evaluating\n" + this.getTemplateName() + "\nline " + this.lineNumber + ":  " + this.line, null);
        }
        value = this.resolveSymbols(value, args);
        log.info("adding " + key + "=" + value + " to overriddenSymbols");
        this.getOverriddenSymbols().put(key, value);
        return false;
    }

    public boolean set4(HashMap<String, String> args) {
        String value;
        String key;
        Pattern p = Pattern.compile("#SET4\\s*/([^/]*)/.*");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            key = "#4";
            value = m.group(1);
            if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
        } else {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), "Improper parameters for #SET4 while evaluating\n" + this.getTemplateName() + "\nline " + this.lineNumber + ":  " + this.line, null);
        }
        value = this.resolveSymbols(value, args);
        log.info("adding " + key + "=" + value + " to overriddenSymbols");
        this.getOverriddenSymbols().put(key, value);
        return false;
    }

    public boolean tablefix() {
        Pattern p = Pattern.compile("#TABLEFIX\\s*(\\S*)\\s*(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        String twoByteCode = null;
        if (m.matches()) {
            twoByteCode = m.group(1).trim();
            if (twoByteCode.startsWith("\"") && twoByteCode.endsWith("\"") || twoByteCode.startsWith("'") && twoByteCode.endsWith("'")) {
                twoByteCode = twoByteCode.substring(1, twoByteCode.length() - 1);
            }
            if (!datasetMap.containsKey(twoByteCode)) {
                throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), "Improper Two Byte Code for #TABLEFIX while evaluating\n" + this.getTemplateName() + "\nline " + this.lineNumber + ":  " + this.line, null);
            }
            this.setTableData(datasetMap.get(twoByteCode));
        }
        return false;
    }

    public String shorthandTablefixValue(String symbol) {
        if (symbol.startsWith("[") && symbol.endsWith("]")) {
            symbol = symbol.substring(1, symbol.length() - 1);
        }
        String[] parts = symbol.split(":");
        com.sas.tools.installs.it.schema.mvsdsdata.DatasetType ds = (com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)datasetMap.get(parts[0]);
        return DatasetHelper.getValue(ds, parts[1]);
    }

    public boolean processInstances() {
        String line;
        Pattern p = Pattern.compile("#PROCESSINSTANCES\\s+(\\S*)\\s+(.*)");
        Matcher m = p.matcher(line = "#PROCESSINSTANCES MVSDSDataTable.xml NOSAL:X DATASETTYPE:PDS||DATASETTYPE:PDSE");
        if (m.matches()) {
            String condition = m.group(2);
            String[] pieces = condition.split("\\s");
            Vector<Vector<String>> allOrPieces = new Vector<Vector<String>>();
            Vector<String> andPieces = new Vector<String>();
            for (int i = 0; i < pieces.length; ++i) {
                String piece = pieces[i];
                if (piece.contains("||")) {
                    Vector<String> localOrPieces = new Vector<String>(Arrays.asList(piece.split("\\|\\|")));
                    allOrPieces.add(localOrPieces);
                    continue;
                }
                andPieces.add(piece);
            }
            for (DatasetType ds : dsTable.getDataset()) {
                boolean allAttributesPassed = true;
                for (String string : andPieces) {
                    String[] keyValue = string.split(":");
                    if (keyValue[1].equals(DatasetHelper.getValue((com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)ds, keyValue[0]))) continue;
                    allAttributesPassed = false;
                    break;
                }
                if (allAttributesPassed) {
                    for (Vector vector : allOrPieces) {
                        boolean anythingPassed = false;
                        for (String orPiece : vector) {
                            String[] keyValue = (orPiece = orPiece.trim()).split(":");
                            if (!keyValue[1].equals(DatasetHelper.getValue((com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)ds, keyValue[0]).trim())) continue;
                            anythingPassed = true;
                            break;
                        }
                        if (anythingPassed) continue;
                        allAttributesPassed = false;
                        break;
                    }
                }
                if (!allAttributesPassed) continue;
                this.setTableData(ds);
                this.staticInstance("");
            }
        } else {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, line, this.getTemplateName()), EN_BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, line, this.getTemplateName()), null);
        }
        return false;
    }

    public boolean staticInstance() {
        Pattern p = Pattern.compile("#STATICINSTANCE\\s+(.*)");
        Matcher m = p.matcher(this.line);
        String params = null;
        if (!m.matches()) {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), EN_BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), null);
        }
        params = m.group(1).trim();
        return this.staticInstance(params);
    }

    public boolean staticInstance(String paramString) {
        BufferedReader reader = this.getReader();
        Element entry = this.getCurrentEntry();
        String[] params = paramString.split(";");
        HashMap<String, String> instanceParams = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            String[] keyValue = params[i].split("=");
            if (keyValue.length != 2) continue;
            instanceParams.put(keyValue[0], keyValue[1]);
        }
        log.info("\n***********************processing static instance for template " + this.getTemplateName() + " START***********************\n");
        this.processTemplateSection(INSTANCE, instanceParams, null);
        log.info("\n***********************processing static instance for template " + this.getTemplateName() + " END***********************\n");
        this.setReader(reader);
        this.setCurrentEntry(entry);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean snippetInsert(HashMap<String, String> args) {
        Pattern p = Pattern.compile("#SNIPPETINSERT\\s+(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        if (!m.matches()) {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), EN_BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), null);
        }
        String snippetFile = m.group(1).trim();
        InputStream is = null;
        BufferedReader reader = null;
        Element entry = null;
        try {
            reader = this.getReader();
            entry = this.getCurrentEntry();
            is = this.setupReaderForTemplate(snippetFile);
            String snippetLine = "";
            int snippetLineNumber = 0;
            while (snippetLine != null) {
                try {
                    snippetLine = this.getReader().readLine();
                    ++snippetLineNumber;
                    if (snippetLine != null) {
                        this.line = snippetLine;
                        this.processLine(args);
                        continue;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileReadFailure", this.getTemplateName(), snippetLineNumber), EN_BUNDLE.messageString("JavaEditX.FileReadFailure", this.getTemplateName(), snippetLineNumber), e);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileCloseFailure", this.getTemplateName()), EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", this.getTemplateName()), e);
            }
            if (reader != null) {
                this.setReader(reader);
            }
            if (entry == null) throw throwable;
            this.setCurrentEntry(entry);
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileCloseFailure", this.getTemplateName()), EN_BUNDLE.messageString("JavaEditX.FileCloseFailure", this.getTemplateName()), e);
        }
        if (reader != null) {
            this.setReader(reader);
        }
        if (entry == null) return false;
        this.setCurrentEntry(entry);
        return false;
    }

    public boolean bucketInsert() {
        Pattern p = Pattern.compile("#BUCKETINSERT\\s+(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String bucketFile = m.group(1).trim() + this.bucketInsertCount;
            JavaEditX bucket = MvsextractTask.getProcessedTemplates().get(bucketFile);
            if (bucket.isEvalutedInstancesExist()) {
                log.info("inserting " + bucketFile + " template instances, because it contained content for some artifacts");
                log.info("appending jobcard output for the prefix section of " + bucketFile);
                this.getJobBuffer().append(bucket.processTemplateSection(PREFIX, new HashMap<String, String>(), null));
                log.info("appending jobcard output for the evaluated instances of " + bucketFile);
                this.getJobBuffer().append(bucket.getInstanceSummary().toString().replace("#|", COMMENT));
                log.info("appending jobcard output for the suffix section of " + bucketFile);
                this.getJobBuffer().append(bucket.processTemplateSection(SUFFIX, new HashMap<String, String>(), null));
            } else {
                log.info("skipping " + bucketFile + " template instances, because it contained content for no artifacts");
            }
        } else {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), EN_BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), null);
        }
        ++this.bucketInsertCount;
        return false;
    }

    public boolean forAll(HashMap<String, String> args) {
        this.loopLines = new Vector();
        int forallLineNumber = this.lineNumber;
        while (!this.line.startsWith(END_FORALL)) {
            try {
                this.line = this.getReader().readLine();
            }
            catch (IOException e) {
                throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.FileReadFailure", this.getTemplateName(), this.lineNumber), EN_BUNDLE.messageString("JavaEditX.FileReadFailure", this.getTemplateName(), this.lineNumber), null);
            }
            if (this.line.startsWith(END_FORALL)) break;
            this.loopLines.add(this.line);
        }
        NodeList members = this.getCurrentEntry().getElementsByTagName("entry");
        for (int i = 0; i < members.getLength(); ++i) {
            Element member = (Element)members.item(i);
            HashMap<String, String> memberParams = new HashMap<String, String>(args);
            NamedNodeMap attributes = member.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                memberParams.put(attributes.item(j).getNodeName(), attributes.item(j).getNodeValue());
            }
            log.info("processing foreach block with params:  " + memberParams);
            this.lineNumber = forallLineNumber + 1;
            this.loopIndex = 0;
            while (this.loopIndex < this.loopLines.size()) {
                this.line = this.loopLines.get(this.loopIndex);
                this.processLine(memberParams);
                this.lineNumber = forallLineNumber + this.loopIndex + 1;
                ++this.loopIndex;
            }
            this.lineNumber = forallLineNumber + this.loopLines.size();
        }
        this.loopLines = null;
        return false;
    }

    public boolean instanceUniqueKey() {
        Pattern p = Pattern.compile("#INSTANCEUNIQUEKEY(.*?)(#NOTUNIQUE(.*))*");
        Matcher m = p.matcher(this.line);
        String match = null;
        String nonUniqueTarget = null;
        if (m.matches()) {
            this.setLastInstanceQualified(false);
            match = m.group(1).trim();
            if (m.group(2) == null) {
                if (!this.getProcessedInstances().contains(match)) {
                    this.getProcessedInstances().add(match);
                }
                return false;
            }
            nonUniqueTarget = m.group(3).trim();
            this.getTargets().add(nonUniqueTarget);
            if (this.getProcessedInstances().contains(match)) {
                log.info("Found a processed instance signature matching " + match + ", so skipping to " + nonUniqueTarget);
                this.skipToSymbol(nonUniqueTarget);
                return false;
            }
            log.info("No processed instance signatures match " + match);
            this.getProcessedInstances().add(match);
            if (this.getTemplateName().equals("BucketDefBBSDSAlloc")) {
                StringBuffer instances = new StringBuffer();
                for (String instance : this.getProcessedInstances()) {
                    instances.append(instance + ",");
                }
                log.info("instances now " + instances);
            }
            return false;
        }
        throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), EN_BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), null);
    }

    public boolean nonDirective() {
        this.line = this.line.substring(2, this.line.length());
        return this.processLine(null);
    }

    public boolean target() {
        Pattern p = Pattern.compile("#(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String target = m.group(1).trim();
            if (this.getTargets().contains(target)) {
                log.info("encountered target:  " + target);
                return false;
            }
        }
        throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.UnknownDirective", this.lineNumber, this.getTemplateName(), this.line), EN_BUNDLE.messageString("JavaEditX.UnknownDirective", this.lineNumber, this.getTemplateName(), this.line), null);
    }

    public boolean instancesContainProduct() {
        Pattern p = Pattern.compile("#INSTANCESCONTAINPRODUCT\\s*([[^#]&&[\\S]]*)\\s*(.*?)");
        Matcher m = p.matcher(this.line);
        if (m.matches()) {
            String evaluationLine = m.group(2).trim();
            String productName = m.group(1).trim();
            if (this.getQualifiedProducts().contains(productName)) {
                this.line = evaluationLine;
                return this.processLine(null);
            }
            log.info("Product " + productName + " not found in qualifying instances.  Not evaluating " + evaluationLine);
            this.evaluateForTargets(evaluationLine);
        }
        return false;
    }

    public boolean instancesMissingProduct() {
        Pattern p = Pattern.compile("#INSTANCESMISSINGPRODUCT\\s*([[^#]&&[\\S]]*)\\s*(.*?)");
        Matcher m = p.matcher(this.line);
        log.info("evaluating\n" + this.line + "\nto see if instances were missing a product");
        if (m.matches()) {
            String evaluationLine = m.group(2).trim();
            String productName = m.group(1).trim();
            log.info("instruction to evaluate if missing:  " + evaluationLine);
            log.info("product to check for:  " + productName);
            log.info("qualified products:");
            for (String product : this.getQualifiedProducts()) {
                log.info(product);
            }
            if (!this.getQualifiedProducts().contains(productName)) {
                this.line = evaluationLine;
                log.info("qualified products did not contain " + productName + ", so processing\n" + this.line);
                return this.processLine(null);
            }
            log.info("Product " + productName + " found in qualifying instances.  Not evaluating " + evaluationLine);
            this.evaluateForTargets(evaluationLine);
        } else {
            log.info("wrong formatting for #INSTANCESMISSINGPRODUCT statement.  Unable to match");
        }
        return false;
    }

    public boolean processLine(HashMap<String, String> args) {
        if (this.line.startsWith(COMMENT)) {
            return false;
        }
        if (this.isSasedtxMode()) {
            if (this.line.startsWith("# ")) {
                return false;
            }
            if (this.line.startsWith(PASS)) {
                this.setPassMode(true);
                return false;
            }
            if (this.isPassMode()) {
                if (this.line.startsWith(RESUME)) {
                    this.setPassMode(false);
                } else {
                    log.info("job line output:  " + this.line);
                    this.getJobBuffer().append(this.line.replace("#|", COMMENT) + "\n");
                }
                return false;
            }
        }
        if (this.line.matches("\\s+#:.*")) {
            this.line = this.line.replaceFirst("\\s+#:", "");
        }
        if (!this.line.startsWith(SET)) {
            log.info("job line input:  " + this.line + "(" + this.getTemplateName() + " line " + this.lineNumber + ")");
            this.line = this.resolveSymbols(this.line, args);
        }
        if (this.line.startsWith(SYMBOL_CALLS)) {
            return this.symbolCalls();
        }
        if (this.line.startsWith(EXCEPTION_FOR_MISSING_SYMBOL)) {
            this.setExceptionForEmptySymbol(true);
        } else {
            if (this.line.startsWith(THEN)) {
                return this.then();
            }
            if (this.line.startsWith(IFEQ)) {
                return this.ifEq();
            }
            if (this.line.startsWith(IFNOTEQ)) {
                return this.ifNotEq();
            }
            if (this.line.startsWith(IF_NOT)) {
                return this.ifNot();
            }
            if (this.line.startsWith(IF)) {
                return this.ifStatement();
            }
            if (this.line.startsWith(RESTRICT_TO_BASE_ZERO_ALTSKU)) {
                return false;
            }
            if (this.line.startsWith(EXCLUDE_BBS_CONTENT)) {
                return false;
            }
            if (this.line.startsWith(END_RESTRICT_TO_BASE_ZERO_ALTSKU)) {
                return false;
            }
            if (this.line.startsWith(END_EXCLUDE_BBS_CONTENT)) {
                return false;
            }
            if (this.line.startsWith(PROMOTE_PROCESSING)) {
                return false;
            }
            if (this.line.startsWith(END_PROMOTE_PROCESSING)) {
                return false;
            }
            if (this.line.startsWith(DIRBLOCKSNEEDED)) {
                return this.dirBlocksNeeded(args);
            }
            if (this.line.startsWith(DIRBLOCKSACTUAL)) {
                return this.dirBlocksActual(args);
            }
            if (this.line.startsWith(SET4)) {
                return this.set4(args);
            }
            if (this.line.startsWith(SET)) {
                return this.set(args);
            }
            if (this.line.startsWith(SNIPPET_INSERT)) {
                return this.snippetInsert(args);
            }
            if (this.line.startsWith(TABLEFIX)) {
                return this.tablefix();
            }
            if (this.line.startsWith(BUCKET_INSERT)) {
                return this.bucketInsert();
            }
            if (this.line.startsWith(FORALL)) {
                return this.forAll(args);
            }
            if (this.line.startsWith(INSTANCE_UNIQUE_KEY)) {
                return this.instanceUniqueKey();
            }
            if (this.line.startsWith(STATIC_INSTANCE)) {
                this.setEvalutedInstancesExist(true);
                if (args != null) {
                    String productName = args.get("PRODUCT");
                    if (productName != null) {
                        this.getQualifiedProducts().add(productName);
                        log.info("adding " + productName + " to qualified products (static instance)");
                    } else {
                        log.info("PRODUCT arg not found when checking args to add to qualified products list");
                    }
                } else {
                    log.info("No args specified for static processing, so skipping qualified products addition");
                }
                return this.staticInstance();
            }
            if (this.line.startsWith(PROCESS_INSTANCES)) {
                return this.processInstances();
            }
            if (this.line.startsWith(NON_DIRECTIVE)) {
                return this.nonDirective();
            }
            if (this.line.startsWith(INSTANCES_CONTAIN_PRODUCT)) {
                return this.instancesContainProduct();
            }
            if (this.line.startsWith(INSTANCES_MISSING_PRODUCT)) {
                return this.instancesMissingProduct();
            }
            if (this.line.startsWith(CREATE_INSTANCE_FROM_ENTRY)) {
                log.info("evaluating instance");
                this.setLastInstanceQualified(true);
                if (args != null) {
                    String productName = args.get("PRODUCT");
                    if (productName != null) {
                        this.getQualifiedProducts().add(productName);
                        log.info("adding " + productName + " to qualified products (static instance)");
                    } else {
                        log.info("PRODUCT arg not found when checking args to add to qualified products list");
                    }
                } else {
                    log.info("No args specified for static processing, so skipping qualified products addition");
                }
                this.setEvalutedInstancesExist(true);
            } else if (this.line.startsWith(JOBBOUNDARY) || this.line.startsWith(END_JOB_FORM)) {
                String job = this.getJobBuffer().toString();
                int e = job.indexOf(" EXEC ");
                if (e > -1) {
                    if (e != job.lastIndexOf(" EXEC ")) {
                        log.info("New Job evaluation beginning.  Storing the following text for last job:\n\n\n" + job + "\n\n\n");
                        this.getJobs().add(job);
                        this.getJobDescriptions().add(this.getJobDescriptionBuffer().toString() + "\n");
                    }
                } else {
                    log.info("New Job evaluation beginning, job buffer is empty. No text to store.\n\n");
                }
                this.setJobBuffer(new StringBuffer());
                this.setJobDescriptionBuffer(new StringBuffer());
            } else {
                if (this.line.startsWith(JOB_INFO)) {
                    return this.jobInfo();
                }
                if (this.line.startsWith(END)) {
                    return false;
                }
                if (this.line.startsWith("#") && !this.line.startsWith("#!")) {
                    return this.target();
                }
                Pattern p = Pattern.compile("(.*?)(?=#/|\\z).*");
                Matcher m = p.matcher(this.line);
                m.matches();
                String output = m.group(1).replaceFirst("\\s*$", "");
                log.info("job line output:  " + output);
                this.getJobBuffer().append(output.replace("#|", COMMENT) + "\n");
            }
        }
        return false;
    }

    public int skipToSymbol(String targetName) {
        this.line = "";
        int beginLineNumber = this.lineNumber;
        if (this.loopLines != null) {
            while (this.loopIndex < this.loopLines.size()) {
                this.line = this.loopLines.get(this.loopIndex);
                if (this.line.startsWith(BUCKET_INSERT)) {
                    ++this.bucketInsertCount;
                }
                if (this.symbolFound(this.line, targetName)) {
                    ++this.loopIndex;
                    log.info("skipped lines " + beginLineNumber + " through " + (beginLineNumber + this.loopIndex) + " in search of #" + targetName);
                    return this.lineNumber + this.loopIndex;
                }
                ++this.loopIndex;
            }
            return this.lineNumber + this.loopIndex;
        }
        while (this.line != null) {
            try {
                this.line = this.getReader().readLine();
                ++this.lineNumber;
                if (this.line == null) {
                    return this.lineNumber;
                }
            }
            catch (IOException e) {
                throw new InstallException(3, null, BUNDLE.messageString("JavaEditX.FileReadError", this.getTemplateName()), EN_BUNDLE.messageString("JavaEditX.FileReadError", this.getTemplateName()), e);
            }
            if (this.line.startsWith(BUCKET_INSERT)) {
                ++this.bucketInsertCount;
            }
            if (!this.symbolFound(this.line, targetName)) continue;
            log.info("skipped lines " + beginLineNumber + " through " + this.lineNumber + " in search of #" + targetName);
            return this.lineNumber;
        }
        return this.lineNumber;
    }

    public boolean symbolFound(String line, String targetName) {
        Pattern p = Pattern.compile(".*?#THEN\\s*(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(line);
        if (m.matches()) {
            String target = m.group(1).trim();
            this.getTargets().add(target);
        }
        return line.startsWith("#" + targetName);
    }

    public String resolveSymbols(String unresolvedString, HashMap<String, String> args) {
        String close;
        String open;
        Matcher m;
        Pattern p;
        if (this.isSasedtxMode()) {
            p = Pattern.compile(".*?%([^%&^\\.]+)\\..*");
            m = p.matcher(unresolvedString);
            open = "%";
            close = ".";
        } else {
            p = Pattern.compile(".*?\\[([^\\[&^\\]]+)\\].*");
            m = p.matcher(unresolvedString);
            open = "[";
            close = "]";
        }
        if (m.matches()) {
            String symbolName = m.group(1);
            String value = this.lookupSymbol(symbolName, args);
            while (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            String resolvedLine = Utils.stringReplaceAll(unresolvedString, open + symbolName + close, value);
            if (resolvedLine.equals(unresolvedString)) {
                return this.resolveArgs(unresolvedString, args);
            }
            return this.resolveSymbols(resolvedLine, args);
        }
        return this.resolveArgs(unresolvedString, args);
    }

    public String resolveArgs(String unresolvedString, HashMap<String, String> args) {
        if (args == null) {
            return unresolvedString;
        }
        Pattern p = Pattern.compile(".*?\\{([^\\{&^\\}]+)\\}.*");
        Matcher m = p.matcher(unresolvedString);
        boolean shouldUppercase = false;
        boolean shouldUpdateName = false;
        if (m.matches()) {
            String resolvedLine;
            String symbol = m.group(1);
            p = Pattern.compile("UC\\((.*)\\)$");
            m = p.matcher(symbol);
            String newSymbol = symbol;
            if (m.matches()) {
                shouldUppercase = true;
                newSymbol = m.group(1);
            } else {
                p = Pattern.compile("NEW\\((.*)\\)$");
                m = p.matcher(symbol);
                if (m.matches()) {
                    shouldUpdateName = true;
                    newSymbol = m.group(1);
                }
            }
            String value = "";
            if (args.get(newSymbol) != null) {
                value = args.get(newSymbol);
            }
            if (shouldUppercase) {
                value = value.toUpperCase();
            }
            if (shouldUpdateName) {
                value = value.toUpperCase();
                value = "NEW".concat(value.substring(3));
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            if ((resolvedLine = Utils.stringReplaceAll(unresolvedString, "{" + symbol + "}", value)).equals(unresolvedString)) {
                return unresolvedString;
            }
            return this.resolveArgs(resolvedLine, args);
        }
        return unresolvedString;
    }

    public String lookupSymbol(String symbolName, HashMap<String, String> args) {
        String overriddenSymbolsValue;
        String shorthandValue;
        String[] symbolParts = symbolName.split(":");
        if (symbolParts.length == 2 && (shorthandValue = this.shorthandTablefixValue(symbolName)) != null) {
            return shorthandValue;
        }
        String overridesValue = overrides.getProperty(symbolName);
        if (overridesValue != null) {
            log.info("resolving " + symbolName + " from symbol overrides:  " + overridesValue);
            return overridesValue;
        }
        if (this.getOverriddenSymbols() != null && (overriddenSymbolsValue = this.getOverriddenSymbols().get(symbolName)) != null) {
            return overriddenSymbolsValue;
        }
        if (this.getTableData() != null) {
            String tableDataValue = null;
            try {
                tableDataValue = DatasetHelper.getValue((com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)this.getTableData(), symbolName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tableDataValue != null && tableDataValue.length() != 0) {
                return tableDataValue;
            }
        }
        try {
            String userParamsValue;
            if (MvsextractTask.UserParams != null && (userParamsValue = MvsextractTask.UserParams.get(symbolName)) != null) {
                return userParamsValue;
            }
        }
        catch (Throwable userParamsValue) {
            // empty catch block
        }
        String defaultsValue = defaults.getProperty(symbolName);
        if (defaultsValue != null) {
            return defaultsValue;
        }
        if (this.isExceptionForEmptySymbol()) {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), "Symbol named " + symbolName + " could not be resolved\n" + this.getTemplateName() + "\nline " + this.lineNumber + ":  " + this.line, null);
        }
        return "";
    }

    public boolean dirBlocksActual(HashMap<String, String> args) {
        String dirBlocks;
        String quotedDsName;
        String dscode = args.get("MVS2BDSCODE");
        DatasetType dstype = datasetMap.get(dscode);
        String actual = ((com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)dstype).getDIRBLOCKSACTUAL();
        if (null != actual && !actual.isEmpty()) {
            log.debug("got DIRBLOCKSACTUAL=" + actual + " from DatasetType.getDIRBLOCKSACTUAL()");
            return false;
        }
        Pattern p = Pattern.compile("#DIRBLOCKSACTUAL\\s*(\\S*)\\s*(.*?)(?=#/|\\z).*");
        Matcher m = p.matcher(this.line);
        if (m.matches() && m.groupCount() > 0) {
            String value = m.group(1).trim();
            if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            String dsName = this.resolveSymbols(value, args);
            quotedDsName = String.format("'%s'", dsName);
            dirBlocks = "";
            if (MvsextractTask.datasetExists(dsName)) {
                dirBlocks = String.valueOf(this.directoryBlockCount(quotedDsName));
            } else {
                this.dirBlocksNeeded(args);
                dirBlocks = ((com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)dstype).getDIRBLOCKSNEEDED();
            }
        } else {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.TemplateFormatError", this.lineNumber, this.line, this.getTemplateName()), "Improper parameters for #DIRBLOCKSACTUAL while evaluating\n" + this.getTemplateName() + "\nline " + this.lineNumber + ":  " + this.line, null);
        }
        log.debug("calling DatasetType.setDIRBLOCKSACTUAL(" + dirBlocks + ") for " + quotedDsName);
        ((com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)dstype).setDIRBLOCKSACTUAL(dirBlocks);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int directoryBlockCount(String dataSetName) {
        int dirBlocks = 0;
        try {
            RecordReader reader = null;
            try {
                reader = JavaEditX.getDatasetReader(dataSetName);
                int bytes = 1;
                while (bytes > 0) {
                    bytes = this.readLine(reader);
                    if (bytes <= 0) continue;
                    ++dirBlocks;
                }
            }
            finally {
                if (reader != null) {
                    JavaEditX.closeDatasetReader(reader);
                }
            }
        }
        catch (ZFileException zfEx) {
            String msg = String.format("Error reading directory of %s: %s", dataSetName, zfEx.getMessage());
            throw new InstallException(3, null, msg, msg, null);
        }
        log.info(String.format("Data set %s has %d directory blocks", dataSetName, dirBlocks));
        return dirBlocks;
    }

    private static RecordReader getDatasetReader(String datasetName) throws ZFileException, RcException {
        String ddName = "PDSDIR";
        String alloc = String.format("alloc fi(%s) da(%s) reuse recfm(u) shr msg(2)", ddName, datasetName);
        ZFile.bpxwdyn((String)alloc);
        RecordReader reader = null;
        reader = RecordReader.newReaderForDD((String)ddName);
        return reader;
    }

    private static void closeDatasetReader(RecordReader reader) throws ZFileException, RcException {
        if (reader != null) {
            String ddName = reader.getDDName();
            try {
                reader.close();
            }
            catch (Throwable throwable) {
                String free = String.format("free fi(%s)", ddName);
                ZFile.bpxwdyn((String)free);
                throw throwable;
            }
            String free = String.format("free fi(%s)", ddName);
            ZFile.bpxwdyn((String)free);
        }
    }

    private int readLine(RecordReader reader) throws ZFileException {
        byte[] buffer = new byte[256];
        int bytes = 0;
        bytes = reader.read(buffer);
        return bytes;
    }

    public boolean dirBlocksNeeded(HashMap<String, String> args) {
        String dscode = args.get("MVS2BDSCODE");
        DatasetType dstype = datasetMap.get(dscode);
        String needed = ((com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)dstype).getDIRBLOCKSNEEDED();
        if (null != needed && !needed.isEmpty()) {
            log.debug("got DIRBLOCKSNEEDED=" + needed + " from DatasetType.getDIRBLOCKSNEEDED()");
            return false;
        }
        String spaceParms = dstype.getSPACEPARMS().trim();
        String pattern = "\\((\\d+|CYL|TRK)\\,\\((\\d+)\\,(\\d+)\\,(\\d+)\\).*";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(spaceParms);
        if (!m.matches()) {
            String msg = String.format("Invalid SPACEPARMS value from MVSDSDataTable.xml for %s: %s", dscode, spaceParms);
            throw new InstallException(3, null, msg, msg, null);
        }
        String dirBlocks = m.group(4);
        log.debug("calling DatasetType.setDIRBLOCKSNEEDED(" + dirBlocks + ") for " + dscode);
        ((com.sas.tools.installs.it.schema.mvsdsdata.DatasetType)dstype).setDIRBLOCKSNEEDED(dirBlocks);
        return false;
    }

    public String getTemplateName() {
        return this._templateName;
    }

    public void setTemplateName(String template) {
        this._templateName = template;
    }

    public HashMap<String, String> getOverriddenSymbols() {
        return this._overriddenSymbols;
    }

    public void setOverriddenSymbols(HashMap<String, String> overriddenSymbols) {
        this._overriddenSymbols = overriddenSymbols;
    }

    public DatasetType getTableData() {
        return this._tableData;
    }

    public void setTableData(DatasetType tableData) {
        this._tableData = tableData;
    }

    public StringBuffer getInstanceSummary() {
        return this._instanceSummary;
    }

    public void setInstanceSummary(StringBuffer cumulativeBucket) {
        this._instanceSummary = cumulativeBucket;
    }

    public Set<String> getTargets() {
        return this._targets;
    }

    public void setTargets(Set<String> targets) {
        this._targets = targets;
    }

    public Vector<String> getJobs() {
        return this._jobs;
    }

    public void setJobs(Vector<String> jobs) {
        this._jobs = jobs;
    }

    public Vector<String> getJobDescriptions() {
        return this._jobDescriptions;
    }

    public void setJobDescriptions(Vector<String> jobDescriptions) {
        this._jobDescriptions = jobDescriptions;
    }

    public Vector<String> getProcessedInstances() {
        return this._processedInstances;
    }

    public void setProcessedInstances(Vector<String> processedInstances) {
        this._processedInstances = processedInstances;
    }

    public boolean isExceptionForEmptySymbol() {
        return this._exceptionForEmptySymbol;
    }

    public void setExceptionForEmptySymbol(boolean exceptionForEmptySymbol) {
        this._exceptionForEmptySymbol = exceptionForEmptySymbol;
    }

    public BufferedReader getReader() {
        return this._reader;
    }

    public void setReader(BufferedReader reader) {
        this._reader = reader;
    }

    public Element getCurrentEntry() {
        return this._currentEntry;
    }

    public void setCurrentEntry(Element currentEntry) {
        this._currentEntry = currentEntry;
    }

    public boolean isEvalutedInstancesExist() {
        return this._evalutedInstancesExist;
    }

    public void setEvalutedInstancesExist(boolean evalutedInstancesExist) {
        this._evalutedInstancesExist = evalutedInstancesExist;
    }

    public boolean isLastInstanceQualified() {
        return this._lastInstanceQualified;
    }

    public void setLastInstanceQualified(boolean lastInstanceQualified) {
        this._lastInstanceQualified = lastInstanceQualified;
    }

    public StringBuffer getJobBuffer() {
        return this._jobBuffer;
    }

    public void setJobBuffer(StringBuffer jobBuffer) {
        this._jobBuffer = jobBuffer;
    }

    public StringBuffer getJobDescriptionBuffer() {
        return this._jobDescriptionBuffer;
    }

    public void setJobDescriptionBuffer(StringBuffer jobDescriptionBuffer) {
        this._jobDescriptionBuffer = jobDescriptionBuffer;
    }

    public Vector<String> getQualifiedProducts() {
        return this._qualifiedProducts;
    }

    public void setQualifiedProducts(Vector<String> qualifiedProducts) {
        this._qualifiedProducts = qualifiedProducts;
    }

    public boolean isSasedtxMode() {
        return this._sasedtxMode;
    }

    public void setSasedtxMode(boolean sasedtxMode) {
        this._sasedtxMode = sasedtxMode;
    }

    public boolean isPassMode() {
        return this._passMode;
    }

    public void setPassMode(boolean passMode) {
        this._passMode = passMode;
    }

    static {
        block20: {
            log = (Logger)LogManager.getLogger("com.sas.tools.installs.it.zos.JavaEditX");
            defaults = new Properties();
            overrides = new Properties();
            BUNDLE = new SSNResource(JavaEditX.class);
            EN_BUNDLE = SSNResource.EnglishResource(JavaEditX.class);
            File defaultsFile = new File(MvsextractTask.getTemplateLoc(), "SymbolDefaults.properties");
            File overridesFile = new File(MvsextractTask.getTemplateLoc(), "SymbolOverride.properties");
            FileInputStream is = null;
            try {
                is = new FileInputStream(defaultsFile);
                if (is != null) {
                    try {
                        defaults.load(is);
                    }
                    catch (IOException e) {
                        throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.SetupError"), EN_BUNDLE.messageString("JavaEditX.SetupError"), e);
                    }
                }
                GregorianCalendar now = new GregorianCalendar();
                Object datePart = String.valueOf(now.get(6));
                String DATE_FORMAT = "HHmmssSSS";
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                datePart = (String)datePart + sdf.format(now.getTime());
                defaults.setProperty("DATETIMEPFX", (String)datePart);
                defaults.setProperty("OSTEMPDIR", System.getProperty("java.io.tmpdir"));
                if (!overridesFile.exists()) break block20;
                is = new FileInputStream(overridesFile);
                if (is != null) {
                    try {
                        overrides.load(is);
                    }
                    catch (IOException e) {
                        throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.SetupError"), EN_BUNDLE.messageString("JavaEditX.SetupError"), e);
                    }
                }
                log.info("overrides set to:");
                Enumeration<Object> overridesEnum = overrides.keys();
                while (overridesEnum.hasMoreElements()) {
                    String key = (String)overridesEnum.nextElement();
                    log.info(key + "=>" + overrides.get(key));
                }
            }
            catch (FileNotFoundException e) {
                throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.SetupError"), EN_BUNDLE.messageString("JavaEditX.SetupError"), e);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.SetupError"), EN_BUNDLE.messageString("JavaEditX.SetupError"), e);
                    }
                }
            }
        }
        File mvsDSDataTable = new File(MvsextractTask.getTemplateLoc(), "MVSDSDataTable.xml");
        try {
            log.debug("unmarshalling dataset metadata:  " + mvsDSDataTable);
            dsTable = SchemaUtils.unmarshal(mvsDSDataTable, DSTable.class);
            datasetMap = new HashMap();
            for (DatasetType ds : dsTable.getDataset()) {
                datasetMap.put(ds.getMVS2BDSCODE().trim(), ds);
            }
        }
        catch (JAXBException e) {
            throw new InstallException(2, null, BUNDLE.messageString("JavaEditX.SetupError"), EN_BUNDLE.messageString("JavaEditX.SetupError"), e);
        }
    }
}

