/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.zos;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.tasks.MvsextractTask;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.it.zos.JobHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class JESHelper
implements JobHelper {
    protected static Logger log = (Logger)LogManager.getLogger("com.sas.tools.installs.it.zos.JESHelper");
    private static final String ARG_JOBID = "-j";
    private static final String JOBOUT = "/zos/jobout";
    private static final String JOBSTAT = "/zos/jobstat";
    private static final String JOBSUB = "/zos/jobsub";
    private static final String EBCDIC_CHARSET = "IBM-1047";
    private static final String NEWLINE = "\n";
    private static final long JOB_POLL_INTERVAL = 5000L;
    private static final String JOB = "JOB ";
    private static final String SUBMITTED = " SUBMITTED";
    private static final String SUBMIT_RESULT_PATTERN = "JOB .+\\([A-Z]*[0-9]+\\) SUBMITTED.*";
    private static final String JOBSTAT_ERROR_PREFIX = "jobstat: ";
    private static final String COMP = "Comp=";
    private static final String COMP_ENDED = "Ended";
    private static final String COMP_ENDED_NORMALLY = "Ended Normally";
    private static final String COMP_ENDED_WITH_ERROR = "Ended with Error";
    private static final String COMP_ABENDED = "Abended";
    private static final String COMP_CANCELED = "Canceled";
    private static final String COMP_JCLERROR = "JCL Error";
    private static final String COMP_CONVERTER = "Converter";
    private static final String COMP_SECURITY = "Security";
    private static final String COMP_FAILED = "Failed";
    private static final String COMP_IEFSSREQ = "IEFSSREQ";
    private static final String COMP_SUCCESS = "MaxCC=0";
    private static final String UNKNOWN_ERROR = "Unknown error";
    private static final SSNResource BUNDLE = new SSNResource(JESHelper.class);
    private static final SSNResource EN_BUNDLE = SSNResource.EnglishResource(JESHelper.class);
    private String cmdOutput;
    private String cmdStatus;
    private String cmdSubmit;

    public JESHelper(Controller controller) {
        String runLocation = controller.getInstallAppLocation();
        this.cmdOutput = runLocation.concat(JOBOUT);
        this.cmdStatus = runLocation.concat(JOBSTAT);
        this.cmdSubmit = runLocation.concat(JOBSUB);
    }

    @Override
    public boolean submitJob(String member, String jclString) throws Exception {
        boolean success = true;
        String[] cmdArray = new String[]{this.getCmdSubmit()};
        StringReader sr = new StringReader(jclString);
        BufferedReader br = new BufferedReader(sr);
        log.info("Executing command: " + this.arrayAsString(cmdArray));
        String cmdResult = this.runCommand(cmdArray, br);
        log.info("Command result: " + cmdResult);
        String jobId = this.jobIdFromSubmitResult(cmdResult);
        if (null == jobId) {
            log.error("Failed to submit job: " + cmdResult);
            throw new InstallException(1, null, BUNDLE.messageString("JESHelper.JobSubmissionFailed", cmdResult), EN_BUNDLE.messageString("JESHelper.JobSubmissionFailed", cmdResult), null);
        }
        success = this.waitForJob(member, jobId);
        this.retrieveJobOutput(jobId);
        return success;
    }

    private String jobIdFromSubmitResult(String submitResult) {
        Pattern p = Pattern.compile(SUBMIT_RESULT_PATTERN);
        Matcher m = p.matcher(submitResult.trim());
        if (!m.matches()) {
            return null;
        }
        int start = JOB.length();
        int end = submitResult.indexOf(SUBMITTED);
        return submitResult.substring(start, end);
    }

    private boolean waitForJob(String member, String jobId) throws Exception {
        String[] completions = new String[]{COMP_ENDED, COMP_ABENDED, COMP_CANCELED, COMP_JCLERROR, COMP_CONVERTER, COMP_SECURITY, COMP_FAILED, COMP_IEFSSREQ};
        boolean running = true;
        boolean result = false;
        String jobResult = null;
        String statusKey = null;
        String status = null;
        String desc = BUNDLE.messageString("JobHelper.WaitingForJob", member, jobId);
        NotificationHandler.defaultHandler().fireProgressBeginNotification(desc);
        block0: while (running) {
            if (MvsextractTask.checkInterrupt()) {
                log.warn("User chose to cancel.  Abandoning job check");
                break;
            }
            Thread.sleep(5000L);
            String[] cmdArray = new String[]{this.getCmdStatus(), ARG_JOBID, jobId};
            jobResult = this.runCommand(cmdArray);
            if (jobResult.startsWith(JOBSTAT_ERROR_PREFIX)) {
                log.error(jobResult);
                status = String.format(" -- %s: %s -- %s", BUNDLE.getString("JobHelper.Unknown"), jobId, jobResult);
                MvsextractTask.getJobStatus().put(member, status);
                desc = BUNDLE.messageString("JESHelper.JobStatusFailed", jobResult);
                NotificationHandler.defaultHandler().fireProgressCompleteNotification(desc);
                return false;
            }
            for (String completion : completions) {
                String searchFor = String.format("%s%s", COMP, completion);
                if (!jobResult.contains(searchFor)) continue;
                running = false;
                if (jobResult.contains(COMP_SUCCESS)) {
                    result = true;
                    log.info(jobResult);
                    status = String.format(" -- %s: %s", BUNDLE.getString("JobHelper.Successful"), jobId);
                    statusKey = "JobHelper.Succeeded";
                } else {
                    log.error(jobResult);
                    status = String.format(" -- %s: %s -- %s", BUNDLE.getString("JobHelper.Failed"), jobId, this.getJobStatus(jobResult));
                    statusKey = "JobHelper.Failed";
                }
                MvsextractTask.getJobStatus().put(member, status);
                continue block0;
            }
        }
        desc = BUNDLE.messageString("JobHelper.JobCompleted", member, BUNDLE.getString(statusKey), jobId, this.getJobStatus(jobResult));
        NotificationHandler.defaultHandler().fireProgressCompleteNotification(desc);
        return result;
    }

    private String runCommand(String[] cmdArray) throws InstallException {
        return this.runCommand(cmdArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runCommand(String[] cmdArray, BufferedReader reader) throws InstallException {
        String result = "";
        String command = this.arrayAsString(cmdArray);
        ProcessBuilder pb = new ProcessBuilder(cmdArray);
        pb.redirectErrorStream(true);
        Process p = null;
        BufferedWriter input = null;
        BufferedReader output = null;
        try {
            p = pb.start();
            input = new BufferedWriter(new OutputStreamWriter(p.getOutputStream(), EBCDIC_CHARSET));
            output = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.writeCommandInput(reader, input);
            p.waitFor();
            result = this.readCommandOutput(output);
        }
        catch (IOException ioEx) {
            this.throwCommandFailure(command, ioEx);
        }
        catch (InterruptedException iEx) {
            this.throwCommandFailure(command, iEx);
        }
        finally {
            if (null != p) {
                p.destroy();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCommandInput(BufferedReader reader, BufferedWriter input) throws IOException {
        if (null == reader) {
            return;
        }
        try {
            String jcl = reader.readLine();
            while (jcl != null) {
                jcl = jcl.concat(NEWLINE);
                input.write(jcl);
                jcl = reader.readLine();
            }
        }
        finally {
            input.close();
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCommandOutput(BufferedReader output) throws IOException {
        StringBuffer result = new StringBuffer();
        try {
            String line;
            while ((line = output.readLine()) != null) {
                log.trace(line);
                result.append(line);
                result.append(NEWLINE);
            }
        }
        finally {
            output.close();
        }
        return result.toString();
    }

    private void throwCommandFailure(String command, Exception ex) {
        throw new InstallException(1, null, BUNDLE.messageString("JESHelper.CommandExecutionFailed", command), EN_BUNDLE.messageString("JESHelper.CommandExecutionFailed", command), ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveJobOutput(String jobId) {
        String[] cmdArray = new String[]{this.getCmdOutput(), ARG_JOBID, jobId};
        Process p = null;
        try {
            log.info("Executing command: " + this.arrayAsString(cmdArray));
            ProcessBuilder pb = new ProcessBuilder(cmdArray);
            pb.redirectErrorStream(true);
            p = pb.start();
            this.logJobOutput(jobId, p);
            p.waitFor();
        }
        catch (IOException ioEx) {
            this.logOutputFailure(jobId, ioEx);
        }
        catch (InterruptedException iEx) {
            this.logOutputFailure(jobId, iEx);
        }
        finally {
            if (null != p) {
                p.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logJobOutput(String jobId, Process p) throws IOException {
        BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream()));
        log.info("Output for job " + jobId);
        log.info("<============================ START OF JOB OUTPUT =============================>");
        try {
            String line;
            while ((line = output.readLine()) != null) {
                log.info(line);
            }
        }
        finally {
            output.close();
        }
        log.info("<============================= END OF JOB OUTPUT ==============================>");
    }

    private void logOutputFailure(String jobid, Exception ex) {
        log.warn(EN_BUNDLE.messageString("JESHelper.OutputRetrievalFailed", jobid), (Throwable)ex);
    }

    private String arrayAsString(String[] array) {
        StringBuffer result = new StringBuffer();
        for (String s : array) {
            result.append(s + " ");
        }
        return result.toString();
    }

    private String getJobStatus(String jobResult) {
        int start = jobResult.indexOf(COMP);
        if (start == -1) {
            return UNKNOWN_ERROR;
        }
        String status = jobResult.substring(start + COMP.length());
        if (status.contains(COMP_SUCCESS)) {
            return status;
        }
        if (status.contains(COMP_ABENDED)) {
            return this.updateAbendCodes(status);
        }
        return status.replace(COMP_ENDED_NORMALLY, COMP_ENDED_WITH_ERROR);
    }

    private String updateAbendCodes(String status) {
        String RESULT_PATTERN = "(Abended\\(RC=S[0-9A-F]+ )(U[0-9A-F]+)(\\))";
        String FORMAT = "U%04d";
        Pattern p = Pattern.compile("(Abended\\(RC=S[0-9A-F]+ )(U[0-9A-F]+)(\\))");
        Matcher m = p.matcher(status.trim());
        if (!m.matches()) {
            return status;
        }
        String abendStringHex = m.group(2);
        String abendCodeHex = abendStringHex.substring(1);
        int value = Integer.parseInt(abendCodeHex, 16);
        String abendStringDecimal = String.format("U%04d", value);
        String updatedStatus = status.replace(abendStringHex, abendStringDecimal);
        return updatedStatus;
    }

    private String getCmdOutput() {
        return this.cmdOutput;
    }

    private String getCmdStatus() {
        return this.cmdStatus;
    }

    private String getCmdSubmit() {
        return this.cmdSubmit;
    }
}

