/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.zos;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.tasks.MvsextractTask;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.it.zos.JobHelper;
import com.sas.util.SasPasswordString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class FTPHelper
implements JobHelper {
    protected static final Logger log = (Logger)LogManager.getLogger("com.sas.tools.installs.it.zos.FTPHelper");
    private SSNResource bundle;
    private SSNResource enBundle;
    private boolean isHotfix;
    private String password;
    private String server;
    private String user;

    public FTPHelper(String server, String user, String password, boolean isHotfix, SSNResource bundle, SSNResource enBundle) {
        this.server = server;
        this.user = user;
        this.password = password;
        this.isHotfix = isHotfix;
        this.bundle = bundle;
        this.enBundle = bundle;
    }

    private String getPassword() {
        return this.password;
    }

    private String getServer() {
        return this.server;
    }

    private String getUser() {
        return this.user;
    }

    private boolean isHotfix() {
        return this.isHotfix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submitJob(String member, String jclString) throws Exception {
        try (BufferedInputStream jclStream = this.getJclStream(jclString);){
            boolean bl = this.submitJob(member, jclStream);
            return bl;
        }
    }

    private boolean submitJob(String member, BufferedInputStream jclStream) throws Exception {
        FTPClient ftp = new FTPClient();
        String pw = this.getPassword();
        if (null != pw) {
            pw = SasPasswordString.decode(pw);
        }
        String jobId = null;
        InputStream jesOutputIS = null;
        boolean retval = false;
        try {
            log.error("Signon to server " + this.server + ", user " + this.user);
            ftp.connect(this.getServer());
            if (!FTPReply.isPositiveCompletion(ftp.getReplyCode())) {
                log.error("FTP connection failed: " + ftp.getReplyString());
            }
            log.info("connect succeeded");
            log.error(ftp.getReplyString());
            ftp.login(this.getUser(), pw);
            log.info("login succeeded");
            log.error(ftp.getReplyString());
            ftp.site("sbdataconn=(ibm-1047,iso8859-1)");
            log.error(ftp.getReplyString());
            ftp.site("filetype=jes");
            log.error(ftp.getReplyString());
            jclStream.mark(Integer.MAX_VALUE);
            ftp.storeFile(this.server, jclStream);
            String replyText = ftp.getReplyString();
            if (replyText.startsWith("530 ") || replyText.startsWith("530-")) {
                log.error("replyText:  " + replyText);
                log.error("ERROR: Invalid password entered for id " + this.user);
                this.setStatus(member, jobId, this.bundle.getString("MvsextractTask.MVSGeneralSubmitError"));
                return false;
            }
            log.error("replyText:  " + replyText);
            int jobNumOffset = replyText.indexOf("JES as ") + 7;
            jobId = replyText.substring(jobNumOffset, jobNumOffset + 8).trim();
            log.error("jobid:  " + jobId);
            boolean jobcomplete = false;
            boolean jobfound = false;
            int waitInterval = 15;
            int waittime = 12600;
            if (jobId.equalsIgnoreCase("*UNKNOWN")) {
                log.error("Job submission failed: verify JOB card");
                this.setStatus(member, jobId, this.bundle.getString("MvsextractTask.MVSGeneralSubmitError"));
                return false;
            }
            if (this.isHotfix()) {
                String message = this.bundle.messageString("MvsextractTask.JobSubmitted", jobId);
                log.info(message);
                NotificationHandler.defaultHandler().fireProgressCompleteNotification(message);
            }
            while (waittime > 0) {
                if (!ftp.isConnected()) {
                    log.error("Signon to server " + this.server + ", user " + this.user);
                    ftp.connect(this.server);
                    log.error(ftp.getReplyString());
                    ftp.login(this.user, pw);
                    log.error(ftp.getReplyString());
                    ftp.site("filetype=jes");
                    log.error(ftp.getReplyString());
                }
                FTPListParseEngine engine = ftp.initiateListParsing("com.sas.tools.installs.it.zos.JESFTPEntryParser", ".");
                FTPFile[] files = engine.getFiles();
                jobfound = false;
                log.info(files.length + " files");
                for (int i = 0; i < files.length; ++i) {
                    if (files[i] == null || files[i].getName() == null || !files[i].getName().equalsIgnoreCase(jobId)) continue;
                    log.info("job found");
                    jobfound = true;
                    if (files[i].getGroup() == null || !files[i].getGroup().equalsIgnoreCase("OUTPUT")) break;
                    log.info("retrieving stream " + jobId);
                    jesOutputIS = ftp.retrieveFileStream(jobId);
                    jobcomplete = jesOutputIS != null;
                    String reply = ftp.getReplyString();
                    jobfound = reply.indexOf("cannot find output") < 0;
                    log.error("reply:  " + reply);
                    break;
                }
                if (jobcomplete) break;
                if (MvsextractTask.checkInterrupt()) {
                    log.debug("User chose to cancel.  Abandoning job check");
                    this.setStatus(member, jobId, this.bundle.getString("MvsextractTask.Unknown"));
                    return false;
                }
                log.info(this.bundle.messageString("AssembleMVSJobcode.JobWait", jobId, waitInterval));
                NotificationHandler.defaultHandler().fireProgressCompleteNotification(this.bundle.messageString("AssembleMVSJobcode.JobWait", jobId, waitInterval));
                log.error("Job still running, wait " + waitInterval + " seconds");
                Thread.sleep(waitInterval * 1000);
                waittime -= waitInterval;
            }
            if (!jobfound) {
                throw new InstallException(1, null, this.bundle.messageString("AssembleMVSJobcode.MVSJobNotFound", jobId), this.enBundle.messageString("AssembleMVSJobcode.MVSJobNotFound", jobId), null);
            }
            if (!jobcomplete) {
                throw new InstallException(1, null, this.bundle.messageString("AssembleMVSJobcode.MVSIncompleteJob", jobId), this.enBundle.messageString("AssembleMVSJobcode.MVSIncompleteJob", jobId), null);
            }
            StringBuffer jesLogBuffer = null;
            try {
                jesLogBuffer = this.contentFromFTPStream(jesOutputIS);
            }
            catch (IOException e) {
                throw new InstallException(1, null, this.bundle.messageString("AssembleMVSJobcode.MVSGeneralSubmitError"), this.enBundle.messageString("AssembleMVSJobcode.MVSGeneralSubmitError"), e);
            }
            finally {
                jesOutputIS.close();
                if (!ftp.completePendingCommand()) {
                    ftp.logout();
                    ftp.disconnect();
                    log.error("File transfer failed.");
                }
            }
            String jesLog = jesLogBuffer.toString();
            retval = this.jobSuccessFromLog(jesLog);
            if (retval) {
                this.setStatus(member, jobId, this.bundle.getString("MvsextractTask.JobCompleted"));
            } else {
                this.setStatus(member, jobId, this.bundle.getString("MvsextractTask.JobFailed"));
            }
            log.info("JES output:  " + jesLog);
            ftp.quit();
            log.info(ftp.getReplyString());
        }
        catch (ParserInitializationException f) {
            throw new InstallException(1, null, this.bundle.messageString("AssembleMVSJobcode.MVSParserInitializationError"), this.enBundle.messageString("AssembleMVSJobcode.MVSParserInitializationError"), f.getRootCause());
        }
        return retval;
    }

    private boolean jobSuccessFromLog(String jesLog) throws Exception {
        boolean retval = false;
        if (!jesLog.contains("IEF403I ")) {
            log.info("job did not run");
        } else if (jesLog.contains("JOB NOT RUN")) {
            log.info("job did not run");
        } else if (jesLog.contains("JOB FAILED")) {
            log.info("job failed");
        } else if (jesLog.contains("Job not found")) {
            log.info("job was not found");
        } else if (jesLog.contains("Job did not complete")) {
            log.info("job did not complete");
        } else {
            String[] lineArray = jesLog.split("\n");
            Vector<String> lines = new Vector<String>(Arrays.asList(lineArray));
            Pattern conditionCodePattern = Pattern.compile(".*COND CODE\\s*(\\S*)$");
            Pattern returnCodePattern = Pattern.compile(".*RETURN CODE( IS)* (\\S*)$");
            boolean failure = false;
            for (String line : lines) {
                block21: {
                    Matcher m;
                    block20: {
                        m = conditionCodePattern.matcher(line);
                        if (m.matches()) {
                            try {
                                if (!new Integer(m.group(1)).equals(0)) {
                                    log.info("non-zero COND CODE, so marking job as failed:  " + line);
                                    failure = true;
                                }
                                break block20;
                            }
                            catch (Exception e) {
                                log.info("non-zero COND CODE, so marking job as failed:  " + line);
                                failure = true;
                            }
                            break;
                        }
                    }
                    if ((m = returnCodePattern.matcher(line)).matches()) {
                        try {
                            if (!new Integer(m.group(2)).equals(0)) {
                                log.info("non-zero RETURN CODE, so marking job as failed:  " + line);
                                failure = true;
                            }
                            break block21;
                        }
                        catch (Exception e) {
                            log.info("non-zero RETURN CODE, so marking job as failed:  " + line);
                            failure = true;
                        }
                        break;
                    }
                }
                if (!failure) continue;
                break;
            }
            if (!failure) {
                retval = true;
            }
        }
        return retval;
    }

    private BufferedInputStream getJclStream(String jclString) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(jclString.getBytes("ISO-8859-1"));
        return new BufferedInputStream(is);
    }

    private StringBuffer contentFromFTPStream(InputStream is) throws IOException {
        int ch;
        StringBuffer retval = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
        while ((ch = reader.read()) > -1) {
            if (ch == 21) {
                ch = 10;
            }
            retval.append((char)ch);
        }
        reader.close();
        return retval;
    }

    private void setStatus(String member, String jobId, String message) {
        String status = String.format(" -- %s: %s", message, jobId == null ? "" : jobId);
        MvsextractTask.getJobStatus().put(member, status);
    }
}

