/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.vjr;

import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.it.schema.metadata.gen.ContentsType;
import com.sas.tools.installs.it.schema.metadata.gen.EntryType;
import com.sas.tools.installs.it.schema.metadata.gen.ObjectFactory;
import com.sas.tools.installs.it.schema.metadata.gen.Zip;
import com.sas.tools.installs.it.tasks.Globals;
import com.sas.tools.installs.it.vjr.InvalidPluginException;
import com.sas.tools.installs.it.vjr.SASVersion;
import com.sas.tools.installs.it.vjr.VJRPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class VJRPluginZip
extends VJRPlugin {
    protected static Logger log = (Logger)LogManager.getLogger(VJRPluginZip.class.getName());
    public static final ObjectFactory zipFactory = new ObjectFactory();
    protected ZipFile m_zipFile = null;
    protected boolean m_closedZipFile = false;
    protected ZipOutputStream m_zipOutputStream = null;
    protected boolean m_closedZipOutputStream = false;
    protected Zip m_zipMetadata = null;
    protected boolean isValid = false;

    public VJRPluginZip(File file) throws InvalidPluginException {
        super(file);
    }

    public VJRPluginZip(String vjrDepotSrc, SASVersion sasVersion) {
        this.setSASVersion(sasVersion);
        this.setFile(new File(vjrDepotSrc, sasVersion.toString() + ".zip"));
    }

    @Override
    protected String getVersionedNameFromFile(File file) throws InvalidPluginException {
        String zipName = file.getName();
        if (!zipName.endsWith(".zip")) {
            throw new InvalidPluginException("Versioned plugin file '" + zipName + "' does not end with a .zip extension!");
        }
        return zipName.substring(0, zipName.length() - 4);
    }

    public boolean isValid() {
        if (!this.isValid) {
            try {
                this.validate();
                this.isValid = true;
            }
            catch (InvalidPluginException ipe) {
                log.error("Versioned plugin file '" + this.m_file + "' is not valid!", (Throwable)ipe);
            }
        }
        return this.isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws InvalidPluginException {
        if (!this.exists()) {
            throw new InvalidPluginException("Versioned plugin file '" + this.m_file + "' does not exist!");
        }
        Zip zipMeta = null;
        ZipFile zipFile = null;
        try {
            ContentsType contents;
            try {
                zipMeta = this.getZipMetadata();
            }
            catch (Exception e) {
                log.error("Versioned plugin file '" + this.m_file + "' is missing or contains an invalid ziplist file '" + this.getZipListPath() + "' from error: " + e.getLocalizedMessage());
                throw new InvalidPluginException("Versioned plugin file '" + this.m_file + "' is missing or contains an invalid ziplist file: " + this.getZipListPath(), e);
            }
            try {
                zipFile = this.getZipFile();
            }
            catch (Exception e) {
                log.error("Versioned plugin file '" + this.m_file + "' cannot be read or is corrupt because of this error: " + e.getLocalizedMessage());
                throw new InvalidPluginException("Versioned plugin file '" + this.m_file + "' cannot be read or is corrupt!", e);
            }
            if (zipMeta != null && zipFile != null && (contents = zipMeta.getContents()) != null) {
                List<EntryType> entries = contents.getEntry();
                if (entries != null && entries.size() > 0) {
                    for (EntryType entry : entries) {
                        if (!entry.getType().equalsIgnoreCase("file")) continue;
                        String entryName = entry.getName();
                        ZipEntry zipEntry = zipFile.getEntry(entryName);
                        if (zipEntry == null) {
                            String msg = "Versioned plugin file '" + this.m_file + "' is missing the following entry: " + entryName;
                            log.error(msg);
                            throw new InvalidPluginException(msg);
                        }
                        if (zipEntry.getSize() != entry.getSize().longValue()) {
                            log.error("Versioned plugin file '" + this.m_file + "' contains ZipEntry size " + zipEntry.getSize() + " which does not match the VJR XML file entry size" + entry.getSize() + " for " + entryName);
                            throw new InvalidPluginException("Versioned plugin file '" + this.m_file + "' contains mismatch in file size for the following entry: " + entryName);
                        }
                        String md5sum = entry.getMd5();
                        if (md5sum == null || md5sum.length() <= 0) continue;
                        try {
                            String calculatedMd5 = Utils.getMd5sum(zipFile.getInputStream(zipEntry));
                            if (md5sum.equalsIgnoreCase(calculatedMd5)) continue;
                            log.error("Versioned plugin file '" + this.m_file + "' contains ZipEntry md5sum " + calculatedMd5 + " which does not match the VJR XML file entry size" + md5sum + " for " + entryName);
                            throw new InvalidPluginException("Versioned plugin file '" + this.m_file + "' contains mismatch in md5sum for the following entry: " + entryName);
                        }
                        catch (Exception e) {
                            log.error("Versioned plugin file '" + this.m_file + "' has an entry '" + entryName + "' which could not be read because of this error: " + e.getLocalizedMessage());
                            throw new InvalidPluginException("Versioned plugin file '" + this.m_file + "' contains mismatch in md5sum for the following entry: " + entryName);
                        }
                    }
                } else {
                    log.warn("Versioned plugin file '" + this.m_file + "' contains an empty ziplist file indicating that there is no Zip content!");
                }
            }
        }
        finally {
            try {
                this.closeZipFile();
            }
            catch (IOException iOException) {}
        }
        log.debug("Verified that " + this.m_file + " is valid.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Zip getZipMetadata() throws IOException, JAXBException {
        if (this.m_zipMetadata != null) return this.m_zipMetadata;
        if (this.exists()) {
            InputStream is = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int length;
                ZipFile zipFile = this.getZipFile();
                ZipEntry zipEntry = zipFile.getEntry(this.getZipListPath());
                byte[] buffer = new byte[1024];
                is = zipFile.getInputStream(zipEntry);
                while ((length = is.read(buffer)) > 0) {
                    baos.write(buffer, 0, length);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (baos != null) {
                    baos.close();
                }
                this.closeZipFile();
            }
            if (baos.size() <= 0) throw new IOException("Could not read JAXB Zip file (ziplist) from " + this.m_file);
            this.m_zipMetadata = SchemaUtils.unmarshal(new ByteArrayInputStream(baos.toByteArray()), Zip.class);
            log.debug("Successfuly read JAXB Zip file (ziplist) from " + this.m_file);
            return this.m_zipMetadata;
        }
        this.m_zipMetadata = zipFactory.createZip();
        log.debug("VJRPluginZip '" + this.m_file + " does not exist thus creating an empty JAXB Zip object.");
        return this.m_zipMetadata;
    }

    public void addZipMetadataEntry(EntryType entry) {
        if (this.m_zipMetadata != null) {
            ContentsType contents = this.m_zipMetadata.getContents();
            if (contents == null) {
                contents = zipFactory.createContentsType();
                this.m_zipMetadata.setContents(contents);
            }
            contents.getEntry().add(entry);
        }
    }

    public ZipFile getZipFile() throws IOException {
        if (this.m_zipFile == null || this.m_closedZipFile) {
            this.m_zipFile = new ZipFile(this.m_file);
            this.m_closedZipFile = false;
        }
        return this.m_zipFile;
    }

    public long getSize() {
        return this.getFile().length();
    }

    public void closeZipFile() throws IOException {
        if (this.m_zipFile != null) {
            this.m_zipFile.close();
        }
        this.m_closedZipFile = true;
    }

    public ZipOutputStream getZipOutputStream() throws IOException {
        if (this.m_zipOutputStream == null || this.m_closedZipOutputStream) {
            this.m_zipOutputStream = new ZipOutputStream(new FileOutputStream(this.m_file));
            this.m_closedZipOutputStream = false;
        }
        return this.m_zipOutputStream;
    }

    public void closeZipOutputStream() throws IOException {
        if (this.m_zipOutputStream != null) {
            this.m_zipOutputStream.flush();
            this.m_zipOutputStream.close();
        }
        this.m_closedZipOutputStream = true;
    }

    public String getZipListPath() {
        return "eclipse/plugins/" + this.sasVersion + "/" + "META-INF/ziplist";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZipMetadata() throws IOException, JAXBException {
        ZipOutputStream out = this.getZipOutputStream();
        Zip zipMetadata = this.getZipMetadata();
        OutputStreamWriter fileWriter = null;
        try {
            if (zipMetadata != null) {
                ZipEntry zipEntry = new ZipEntry(this.getZipListPath());
                out.putNextEntry(new ZipEntry(zipEntry));
                fileWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                SchemaUtils.marshal(zipMetadata, Zip.class, new PrintWriter((Writer)fileWriter, true));
            }
        }
        finally {
            if (out != null) {
                out.closeEntry();
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZipEntry(ZipFile srcZipFile, ZipEntry zipEntry) throws IOException {
        ZipOutputStream out = this.getZipOutputStream();
        InputStream is = null;
        try {
            int length;
            out.putNextEntry(new ZipEntry(zipEntry));
            byte[] buffer = new byte[1024];
            is = srcZipFile.getInputStream(zipEntry);
            while ((length = is.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            if (out != null) {
                out.closeEntry();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    public void delete() {
        if (this.m_file.exists() && this.m_file.isFile()) {
            this.m_file.delete();
            log.info("Deleted versioned plugin file: " + this.m_file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createPluginFromSourceZipFile(ZipFile zipFile) throws IOException, JAXBException {
        ContentsType contents;
        log.debug("Creating a new VJR plugin zip file from source: " + zipFile.getName());
        boolean success = false;
        Zip zipMetadata = this.getZipMetadata();
        if (zipFile != null && zipMetadata != null && (contents = zipMetadata.getContents()) != null) {
            try {
                List<EntryType> entries = contents.getEntry();
                for (EntryType entry : entries) {
                    if (!entry.getType().equalsIgnoreCase("file")) continue;
                    String entryName = entry.getName();
                    ZipEntry zipEntry = new ZipEntry(zipFile.getEntry(entryName));
                    zipEntry.setCompressedSize(-1L);
                    if (zipEntry == null) {
                        log.error("Cannot find expected zip entry '" + entryName + "' from " + zipFile.getName());
                        continue;
                    }
                    if (zipEntry.getSize() != entry.getSize().longValue() && Globals.g_debug) {
                        log.debug("The ZipEntry size " + zipEntry.getSize() + " does not match the VJR XML file entry size" + entry.getSize() + " for " + entryName);
                    }
                    this.writeZipEntry(zipFile, zipEntry);
                }
                this.writeZipMetadata();
                success = true;
            }
            finally {
                this.closeZipOutputStream();
                if (success) {
                    log.debug("Successfully extracted zip content into: " + this.m_file);
                } else {
                    this.delete();
                    log.debug("Error extracting zip content thus deleting corrupt file: " + this.m_file);
                }
            }
        }
        return success;
    }
}

