/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.vjr;

import com.sas.tools.installs.it.vjr.InvalidPluginException;
import com.sas.tools.installs.it.vjr.InvalidSASVersionException;
import com.sas.tools.installs.it.vjr.SASVersion;
import com.sas.tools.installs.it.vjr.VJRConstants;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class VJRPlugin
implements Comparable<VJRPlugin>,
VJRConstants {
    protected static Logger log = (Logger)LogManager.getLogger(VJRPlugin.class.getName());
    protected SASVersion sasVersion = null;
    protected File m_file = null;

    protected VJRPlugin() {
    }

    public VJRPlugin(File file) throws InvalidPluginException {
        this.setFile(file);
        this.setSASVersion(this.getVersionedNameFromFile(file));
    }

    protected String getVersionedNameFromFile(File file) throws InvalidPluginException {
        String versionedName = file.getName();
        if (!file.exists()) {
            throw new InvalidPluginException("VJRPlugin file does not exist!");
        }
        if (file.isFile()) {
            String jarName = file.getName();
            if (!jarName.endsWith(".jar")) {
                throw new InvalidPluginException("VJRPlugin file does not end with a .jar extension!");
            }
            versionedName = jarName.substring(0, jarName.length() - 4);
        }
        return versionedName;
    }

    protected void setSASVersion(SASVersion sasVersion) {
        if (sasVersion == null) {
            throw new NullPointerException("VJRPlugin version cannot be null!");
        }
        this.sasVersion = sasVersion;
    }

    protected void setSASVersion(String versionedName) throws InvalidSASVersionException {
        if (versionedName == null) {
            throw new NullPointerException("VJRPlugin version cannot be null!");
        }
        this.sasVersion = new SASVersion(versionedName);
    }

    public boolean isDirectory() {
        return this.m_file.isDirectory();
    }

    public String getName() {
        return this.sasVersion.getPluginName();
    }

    public SASVersion getSASVersion() {
        return this.sasVersion;
    }

    public String getVersion() {
        return this.sasVersion.getVersion();
    }

    protected void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("VJRPlugin cannot set a null File!");
        }
        this.m_file = file;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean exists() {
        boolean ret = this.m_file.exists();
        if (!ret) {
            log.debug("VJRPluginZip '" + this.m_file + "' does not exist!");
        }
        return ret;
    }

    public boolean equals(Object obj) {
        VJRPlugin anotherVJRPlugin;
        boolean ret = false;
        if (obj instanceof VJRPlugin && this.compareTo(anotherVJRPlugin = (VJRPlugin)obj) == 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public int compareTo(VJRPlugin o) {
        int ret = -1;
        if (o != null && ret == 0) {
            ret = this.sasVersion.compareTo(o.getSASVersion());
        }
        return ret;
    }

    public String toString() {
        return this.sasVersion.toString();
    }
}

