/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.vjr;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.it.schema.install.gen.Extract;
import com.sas.tools.installs.it.schema.install.gen.ExtractVJRContent;
import com.sas.tools.installs.it.schema.install.gen.InstallType;
import com.sas.tools.installs.it.schema.install.gen.Project;
import com.sas.tools.installs.it.schema.install.gen.Target;
import com.sas.tools.installs.it.schema.metadata.gen.ContentsType;
import com.sas.tools.installs.it.schema.metadata.gen.EntryType;
import com.sas.tools.installs.it.schema.metadata.gen.Zip;
import com.sas.tools.installs.it.tasks.Globals;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.it.vjr.FileListData;
import com.sas.tools.installs.it.vjr.InvalidPluginException;
import com.sas.tools.installs.it.vjr.InvalidSASVersionException;
import com.sas.tools.installs.it.vjr.PluginNotFoundException;
import com.sas.tools.installs.it.vjr.SASVersion;
import com.sas.tools.installs.it.vjr.VJRConstants;
import com.sas.tools.installs.it.vjr.VJREvent;
import com.sas.tools.installs.it.vjr.VJREventHandler;
import com.sas.tools.installs.it.vjr.VJRException;
import com.sas.tools.installs.it.vjr.VJRExtractTask;
import com.sas.tools.installs.it.vjr.VJRList;
import com.sas.tools.installs.it.vjr.VJRPlugin;
import com.sas.tools.installs.it.vjr.VJRPluginZip;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class VJRManager
implements VJRConstants {
    public static SSNResource s_bundle = new SSNResource(VJRManager.class);
    public static Logger log = (Logger)LogManager.getLogger(VJRManager.class.getName());
    private static Object singletonLock = new Object();
    private static VJRManager singleton = null;
    protected String m_sasHome = null;
    protected String m_depotHome = null;
    protected String m_vjrHome = null;
    protected String m_vjrPluginsHome = null;
    protected String m_vjrDepotSrc = null;
    protected long m_totalCompression = 0L;
    protected Map<SASVersion, VJRPluginZip> m_depotPluginZips = new ConcurrentHashMap<SASVersion, VJRPluginZip>();
    protected Map<SASVersion, VJRPlugin> m_vjrhomePlugins = new ConcurrentHashMap<SASVersion, VJRPlugin>();
    protected Map<SASVersion, VJRExtractTask> m_queuedVJRExtractTasksMap = new ConcurrentHashMap<SASVersion, VJRExtractTask>();
    protected Map<SASVersion, VJRPluginZip> m_queuedVJRPluginZipForDepotCreation = new ConcurrentHashMap<SASVersion, VJRPluginZip>();
    protected VJREventHandler m_eventHandler = null;
    protected Set<File> m_vjrlistFiles = new HashSet<File>();
    protected Set<SASVersion> m_orphanedDepotPluginZips = new HashSet<SASVersion>();
    protected static Appender appender = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VJRManager getInstance() {
        Object object = singletonLock;
        synchronized (object) {
            if (singleton == null) {
                singleton = new VJRManager();
            }
        }
        return singleton;
    }

    public String getDepotHome() {
        return this.m_depotHome;
    }

    public String getSASHome() {
        return this.m_sasHome;
    }

    public String getVjrHome() {
        return this.m_vjrHome;
    }

    public String getVjrPluginsHome() {
        return this.m_vjrPluginsHome;
    }

    public String getVjrDepotSrc() {
        return this.m_vjrDepotSrc;
    }

    public void clearVJRExtractTasksQueue() {
        this.m_queuedVJRExtractTasksMap.clear();
    }

    public void loadSasHome(String sasHome) throws VJRException {
        if (sasHome != null && !sasHome.equalsIgnoreCase(this.m_sasHome)) {
            log.debug("Loading SASHome: " + sasHome);
            this.m_sasHome = sasHome;
            this.m_vjrHome = Utils.joinPath(this.m_sasHome, "SASVersionedJarRepository");
            this.m_vjrPluginsHome = Utils.joinPath(this.m_vjrHome, "eclipse/plugins");
            File pluginsHomeDir = new File(this.m_vjrPluginsHome);
            this.m_vjrhomePlugins.clear();
            this.m_queuedVJRExtractTasksMap.clear();
            if (pluginsHomeDir.isDirectory()) {
                log.debug("Loading VJRHome: " + pluginsHomeDir);
                File[] pluginFiles = pluginsHomeDir.listFiles();
                for (int i = 0; i < pluginFiles.length; ++i) {
                    File pluginFile = pluginFiles[i];
                    try {
                        VJRPlugin vjrPlugin = new VJRPlugin(pluginFile);
                        SASVersion sasVersion = vjrPlugin.getSASVersion();
                        if (vjrPlugin.isDirectory() && !sasVersion.isStandardVersion()) {
                            log.debug("Skipping non-standard versioned plugin directory: " + pluginFile);
                            continue;
                        }
                        log.debug("Found versioned plugin directory: " + pluginFile);
                        this.m_vjrhomePlugins.put(sasVersion, vjrPlugin);
                        continue;
                    }
                    catch (InvalidPluginException ipe) {
                        log.debug("Skipping invalid versioned plugin: " + pluginFile);
                    }
                }
            }
        }
    }

    private boolean hasDepotBeenOptimized(File depotHome) throws VJRException {
        boolean result = false;
        try {
            File[] fileArray = new File(depotHome, "product_data").listFiles(new FileFilter(){

                @Override
                public boolean accept(File fileName) {
                    return fileName.isDirectory();
                }
            });
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = 0;
                File product = fileArray[i];
                File[] fileArray2 = product.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File fileName) {
                        return "vjrlist".equals(fileName.getName());
                    }
                });
                int n3 = fileArray2.length;
                if (n2 >= n3) continue;
                File vjrlistFiles = fileArray2[n2];
                result = true;
                break;
            }
        }
        catch (Exception e) {
            log.error("Error while looking for vjrlist files: " + e.getMessage());
            throw new VJRException("Error while looking for vjrlist files: " + e.getMessage());
        }
        return result;
    }

    public void loadDepot(String depotHome) throws VJRException {
        try {
            if (depotHome != null && !depotHome.equalsIgnoreCase(this.m_depotHome)) {
                log.debug("Loading depot: " + depotHome);
                File depotDirFile = new File(depotHome);
                if (!depotDirFile.isDirectory()) {
                    throw new VJRException("The depot directory '" + depotHome + "'does not exist!");
                }
                this.m_depotHome = depotHome;
                this.m_vjrDepotSrc = Utils.joinPath(this.m_depotHome, "vjr");
                File vjrDepotSrcDir = new File(this.m_vjrDepotSrc);
                this.m_depotPluginZips.clear();
                this.m_queuedVJRExtractTasksMap.clear();
                if (vjrDepotSrcDir.isDirectory()) {
                    File[] pluginFiles = vjrDepotSrcDir.listFiles();
                    for (int i = 0; i < pluginFiles.length; ++i) {
                        File pluginFile = pluginFiles[i];
                        try {
                            String fileName = pluginFile.getName();
                            if (!fileName.endsWith(".zip")) continue;
                            VJRPluginZip vjrPlugin = new VJRPluginZip(pluginFile);
                            this.m_depotPluginZips.put(vjrPlugin.getSASVersion(), vjrPlugin);
                            log.debug("Found versioned plugin zip file: " + pluginFile);
                            continue;
                        }
                        catch (InvalidPluginException ipe) {
                            log.debug("Skipping invalid versioned plugin: " + pluginFile);
                        }
                    }
                } else if (this.hasDepotBeenOptimized(depotDirFile)) {
                    log.fatal("VJR directory missing or corrupted: " + this.m_vjrDepotSrc);
                    throw new VJRException("VJR directory is missing or corrupted: " + this.m_vjrDepotSrc);
                }
            }
        }
        catch (VJRException e) {
            log.fatal("Caught exception during loadDepot()", (Throwable)e);
            throw e;
        }
    }

    public boolean isDepotCompressed() {
        boolean ret = false;
        if (this.m_depotHome == null) {
            log.warn("No depot has been loaded to check if depot has been compressed!");
        } else {
            ret = this.m_depotPluginZips.size() > 0;
        }
        return ret;
    }

    public void notifyCompletedExtractTask(VJRExtractTask extractTask) throws VJRException {
        if (extractTask != null) {
            SASVersion sasVersion = extractTask.getSASVersion();
            this.m_queuedVJRExtractTasksMap.remove(sasVersion);
            log.debug("VJRExctract task completed and adding new versioned plugin: " + sasVersion.getPluginName() + "_" + sasVersion.getVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VJRExtractTask> queueExtractTasksForVjrList(String depotHome, String sasHome, VJRList vjrlist) throws VJRException {
        ArrayList<VJRExtractTask> ret = new ArrayList<VJRExtractTask>();
        Map<SASVersion, VJRExtractTask> map = this.m_queuedVJRExtractTasksMap;
        synchronized (map) {
            if (this.m_depotHome == null || !this.m_depotHome.equalsIgnoreCase(depotHome)) {
                this.loadDepot(depotHome);
            }
            if (this.m_sasHome == null || !this.m_sasHome.equalsIgnoreCase(sasHome)) {
                this.loadSasHome(sasHome);
            }
            Set<SASVersion> pluginSet = vjrlist.getPluginSet();
            for (SASVersion sasVersion : pluginSet) {
                VJRPluginZip pluginZip = this.m_depotPluginZips.get(sasVersion);
                if (pluginZip == null) {
                    throw new PluginNotFoundException("Cannot find dependent plugin: " + sasVersion);
                }
                if (this.m_queuedVJRExtractTasksMap.containsKey(sasVersion) || this.m_vjrhomePlugins.containsKey(sasVersion)) continue;
                VJRExtractTask extractTask = new VJRExtractTask(this.m_vjrHome, pluginZip);
                extractTask.setController(Controller.defaultController());
                this.m_queuedVJRExtractTasksMap.put(sasVersion, extractTask);
                ret.add(extractTask);
                log.debug("Queued VJRExtractTask for: " + sasVersion);
            }
        }
        return ret;
    }

    public void queueVJRPluginZipsForDepotCreation(File vjrListFile) throws VJRException {
        if (vjrListFile != null && vjrListFile.isFile()) {
            try {
                VJRList vjrList = VJRList.read(vjrListFile);
                for (SASVersion sasVersion : vjrList.getPluginSet()) {
                    VJRPluginZip pluginZip = this.m_depotPluginZips.get(sasVersion);
                    if (pluginZip == null) {
                        throw new PluginNotFoundException("The file '" + vjrListFile + "' has a dependent plugin that does not exist: " + sasVersion);
                    }
                    this.m_queuedVJRPluginZipForDepotCreation.put(pluginZip.getSASVersion(), pluginZip);
                }
            }
            catch (IOException ioe) {
                throw new VJRException("Unable to read file: " + vjrListFile, ioe);
            }
        }
    }

    public Collection<VJRPluginZip> getQueuedVJRPluginZipsForDepotCreation() {
        return this.m_queuedVJRPluginZipForDepotCreation.values();
    }

    public void clearQueueVJRPluginZipsForDepotCreation() {
        this.m_queuedVJRPluginZipForDepotCreation.clear();
    }

    public void copySourceVJRPluginZip(VJRPluginZip sourcePluginZip) throws VJRException {
        if (sourcePluginZip != null) {
            File vjrDepotSrcDir;
            if (this.m_vjrDepotSrc == null) {
                this.m_vjrDepotSrc = Utils.joinPath(this.m_depotHome, "vjr");
            }
            if (!(vjrDepotSrcDir = new File(this.m_vjrDepotSrc)).exists()) {
                vjrDepotSrcDir.mkdirs();
                log.debug("Created directory: " + vjrDepotSrcDir);
            }
            VJRPluginZip targetPluginZip = new VJRPluginZip(this.m_vjrDepotSrc, sourcePluginZip.getSASVersion());
            File targetFile = targetPluginZip.getFile();
            File sourceFile = sourcePluginZip.getFile();
            if (this.m_depotPluginZips.containsKey(targetPluginZip.getSASVersion())) {
                log.debug("The versioned plugin already exists: " + targetFile);
            } else {
                try {
                    byte[] buffer = new byte[262144];
                    Utils.copyFile(sourceFile, targetFile, buffer);
                }
                catch (IOException ioe) {
                    targetFile.delete();
                    throw new VJRException("Cannot copy file from '" + sourceFile + "' to '" + targetFile + "'");
                }
                try {
                    TaskHelper.FileMode file = new TaskHelper.FileMode(targetFile);
                    file.setPerm(493);
                    file.commit();
                }
                catch (IOException e) {
                    log.error("Error Setting Permissions: " + targetFile, (Throwable)e);
                    throw new VJRException("Error Setting Permissions: " + targetFile);
                }
                this.m_depotPluginZips.put(targetPluginZip.getSASVersion(), targetPluginZip);
            }
        }
    }

    protected File findVjrXmlFile(File altSkuProdDataDir) {
        File ret;
        block9: {
            ret = null;
            File installFile = new File(altSkuProdDataDir, "install.xml");
            try {
                log.debug("unmarshalling install.xml at " + installFile);
                Project project = SchemaUtils.unmarshal(installFile, Project.class);
                if (project == null) break block9;
                List<Target> targets = project.getTarget();
                for (Target target : targets) {
                    if (!target.getName().equalsIgnoreCase("install")) continue;
                    List<InstallType> tasks = target.getTasks();
                    for (InstallType installType : tasks) {
                        Extract extract;
                        String src;
                        if (!(installType instanceof Extract) || (src = (extract = (Extract)installType).getSource()) == null || !src.equalsIgnoreCase("vjr")) continue;
                        String vjrFileName = extract.getFilename();
                        if (vjrFileName != null) {
                            File vjrFile = new File(altSkuProdDataDir.getAbsolutePath(), vjrFileName);
                            if (vjrFile.exists() && vjrFile.isFile()) {
                                ret = vjrFile;
                            } else {
                                log.debug("The VJR XML file described by the install.xml does not exist: " + vjrFile);
                            }
                        }
                        break block9;
                    }
                    break;
                }
            }
            catch (JAXBException jaxbe) {
                jaxbe.printStackTrace();
            }
        }
        if (ret == null) {
            log.debug("No VJR file found in: " + altSkuProdDataDir);
        } else {
            log.debug("Found VJR XML file: " + ret);
        }
        return ret;
    }

    public int estimateDepotCompressionEvents() {
        if (this.m_depotHome == null) {
            log.error("No depot has been loaded for compression!");
            return 0;
        }
        File productsDir = new File(Utils.joinPath(this.m_depotHome, "products"));
        if (productsDir.exists() && productsDir.isDirectory()) {
            return productsDir.listFiles().length;
        }
        return 0;
    }

    public long getUsableSpaceForDepot() {
        if (this.m_depotHome == null) {
            log.error("No depot has been loaded for compression free disk space requirement estimatation!");
            return 0L;
        }
        File depotHomeDirFile = new File(this.m_depotHome);
        if (depotHomeDirFile.isDirectory()) {
            return depotHomeDirFile.getUsableSpace();
        }
        return 0L;
    }

    public long estimatedDiskRequirementForCompressingAltSku(FileListData fileList) {
        long ret = 0L;
        if (fileList != null) {
            log.debug("Estimating space requirements for compression: " + fileList.getFile());
            try {
                FileListData.DirList dirList = fileList.getSkuDatDirList();
                if (dirList != null) {
                    for (String filename : dirList.getSkuFileNames()) {
                        if (!filename.equalsIgnoreCase("install.xml") && !filename.equalsIgnoreCase("filelist.xml") && !filename.endsWith("_vjr.xml")) continue;
                        ret += Long.parseLong(dirList.getSkuFile(filename).getAttribute("size"));
                    }
                }
                if ((dirList = fileList.getSkuPkgDirList()) != null) {
                    for (String filename : dirList.getSkuFileNames()) {
                        if (!filename.endsWith("_vjr.zip")) continue;
                        ret += Long.parseLong(dirList.getSkuFile(filename).getAttribute("size"));
                    }
                }
                ret += 102400L;
            }
            catch (Throwable t) {
                log.warn("Could not load the following file to estimate disk requirements: " + fileList.getFile(), t);
                ret = 0x40000000L;
            }
        }
        return ret;
    }

    public void compressDepot() throws VJRException {
        VJREvent.EventType eventType = VJREvent.EventType.COMPRESSION;
        try {
            if (this.m_depotHome != null) {
                if (!Utils.canWriteToPath(this.m_depotHome)) {
                    throw new VJRException("User does not have write permission to the depot directory '" + this.m_depotHome + "'!");
                }
                this.m_vjrDepotSrc = Utils.joinPath(this.m_depotHome, "vjr");
                File vjrDepotSrcDir = new File(this.m_vjrDepotSrc);
                if (!vjrDepotSrcDir.exists()) {
                    vjrDepotSrcDir.mkdir();
                    log.debug("Created directory: " + vjrDepotSrcDir);
                }
                log.info("Compressing depot: " + this.m_depotHome);
                long start = System.currentTimeMillis();
                this.m_totalCompression = 0L;
                File productsDir = new File(Utils.joinPath(this.m_depotHome, "products"));
                if (productsDir.exists() && productsDir.isDirectory()) {
                    File[] altSkuDirs = productsDir.listFiles();
                    for (int i = 0; i < altSkuDirs.length; ++i) {
                        VJREventHandler.Action action;
                        File altSkuProdDir = altSkuDirs[i];
                        this.compressAltSku(altSkuProdDir);
                        if (this.m_eventHandler == null || (action = this.m_eventHandler.notify(new VJREvent(eventType, VJREvent.Status.SUCCESS, s_bundle.messageString("VJRManager.CompressionCompleted.txt", altSkuProdDir)))) != VJREventHandler.Action.ABORT) continue;
                        log.debug("Aborting depot compression from event handler response");
                        return;
                    }
                }
                if (this.m_eventHandler != null) {
                    this.m_eventHandler.notify(new VJREvent(eventType, VJREvent.Status.TERMINATE, s_bundle.messageString("VJRManager.EventTermination.txt")));
                }
                log.info("Completed compression in " + (System.currentTimeMillis() - start) / 1000L + "s and saved " + (int)(this.m_totalCompression / 0x100000L) + "MB");
            }
        }
        catch (VJRException e) {
            log.fatal("Caught exception during compressDepot()", (Throwable)e);
            throw e;
        }
    }

    public SASVersion findSASVersionFromVjrXmlEntry(EntryType entry) {
        String relativePathName;
        SASVersion sasVersion = null;
        if (entry != null && (relativePathName = entry.getName()) != null && relativePathName.startsWith("eclipse/plugins/")) {
            int iSlash = (relativePathName = relativePathName.substring("eclipse/plugins/".length()).trim()).indexOf("/");
            if (iSlash != -1) {
                relativePathName = relativePathName.substring(0, iSlash).trim();
            }
            if (relativePathName.equalsIgnoreCase("groovy_2.1.3")) {
                log.debug("Skipping eclipse plugin: " + relativePathName);
                return null;
            }
            boolean isLooseJar = false;
            if (relativePathName.endsWith(".jar")) {
                relativePathName = relativePathName.substring(0, relativePathName.length() - 4);
                log.debug("Loose jar (eclipse plugin): " + entry.getName() + " relativePathName: " + relativePathName);
                isLooseJar = true;
            }
            try {
                if (relativePathName.length() > 0) {
                    sasVersion = new SASVersion(relativePathName);
                    if (!isLooseJar && !sasVersion.isStandardVersion()) {
                        sasVersion = null;
                        log.debug("Found versioned plugin that is non-standard and is not a loose 3rd party jar: " + entry.getName());
                    }
                }
            }
            catch (InvalidSASVersionException isve) {
                log.debug("Keeping non-versioned or exempt versioned file: " + entry.getName());
            }
        }
        return sasVersion;
    }

    public File findZipFileFromXmlFile(File vjrXmlFile) throws FileNotFoundException {
        String fileName = vjrXmlFile.getName();
        if (fileName.endsWith(".xml")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        fileName = fileName + ".zip";
        String altsku = vjrXmlFile.getParentFile().getName();
        File file = new File(Utils.joinPath(this.m_depotHome, "products", altsku), fileName);
        return file;
    }

    public ZipFile openZipFileFromXmlFile(File vjrXmlFile) throws ZipException, IOException {
        File file = this.findZipFileFromXmlFile(vjrXmlFile);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("Could not find VJR zip file: " + file);
        }
        return new ZipFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compressVjrZipFile(File zipFile, List<EntryType> keepEntries) throws IOException {
        log.debug("Compressing the VJR Zip file: " + zipFile);
        boolean success = false;
        ArrayList<EntryType> keepFileEntries = new ArrayList<EntryType>();
        for (EntryType entry : keepEntries) {
            if (!entry.getType().equalsIgnoreCase("file")) continue;
            keepFileEntries.add(entry);
        }
        if (keepFileEntries.size() == 0) {
            zipFile.delete();
            success = true;
            log.debug("Not keeping any zip entries thus deleted this file: " + zipFile);
        } else {
            File tmpFile = new File(zipFile.getAbsolutePath() + "_new");
            if (tmpFile != null) {
                log.debug("Created temp file to output kept entries: " + tmpFile);
                ZipFile zipInput = null;
                ZipOutputStream zipOutput = null;
                try {
                    zipInput = new ZipFile(zipFile);
                    zipOutput = new ZipOutputStream(new FileOutputStream(tmpFile));
                    byte[] buffer = new byte[1024];
                    for (EntryType entry : keepFileEntries) {
                        ZipEntry zipEntry = zipInput.getEntry(entry.getName());
                        InputStream is = null;
                        try {
                            int length;
                            is = zipInput.getInputStream(zipEntry);
                            ZipEntry ze = new ZipEntry(zipEntry);
                            ze.setCompressedSize(-1L);
                            zipOutput.putNextEntry(ze);
                            while ((length = is.read(buffer)) > 0) {
                                zipOutput.write(buffer, 0, length);
                            }
                        }
                        finally {
                            if (zipOutput != null) {
                                zipOutput.closeEntry();
                            }
                            if (is != null) {
                                is.close();
                            }
                        }
                        log.debug("Wrote the following entry to the temporary zip file: " + entry.getName());
                    }
                    success = true;
                }
                finally {
                    if (zipInput != null) {
                        zipInput.close();
                    }
                    if (zipOutput != null) {
                        zipOutput.close();
                    }
                    if (success) {
                        File backupFile = new File(zipFile.getAbsolutePath() + "_orig");
                        try {
                            zipFile.renameTo(backupFile);
                            log.debug("Renamed zip file " + zipFile + "' to backup '" + backupFile + "'");
                            tmpFile.renameTo(zipFile);
                            log.debug("Renamed temp zip file " + tmpFile + "' to '" + zipFile + "'");
                            backupFile.delete();
                            log.debug("Deleted backup '" + backupFile + "'");
                        }
                        catch (Throwable t) {
                            if (!zipFile.isFile() && backupFile.isFile()) {
                                backupFile.renameTo(zipFile);
                            }
                            tmpFile.delete();
                        }
                    } else {
                        tmpFile.delete();
                        log.debug("Error occurred thus deleted the temp zip file: " + tmpFile);
                    }
                }
            }
        }
        return success;
    }

    public boolean findAndRemovePluginEntries(Zip zip, List<EntryType> allEntries, HashMap<SASVersion, VJRPluginZip> tmpPluginZipMap) throws JAXBException, IOException {
        boolean removedEntry = false;
        Iterator<EntryType> itEntries = allEntries.iterator();
        EntryType eclipseDirEntry = null;
        EntryType pluginsDirEntry = null;
        while (itEntries.hasNext()) {
            SASVersion sasVersion;
            EntryType entry = itEntries.next();
            String entryName = entry.getName();
            if (entryName.equalsIgnoreCase("eclipse")) {
                eclipseDirEntry = entry;
                continue;
            }
            if (entryName.equalsIgnoreCase("eclipse/plugins")) {
                pluginsDirEntry = entry;
                continue;
            }
            if (!entryName.startsWith("eclipse/plugins") || (sasVersion = this.findSASVersionFromVjrXmlEntry(entry)) == null) continue;
            itEntries.remove();
            removedEntry = true;
            VJRPluginZip existingPlugin = this.m_depotPluginZips.get(sasVersion);
            if (existingPlugin != null && !existingPlugin.isValid()) {
                this.m_depotPluginZips.remove(sasVersion);
                existingPlugin.delete();
                existingPlugin = null;
            }
            if (existingPlugin != null) {
                tmpPluginZipMap.put(existingPlugin.getSASVersion(), existingPlugin);
                log.debug("A matching plugin already exists thus no need to create a VJRPluginZip for: " + sasVersion);
                continue;
            }
            VJRPluginZip vjrPlugin = tmpPluginZipMap.get(sasVersion);
            Zip zipMetadata = null;
            if (vjrPlugin == null) {
                vjrPlugin = new VJRPluginZip(this.m_vjrDepotSrc, sasVersion);
                zipMetadata = vjrPlugin.getZipMetadata();
                zipMetadata.setDescription(zip.getDescription());
                zipMetadata.setName(zip.getName());
                if (eclipseDirEntry != null) {
                    vjrPlugin.addZipMetadataEntry(eclipseDirEntry);
                }
                if (pluginsDirEntry != null) {
                    vjrPlugin.addZipMetadataEntry(pluginsDirEntry);
                }
                tmpPluginZipMap.put(vjrPlugin.getSASVersion(), vjrPlugin);
                log.debug("Created a new VJRPluginZip '" + sasVersion + "' to populate with entry metadata");
            }
            vjrPlugin.addZipMetadataEntry(entry);
        }
        return removedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compressVjrXmlFile(File vjrXmlFile) throws JAXBException, IOException, InvalidSASVersionException {
        boolean done = false;
        if (vjrXmlFile != null) {
            HashMap<SASVersion, VJRPluginZip> tmpPluginZipMap;
            List<EntryType> allEntries;
            boolean removedEntry;
            log.debug("Determining whether we can compress content from: " + vjrXmlFile);
            Zip zip = SchemaUtils.unmarshal(vjrXmlFile, Zip.class);
            ContentsType contents = zip.getContents();
            if (contents != null && (removedEntry = this.findAndRemovePluginEntries(zip, allEntries = contents.getEntry(), tmpPluginZipMap = new HashMap<SASVersion, VJRPluginZip>()))) {
                log.debug("Found and removed at least one VJR plugin found in: " + vjrXmlFile);
                File zipFile = this.findZipFileFromXmlFile(vjrXmlFile);
                ZipFile zipSource = null;
                Collection<VJRPluginZip> removedPlugins = tmpPluginZipMap.values();
                if (removedPlugins.size() > 0) {
                    VJRList vjrList = null;
                    File vjrListFile = new File(vjrXmlFile.getParentFile(), "vjrlist");
                    try {
                        vjrList = VJRList.read(vjrListFile);
                        log.debug("Read from an existing vjrlist file: " + vjrListFile);
                    }
                    catch (FileNotFoundException fnfe) {
                        vjrList = new VJRList();
                        log.debug("Creating a new VJRList object");
                    }
                    try {
                        for (VJRPluginZip pluginZip : tmpPluginZipMap.values()) {
                            if (!pluginZip.exists()) {
                                if (zipSource == null) {
                                    zipSource = new ZipFile(zipFile);
                                }
                                pluginZip.createPluginFromSourceZipFile(zipSource);
                                this.m_totalCompression -= pluginZip.getFile().length();
                                this.m_depotPluginZips.put(pluginZip.getSASVersion(), pluginZip);
                            }
                            vjrList.addPluginVersion(pluginZip.getSASVersion());
                            log.debug("Added plugin dependency '" + pluginZip.getSASVersion() + "' to vjrlist.");
                        }
                    }
                    finally {
                        if (zipSource != null) {
                            zipSource.close();
                        }
                    }
                    if (vjrList.size() > 0) {
                        vjrList.write(vjrListFile);
                        log.debug("Wrote updates to vjrlist: " + vjrListFile);
                    }
                }
                long fileSizesBefore = zipFile.length() + vjrXmlFile.length();
                this.compressVjrZipFile(zipFile, allEntries);
                long fileSizesAfter = 0L;
                if (!zipFile.exists()) {
                    vjrXmlFile.delete();
                    log.debug("The VJR zip does not exist anymore thus delete: " + vjrXmlFile);
                } else {
                    SchemaUtils.marshal(zip, Zip.class, vjrXmlFile, SchemaUtils.WriteOption.NOT_IN_PLACE);
                    log.debug("Removed entries from the VJR XML metadata file because of compression: " + vjrXmlFile);
                    fileSizesAfter = zipFile.length() + vjrXmlFile.length();
                }
                this.m_totalCompression += fileSizesBefore - fileSizesAfter;
                done = true;
            }
        }
        return done;
    }

    public void removeVjrXmlFileFromFileList(File vjrXmlFile, FileListData fileList) throws FileNotFoundException {
        FileListData.DirList skuDataDirList = fileList.getSkuDatDirList();
        if (skuDataDirList != null) {
            skuDataDirList.removeSkuFileByName(vjrXmlFile.getName());
        }
        File vjrZipFile = this.findZipFileFromXmlFile(vjrXmlFile);
        FileListData.DirList skuPkgDirList = fileList.getSkuPkgDirList();
        if (skuPkgDirList != null) {
            skuPkgDirList.removeSkuFileByName(vjrZipFile.getName());
        }
    }

    public void updateVjrXmlFileInFileList(File vjrXmlFile, FileListData fileList) throws FileNotFoundException {
        FileListData.DirList skuDataDirList = fileList.getSkuDatDirList();
        if (skuDataDirList != null) {
            FileListData.DirList.SkuFile skuFile = skuDataDirList.getSkuFile(vjrXmlFile.getName());
            if (skuFile == null) {
                throw new FileNotFoundException("Could not find entry for '" + vjrXmlFile.getName() + "' in " + fileList.getFile());
            }
            skuFile.setAttribute("time", Long.toString(vjrXmlFile.lastModified()));
            skuFile.setAttribute("size", Long.toString(vjrXmlFile.length()));
            skuFile.setAttribute("checksum", Utils.getMd5sum(vjrXmlFile));
        }
        File vjrZipFile = this.findZipFileFromXmlFile(vjrXmlFile);
        FileListData.DirList skuPkgDirList = fileList.getSkuPkgDirList();
        if (skuPkgDirList != null) {
            FileListData.DirList.SkuFile skuFile = skuPkgDirList.getSkuFile(vjrZipFile.getName());
            if (skuFile == null) {
                throw new FileNotFoundException("Could not find entry for '" + vjrZipFile.getName() + "' in " + fileList.getFile());
            }
            skuFile.setAttribute("time", Long.toString(vjrZipFile.lastModified()));
            skuFile.setAttribute("size", Long.toString(vjrZipFile.length()));
            skuFile.setAttribute("checksum", Utils.getMd5sum(vjrZipFile));
        }
    }

    public void updateVjrListInFileList(File vjrListFile, FileListData fileList) {
        FileListData.DirList dirList;
        if (vjrListFile.isFile() && (dirList = fileList.getSkuDatDirList()) != null) {
            FileListData.DirList.SkuFile skuFile = dirList.getExistingOrCreateSkuFile("vjrlist");
            skuFile.setAttribute("time", Long.toString(vjrListFile.lastModified()));
            skuFile.setAttribute("size", Long.toString(vjrListFile.length()));
            skuFile.setAttribute("checksum", Utils.getMd5sum(vjrListFile));
        }
    }

    public String convertSizeToStringMB(long diskSize) {
        String ret = "0";
        if (diskSize > 0L) {
            ret = Long.toString(Math.max(1L, diskSize / 0x100000L));
        }
        return ret;
    }

    public boolean compressAltSku(File altSkuProdDir) throws VJRException {
        VJREvent.EventType eventType = VJREvent.EventType.COMPRESSION;
        boolean done = false;
        boolean filesModified = false;
        String altsku = altSkuProdDir.getName();
        File altSkuProdDataDir = new File(this.m_depotHome, Utils.joinPath("product_data", altsku));
        File installFile = new File(altSkuProdDataDir, "install.xml");
        File fileListFile = new File(altSkuProdDataDir, "filelist.xml");
        File vjrListFile = new File(altSkuProdDataDir, "vjrlist");
        Project project = null;
        FileListData fileList = null;
        boolean retry = true;
        while (retry) {
            retry = false;
            if (!installFile.exists()) continue;
            log.info("Compressing altsku: " + altsku);
            long compressSizeBefore = this.m_totalCompression;
            try {
                project = SchemaUtils.unmarshal(installFile, Project.class);
                fileList = new FileListData(fileListFile);
                long extraSpaceNeeded = this.estimatedDiskRequirementForCompressingAltSku(fileList) - this.getUsableSpaceForDepot();
                if (extraSpaceNeeded > 0L) {
                    retry = this.handleErrorEvent(eventType, s_bundle.messageString("VJRManager.InsufficientDiskSpaceForCompression.txt", this.convertSizeToStringMB(extraSpaceNeeded), altSkuProdDataDir));
                    continue;
                }
                List<Target> targets = project.getTarget();
                for (Target target : targets) {
                    if (!target.getName().equalsIgnoreCase("install")) continue;
                    log.debug("Found an install target for: " + installFile);
                    List<InstallType> tasks = target.getTasks();
                    Iterator<InstallType> itTasks = tasks.iterator();
                    boolean extractVJRContentTaskFound = false;
                    while (itTasks.hasNext()) {
                        InstallType installType = itTasks.next();
                        if (installType instanceof Extract) {
                            String vjrFileName;
                            Extract extract = (Extract)installType;
                            String src = extract.getSource();
                            if (src == null || !src.equalsIgnoreCase("vjr") || (vjrFileName = extract.getFilename()) == null) continue;
                            File vjrXmlFile = new File(altSkuProdDataDir.getAbsolutePath(), vjrFileName);
                            if (vjrXmlFile.exists() && vjrXmlFile.isFile()) {
                                done = this.compressVjrXmlFile(vjrXmlFile);
                                if (!vjrXmlFile.exists()) {
                                    itTasks.remove();
                                    this.removeVjrXmlFileFromFileList(vjrXmlFile, fileList);
                                } else {
                                    this.updateVjrXmlFileInFileList(vjrXmlFile, fileList);
                                }
                            } else {
                                log.debug("The VJR XML file described by the install.xml does not exist: " + vjrXmlFile);
                                itTasks.remove();
                                this.removeVjrXmlFileFromFileList(vjrXmlFile, fileList);
                            }
                            filesModified = true;
                            continue;
                        }
                        if (!(installType instanceof ExtractVJRContent)) continue;
                        extractVJRContentTaskFound = true;
                    }
                    if (!vjrListFile.isFile()) break;
                    if (!extractVJRContentTaskFound) {
                        ExtractVJRContent extractVJRContentTask = new ExtractVJRContent();
                        tasks.add(extractVJRContentTask);
                    }
                    this.updateVjrListInFileList(vjrListFile, fileList);
                    filesModified = true;
                    break;
                }
                if (!filesModified) continue;
                SchemaUtils.marshal(project, Project.class, installFile, SchemaUtils.WriteOption.NOT_IN_PLACE);
                log.debug("Updated entries in the install.xml because of compression: " + installFile);
                fileList.write();
                log.debug("Updated the filelist.xml: " + fileListFile);
                log.info("  ...compressed by " + (int)((this.m_totalCompression - compressSizeBefore) / 0x100000L) + "MB");
            }
            catch (Throwable t) {
                retry = this.handleErrorEvent(t, eventType);
            }
        }
        return done;
    }

    protected boolean handleErrorEvent(VJREvent.EventType eventType, String msg) throws VJRException {
        return this.handleErrorEvent(null, eventType, msg);
    }

    protected boolean handleErrorEvent(Throwable t, VJREvent.EventType eventType) throws VJRException {
        return this.handleErrorEvent(t, eventType, s_bundle.getString("VJRManager.UnexpectedError.txt"));
    }

    protected boolean handleErrorEvent(Throwable t, VJREvent.EventType eventType, String msg) throws VJRException {
        if (t != null) {
            log.error("Caught an exception", t);
        }
        boolean retry = false;
        boolean doThrowError = true;
        if (this.m_eventHandler != null) {
            switch (this.m_eventHandler.notify(new VJREvent(eventType, VJREvent.Status.ERROR, msg, t))) {
                case RETRY: {
                    doThrowError = false;
                    retry = true;
                    break;
                }
                case CONTINUE: {
                    doThrowError = false;
                    retry = false;
                }
                case ABORT: {
                    doThrowError = true;
                }
            }
        }
        if (doThrowError) {
            if (t == null) {
                throw new VJRException(msg);
            }
            if (t instanceof VJRException) {
                throw (VJRException)t;
            }
            throw new VJRException(t);
        }
        return retry;
    }

    private int loadApplicableVJRListForDepot() {
        if (this.m_depotHome == null) {
            log.error("No depot has been loaded!");
            return 0;
        }
        if (this.m_vjrlistFiles.size() == 0) {
            File productsDir = new File(Utils.joinPath(this.m_depotHome, "products"));
            File productDataDir = new File(this.m_depotHome, "product_data");
            if (productsDir.exists() && productsDir.isDirectory()) {
                File[] altSkuDirs = productsDir.listFiles();
                for (int i = 0; i < altSkuDirs.length; ++i) {
                    String altsku = altSkuDirs[i].getName();
                    File vjrlistFile = new File(productDataDir, Utils.joinPath(altsku, "vjrlist"));
                    if (!vjrlistFile.isFile()) continue;
                    this.m_vjrlistFiles.add(vjrlistFile);
                }
            }
        }
        return this.m_vjrlistFiles.size();
    }

    public int estimateDepotEvents(VJREvent.EventType vjrEventType) {
        int ret = 0;
        if (this.m_depotHome != null) {
            switch (vjrEventType) {
                case VALIDATION: {
                    ret = this.loadApplicableVJRListForDepot() + this.m_depotPluginZips.size();
                    break;
                }
                case PRUNING: {
                    ret = this.findPluginZipsToPruneInDepot();
                    break;
                }
                case COMPRESSION: {
                    File productsDir = new File(Utils.joinPath(this.m_depotHome, "products"));
                    if (!productsDir.exists() || !productsDir.isDirectory()) break;
                    ret = productsDir.listFiles().length;
                }
            }
        }
        return ret;
    }

    private int findPluginZipsToPruneInDepot() {
        if (this.m_depotHome == null) {
            log.error("No depot has been loaded for pruning!");
            return 0;
        }
        this.loadApplicableVJRListForDepot();
        try {
            this.m_orphanedDepotPluginZips.addAll(this.m_depotPluginZips.keySet());
            for (File vjrlistFile : this.m_vjrlistFiles) {
                if (this.m_orphanedDepotPluginZips.size() != 0) {
                    log.debug("Finding versioned plugins to keep based on vjrlist: " + vjrlistFile);
                    VJRList vjrlist = VJRList.read(vjrlistFile);
                    for (SASVersion pluginVersion : vjrlist.getPluginSet()) {
                        if (!this.m_depotPluginZips.containsKey(pluginVersion)) {
                            String msg = "The depot is missing a versioned plugin for " + pluginVersion;
                            log.error(msg);
                            throw new InvalidPluginException(msg);
                        }
                        this.m_orphanedDepotPluginZips.remove(pluginVersion);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            log.error("An error occurred determining the set of versioned plugins to prune!", t);
            this.m_orphanedDepotPluginZips.clear();
        }
        return this.m_orphanedDepotPluginZips.size();
    }

    public long pruneDepot() throws VJRException {
        long ret = 0L;
        VJREvent.EventType eventType = VJREvent.EventType.PRUNING;
        if (this.m_depotHome == null) {
            throw new VJRException("No depot has been loaded for pruning!");
        }
        this.estimateDepotEvents(VJREvent.EventType.PRUNING);
        for (SASVersion sasVersion : this.m_orphanedDepotPluginZips) {
            VJREventHandler.Action action;
            log.info("Pruning non-required versioned plugin: " + sasVersion);
            boolean retry = true;
            while (retry) {
                retry = false;
                try {
                    VJRPluginZip pluginZip = this.m_depotPluginZips.get(sasVersion);
                    if (pluginZip == null) continue;
                    long size = pluginZip.getSize();
                    pluginZip.delete();
                    ret += size;
                }
                catch (Throwable t) {
                    retry = this.handleErrorEvent(t, eventType);
                }
            }
            if (this.m_eventHandler == null || (action = this.m_eventHandler.notify(new VJREvent(eventType, VJREvent.Status.SUCCESS, s_bundle.messageString("VJRManager.PruningCompleted.txt", sasVersion)))) != VJREventHandler.Action.ABORT) continue;
            return ret;
        }
        return ret;
    }

    public void validateDepot() throws VJRException {
        VJREventHandler.Action action;
        boolean retry;
        VJREvent.EventType eventType = VJREvent.EventType.VALIDATION;
        long start = System.currentTimeMillis();
        if (this.m_depotHome == null) {
            throw new VJRException("No depot has been loaded for validation!");
        }
        this.estimateDepotEvents(eventType);
        for (VJRPluginZip plugin : this.m_depotPluginZips.values()) {
            log.info("Checking package: " + plugin.getFile());
            retry = true;
            while (retry) {
                retry = false;
                try {
                    plugin.validate();
                }
                catch (Throwable t) {
                    retry = this.handleErrorEvent(t, eventType);
                }
            }
            if (this.m_eventHandler == null || (action = this.m_eventHandler.notify(new VJREvent(eventType, VJREvent.Status.SUCCESS, s_bundle.messageString("VJRManager.ValidationCompleted.txt", plugin.getFile())))) != VJREventHandler.Action.ABORT) continue;
            throw new VJRException("Scan Aborted.");
        }
        this.m_orphanedDepotPluginZips.addAll(this.m_depotPluginZips.keySet());
        for (File vjrlistFile : this.m_vjrlistFiles) {
            retry = true;
            while (retry) {
                retry = false;
                try {
                    VJRList vjrlist = VJRList.read(vjrlistFile);
                    log.info("Checking product data: " + vjrlistFile);
                    for (SASVersion pluginVersion : vjrlist.getPluginSet()) {
                        if (!this.m_depotPluginZips.containsKey(pluginVersion)) {
                            String msg = "The depot is missing a versioned plugin for " + pluginVersion;
                            log.error(msg);
                            throw new InvalidPluginException(msg);
                        }
                        log.debug("Verified that the dependency for " + pluginVersion + " exists.");
                        this.m_orphanedDepotPluginZips.remove(pluginVersion);
                    }
                    File installFile = new File(vjrlistFile.getParentFile(), "install.xml");
                    log.info("Checking product data: " + installFile);
                    boolean foundExtractVJRContentTask = false;
                    log.debug("unmarshalling install.xml at " + installFile);
                    Project project = SchemaUtils.unmarshal(installFile, Project.class);
                    List<Target> targets = project.getTarget();
                    for (Target target : targets) {
                        if (!target.getName().equalsIgnoreCase("install")) continue;
                        List<InstallType> tasks = target.getTasks();
                        for (InstallType installType : tasks) {
                            if (!(installType instanceof ExtractVJRContent)) continue;
                            foundExtractVJRContentTask = true;
                        }
                    }
                    if (!foundExtractVJRContentTask) {
                        throw new VJRException("The " + installFile + " is missing an <ExtractVJRContent> install rule. Please re-run the depot compression to repair this file.");
                    }
                    log.debug("Verified that " + installFile + " is valid.");
                    boolean foundVJRListEntry = false;
                    File fileListFile = new File(vjrlistFile.getParentFile(), "filelist.xml");
                    log.info("Checking product data: " + fileListFile);
                    FileListData fileList = new FileListData(fileListFile);
                    FileListData.DirList dirList = fileList.getSkuDatDirList();
                    if (dirList != null && dirList.getSkuFile("vjrlist") != null) {
                        foundVJRListEntry = true;
                    }
                    if (!foundVJRListEntry) {
                        throw new VJRException("The " + fileListFile + " is missing a file entry for " + "vjrlist" + ". Please re-run the depot compression to repair this file.");
                    }
                    log.debug("Verified that " + fileListFile + " is valid.");
                    if (!Globals.g_debug) continue;
                    for (SASVersion pluginVersion : this.m_orphanedDepotPluginZips) {
                        log.debug("The versioned plugin " + pluginVersion + " is no longer referenced by a product in the depot.");
                    }
                }
                catch (Throwable t) {
                    retry = this.handleErrorEvent(t, eventType);
                }
            }
            if (this.m_eventHandler == null || (action = this.m_eventHandler.notify(new VJREvent(eventType, VJREvent.Status.SUCCESS, s_bundle.messageString("VJRManager.ValidationCompleted.txt", vjrlistFile)))) != VJREventHandler.Action.ABORT) continue;
            return;
        }
        this.m_vjrlistFiles.clear();
        if (this.m_eventHandler != null) {
            this.m_eventHandler.notify(new VJREvent(eventType, VJREvent.Status.TERMINATE, s_bundle.messageString("VJRManager.EventTermination.txt")));
        }
        log.info("Completed validation in " + (System.currentTimeMillis() - start) / 1000L + "s");
    }

    public void setEventHandler(VJREventHandler eventHandler) {
        this.m_eventHandler = eventHandler;
    }

    public static void setVJRLogLevel(Level level) {
        VJRManager.setVJRLogLevel(level, null);
    }

    public static void setVJRLogLevel(Level level, String filePath) {
        if (appender == null) {
            String PATTERN = "%d [%p|%C{1}] %m%n";
            PatternLayout layout = PatternLayout.newBuilder().withPattern(PATTERN).build();
            if (filePath != null) {
                appender = ((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setName("appender")).withFileName(filePath)).setLayout(layout)).build();
            }
            if (appender == null) {
                appender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((AbstractAppender.Builder)ConsoleAppender.newBuilder()).setName("appender")).setLayout(layout)).build();
            }
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.addAppender(appender, null, null);
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    public static void main(String[] argv) {
        boolean doCompress = false;
        String depotDir = null;
        String errorMessage = argv.length == 0 ? "No arguments specified!" : null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equalsIgnoreCase("-compressVJR")) {
                doCompress = true;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-depotdir")) {
                if (argv.length > i + 1) {
                    depotDir = argv[++i];
                    continue;
                }
                errorMessage = "Missing the <depotdir> path for option -depotdir <depotdir>!";
                continue;
            }
            errorMessage = "Invalid option specified: " + argv[i];
            break;
        }
        if (errorMessage != null) {
            System.out.println(errorMessage);
            System.out.println("java com.sas.tools.installs.it.vjr.VJRManager [OPTIONS]");
            System.out.println("OPTIONS:");
            System.out.println(" -compressvjr  #Compresses the VJR in a depot. Must specify -depotdir.");
            System.out.println(" -depotdir <depotdir>  #Specify the depot root directory");
        }
        VJRManager.setVJRLogLevel(Level.ALL, null);
        VJRManager vjrManager = new VJRManager();
        try {
            vjrManager.loadDepot(depotDir);
            if (doCompress) {
                vjrManager.compressDepot();
            }
        }
        catch (VJRException vjre) {
            vjre.printStackTrace();
        }
    }
}

