/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.view;

import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.view.PrintableEditorPane;
import com.sas.tools.installs.it.view.SSNResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class KitHelp
extends JFrame {
    private static final long serialVersionUID = 8738268297532026185L;
    protected static SSNResource bundle = new SSNResource(KitHelp.class);
    private JFrame parent;
    private PrintableEditorPane helpPane;
    protected Logger log = (Logger)LogManager.getLogger(KitHelp.class);

    public KitHelp(JFrame parent) {
        this.parent = parent;
        this.helpPane = new PrintableEditorPane();
        this.helpPane.setContentType("text/html");
        this.helpPane.setEditable(false);
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 5, 0);
        this.getContentPane().add((Component)new toolBar(), c);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        this.getContentPane().add((Component)new JScrollPane(this.helpPane), c);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                KitHelp.this.dispose();
            }
        });
    }

    @Override
    public void show() {
        if (!this.isShowing() && this.parent != null) {
            this.setTitle(this.parent.getTitle());
            this.setIconImage(this.parent.getIconImage());
            this.setSize(this.parent.getSize());
            Point location = this.parent.getLocationOnScreen();
            int offset = (int)this.parent.getContentPane().getLocationOnScreen().getY() - this.parent.getY();
            location.translate(offset, offset);
            this.setLocation(location);
        }
        super.show();
    }

    public void setHelp(String id) {
        if (id != null) {
            File helpFile = new File(id);
            if (helpFile.isFile()) {
                try {
                    Document doc = this.helpPane.getDocument();
                    doc.putProperty("stream", null);
                    this.helpPane.setPage(Utils.pathToURL(id));
                }
                catch (Exception e) {
                    this.log.info("Error loading dynamic help file: " + id);
                }
            } else {
                int i = 0;
                String lang = System.getProperty("language");
                String page = "/doc/" + lang + "/it/html/" + id + ".html";
                URL url = null;
                block9: while (page != null) {
                    try {
                        url = this.getClass().getResource(page);
                        this.helpPane.setPage(url);
                        page = null;
                    }
                    catch (IOException e) {
                        switch (++i) {
                            case 1: {
                                page = "/doc/en/it/html/" + id + ".html";
                                continue block9;
                            }
                            case 2: {
                                page = "/doc/" + lang + "/it/html/Overview.html";
                                continue block9;
                            }
                            case 3: {
                                page = "/doc/en/it/html/Overview.html";
                                continue block9;
                            }
                        }
                        page = null;
                        this.log.info("Help Not Found: " + id);
                    }
                }
            }
        }
    }

    private class PrinterDialogThread
    extends Thread {
        private PrinterJob printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            PageFormat pageFormat = this.printerJob.defaultPage();
            this.printerJob.setPrintable(KitHelp.this.helpPane, pageFormat);
            this.printerJob.validatePage(pageFormat);
            if (this.printerJob.printDialog()) {
                try {
                    this.printerJob.setPrintable(KitHelp.this.helpPane, pageFormat);
                    this.printerJob.validatePage(pageFormat);
                    this.printerJob.print();
                }
                catch (Exception e) {
                    KitHelp.this.log.info(e.getMessage());
                }
            }
        }
    }

    private class toolBar
    extends JPanel {
        private JButton printButton;
        private JButton closeButton;
        private JLabel verlabel;
        private JTextField verinfo;

        public toolBar() {
            String text = bundle.getString("Common.Print.txt");
            this.printButton = new JButton(Util.getLabelWithoutMnemonic(text));
            this.printButton.setMnemonic(Util.getDisplayedMnemonic(text));
            text = bundle.getString("Common.close.txt");
            this.closeButton = new JButton(Util.getLabelWithoutMnemonic(text));
            this.closeButton.setMnemonic(Util.getDisplayedMnemonic(text));
            this.verinfo = new JTextField();
            this.verinfo.setText(Controller.defaultController().getToolVersion());
            this.verinfo.setEditable(false);
            text = bundle.getString("KitHelp.Version.txt");
            String txt = Util.getLabelWithoutMnemonic(text);
            this.verlabel = new JLabel(txt);
            this.verlabel.setLabelFor(this.verinfo);
            this.verlabel.setFocusable(false);
            this.verlabel.setFocusable(false);
            this.verlabel.setAlignmentX(1.0f);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 5);
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this.printButton, c);
            c.gridx = 1;
            c.gridy = 0;
            this.add((Component)this.closeButton, c);
            c.weightx = 1.0;
            c.anchor = 13;
            c.gridx = 2;
            c.gridy = 0;
            this.add((Component)this.verlabel, c);
            c.weightx = 0.0;
            c.gridx = 3;
            c.gridy = 0;
            this.add((Component)this.verinfo, c);
            this.printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    PrinterDialogThread printerThread = new PrinterDialogThread(printerJob);
                    printerThread.start();
                }
            });
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KitHelp.this.dispose();
                }
            });
        }
    }
}

