/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.schema.install.gen.SetEnvironment;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class SetEnvironmentTask
extends InstallationTask {
    private static WindowsRegistry winreg = new WindowsRegistry();
    private static final int HIVE = 8;
    private static final String KEY = "System\\CurrentControlSet\\Control\\Session Manager\\Environment";

    @Override
    public void execute() throws InstallException {
        if (this.isUndo()) {
            this.rollback();
        } else if (TaskHelper.isWindows()) {
            this.executeWindows(this.getName(), this.getValue());
        } else {
            int platform = TaskHelper.getOS();
            throw new InstallException(3, this, this.getBundle().messageString("InstallationTask.UnsupportedPlatform", platform), this.getEnBundle().messageString("InstallationTask.UnsupportedPlatform", platform), null);
        }
    }

    protected void executeWindows(String name, String value) {
        String newVal;
        String delimiter = this.getDelimiter();
        name = this.getEnvironmentName(name);
        String curVal = this.getEnvironmentValue(name);
        int curType = winreg.getValueType(8, KEY, name);
        if (curType == 107) {
            this.log.info("Environment variable " + name + " does not exist");
        } else {
            this.log.info("Environment variable " + name + " exists with value '" + curVal + "'");
        }
        if (!this.isUndo()) {
            this.log.info("Adding value " + value);
            if (delimiter != null) {
                newVal = this.addValue(curVal, value);
                this.log.info("Replacing current value with '" + newVal + "'");
                winreg.setValue(8, KEY, name, newVal, curType);
            } else {
                this.log.info("Setting new variable to '" + value + "'");
                winreg.setValue(8, KEY, name, value, 109);
            }
        } else {
            this.log.info("Removing value " + value);
            if (delimiter != null) {
                newVal = this.removeValue(curVal, value);
                this.log.info("Replacing current value with '" + newVal + "'");
                winreg.setValue(8, KEY, name, newVal, curType);
            } else if (curVal.equals(value)) {
                this.log.info("Deleting variable " + name);
                winreg.deleteValue(8, KEY, name);
            } else {
                this.log.warn("Variable has changed since installation, skipping deletion");
            }
        }
        boolean registered = SASWinAPI.registerEnvironmentChange();
        this.log.info("registerEnvironmentChange for environment variable " + name + " with value " + value + ": " + registered);
    }

    @Override
    public void rollback() throws InstallException {
        if (!TaskHelper.isWindows()) {
            int platform = TaskHelper.getOS();
            throw new InstallException(3, this, this.getBundle().messageString("InstallationTask.UnsupportedPlatform", platform), this.getEnBundle().messageString("InstallationTask.UnsupportedPlatform", platform), null);
        }
        this.executeWindows(this.getName(), this.getValue());
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public String descriptionForLog() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.getName());
        params.put("value", this.getValue());
        params.put("delimiter", this.getDelimiter());
        return TaskHelper.getDescriptionForLog("SetEnvironmentTask", params);
    }

    private String getEnvironmentName(String name) {
        for (String aName : winreg.getChildrenForKey(8, KEY)) {
            if (!aName.equalsIgnoreCase(name)) continue;
            name = aName;
        }
        return name;
    }

    private String removeValue(String curVal, String value) {
        String delimiter = this.getDelimiter();
        ArrayList<String> valueParts = new ArrayList<String>();
        for (String part : curVal.split(delimiter)) {
            if (!part.equals(value)) {
                valueParts.add(part);
                continue;
            }
            this.log.info("Found " + value + ", removing");
        }
        return TaskHelper.join(valueParts, delimiter);
    }

    private String addValue(String curVal, String value) {
        String delimiter = this.getDelimiter();
        ArrayList<String> valueParts = new ArrayList<String>();
        boolean found = false;
        for (String part : curVal.split(delimiter)) {
            if (part.equals(value)) {
                found = true;
                this.log.info("Found " + value + ", so won't add it");
            }
            valueParts.add(part);
        }
        if (!found) {
            valueParts.add(value);
            this.log.info("Didn't find " + value + ", adding");
        }
        return TaskHelper.join(valueParts, delimiter);
    }

    private String getEnvironmentValue(String name) {
        String value = winreg.getValue(8, KEY, name);
        return value != null ? value : "";
    }

    private String getName() {
        return ((SetEnvironment)this.getData()).getName();
    }

    private String getValue() {
        return Utils.fixPathSlashes(this.resolveProperty(((SetEnvironment)this.getData()).getValue()));
    }

    private String getDelimiter() {
        return ((SetEnvironment)this.getData()).getDelimiter();
    }
}

