/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.installs.it.AltskuProperties;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.schema.install.Copy;
import com.sas.tools.installs.it.schema.install.Delete;
import com.sas.tools.installs.it.schema.install.RunFileUtility;
import com.sas.tools.installs.it.schema.install.gen.ConstrainBy;
import com.sas.tools.installs.it.schema.install.gen.FileExistConstraint;
import com.sas.tools.installs.it.schema.install.gen.FileExistTest;
import com.sas.tools.installs.it.schema.install.gen.HostList;
import com.sas.tools.installs.it.schema.install.gen.InstallType;
import com.sas.tools.installs.it.schema.install.gen.PropertyMatchConstraint;
import com.sas.tools.installs.it.schema.install.gen.PropertyMatchTest;
import com.sas.tools.installs.it.schema.install.gen.Target;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.RunFileUtilityTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.SSNResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public abstract class InstallationTask {
    public static final String ROLLBACK = "rollbackAndFail";
    public static final String PROMPT = "prompt";
    public static final String ADDED_FILE = "Added";
    public static final String CHANGED_FILE = "Changed";
    public static final String REMOVED_FILE = "Removed";
    public static final String CHECKED_FILE = "Checked";
    public static final String BACKED_UP_FILE = "Backed up";
    public static final String METADATA_EVENT = "Metadata event";
    protected SSNResource _bundle = new SSNResource(this.getClass());
    protected SSNResource _enBundle = SSNResource.EnglishResource(this.getClass());
    protected Logger log = (Logger)LogManager.getLogger(this.getClass().getName());
    protected Logger fileLog = (Logger)LogManager.getLogger("FileLog");
    protected String _description = null;
    protected HashMap<String, String> dataProperties = new HashMap();
    protected int _fileCount = 0;
    public static final boolean WINDOWS_OS = TaskHelper.isWindows();
    public static final String SAS_CONFIG_FILENAME = "sasv9.cfg";
    protected String _backupKey = null;
    protected boolean _undo = false;
    protected String _failureAction = "rollbackAndFail";
    protected HostList _hostList = null;
    protected Controller _controller;
    protected InstallType _data = null;
    protected Target target = null;
    protected String _altsku = null;
    private AltskuProperties props;
    protected HashMap<String, Long> _filesToAdd = new HashMap();
    protected HashMap<String, Long> _filesToChange = new HashMap();
    protected HashMap<String, Long> _filesToRemove = new HashMap();
    protected HashMap<String, Long> _filesToCheck = new HashMap();
    private static final int bufferSize = 262144;
    private static final byte[] buf = new byte[262144];

    public InstallationTask(Controller controller) {
        this.setController(controller);
    }

    public InstallationTask() {
    }

    public String getSubType() {
        return "";
    }

    public void setData(InstallType data) {
        this._data = data;
    }

    public InstallType getData() {
        return this._data;
    }

    protected Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String getAltsku() {
        return this._altsku;
    }

    public String getProdCodeFromAltSku() {
        int seperator;
        String ret = this._altsku;
        if (this._altsku != null && (seperator = this._altsku.indexOf("__")) != -1) {
            ret = this._altsku.substring(0, seperator);
        }
        return ret;
    }

    public void setAltSku(String altsku) {
        this._altsku = altsku;
    }

    public String resolveProperty(String value) {
        return this.props.resolve(value);
    }

    public String resolveShortPaths(String value) {
        Pattern pShort = Pattern.compile("\\$Short\\{([^\\}]*)\\}");
        Matcher mShort = pShort.matcher(value);
        String shortPath = "";
        StringBuffer resolvedValue = new StringBuffer();
        while (mShort.find()) {
            String longPathValue = mShort.group(1);
            File longPath = new File(longPathValue);
            if (WINDOWS_OS) {
                if (!JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, SASWinAPI.libNames)) {
                    String missingLib = JNIUtils.getJniLib(SASWinAPI.libNames);
                    throw new InstallException(1, null, this.getBundle().messageString("Controller.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
                }
                if (longPath.exists()) {
                    shortPath = SASWinAPI.GetShortPath(longPathValue);
                    mShort.appendReplacement(resolvedValue, shortPath.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
                    this.log.info("Changed long path \"" + longPathValue + "\" to short path: \"" + shortPath + "\"");
                    continue;
                }
                this.log.warn("Could not resolve \"" + longPath + "\" to short path. Path does not exist.");
                continue;
            }
            mShort.appendReplacement(resolvedValue, longPathValue.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        }
        mShort.appendTail(resolvedValue);
        return resolvedValue.toString();
    }

    public void takeAttributesFromMap(HashMap<String, String> parameters) {
        for (String key : parameters.keySet()) {
            String resolvedValue = this.resolveProperty(parameters.get(key));
            String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1, key.length());
            try {
                Method method = this.getClass().getMethod(methodName, String.class);
                method.invoke((Object)this, resolvedValue);
            }
            catch (Exception e) {
                throw new InstallException(2, this, this.getBundle().messageString("InstallationTask.UnidentifiedTaskAttribute", key, this.getClass().getName()), this.getBundle().messageString("InstallationTask.UnidentifiedTaskAttribute", key, this.getClass().getName()), e);
            }
        }
    }

    public void preExecute() throws Exception {
        this.setFilesToAdd(new HashMap<String, Long>());
        this.setFilesToChange(new HashMap<String, Long>());
        this.setFilesToRemove(new HashMap<String, Long>());
    }

    public abstract String descriptionForLog();

    public boolean executeOnCurrentHost() {
        if (this.getHostList() == null || this.getHostList().getName().isEmpty()) {
            return true;
        }
        String OS_Suffix = TaskHelper.getOS_Suffix();
        if (OS_Suffix.equalsIgnoreCase("win")) {
            OS_Suffix = "w32";
        }
        if (this.getHostList().getName().contains(OS_Suffix)) {
            return true;
        }
        String taskDescription = this.descriptionForLog();
        taskDescription = taskDescription == null ? ".  " : "\n" + taskDescription + "\n\t";
        this.log.info("Skipping task" + taskDescription + "Package platform (" + TaskHelper.getOS_Suffix() + ") not contained in host list (" + this.getHostList() + ")");
        return false;
    }

    public abstract void execute() throws InstallException;

    public abstract void retry() throws InstallException;

    public abstract void rollback() throws InstallException;

    public abstract void postExecute() throws Exception;

    public void notifySetup(String action, EntryData metaData, String message) {
        String name = metaData.getName();
        if (name == null) {
            name = metaData.getDestination().getAbsolutePath();
        }
        String logMessage = name + " is to be " + action;
        if (message != null) {
            logMessage = logMessage + "(" + message + ")";
        }
        this.log.info(logMessage);
        this.getNotifier().fireSetupNotification(action, metaData, message);
    }

    public void notifySetup(String description, String logDescription) {
        if (logDescription != null) {
            this.log.info("Setup event:  " + logDescription);
        }
        this.notifySetup(description);
    }

    public void notifySetup(String description) {
        this.getNotifier().fireSetupNotification(description);
    }

    public void notifyProgressComplete(String description) {
        this.log.info("notifyProgressComplete notification broadcast.  Description:  " + description);
        this.getNotifier().fireProgressCompleteNotification(description);
    }

    public void notifyRollbackProgressComplete(String description) {
        this.log.info("notifyRollbackProgressComplete notification broadcast.\n\tDescription:  " + description);
        this.getNotifier().fireRollbackProgressCompleteNotification(description);
    }

    public void notifyProgressComplete(String action, EntryData metaData) {
        Long size = new Long(0L);
        if (metaData.getSize() != null) {
            size = metaData.getSize();
        }
        String logMessage = metaData.getName() + " (" + size + " bytes) has been successfully " + action;
        this.log.info(logMessage);
        this.getNotifier().fireProgressCompleteNotification(action, metaData);
    }

    public NotificationHandler getNotifier() {
        return NotificationHandler.defaultHandler();
    }

    public void notifyRollbackProgressComplete(String action, EntryData metaData, long bytes) {
        String logMessage = metaData.getName() + " have been " + action + " (" + bytes + " bytes) for rollback";
        this.log.info(logMessage);
        this.log.info("notifyRollbackProgressComplete notification broadcast:\n\taction:  " + action + "\n\tmetaData name:  " + metaData.getName() + "\n\tbytes:  " + bytes);
        this.getNotifier().rollbackBytesMoved(bytes);
        this.getNotifier().fireRollbackProgressCompleteNotification(action, metaData);
    }

    public void notifyProgressStart(String description) {
        this.log.info("notifyProgressStart notification broadcast.\n\tdescription:  " + description);
        this.getNotifier().fireProgressBeginNotification(description);
    }

    public void notifyRollbackProgressStart(String description) {
        this.log.info("notifyRollbackProgressStart notification broadcast.\n\tdescription:  " + description);
        this.getNotifier().fireRollbackProgressBeginNotification(description);
    }

    public void notifyProgressStart(String action, EntryData metaData) {
        String logMessage = metaData.getName() + " is about to be " + action;
        this.fileLog.info(logMessage);
        this.getNotifier().fireProgressBeginNotification(action, metaData);
    }

    public void notifyProgressFailure(String action, EntryData metaData) {
        String logMessage = metaData.getName() + " failed to be " + action;
        this.log.info(logMessage);
        this.getNotifier().fireProgressFailedNotification(action, metaData);
    }

    public void streamDataWithNotifications(InputStream is, OutputStream os, boolean rollback) throws IOException {
        int n;
        while ((n = is.read(buf)) > -1) {
            if (rollback) {
                this.notifyRollbackBytesMoved(n);
            } else {
                this.notifyBytesMoved(n);
            }
            os.write(buf, 0, n);
        }
    }

    public void notifyRollbackProgressStart(String action, EntryData metaData) {
        String logMessage = metaData.getName() + " is about to be " + action + " for rollback";
        this.fileLog.info(logMessage);
        this.getNotifier().fireRollbackProgressBeginNotification(action, metaData);
    }

    public void notifyBytesMoved(long bytes) {
        this.getNotifier().bytesMoved(bytes);
    }

    public void notifyRollbackBytesMoved(long bytes) {
        this.getNotifier().rollbackBytesMoved(bytes);
    }

    public void notifyReboot(String description) {
        this.getNotifier().fireRebootFlagNotification(description);
    }

    public void notifyWarning(String description) {
        this.getNotifier().fireWarningFlagNotification(description);
    }

    public String getBackupKey() {
        return this._backupKey;
    }

    public void setBackupKey(String backupKey) {
        this._backupKey = backupKey;
    }

    public boolean isUndo() {
        if (this._undo && this.getTarget().getName().endsWith("uninstall")) {
            return false;
        }
        return this._undo;
    }

    public void setUndo(boolean undo) {
        this._undo = undo;
    }

    public HashMap<String, Long> getFilesToAdd() {
        return this._filesToAdd;
    }

    public void setFilesToAdd(HashMap<String, Long> filesToAdd) {
        this._filesToAdd = filesToAdd;
    }

    public HashMap<String, Long> getFilesToChange() {
        return this._filesToChange;
    }

    public void setFilesToChange(HashMap<String, Long> filesToChange) {
        this._filesToChange = filesToChange;
    }

    public HashMap<String, Long> getFilesToRemove() {
        return this._filesToRemove;
    }

    public void setFilesToRemove(HashMap<String, Long> filesToRemove) {
        this._filesToRemove = filesToRemove;
    }

    public HashMap<String, Long> getFilesToCheck() {
        return this._filesToCheck;
    }

    public void setFilesToCheck(HashMap<String, Long> filesToCheck) {
        this._filesToCheck = filesToCheck;
    }

    public String getFailureAction() {
        return this._failureAction;
    }

    public void setFailureAction(String failureAction) {
        this._failureAction = failureAction;
    }

    public HostList getHostList() {
        return this.getData().getHostList();
    }

    public void setHostList(HostList hostList) {
        this._hostList = hostList;
    }

    public SSNResource getBundle() {
        return this._bundle;
    }

    public void setBundle(SSNResource bundle) {
        this._bundle = bundle;
    }

    public SSNResource getEnBundle() {
        return this._enBundle;
    }

    public void setEnBundle(SSNResource enBundle) {
        this._enBundle = enBundle;
    }

    public Controller getController() {
        return this._controller;
    }

    public void setController(Controller controller) {
        this._controller = controller;
        this.props = new AltskuProperties(controller, controller.getAltSku());
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public static int executeProcess(ProcessBuilder pb, Logger log) throws IOException, InterruptedException {
        pb.redirectErrorStream(true);
        log.info("preparing to execute " + pb.command());
        Process process = pb.start();
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        while ((line = input.readLine()) != null) {
            log.info(line);
        }
        log.info("Reading output is done.");
        input.close();
        log.info("Waiting for process to signal done.");
        int rc = process.waitFor();
        log.info("execution complete with exit value " + rc);
        return process.exitValue();
    }

    public static String getSASHome() {
        Controller controller = Controller.defaultController();
        String productHomePath = controller.getProperty("SASHome");
        String absolutePath = controller.getFS().getAbsolutePath(productHomePath);
        return absolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSASOutput(int rc, String logFilePath) throws InstallException {
        ArrayList<String> errors = new ArrayList<String>();
        File logFile = new File(logFilePath);
        this.log.info("Invocation of SAS returned " + rc);
        if (rc >= 2) {
            errors.add("SAS invocation return code of " + rc + "\n");
        }
        if (logFile.exists()) {
            BufferedReader logReader = null;
            boolean deleteLog = false;
            try {
                this.log.info("SAS log contents:");
                logReader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));
                String line = null;
                while ((line = logReader.readLine()) != null) {
                    this.log.info(line);
                }
                if (Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
                    deleteLog = true;
                }
            }
            catch (IOException e) {
                this.log.info("Unable to open the SAS log " + logFile, (Throwable)e);
            }
            finally {
                this.log.info("end of SAS log");
                if (logReader != null) {
                    try {
                        logReader.close();
                    }
                    catch (IOException e) {
                        this.log.info("Unable to close the SAS log " + logFile, (Throwable)e);
                    }
                }
                if (deleteLog) {
                    logFile.delete();
                }
            }
        }
        if (errors.size() > 0) {
            throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.SASOutputErrors", errors), this.getEnBundle().messageString("InstallationTask.SASOutputErrors", errors), null);
        }
    }

    public int getFileCount() {
        return this._fileCount;
    }

    public void setFileCount(int fileCount) {
        this._fileCount = fileCount;
    }

    protected String getSASFoundationRoot() {
        if (Controller.installProperties.getProperty("sdm.postinstall") == "TRUE") {
            this.setSASFoundationRoot(Controller.installProperties.getProperty("base.home"));
        } else if (TaskHelper.isWindows()) {
            this.setSASFoundationRoot(this.getController().getProperty("ProductHome"));
        }
        return Controller.installProperties.getProperty("sas.root");
    }

    protected void setSASFoundationRoot(String path) {
        Controller.installProperties.setProperty("sas.root", path);
    }

    protected File getSASHelp() {
        File sasroot = new File(this.getSASFoundationRoot());
        if (TaskHelper.isWindows()) {
            sasroot = new File(sasroot, "core");
        }
        return new File(sasroot, "sashelp");
    }

    protected List<String> getSASBatchArgs(File inputFile, String logFilename) {
        File sasexe = this.getSASExe();
        ArrayList<String> args = new ArrayList<String>();
        args.add(sasexe.getPath());
        args.add("-sysin");
        args.add(inputFile.getPath());
        args.addAll(this.getLogArgs(logFilename));
        args.add("-nodms");
        args.add("-noterminal");
        args.add("-noautoexec");
        if (Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
            args.add("-nodate");
        } else {
            args.add("-date");
        }
        args.add("-nostimer");
        args.add("-unbuflog");
        if (TaskHelper.isWindows()) {
            args.add("-sasuser");
            args.add("\"" + this.getInstallMisc() + "\"");
            args.add("-icon");
            args.add("-nosplash");
            args.add("-noprngetlist");
            args.add("-msg");
            args.add("!SASROOT/core/sasmsg");
        } else if (TaskHelper.isUnix()) {
            args.add("-filelocks");
            args.add("none");
            args.add("-nonews");
            String foundation = this.getSASFoundationRoot();
            args.add("-set");
            args.add("sasroot");
            args.add(foundation);
            args.add("-sasuser");
            args.add(foundation + "/install/admin");
            args.add("-work");
            args.add(foundation + "/install/admin");
            args.add("-msg");
            args.add(foundation + "/sasmsg");
        }
        return args;
    }

    protected void deleteSASTempFiles() {
        File dir = new File(this.getInstallMisc().toString());
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            String fileDelete;
            File file;
            if (!files[i].endsWith(".sas7bcat") && !files[i].endsWith(".sas7bitm") || (file = new File(fileDelete = this.getInstallMisc().toString() + File.separator + files[i])) == null || !file.exists()) continue;
            file.delete();
        }
    }

    private List<String> getLogArgs(String file) {
        ArrayList<String> args = new ArrayList<String>();
        String logFile = null;
        logFile = Controller.installProperties.getProperty("sdm.postinstall") == "TRUE" ? this.getController().getSetinitLog() : this.getSASLog(file);
        if (TaskHelper.isWindows() || TaskHelper.isUnix()) {
            args.add("-log");
            args.add(logFile);
        }
        return args;
    }

    protected File getSASExe() {
        String sas = "/unsupported_platform";
        if (TaskHelper.isWindows()) {
            sas = this.getController().getFS().append(this.getSASFoundationRoot(), "sas.exe");
        } else if (TaskHelper.isUnix()) {
            sas = this.getController().getFS().append(this.getSASFoundationRoot(), "bin", "sas_en");
        } else {
            this.log.fatal("Not a supported platform for this task: " + TaskHelper.getOS());
        }
        return new File(sas);
    }

    public File getSASConfigFile(String lang) {
        String sasRoot = this.getSASFoundationRoot();
        File config = null;
        config = "en".equals(lang) && TaskHelper.isUnix() ? new File(sasRoot, SAS_CONFIG_FILENAME) : new File(this.getController().getFS().append(sasRoot, "nls", lang, SAS_CONFIG_FILENAME));
        return config;
    }

    protected File getInstallMisc() {
        return new File(InstallationTask.getSASHome(), "InstallMisc");
    }

    protected File getInstallLogs() {
        return this.getController().getLogPath();
    }

    protected String getSASLog(String logFilename) {
        return new File(this.getInstallLogs(), logFilename).getPath();
    }

    public UninstallTarget getUninstallTarget() {
        return UninstallTarget.SAME;
    }

    protected void copyFile(File from, File to) {
        this.log.info("Copy from: " + from.getAbsolutePath());
        this.log.info("Copy to: " + to.getAbsolutePath());
        Copy copy = new Copy();
        copy.setFrom(from.getAbsolutePath());
        copy.setTo(to.getAbsolutePath());
        RunFileUtility runFileUtility = new RunFileUtility();
        runFileUtility.setAction("copy");
        runFileUtility.setCopy(copy);
        RunFileUtilityTask runFileUtilityTask = new RunFileUtilityTask();
        runFileUtilityTask.setData(runFileUtility);
        runFileUtilityTask.setController(this.getController());
        runFileUtilityTask.execute();
    }

    protected void deleteAtUninstall(File file, Target removalTarget) {
        Delete delete = new Delete();
        delete.setFile(file.getAbsolutePath());
        RunFileUtility runFileUtility = new RunFileUtility();
        runFileUtility.setAction("delete");
        runFileUtility.setDelete(delete);
        removalTarget.getTasks().add(runFileUtility);
    }

    public boolean isConstraintMet() {
        boolean isMet = true;
        ConstrainBy constrainBy = this.getConstrainBy();
        if (constrainBy != null) {
            if (constrainBy.getLocale() != null) {
                this.log.info("checking constrainBy Locale");
                isMet = this.isLocaleConstraintMet(this.resolveProperty(constrainBy.getLocale()));
            }
            List<PropertyMatchConstraint> constraints = constrainBy.getPropertyMatch();
            for (int i = 0; isMet && i < constraints.size(); ++i) {
                this.log.info("checking constrainBy PropertyMatch " + i);
                isMet = this.isPropertyMatchConstraintMet(constraints.get(i));
            }
            List<FileExistConstraint> fileConstraints = constrainBy.getFileExist();
            for (int i = 0; isMet && i < fileConstraints.size(); ++i) {
                this.log.info("checking constrainBy FileExist " + i);
                isMet = this.isFileExistConstraintMet(fileConstraints.get(i));
            }
        }
        this.log.info("All constrainBy tests met: " + isMet);
        return isMet;
    }

    protected boolean isPropertyMatchConstraintMet(PropertyMatchConstraint propertyMatch) {
        boolean isMet = true;
        String value = this.resolveProperty(propertyMatch.getValue());
        String match = this.resolveProperty(propertyMatch.getMatch());
        PropertyMatchTest test = propertyMatch.getTest();
        if (test.equals((Object)PropertyMatchTest.EQUALS)) {
            isMet = value.equals(match);
            this.log.info("'" + value + "' equals '" + match + "': " + isMet);
        } else if (test.equals((Object)PropertyMatchTest.NOTEQUALS)) {
            isMet = !value.equals(match);
            this.log.info("'" + value + "' notequals '" + match + "': " + isMet);
        }
        return isMet;
    }

    protected boolean isFileExistConstraintMet(FileExistConstraint fileExist) {
        boolean isMet = true;
        File path = new File(this.resolveProperty(fileExist.getPath()));
        FileExistTest test = fileExist.getTest();
        String fileType = fileExist.getType();
        if (test.equals((Object)FileExistTest.EXIST)) {
            if (fileType.equals("file")) {
                isMet = path.isFile();
                this.log.info("'" + path + "' file exists: " + isMet);
            } else if (fileType.equals("directory")) {
                isMet = path.isDirectory();
                this.log.info("'" + path + "' directory exists: " + isMet);
            }
        } else if (test.equals((Object)FileExistTest.NOTEXIST)) {
            if (fileType.equals("file")) {
                isMet = !path.isFile();
                this.log.info("'" + path + "' file does not exist: " + isMet);
            } else if (fileType.equals("directory")) {
                isMet = !path.isDirectory();
                this.log.info("'" + path + "' directory does not exist: " + isMet);
            }
        }
        return isMet;
    }

    protected boolean isLocaleConstraintMet(String locale) {
        return true;
    }

    protected ConstrainBy getConstrainBy() {
        return this.getData().getConstrainBy();
    }

    public static enum UninstallTarget {
        PREINSTALL,
        INSTALL,
        POSTINSTALL,
        SAME;

    }
}

