/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.HiveKeyRegistry;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.schema.install.gen.InstallMSIPackage;
import com.sas.tools.installs.it.tasks.CommandLineArgTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class InstallMSIPackageTask
extends CommandLineArgTask {
    private static final String TASK_NAME = "InstallMSIPackage";
    private static Logger log = (Logger)LogManager.getLogger("com.sas.tools.installs.it.tasks.InstallMSIPackageTask");
    private static final String ProductIDKey = "ProductID";
    private String productCode = "";
    private String version = "";
    private String platform = "";
    private String language = "";

    @Override
    public String descriptionForLog() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("msiPackage", ((InstallMSIPackage)this.getData()).getMsiPackage());
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    @Override
    public void preExecute() throws Exception {
        if (TaskHelper.getOS() != 1) {
            log.info("The InstallMSIPackage task is only supported on Windows, skipping this task");
            return;
        }
        Controller controller = this.getController();
        this.productCode = controller.getProperty("12ByteCode");
        this.version = controller.getProperty("ProductVersion");
        this.platform = controller.getProperty("host");
        this.language = controller.getProperty("ProductLanguage");
        super.preExecute();
    }

    @Override
    public void execute() throws InstallException {
        String args = "";
        String webinf_args = "";
        MsiArgs msiArgs = new MsiArgs();
        MsiLogging msiLogging = new MsiLogging(this.getController().getLogPath());
        if (this.isUndo()) {
            WindowsRegistry winRegistry = new WindowsRegistry();
            String registryKey = ((InstallMSIPackage)this.getData()).getGuidRegistryKey();
            if (registryKey != null) {
                registryKey = this.resolveProperty(registryKey);
            }
            args = msiArgs.getUninstallArgs(winRegistry, registryKey, msiLogging.getUninstallLog());
            log.info("Uninstalling MSI package with the command: " + args);
        } else {
            File msiPackage = new File(this.getController().getCurrentContext().getPayloadDir(), ((InstallMSIPackage)this.getData()).getMsiPackage());
            String TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO = "HKEY_LOCAL_MACHINE\\SOFTWARE\\SAS Institute Inc.\\AddIn for Microsoft Office\\" + this.version + "\\LanguageResources\\";
            String TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO32 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\AddIn for Microsoft Office\\" + this.version + "\\LanguageResources\\";
            String TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA = "HKEY_LOCAL_MACHINE\\SOFTWARE\\SAS Institute Inc.\\Enterprise Guide\\" + this.version + "\\LanguageResources\\";
            String TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA32 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\Enterprise Guide\\" + this.version + "\\LanguageResources\\";
            if (msiPackage.getName().indexOf(".msi") > 0 && !this.language.equals("en") && (this.productCode.equals("eguide") || this.productCode.equals("msofficeint"))) {
                WindowsRegistry winRegistry = new WindowsRegistry();
                String registryKey = ((InstallMSIPackage)this.getData()).getGuidRegistryKey();
                if (registryKey != null) {
                    registryKey = this.resolveProperty(registryKey);
                }
                if (this.productCode.equals("msofficeint")) {
                    registryKey = this.platform.equals("win") ? (this.language.equals("iw") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + "he" : (this.language.equals("zh") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + "zh-CN" : (this.language.equals("zt") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + "zh-TW" : (this.language.equals("zx") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + "zh-HK" : TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + this.language)))) : (msiPackage.getAbsolutePath().indexOf("_win_") > 0 ? (this.language.equals("iw") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO32 + "he" : (this.language.equals("zh") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO32 + "zh-CN" : (this.language.equals("zt") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO32 + "zh-TW" : (this.language.equals("zx") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO32 + "zh-HK" : TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO32 + this.language)))) : (this.language.equals("iw") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + "he" : (this.language.equals("zh") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + "zh-CN" : (this.language.equals("zt") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + "zh-TW" : (this.language.equals("zx") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + "zh-HK" : TEMP_SAS_INSTALL_REGISTRY_ROOT_AMO + this.language)))));
                }
                if (this.productCode.equals("eguide")) {
                    registryKey = this.platform.equals("win") ? (this.language.equals("iw") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + "he" : (this.language.equals("zh") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + "zh-CN" : (this.language.equals("zt") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + "zh-TW" : (this.language.equals("zx") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + "zh-HK" : TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + this.language)))) : (msiPackage.getAbsolutePath().indexOf("_win_") > 0 ? (this.language.equals("iw") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA32 + "he" : (this.language.equals("zh") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA32 + "zh-CN" : (this.language.equals("zt") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA32 + "zh-TW" : (this.language.equals("zx") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA32 + "zh-HK" : TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA32 + this.language)))) : (this.language.equals("iw") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + "he" : (this.language.equals("zh") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + "zh-CN" : (this.language.equals("zt") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + "zh-TW" : (this.language.equals("zx") ? TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + "zh-HK" : TEMP_SAS_INSTALL_REGISTRY_ROOT_EGA + this.language)))));
                }
                if ((args = msiArgs.getUninstallArgs(winRegistry, registryKey, msiLogging.getUninstallLog())) != null) {
                    log.info("Uninstalling MSI package with the command: " + args + "  prior to reinstalling.");
                    this.runMSIInstall_Runtime(args);
                }
            }
            if (!msiPackage.exists()) {
                throw new InstallException(1, this, this.getBundle().messageString("InstallMSIPackage.MsiFileNotFound", msiPackage.getAbsolutePath()), this.getEnBundle().messageString("InstallMSIPackage.MsiFileNotFound", msiPackage.getAbsolutePath()), null);
            }
            args = msiArgs.getInstallArgs(msiPackage, this.getResolvedArgs((InstallMSIPackage)this.getData()), msiLogging.getInstallLog(), false);
            log.info("Installing MSI package with the command: " + args);
            if (this.productCode.equals("webinfdodbc")) {
                webinf_args = msiArgs.getInstallArgs(msiPackage, this.getResolvedArgs((InstallMSIPackage)this.getData()), msiLogging.getInstallLog(), true);
                log.info("Repairing MSI package with the command: " + webinf_args);
            }
        }
        if (this.isUndo() && args == null) {
            log.info("The MSI package for " + this.productCode + " " + this.version + " " + this.platform + " " + this.language + " is no longer installed.");
            return;
        }
        this.runMSIInstall_Runtime(args);
        if (webinf_args != null && !webinf_args.isEmpty()) {
            this.runMSIInstall_Runtime(webinf_args);
        }
    }

    private void runMSIInstall_Runtime(String args) {
        int rc = 0;
        Runtime run = Runtime.getRuntime();
        try {
            Process pp = run.exec(args);
            rc = pp.waitFor();
            log.info("Return code from msiexec: " + rc);
        }
        catch (Exception e) {
            throw new InstallException(1, this, this.getBundle().messageString("InstallMSIPackage.AnErrorOccurredStartingMSIInstall", args), this.getEnBundle().messageString("InstallMSIPackage.AnErrorOccurredStartingMSIInstall", args), e);
        }
        if (rc != 0) {
            if (rc == 1638) {
                log.warn("Error code 1638 was returned from msiexec, indicating another version of this product has already been installed and the version being installed cannot be.");
            } else if (this.productCode.equals("webinfdodbc") && (rc == 1603 || rc == 1605)) {
                log.warn("Error code " + rc + " was returned from msiexec, indicating another version of this product has already been installed and the version being installed cannot be.");
            } else if (rc == 3010) {
                log.info("Msiexec returned 3010 indicating the install completed successfully but a reboot is required to complete the installation.");
                this.notifyReboot("Reboot pending due to installation of " + this.getController().getProperty("12ByteCode") + ".");
            } else {
                throw new InstallException(1, this, this.getBundle().messageString("InstallMSIPackage.MsiexecReturnedNonZeroReturnCode", rc, args), this.getEnBundle().messageString("InstallMSIPackage.MsiexecReturnedNonZeroReturnCode", rc, args), null);
            }
        }
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    @Override
    public void postExecute() throws Exception {
    }

    class MsiLogging {
        File logPath = null;

        MsiLogging(File logPath) {
            this.logPath = logPath;
        }

        public String getInstallLog() {
            return this.getLog("install");
        }

        public String getUninstallLog() {
            return this.getLog("uninstall");
        }

        private String getLog(String prefix) {
            String DATE_FORMAT_NOW = "yyyy-MM-dd-HH.mm.ss";
            Date logDate = Calendar.getInstance().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
            String logFilename = prefix + "_" + InstallMSIPackageTask.this.productCode + "_" + InstallMSIPackageTask.this.version + "_" + InstallMSIPackageTask.this.platform + "_" + InstallMSIPackageTask.this.language + "_" + sdf.format(logDate) + ".log";
            if (this.logPath == null) {
                this.logPath = new File(".");
            }
            File installLog = new File(this.logPath, logFilename);
            return installLog.getAbsolutePath();
        }
    }

    class MsiArgs {
        private static final String msiExec = "msiexec.exe";
        private static final String installArg = "/i";
        private static final String updateArg = "/update";
        private static final String uninstallArg = "/uninstall";
        private static final String silentArg = "/qn";
        private static final String msiLoggingArg = "/LV*X";
        private static final String noRestartArg = "/norestart";
        private static final String repairArg = "/fp";

        MsiArgs() {
        }

        public String getInstallArgs(File msiPackage, List<String> msiPackageArgs, String logFilename, boolean repair) {
            String install = installArg;
            if (msiPackage.getName().toLowerCase().endsWith(".msp")) {
                install = updateArg;
            }
            if (repair) {
                install = repairArg;
            }
            String args = "msiexec.exe ";
            args = args.concat(install + " ");
            args = args.concat("\"" + msiPackage.getAbsolutePath() + "\" ");
            args = args.concat("/qn ");
            args = args.concat("/norestart ");
            for (String addArgs : msiPackageArgs) {
                args = args.concat(addArgs + " ");
            }
            if (logFilename != null && !logFilename.equals("")) {
                args = args.concat("/LV*X ");
                args = args.concat("\"" + logFilename + "\"");
            }
            return args;
        }

        public String getUninstallArgs(HiveKeyRegistry winRegistry, String registryKey, String logFilename) {
            String args = null;
            String guid = this.getUninstallGuid(winRegistry, registryKey);
            if (guid == null || guid.equals("")) {
                return args;
            }
            args = "msiexec.exe ";
            args = args.concat("/uninstall ");
            if (!guid.startsWith("{")) {
                guid = "{".concat(guid);
            }
            if (!guid.endsWith("}")) {
                guid = guid.concat("}");
            }
            args = args.concat(guid + " ");
            args = args.concat("/qn ");
            args = args.concat("/norestart ");
            if (logFilename != null && !logFilename.equals("")) {
                args = args.concat("/LV*X ");
                args = args.concat("\"" + logFilename + "\"");
            }
            return args;
        }

        private String getUninstallGuid(HiveKeyRegistry winRegistry, String registryKey) {
            String guid = null;
            if (registryKey == null || registryKey.equals("")) {
                return null;
            }
            if (InstallMSIPackageTask.this.platform.equalsIgnoreCase("wx6")) {
                winRegistry.setBitMode(64);
            } else {
                winRegistry.setBitMode(32);
            }
            registryKey = registryKey.trim();
            registryKey = registryKey.replace("HKEY_LOCAL_MACHINE\\", "");
            guid = winRegistry.getValue(8, registryKey, InstallMSIPackageTask.ProductIDKey);
            return guid;
        }
    }
}

