/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.it.schema.install.EmbedJava;
import com.sas.tools.installs.it.schema.install.gen.ArgList;
import com.sas.tools.installs.it.schema.install.gen.ConstrainBy;
import com.sas.tools.installs.it.schema.install.gen.Extract;
import com.sas.tools.installs.it.schema.install.gen.FileExistConstraint;
import com.sas.tools.installs.it.schema.install.gen.FileExistTest;
import com.sas.tools.installs.it.schema.install.gen.HostList;
import com.sas.tools.installs.it.schema.install.gen.InstallType;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.schema.metadata.gen.ContentsType;
import com.sas.tools.installs.it.schema.metadata.gen.EntryType;
import com.sas.tools.installs.it.schema.metadata.gen.Zip;
import com.sas.tools.installs.it.tasks.EmbedJavaTask;
import com.sas.tools.installs.it.tasks.InstallationTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class ExtractTask
extends InstallationTask {
    private static final long serialVersionUID = 1L;
    public static final String NONE = "NONE";
    public static final String DATE = "DATE";
    public static final String VERSION = "VERSION";
    public static final String CHECKSUM = "CHECKSUM";
    public static final String DELETE = "DELETE";
    public static final String EQUALS = "equals";
    public static final String LESS_THAN = "lessthan";
    public static final String LESS_THAN_EQUALS = "lessthanequals";
    public static final String GREATER_THAN = "greaterthan";
    public static final String GREATER_THAN_EQUALS = "greaterthanequals";
    public static final String DEFAULT = "default";
    public static final int PRE_EXECUTE = 0;
    public static final int EXECUTE = 1;
    private int _mode = 1;
    public static final int RETRY = 0;
    public static final int ROLLBACK = 1;
    private int _action = 0;
    private static final int MAX_RETRIES = 3;
    private static final long[] RETRY_SLEEP = new long[]{1000L, 5000L, 10000L};
    protected String _backupDestination;
    protected String _sourceFile;
    protected HashMap<String, EntryData> _installMap;
    protected HashMap<String, EntryData> _deleteMap;
    protected HashMap<String, EntryData> _directoryMap;
    protected HashMap<String, EntryData> _uninstallMap;
    protected String _filename;
    protected String _lastEntry = null;
    protected ZipFile _zip = null;
    protected Zip _jaxbZip = null;
    private String sku;
    protected String _home = "";
    protected File _zipDataFile;
    protected File _zipFile;
    protected Logger fileLog = (Logger)LogManager.getLogger("FileLog");

    public ExtractTask() {
        this.sku = Controller.defaultController().getAltSku();
        String key = this.sku.concat(this.getClass().getName());
        Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(this.getClass().getName(), "clearVJRCache", ProcessingTaskInfo.Priority.LOW));
        Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this.getClass(), "clearVJRCache", ProcessingTask.Priority.LOW));
    }

    public static int clearVJRCache() {
        int returnCode = 0;
        Logger logger = (Logger)LogManager.getLogger(ExtractTask.class);
        EmbedJavaTask javaTask = new EmbedJavaTask();
        EmbedJava taskData = new EmbedJava();
        String jarPath = System.getProperty("VJRHome") + "/eclipse/plugins/sas.launcher.jar";
        taskData.setJar(jarPath);
        taskData.setMainClass("com.sas.app.NonAPI");
        ArgList arglist = new ArgList();
        arglist.getArg().add("-install");
        taskData.setArgList(arglist);
        ConstrainBy constrainBy = new ConstrainBy();
        FileExistConstraint jarExist = new FileExistConstraint();
        jarExist.setPath(jarPath);
        jarExist.setTest(FileExistTest.EXIST);
        constrainBy.getFileExist().add(jarExist);
        FileExistConstraint jreExist = new FileExistConstraint();
        jreExist.setPath(Controller.defaultController().getProperty("JAVAEXE"));
        jreExist.setTest(FileExistTest.EXIST);
        constrainBy.getFileExist().add(jreExist);
        taskData.setConstrainBy(constrainBy);
        javaTask.setData(taskData);
        javaTask.setController(Controller.defaultController());
        if (javaTask.isConstraintMet()) {
            logger.info("Regenerating the VJR Cache");
            javaTask.execute();
            logger.info("VJR Cache regeneration Complete");
        } else {
            logger.info("Can't regenerate VJR Cache");
        }
        return returnCode;
    }

    @Override
    public String getSubType() {
        return this.getSource();
    }

    @Override
    public void setData(InstallType data) {
        super.setData(data);
        HostList hostList = this.getData().getHostList();
        if (hostList != null) {
            this.log.info("Host list: " + hostList);
        }
        this.loadMetaData(this.getFilename());
    }

    protected void loadMetaData(String metaFile) {
        this._installMap = new HashMap();
        this._directoryMap = new HashMap();
        this._deleteMap = new HashMap();
        this._zipDataFile = new File(metaFile);
        Zip zipData = null;
        if (this.isUndo() && !this._zipDataFile.exists()) {
            this.log.info("uninstall: metdata not installed for this platform, skipping: " + metaFile);
            Zip emptyZipData = new Zip();
            ContentsType contentsType = new ContentsType();
            emptyZipData.setContents(contentsType);
            this.setJaxbZip(emptyZipData);
            return;
        }
        try {
            this.log.debug("unmarshalling metadata:  " + metaFile);
            zipData = SchemaUtils.unmarshal(this._zipDataFile, Zip.class);
        }
        catch (JAXBException e) {
            throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.MetadataFileReadError", metaFile), "Error reading the " + metaFile + " package data file", e);
        }
        this.setJaxbZip(zipData);
        this._fileCount += this.getJaxbZip().getContents().getEntry().size();
    }

    @Override
    public void notifySetup(String action, EntryData metaData, String message) {
        if (message != null) {
            this.fileLog.info(message);
        }
        NotificationHandler.defaultHandler().fireSetupNotification(action, metaData, message);
    }

    private void addToMap(EntryData entry) {
        entry.setDestination(new File(Utils.joinPath(this.getHome(), entry.getName())));
        if (EntryData.FILE.equals(entry.getType())) {
            if (entry.shouldDelete()) {
                this._deleteMap.put(entry.getName(), entry);
            } else {
                this._installMap.put(entry.getName(), entry);
            }
        } else {
            this._directoryMap.put(entry.getName(), entry);
        }
    }

    protected void openZipFile() {
        if (!this.isUndo()) {
            try {
                this._zip = new ZipFile(this.getZipFile());
            }
            catch (Exception e) {
                throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.ErrorOpeningZip", this.getFilename()), "Error opening zip " + this.getFilename(), e);
            }
        }
    }

    protected void closeZipFile() {
        try {
            if (this._zip != null) {
                this._zip.close();
            }
        }
        catch (Exception e) {
            throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.ErrorClosingZip", this.getFilename()), "Error closing zip " + this.getFilename(), e);
        }
    }

    @Override
    public void preExecute() throws Exception {
        super.preExecute();
        this._mode = 0;
        for (EntryType entryType : this.getJaxbZip().getContents().getEntry()) {
            if (entryType == null) break;
            this.addToMap((EntryData)entryType);
        }
        this.handleEntryData();
        if (this.getController().isInstallCancelled()) {
            return;
        }
        this.preExecuteSummary();
    }

    private void preExecuteSummary() {
        EntryData entry = null;
        if (this.getFilesToCheck().size() > 0) {
            for (String key : this.getFilesToCheck().keySet()) {
                if (this._directoryMap.containsKey(key) || this.getFilesToRemove().containsKey(key)) continue;
                entry = this._installMap.get(key);
                entry.setSize(this.getFilesToCheck().get(key));
                this.notifySetup("Checked", entry, null);
            }
        }
        if (this.getFilesToAdd().size() > 0) {
            for (String key : this.getFilesToAdd().keySet()) {
                entry = this._installMap.get(key);
                entry.setSize(this.getFilesToAdd().get(key));
                this.notifySetup("Added", entry, null);
            }
        }
        if (this.getFilesToRemove().size() > 0) {
            for (String key : this.getFilesToRemove().keySet()) {
                entry = this._deleteMap.get(key);
                entry.setSize(this.getFilesToRemove().get(key));
                this.notifySetup("Removed", entry, null);
            }
        }
        if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, DiskInfoAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib(DiskInfoAPI.libNames);
            File fullLibPath = new File(JNIUtils.JNI_LIB_BASE, missingLib);
            throw new InstallException(2, this, this.getBundle().messageString("InstallationTask.MissingJNILib", missingLib), "Unable to load library:  " + fullLibPath.getAbsolutePath(), null);
        }
        for (String key : this._directoryMap.keySet()) {
            int entrymode;
            int filemode;
            EntryData entryData = this._directoryMap.get(key);
            if (!entryData.getDestination().exists()) {
                this.notifySetup("Added", entryData, null);
                continue;
            }
            if (Utilities.getOS() == 1 || entryData.getMode() == null || (filemode = DiskInfoAPI.GetOctalFileMode(entryData.getDestination().getAbsolutePath()) % 10000) == (entrymode = entryData.getMode() % 10000)) continue;
            this.notifySetup("Changed", entryData, null);
        }
        for (String key : this.getFilesToChange().keySet()) {
            entry = this._installMap.get(key);
            Long length = this.getFilesToChange().get(key);
            if (entry == null) continue;
            entry.addParameter("size", String.valueOf(length));
            this.notifySetup("Changed", entry, null);
        }
    }

    @Override
    public void execute() throws InstallException {
        this._mode = 1;
        this.openZipFile();
        try {
            this.handleEntryData();
        }
        finally {
            this.closeZipFile();
        }
    }

    @Override
    public void postExecute() {
        if (this.getController().isInstallCancelled()) {
            return;
        }
        if (Controller.uninstall_mode) {
            this._zipDataFile.delete();
        } else if (!(this._uninstallMap == null || this.getController().getProperty("uninstallProvided") != null && this.getController().getProperty("uninstallProvided").equals("true"))) {
            this.generateUninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInterrupt() {
        Controller controller = this.getController();
        synchronized (controller) {
            try {
                while (this.getController().isInterrupt()) {
                    this.log.info("Pausing to wait for user verification with regard to cancellation");
                    this.getController().wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.getController().isInstallCancelled()) {
                return true;
            }
        }
        return false;
    }

    private void handleEntryData() {
        if (!this.isUndo()) {
            try {
                EntryData entryData;
                TreeMap<Object, EntryData> sortedMap = new TreeMap<Object, EntryData>(Collator.getInstance());
                sortedMap.putAll(this._directoryMap);
                for (Object key : sortedMap.keySet()) {
                    EntryData entryData2 = this._directoryMap.get(key);
                    if (null == entryData2) continue;
                    if (0 == this._mode) {
                        this.handleExtraction(entryData2, null);
                        continue;
                    }
                    ZipEntry entry = this._zip.getEntry((String)key);
                    entryData2.setZipEntry(entry);
                    this.handleExtraction(entryData2, entry);
                }
                for (String key : this._installMap.keySet()) {
                    if (this.checkInterrupt()) {
                        return;
                    }
                    entryData = this._installMap.get(key);
                    if (null == entryData) continue;
                    if (0 == this._mode) {
                        this.handleExtraction(entryData, null);
                        continue;
                    }
                    ZipEntry entry = this._zip.getEntry(key);
                    entryData.setZipEntry(entry);
                    if (null != entry) {
                        this.handleExtraction(entryData, entry);
                        continue;
                    }
                    throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.MetadataInconsistency", this._zip.getName()), "Metadata is inconsistent with zip file data. Zip file: " + this._zip.getName() + " Key: " + key, null);
                }
                for (String key : this._deleteMap.keySet()) {
                    if (this.checkInterrupt()) {
                        return;
                    }
                    entryData = this._deleteMap.get(key);
                    if (null == entryData) continue;
                    this.fileLog.info("Deleting " + entryData.getDestination());
                    this.handleExtraction(entryData, null);
                }
            }
            catch (Exception e) {
                throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.ZipFileError", this.getZipFile().getName()), "Error extracting content from zip file " + this.getZipFile().getName(), e);
            }
        } else {
            EntryData entryData;
            for (String key : this._installMap.keySet()) {
                if (this.checkInterrupt()) {
                    return;
                }
                entryData = this._installMap.get(key);
                if (null == entryData) continue;
                this.handleRestoration(entryData, key);
            }
            for (String key : this._deleteMap.keySet()) {
                if (this.checkInterrupt()) {
                    return;
                }
                entryData = this._deleteMap.get(key);
                if (null == entryData) continue;
                this.handleRestoration(entryData, key);
            }
            TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
            sortedMap.putAll(this._directoryMap);
            Iterator iterator = sortedMap.keySet().iterator();
            while (iterator.hasNext()) {
                if (this.checkInterrupt()) {
                    return;
                }
                String key = (String)iterator.next();
                EntryData entryData3 = (EntryData)sortedMap.get(key);
                if (null == entryData3) continue;
                this.handleRestoration(entryData3, entryData3.getName());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleExtraction(EntryData entryData, ZipEntry zipEntry) throws InstallException {
        File file = entryData.getDestination();
        String action = "Changed";
        if (entryData.shouldDelete()) {
            action = "Removed";
        } else if (!file.exists()) {
            action = "Added";
        }
        if (0 == this._mode) {
            this.getFilesToCheck().put(entryData.getName(), entryData.getSize());
        }
        if (this.runtimeActionRequired(entryData, file)) {
            if (1 == this._mode) {
                this.notifyProgressStart(action, entryData);
            }
            try {
                this.generateRestore(entryData, file);
                this.gatherFileChanges(entryData, file);
                this.doBackup(entryData, file);
                if (entryData.shouldDelete() || !this.extractEntry(file, zipEntry, entryData)) return;
                this.doPermissions(entryData);
                return;
            }
            catch (Exception e) {
                throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.ZipContentError", entryData.getName()), "Error extracting file entry " + entryData.getName() + " from zip", e);
            }
        } else {
            if (1 != this._mode) return;
            this.notifyBytesMoved(entryData.getSize());
        }
    }

    private void handleRestoration(EntryData data, String filename) {
        if (this.doRestoreComparisons(data, filename) && 1 == this._mode && data.performRestoreForTask(this)) {
            this.doPermissions(data);
        }
    }

    protected boolean runtimeActionRequired(EntryData data, File file) {
        boolean pass = false;
        if (data.shouldDelete()) {
            return true;
        }
        if (this.getController().alwaysOverwrite()) {
            this.fileLog.info("File check skipped for " + data.getName());
            return true;
        }
        if (!file.isDirectory()) {
            if (file.exists()) {
                if (NONE.equalsIgnoreCase(data.getCompareby())) {
                    this.fileLog.info("No comparisons requested for " + data.getName());
                    pass = true;
                } else if (DATE.equalsIgnoreCase(data.getCompareby())) {
                    Long local = file.lastModified();
                    Long remote = data.getLastModified();
                    pass = this.compareFiles(local, remote, data.getEquate(), 2000L);
                    String logEntry = "Date comparison for " + data.getName() + ".  Installed file last modified:  " + local + "(" + new Date(local).toString() + "), zip entry last modified:  " + remote + "(" + new Date(remote).toString() + ")";
                    logEntry = pass ? logEntry + "  " + data.getName() + " will be installed" : logEntry + "  " + data.getName() + " will be skipped";
                    this.fileLog.info(logEntry);
                } else if (VERSION.equalsIgnoreCase(data.getCompareby())) {
                    if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, DiskInfoAPI.libNames)) {
                        String missingLib = JNIUtils.getJniLib(DiskInfoAPI.libNames);
                        throw new InstallException(2, this, this.getBundle().messageString("InstallationTask.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
                    }
                    String localVersion = new String();
                    try {
                        localVersion = DiskInfoAPI.getFileVersion(file);
                    }
                    catch (Exception e1) {
                        Controller.logStackTrace(e1);
                        throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.FileComparisonError", file.getAbsolutePath()), this.getEnBundle().messageString("ZipExtractor.FileComparisonError", file.getAbsolutePath()), null);
                    }
                    String logEntry = "Version comparison for " + data.getName() + ".  Installed file version  " + localVersion + ", file to install version:  " + data.getVersion();
                    int comparisonResult = 0;
                    comparisonResult = DiskInfoAPI.compareFileVersionStrings(localVersion, data.getVersion());
                    if (comparisonResult == 0) {
                        pass = true;
                        String installedMd5 = Utils.getMd5sum(file);
                        if (data.getMd5() != null && !data.getMd5().equals("") && data.getMd5().equals(installedMd5)) {
                            pass = false;
                        }
                        if (pass) {
                            logEntry = logEntry + "\n\t\tFile version unable to be used as method of comparison, so reverting to date/time check.";
                            long local = file.lastModified();
                            long remote = data.getLastModified();
                            logEntry = logEntry + "\n\t\tDate comparisons for " + data.getName() + ".  Installed file last modified:  " + local + "(" + new Date(local).toString() + "), zip entry last modified:  " + remote + "(" + new Date(remote).toString() + ")";
                            pass = this.compareFiles(local, remote, GREATER_THAN);
                        }
                        logEntry = pass ? logEntry + "  " + data.getName() + " will be installed" : logEntry + "  " + data.getName() + " will be skipped";
                    } else if (comparisonResult == 1) {
                        logEntry = logEntry + "  " + data.getName() + " will be installed";
                        pass = true;
                    } else {
                        logEntry = logEntry + "  " + data.getName() + " will be skipped";
                        pass = false;
                    }
                    this.fileLog.info(logEntry);
                } else if (CHECKSUM.equalsIgnoreCase(data.getCompareby())) {
                    String local = Utils.getMd5sum(file);
                    String remote = data.getMd5();
                    pass = this.compareFiles(local, remote, data.getEquate());
                    String logEntry = "Checksum comparisons for " + data.getName() + ".  Installed file checksum:  " + local + ", zip entry last modified:  " + remote;
                    logEntry = pass ? logEntry + "  " + data.getName() + " will be installed" : logEntry + "  " + data.getName() + " will be skipped";
                    this.fileLog.info(logEntry);
                }
            } else {
                String sasHpfSkipFileName = "sasexe/sasdatek";
                if (this._altsku.startsWith("sashpf__") && data.getName().equals(sasHpfSkipFileName)) {
                    this.fileLog.info(data.getName() + " will be skipped");
                    pass = false;
                } else {
                    pass = true;
                    this.fileLog.info(data.getName() + " will be installed unconditionally because it is a new file");
                }
            }
        } else {
            pass = true;
            this.fileLog.info(data.getName() + " will be installed unconditionally because it is a directory");
        }
        return pass;
    }

    private boolean doRestoreComparisons(EntryData data, String filename) {
        if (!data.isUninstall().booleanValue()) {
            return false;
        }
        boolean pass = false;
        File installed = data.getDestination();
        if (data.isNew().booleanValue()) {
            if (0 == this._mode && EntryData.FILE.equals(data.getType()) && installed.exists()) {
                this.getFilesToRemove().put(filename, installed.length());
            }
            pass = true;
        } else {
            File file = new File(this.getController().getBackupDestination(this.getHome(), false), filename);
            if (NONE.equalsIgnoreCase(data.getCompareby())) {
                pass = true;
            } else if (DATE.equalsIgnoreCase(data.getCompareby())) {
                long local = file.lastModified();
                long remote = installed.lastModified();
                pass = this.compareFiles(local, remote, data.getEquate());
            } else if (VERSION.equalsIgnoreCase(data.getCompareby())) {
                boolean versionsCompared = false;
                if (!versionsCompared) {
                    long local = file.lastModified();
                    long remote = installed.lastModified();
                    pass = this.compareFiles(local, remote, data.getEquate());
                }
            } else if (CHECKSUM.equalsIgnoreCase(data.getCompareby())) {
                long remote;
                long local;
                try {
                    CheckedInputStream cis = new CheckedInputStream(new FileInputStream(file), new CRC32());
                    byte[] tempBuf = new byte[128];
                    while (cis.read(tempBuf) >= 0) {
                    }
                    local = cis.getChecksum().getValue();
                    cis.close();
                    cis = new CheckedInputStream(new FileInputStream(file), new CRC32());
                    tempBuf = new byte[128];
                    while (cis.read(tempBuf) >= 0) {
                    }
                    remote = cis.getChecksum().getValue();
                    cis.close();
                }
                catch (Exception e) {
                    throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.FileChecksumError", file.getAbsolutePath()), "An error was encountered while validating checksum data for file " + file.getAbsolutePath(), e);
                }
                pass = this.compareFiles(local, remote, data.getEquate());
            } else if (DELETE.equalsIgnoreCase(data.getCompareby())) {
                if (0 == this._mode) {
                    this.getFilesToAdd().put(filename, file.length());
                }
                return true;
            }
            if (pass && 0 == this._mode) {
                this.getFilesToChange().put(filename, file.length());
            }
        }
        return pass;
    }

    protected void doBackup(EntryData data, File file) throws InstallException {
        if (Controller.defaultController().isHotfix() && EntryData.FILE.equals(data.getType())) {
            if (0 == this._mode) {
                data.notifyBackupForTask(this);
            } else if (1 == this._mode) {
                data.performBackupForTask(this);
            }
        }
    }

    private void gatherFileChanges(EntryData data, File file) {
        if (0 == this._mode && EntryData.FILE.equals(data.getType())) {
            if (data.shouldDelete()) {
                this.getFilesToRemove().put(data.getName(), file.length());
            } else if (data.isNew().booleanValue()) {
                this.getFilesToAdd().put(data.getName(), data.getSize());
            } else {
                this.getFilesToChange().put(data.getName(), data.getSize());
            }
        }
    }

    private void doPermissions(EntryData data) {
        if (1 == this._mode && Utilities.getOS() != 1 && !data.shouldDelete()) {
            if (data.getMode() != null) {
                if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, DiskInfoAPI.libNames)) {
                    String missingLib = JNIUtils.getJniLib(DiskInfoAPI.libNames);
                    throw new InstallException(2, this, this.getBundle().messageString("InstallationTask.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
                }
                try {
                    int success = DiskInfoAPI.SetOctalFileMode(data.getDestination().getAbsolutePath(), data.getMode());
                    if (success != 0) {
                        throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.FilePermissionChangeFailure", data.getMode(), data.getDestination()), "Error setting permissions to " + data.getMode() + " for file " + data.getDestination(), null);
                    }
                }
                catch (Exception e) {
                    throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.FilePermissionChangeFailure", data.getMode(), data.getDestination()), "Error setting permissions to " + data.getMode() + " for file " + data.getDestination(), e);
                }
            }
            if (data.getOwner() != null || data.getGroup() != null) {
                String ownerString = "na";
                String groupString = "na";
                try {
                    int owner = data.getOwner() != null ? DiskInfoAPI.GetFileOwner(data.getDestination().getAbsolutePath()) : Integer.valueOf(data.getOwner());
                    ownerString = String.valueOf(owner);
                    int group = data.getGroup() != null ? DiskInfoAPI.GetFileGroup(data.getDestination().getAbsolutePath()) : Integer.valueOf(data.getGroup());
                    groupString = String.valueOf(group);
                    DiskInfoAPI.SetFileOwnerGroup(data.getDestination().getAbsolutePath(), owner, group);
                    this.fileLog.info("Changing owner/group of " + data.getDestination().getAbsolutePath() + " to " + owner + "/" + group);
                }
                catch (Exception e) {
                    throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.OwnerGroupChangeFailure", ownerString, groupString, data.getDestination()), "Failure changing owner/group to " + ownerString + "/" + groupString + " for file " + data.getDestination(), e);
                }
            }
        }
    }

    protected void generateRestore(EntryData data, File file) {
        if (1 == this._mode) {
            EntryData localFileData = null;
            if (data.isBackup().booleanValue()) {
                localFileData = new EntryData();
                localFileData.setName(data.getName());
                localFileData.setType(data.getType());
                localFileData.setAltDests(data.getAltDests());
                localFileData.setPatch(data.isPatch());
                localFileData.setPatchval(data.getPatchval());
                localFileData.setTkpatch(data.isTkpatch());
                localFileData.setCompareby(NONE);
                localFileData.setEquate("na");
                localFileData.setBackup(data.isBackup());
                localFileData.setDestination(data.getDestination());
                localFileData.setNew(data.isNew());
                if (!data.isNew().booleanValue() && Utilities.getOS() != 1 && Utilities.getOS() != 6 && Utilities.getOS() != 8) {
                    if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, DiskInfoAPI.libNames)) {
                        String missingLib = JNIUtils.getJniLib(DiskInfoAPI.libNames);
                        throw new InstallException(2, this, this.getBundle().messageString("InstallationTask.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
                    }
                    int filemode = DiskInfoAPI.GetOctalFileMode(data.getDestination().getAbsolutePath());
                    localFileData.setMode(filemode);
                    localFileData.setOwnerID(DiskInfoAPI.GetFileOwner(data.getDestination().getAbsolutePath()));
                    localFileData.setGroupID(DiskInfoAPI.GetFileGroup(data.getDestination().getAbsolutePath()));
                }
                localFileData.setReboot(false);
                if (this.getHome().contains(this.getController().getProperty("VJR")) && !data.getDestination().getAbsolutePath().contains(this.getController().getProperty("MVA_VJRPicklistDir"))) {
                    this.fileLog.info(data.getName() + " will not be flagged for removal from " + this.getController().getProperty("VJR") + " during a rollback or uninstall");
                    localFileData.setUninstall(false);
                } else {
                    localFileData.setUninstall(true);
                }
                if (null == this._uninstallMap) {
                    this._uninstallMap = new HashMap();
                }
                this._uninstallMap.put(data.getName(), localFileData);
            }
        }
    }

    private boolean extractEntry(File file, ZipEntry entry, EntryData data) throws IOException, InterruptedException {
        if (1 == this._mode) {
            if (EntryData.FILE.equals(data.getType())) {
                String action = "Changed";
                if (data.isNew().booleanValue()) {
                    action = "Added";
                }
                for (int retryNum = 0; retryNum <= 3; ++retryNum) {
                    try {
                        File parent = file.getParentFile();
                        if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
                            throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.DirectoryCreationError", parent.getAbsolutePath()), "Error creating directory:  " + parent.getAbsolutePath(), null);
                        }
                        this._lastEntry = entry.getName();
                        int origMode = DiskInfoAPI.GetFileMode(file.getAbsolutePath());
                        this.fileLog.info("file " + file.getAbsolutePath() + " has fmode of " + origMode);
                        boolean changedMode = false;
                        if (origMode != -1 && DiskInfoAPI.GetOctalFileMode(file.getAbsolutePath()) % 1000 < 600) {
                            this.fileLog.info("Changing mode of " + file.getAbsolutePath() + " so that we can extract it.");
                            DiskInfoAPI.SetFileMode(file.getAbsolutePath(), 493);
                            changedMode = true;
                        }
                        InputStream is = this._zip.getInputStream(entry);
                        FileOutputStream os = new FileOutputStream(file);
                        this.streamDataWithNotifications(is, os, false);
                        os.close();
                        is.close();
                        String installedMd5 = Utils.getMd5sum(file);
                        if (data.getMd5() != null && !data.getMd5().equals("") && installedMd5 != null && !installedMd5.equals("")) {
                            if (!data.getMd5().equals(installedMd5)) {
                                throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.BadChecksum", file.getAbsolutePath()), "There is a problem installing the file " + file.getAbsolutePath() + ".\n The checksum of the installed file does not match the expected checksum value.\nExpected checksum value: " + data.getMd5() + "\nActual checksum value: " + installedMd5 + "\n", null);
                            }
                        } else {
                            this.log.warn("Skipping checksum validation for file " + file.getAbsolutePath() + " due to insufficient data: expected checksum=" + data.getMd5() + "  actual checksum=" + installedMd5);
                        }
                        boolean fireChangeAction = false;
                        if (Utilities.getOS() == 8 && file.getName().endsWith(".groovy") && Utils.isAscii(file)) {
                            if (!Utils.convertToEbcdic(file)) {
                                throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.AsciiToEbcdicConvertError", file.getAbsolutePath()), "There is a problem converting the file\n" + file.getAbsolutePath() + "\nfrom ASCII to EBCDIC.\n", null);
                            }
                            fireChangeAction = true;
                        }
                        file.setLastModified(data.getLastModified());
                        if (changedMode) {
                            this.fileLog.info("Changing mode of " + file.getAbsolutePath() + " back to " + origMode);
                            DiskInfoAPI.SetFileMode(file.getAbsolutePath(), origMode);
                        }
                        if (fireChangeAction) {
                            data.flushMd5();
                            this.fileLog.info("converted ascii->ebcdic " + file.getAbsolutePath());
                            this.notifyProgressComplete("Changed", data);
                        }
                        this.fileLog.info("extracted " + file.getAbsolutePath());
                        this.notifyProgressComplete(action, data);
                        break;
                    }
                    catch (IOException e) {
                        if (retryNum >= 3) {
                            this.notifyProgressFailure(action, data);
                            this.log.error("Error extracting " + entry.getName() + e);
                            throw e;
                        }
                        String msg = String.format("Error extracting %s, retrying in %d seconds", entry.getName(), RETRY_SLEEP[retryNum] / 1000L);
                        this.log.error(msg);
                        Thread.sleep(RETRY_SLEEP[retryNum]);
                        continue;
                    }
                }
            } else if (EntryData.DIRECTORY.equals(data.getType())) {
                File dir = this.fixDirectory(file);
                if (dir.isDirectory()) {
                    return true;
                }
                if (!dir.mkdirs()) {
                    throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.DirectoryCreationError", dir.getAbsolutePath()), "Error creating directory:  " + dir.getAbsolutePath(), null);
                }
                this.fileLog.info("created directory: " + dir.getAbsolutePath());
            }
        }
        return true;
    }

    private File fixDirectory(File directory) {
        String dir = directory.getAbsolutePath();
        if (dir.endsWith(".")) {
            String modDir = dir.substring(0, dir.length() - 1);
            this.log.info("Trailing '.' removed from directory entry: " + modDir);
            File fixedDirectory = new File(modDir);
            return fixedDirectory;
        }
        return directory;
    }

    @Override
    public void retry() {
        this.openZipFile();
        try {
            this.continueProcessing(this._installMap);
            this.continueProcessing(this._deleteMap);
        }
        finally {
            this.closeZipFile();
        }
    }

    protected void continueProcessing(HashMap<String, EntryData> map) {
        boolean continueProcessing = false;
        for (String key : map.keySet()) {
            EntryData entryData = map.get(key);
            if (!continueProcessing && key.equalsIgnoreCase(this._lastEntry)) {
                continueProcessing = true;
            }
            if (!continueProcessing || null == entryData) continue;
            if (!this.isUndo()) {
                try {
                    ZipEntry entry = this._zip.getEntry(key);
                    this.handleExtraction(entryData, entry);
                    continue;
                }
                catch (Exception e) {
                    throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.ZipFileError", this._zip.getName()), "Error extracting content from zip file " + this._zip.getName(), e);
                }
            }
            this.handleRestoration(entryData, key);
        }
    }

    @Override
    public void rollback() {
        if (null != this._uninstallMap) {
            try {
                HashMap<String, EntryData> uninstallDirectories = new HashMap<String, EntryData>();
                for (String key : this._uninstallMap.keySet()) {
                    EntryData entryData = this._uninstallMap.get(key);
                    if (entryData.getType().equals(EntryData.DIRECTORY)) {
                        uninstallDirectories.put(entryData.getName(), entryData);
                        continue;
                    }
                    if (null == entryData) continue;
                    this.handleRestoration(entryData, key);
                }
                TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
                sortedMap.putAll(uninstallDirectories);
                for (String key : sortedMap.keySet()) {
                    EntryData entryData = (EntryData)sortedMap.get(key);
                    this.handleRestoration(entryData, key);
                }
            }
            catch (Exception e) {
                throw new InstallException(1, this, this.getBundle().messageString("Shared.GenericRollbackFailure"), "Error restoring files", e);
            }
        }
    }

    protected void generateUninstall() {
        if ("false".equalsIgnoreCase(this.getController().getProperty("CreateBackupLoc"))) {
            this.log.info("skipping uninstall data generation because backups are disabled");
            return;
        }
        if (!this.isUndo()) {
            File uninstallData = null;
            try {
                String filename = this.getBase(this.getFilename());
                int lastDirBoundary = filename.lastIndexOf(File.separator);
                if (lastDirBoundary > 0) {
                    filename = filename.substring(lastDirBoundary, filename.length());
                }
                uninstallData = new File(this.getController().metadataBackupDirectory(), filename + ".xml");
                if (this.getController().isMaintenanceVersionCheckingSkipped() && uninstallData.exists()) {
                    this.fileLog.info("Maintenance version checking skipped (forced re-install) and file metadata, " + uninstallData.getAbsolutePath() + " already exists, file metadata will not be overwritten");
                } else {
                    Zip zip = new Zip();
                    ContentsType contents = new ContentsType();
                    zip.setContents(contents);
                    List<EntryType> entryList = contents.getEntry();
                    for (String key : this._uninstallMap.keySet()) {
                        EntryData data = this._uninstallMap.get(key);
                        if (EntryData.FILE.equals(data.getType())) {
                            entryList.add(0, data);
                            continue;
                        }
                        entryList.add(data);
                    }
                    JAXBContext jc = JAXBContext.newInstance("com.sas.tools.installs.it.schema.metadata.gen", this.getClass().getClassLoader());
                    Marshaller m = jc.createMarshaller();
                    m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    m.marshal((Object)zip, new FileOutputStream(uninstallData));
                    this.log.info("Created uninstall zip metadata at " + uninstallData.getAbsolutePath());
                }
            }
            catch (Exception e) {
                throw new InstallException(1, this, this.getBundle().messageString("ZipExtractor.UninstallGenerationError", uninstallData.getAbsolutePath()), "Unable to write out uninstall instructions at " + uninstallData.getAbsolutePath(), e);
            }
        }
    }

    private String getBase(String name) {
        int index;
        String base = "";
        if (null != name && (index = name.lastIndexOf(46)) >= 0) {
            base = name.substring(0, index);
        }
        return base;
    }

    private boolean compareFiles(long local, long remote, String equate) {
        return GREATER_THAN.equalsIgnoreCase(equate) ? remote > local : (GREATER_THAN_EQUALS.equalsIgnoreCase(equate) ? remote >= local : (LESS_THAN.equalsIgnoreCase(equate) ? remote < local : (LESS_THAN_EQUALS.equalsIgnoreCase(equate) ? remote <= local : EQUALS.equalsIgnoreCase(equate) && remote == local)));
    }

    private boolean compareFiles(String local, String remote, String equate) {
        return GREATER_THAN.equalsIgnoreCase(equate) ? remote.compareTo(local) < 0 : (GREATER_THAN_EQUALS.equalsIgnoreCase(equate) ? remote.compareTo(local) <= 0 : (LESS_THAN.equalsIgnoreCase(equate) ? remote.compareTo(local) > 0 : (LESS_THAN_EQUALS.equalsIgnoreCase(equate) ? remote.compareTo(local) >= 0 : EQUALS.equalsIgnoreCase(equate) && remote.equals(local))));
    }

    private boolean compareFiles(long local, long remote, String equate, long milliseconds) {
        return GREATER_THAN.equalsIgnoreCase(equate) ? remote > local && !this.equalWithinMilliseconds(local, remote, milliseconds) : (GREATER_THAN_EQUALS.equalsIgnoreCase(equate) ? remote >= local || this.equalWithinMilliseconds(local, remote, milliseconds) : (LESS_THAN.equalsIgnoreCase(equate) ? remote < local && !this.equalWithinMilliseconds(local, remote, milliseconds) : (LESS_THAN_EQUALS.equalsIgnoreCase(equate) ? remote <= local || this.equalWithinMilliseconds(local, remote, milliseconds) : EQUALS.equalsIgnoreCase(equate) && (remote == local || this.equalWithinMilliseconds(local, remote, milliseconds)))));
    }

    private boolean equalWithinMilliseconds(long epoch1, long epoch2, long milliseconds) {
        return Math.abs(epoch1 - epoch2) <= milliseconds;
    }

    public void updateFilenameForUndo(String name) {
        this._sourceFile = new File(this.getController().metadataBackupDirectory(), name).getAbsolutePath();
    }

    @Override
    public void setUndo(boolean undo) {
        super.setUndo(undo);
        if (undo && this._filename != null) {
            this.updateFilenameForUndo(this._filename);
        }
    }

    @Deprecated
    public String getEvent() {
        return "";
    }

    @Deprecated
    public void setEvent(String event) {
    }

    public String getAction() {
        if (this._action == 0) {
            return "RETRY";
        }
        if (this._action == 1) {
            return "ROLLBACK";
        }
        return "RETRY";
    }

    public void setAction(String action) {
        if ("RETRY".equalsIgnoreCase(action)) {
            this._action = 0;
        } else if ("ROLLBACK".equalsIgnoreCase(action)) {
            this._action = 1;
        }
    }

    public String getDownloadLocation() {
        return this.getHome() + "/downloads\\";
    }

    public String getHome() {
        if (this.dataProperties.get("home") == null) {
            String home = ((Extract)this.getData()).getHome();
            if (home == null || home.length() == 0) {
                this.dataProperties.put("home", System.getProperty("SASHome"));
            } else {
                this.dataProperties.put("home", this.resolveProperty(home));
            }
        }
        return (String)this.dataProperties.get("home");
    }

    public String getFilename() {
        if (this.dataProperties.get("filename") == null) {
            String name = ((Extract)this.getData()).getFilename();
            if (this.isUndo()) {
                this.updateFilenameForUndo(name);
            } else {
                this._sourceFile = new File(this.getController().getPackageDir(), name).getAbsolutePath();
            }
            this.dataProperties.put("filename", this._sourceFile);
        }
        return (String)this.dataProperties.get("filename");
    }

    public String getSource() {
        return ((Extract)this.getData()).getSource();
    }

    @Override
    public String descriptionForLog() {
        return "Extract task:  file=>" + this.getFilename() + ", source=>" + this.getSource();
    }

    public Zip getJaxbZip() {
        return this._jaxbZip;
    }

    public void setJaxbZip(Zip jaxbZip) {
        this._jaxbZip = jaxbZip;
    }

    protected File getZipFile() {
        if (this.getData() == null) {
            return null;
        }
        String basename = this.getBase(new File(this.getFilename()).getName());
        File zip = new File(this.getController().getCurrentContext().getPayloadDir(), basename + ".zip");
        if (zip.exists() && zip.isFile()) {
            return zip;
        }
        String metaFile = this.getFilename();
        return new File(this.getBase(metaFile) + ".zip");
    }
}

