/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.ArrayValue;
import com.sas.tools.installs.it.schema.install.gen.EditSASConfig;
import com.sas.tools.installs.it.schema.install.gen.OptionValue;
import com.sas.tools.installs.it.schema.install.gen.Substitution;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.SASConfigFile;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class EditSASConfigTask
extends InstallationTask {
    private static final String DEFAULT = "";
    private static final String UTF8_Encoding = "UTF-8";
    protected Logger log = (Logger)LogManager.getLogger(this.getClass().getName());
    public static Integer platform;
    public static char quote;
    protected String _langCode = "";
    protected String _langName = "";
    protected Boolean _langDBCS = false;
    protected String _dbcstype = "";
    protected Boolean _nlsUpdate = false;
    protected static String[] dbcsLangs;
    protected static final String CHINESE_HK_LANG_CODE = "zx";
    protected String _configFile;
    protected String _newArrayValue;
    protected boolean _quoteValues = true;
    protected Map<String, String> _backupConfigFile = new HashMap<String, String>();
    protected File nlsDir;
    protected String _langDirPath;
    protected String _sashome_locale = "";
    protected String _sashome_encoding = "";
    protected Map<String, String> _pathOptionDirs = new HashMap<String, String>();
    protected Map<String, String> _installedCfgFiles = new HashMap<String, String>();
    protected Map<String, String> _sasExtPaths = new HashMap<String, String>();
    public static final String CONFIG_FILE_NAME = "sasv9.cfg";
    public static final String NLS_DIR = "nls";
    public static final Integer UNX;
    public static final Integer WIN;
    public static final String DIR_SASAUTOS = "sasmacro";
    public static final String DIR_SASHELP = "sashelp";
    public static final String DIR_MSG = "sasmsg";
    public static final String DIR_SAMPSIO = "sample";
    public static final String DIR_SAMPSRC = "sample";
    public static final String DIR_INSTALL = "test";
    public static final String DIR_PATH = "sasexe";
    public static final String DIR_MAPS = "maps";
    protected static final String LIST_ITEM_FIRST = "!SASCFG";
    protected static final String LIST_ITEM_SECOND = "nls_";
    protected static final String LIST_ITEM_THIRD = "dbcs";
    protected static final String LIST_ITEM_FOURTH = "base";
    protected static final String REF_SASROOT = "*SASROOT*";
    protected static final String REF_SASNLS = "*SASNLS*";
    protected static final String REF_SASEXT = "*SASEXT*";
    protected static final String REF_PLATFORM = "*SASPLATFORM*";
    public static String ADD;
    public static String REMOVE;
    public static String REPLACE;
    private static final String SET = "SET";
    private static final String APPEND = "APPEND";
    private static final String INSERT = "INSERT";
    private static final String EMPTY = "";
    protected static final String REF_FORMCHAR = "formchar_for_lang";
    protected static final String DASH_FORMCHAR = "-FORMCHAR";
    protected static final String FORMCHAR_ANSI = "'7c2d2d2d2d7c2b7c2d2d2d2b3d7c2d2f5c3c3e2a'x";
    protected static final String FORMCHAR_SASFONT = "'82838485868788898A8B8C2B3D7C2D2F5C3C3E2A'x";
    private final Map<String, Boolean> prefixRepeatable = new HashMap<String, Boolean>();
    private Map<String, String> sasFormChars = new HashMap<String, String>();
    public static final String SAS_WOW_TAG = "(32)";
    public static final boolean WINDOWS_OS;
    protected String[] _langList;
    String _installDir = null;
    Set<String> _selected_languages = new HashSet<String>(Arrays.asList(Controller.installProperties.getProperty("selected.or.installed.languages").split(",")));
    private SASConfigFile _sasConfigFile;

    public EditSASConfigTask() {
        this.prefixRepeatable.put("", Boolean.FALSE);
        this.prefixRepeatable.put(SET, Boolean.FALSE);
        this.prefixRepeatable.put(INSERT, Boolean.TRUE);
        this.prefixRepeatable.put(APPEND, Boolean.TRUE);
        this.sasFormChars.put("en", FORMCHAR_SASFONT);
        this.sasFormChars.put("fr", FORMCHAR_SASFONT);
        this.sasFormChars.put("it", FORMCHAR_SASFONT);
        this.sasFormChars.put("es", FORMCHAR_SASFONT);
        this.sasFormChars.put("de", FORMCHAR_SASFONT);
        this.sasFormChars.put("da", FORMCHAR_SASFONT);
        this.sasFormChars.put("sv", FORMCHAR_SASFONT);
        this.sasFormChars.put("1d", FORMCHAR_ANSI);
        this.sasFormChars.put("pl", FORMCHAR_ANSI);
        this.sasFormChars.put("hu", FORMCHAR_ANSI);
        this.sasFormChars.put("cs", FORMCHAR_ANSI);
        this.sasFormChars.put("zh", FORMCHAR_ANSI);
        this.sasFormChars.put("zt", FORMCHAR_ANSI);
        this.sasFormChars.put("ja", FORMCHAR_ANSI);
        this.sasFormChars.put("ko", FORMCHAR_ANSI);
        this.sasFormChars.put("ru", FORMCHAR_ANSI);
        this.sasFormChars.put("u8", FORMCHAR_ANSI);
    }

    @Override
    public String descriptionForLog() {
        return "EditSASConfig";
    }

    @Override
    public void preExecute() throws Exception {
        this.log.debug("in SASConfigEditor preExecute");
        if (this.isUndo()) {
            return;
        }
        this.setInstallDir();
        this.getPathOptionDirs().put("SASAUTOS", DIR_SASAUTOS);
        this.getPathOptionDirs().put("SASHELP", DIR_SASHELP);
        this.getPathOptionDirs().put("MSG", DIR_MSG);
        this.getPathOptionDirs().put("SAMPSIO", "sample");
        this.getPathOptionDirs().put("SAMPSRC", "sample");
        this.getPathOptionDirs().put("INSTALL", DIR_INSTALL);
        this.getPathOptionDirs().put("location", DIR_PATH);
        this.setNlsDir(new File(this.getController().getProperty("ProductHome"), NLS_DIR));
        if (Utilities.getOS() == 1) {
            this.log.debug("SASConfigEditor::preExecute() - Windows platform detected.");
            platform = WIN;
            quote = (char)34;
        } else if (Utilities.getOS() != 1 && Utilities.getOS() != 6 && Utilities.getOS() != 8) {
            this.log.debug("SASConfigEditor::preExecute() - Unix platform detected.");
            platform = UNX;
            quote = (char)39;
        }
        this.performActions("preexecute");
        if (this.getLangCode() == null) {
            this.setLangCode("");
        }
    }

    @Override
    public void postExecute() throws Exception {
        this.log.debug("in SASConfigEditor postExecute");
    }

    @Override
    public void retry() throws InstallException {
        this.log.debug("in SASConfigEditor retry");
    }

    @Override
    public void execute() {
        this.log.debug("in SASConfigEditor execute");
        this.log.info("---> CONFIG EDITOR FIX FOR CASE MISMATCH <---");
        if (this.isUndo()) {
            this.rollback();
            return;
        }
        this._sashome_locale = Controller.installProperties.getProperty("sashome.locale.name");
        this._sashome_encoding = Controller.installProperties.getProperty("sashome.encoding.for.selected.locale");
        this.log.debug("SASConfigEditor::execute() - _sashome_locale = " + this._sashome_locale);
        this.log.debug("SASConfigEditor::execute() - _sashome_encoding = " + this._sashome_encoding);
        this.log.info("Selected languages: " + Controller.installProperties.getProperty("selected.languages"));
        this.log.debug("SASConfigEditor::execute() - langCode = " + this.getLangCode());
        if (this._selected_languages.contains(CHINESE_HK_LANG_CODE)) {
            this._selected_languages.remove(CHINESE_HK_LANG_CODE);
        }
        this.log.info("Selected languages: " + this._selected_languages);
        File cfgFile = this.determineCfgFile();
        if (cfgFile != null && cfgFile.exists()) {
            this.getInstalledCfgFiles().put(this.getLangCode(), cfgFile.getAbsolutePath());
            this.log.debug("SASConfigEditor::execute() - found " + this.getInstalledCfgFiles().size() + " files to handle");
            this.doEditConfigFiles();
            return;
        }
        if (TaskHelper.isWindows() && "".equals(this.getLangCode())) {
            String[] selectedLangs = this._selected_languages.toArray(new String[0]);
            for (int i = 0; i < selectedLangs.length; ++i) {
                String sLanguage = selectedLangs[i];
                this.log.info("Selected language: " + sLanguage);
                File cfgFile1 = new File(new File(this.getNlsDir(), sLanguage), CONFIG_FILE_NAME);
                if (!cfgFile1.exists()) continue;
                this.getInstalledCfgFiles().put(sLanguage, cfgFile1.getAbsolutePath());
                this.log.debug("SASConfigEditor::execute() - found " + this.getInstalledCfgFiles().size() + " files to handle");
                this.doEditConfigFiles();
            }
            return;
        }
    }

    private File copyCfgFilesToProductHome() {
        File cfgFile = null;
        this._selected_languages.add("en");
        this._selected_languages.add("u8");
        this._selected_languages.add("1d");
        this.log.info("getLangCode() is " + this.getLangCode());
        if ("".equals(this.getLangCode())) {
            String[] selectedLangs = this._selected_languages.toArray(new String[0]);
            for (int i = 0; i < selectedLangs.length; ++i) {
                String sLanguage = selectedLangs[i];
                this.log.info("sLanguage: " + sLanguage);
                File cfgFile2 = new File(new File(this.getNlsDir(), sLanguage), CONFIG_FILE_NAME);
                if (cfgFile2.exists()) continue;
                File cfgFileTemplate = null;
                cfgFileTemplate = new File(Utils.joinPath(this.getController().getProperty("ProductHome"), "core\\sasmisc\\deployment", CONFIG_FILE_NAME));
                this.log.info("cfgFileTemplate is " + cfgFileTemplate);
                if (!cfgFileTemplate.exists()) continue;
                this.copyFile(cfgFileTemplate, cfgFile2);
                this.deleteAtUninstall(cfgFile2, this.getTarget());
            }
        }
        if (this._selected_languages.contains(this.getLangCode())) {
            this.log.info("Processing product: " + this.getController().getProperty("ProductName") + " for language: " + this.getController().getProperty("ProductLanguage"));
            cfgFile = new File(new File(this.getNlsDir(), this.getLangCode()), CONFIG_FILE_NAME);
            if (!cfgFile.exists()) {
                File cfgFileTemplate = null;
                cfgFileTemplate = new File(Utils.joinPath(this.getController().getProperty("ProductHome"), "core\\sasmisc\\deployment", CONFIG_FILE_NAME));
                if (cfgFileTemplate.exists()) {
                    this.copyFile(cfgFileTemplate, cfgFile);
                    this.deleteAtUninstall(cfgFile, this.getTarget());
                } else {
                    this.log.warn("Config file not found " + cfgFile.getAbsolutePath());
                    cfgFile = null;
                }
            }
        }
        return cfgFile;
    }

    private File determineCfgFile() {
        File cfgFile = null;
        cfgFile = TaskHelper.getOS() == 1 ? this.copyCfgFilesToProductHome() : ("".equals(this.getLangCode()) ? new File(this.getController().getProperty("ProductHome"), CONFIG_FILE_NAME) : new File(new File(this.getNlsDir(), this.getLangCode()), CONFIG_FILE_NAME));
        return cfgFile;
    }

    private SASConfigFile getSASConfigFile() {
        return this._sasConfigFile;
    }

    private void setSASConfigFile(SASConfigFile sasConfigFile) {
        this._sasConfigFile = sasConfigFile;
    }

    private void replaceText(String name, String pattern, String value) {
        if (name.equals("")) {
            this.getSASConfigFile().replaceAll(pattern, value);
        }
    }

    private void addOption(String name, String prefix, String value) {
        if (this.getSASConfigFile().optionExists(name) && !this.isRepeatablePrefix(prefix)) {
            this.log.info("Option " + name + " already exists in the configuration file. Update not needed.");
        } else {
            String oldValue;
            if (this.getSASConfigFile().optionExists(name) && (oldValue = this.getSASConfigFile().getScalarOptionValue(name)).indexOf(value) > -1) {
                this.log.info("Option " + name + ":" + value + " already exists in the configuration file. Update not needed.");
                return;
            }
            this.log.info("Adding an option in config files: " + name + "," + prefix + "," + value);
            String newVal = this.replacePathRefs(value);
            newVal = this.resolveProperty(newVal);
            if (newVal.equals("")) {
                this.getSASConfigFile().addScalarOption(name, prefix);
            } else {
                this.getSASConfigFile().addScalarOption(name, newVal, prefix);
            }
        }
    }

    private boolean isRepeatablePrefix(String prefix) {
        Boolean isRepeatable = this.prefixRepeatable.get(prefix);
        return isRepeatable == null ? false : isRepeatable;
    }

    private void replaceOption(String name, String prefix, String value) {
        this.log.info("Replacing an option in config files");
        this.getSASConfigFile().replaceScalarOptionValue(name, this.replacePathRefs(this.resolveProperty(value)));
    }

    private void removeOption(String name, String prefix, String value) {
        this.log.info("Removing an option from config files");
        this.getSASConfigFile().removeOption(name);
    }

    protected void addArrayValue(String name, String pattern, String value, String prefix) {
        this.log.info("Adding a value to an option in config files");
        String newVal = this.replacePathRefs(value);
        newVal = this.resolveProperty(newVal);
        if (this.getSASConfigFile().arrayValueExists(name, newVal, prefix)) {
            this.log.info("Array value " + newVal + "  already exists in option " + name + ".  Update not needed.");
        } else {
            this.log.info("Adding an array value in config files: " + name + "," + pattern + "," + value);
            String pathToAdd = "";
            String listTag = "";
            if (name.equalsIgnoreCase("JREOPTIONS")) {
                listTag = "entry";
                pathToAdd = newVal;
                if (platform == WIN) {
                    if (!JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, SASWinAPI.libNames)) {
                        String missingLib = JNIUtils.getJniLib(SASWinAPI.libNames);
                        throw new InstallException(1, null, this.getBundle().messageString("Controller.MissingJNILib", missingLib), "Unable to load library: " + missingLib, null);
                    }
                    int start = newVal.indexOf(61);
                    if (start > 0) {
                        String path = newVal.substring(newVal.indexOf(61) + 1);
                        File pathToCheck = new File(path);
                        if (pathToCheck.exists()) {
                            pathToAdd = SASWinAPI.GetShortPath(path);
                            this.log.info("pathToCheck was found: " + pathToAdd);
                            pathToAdd = newVal.substring(0, start + 1) + pathToAdd;
                        } else {
                            this.log.info("pathToCheck was NOT FOUND: " + path);
                        }
                        if (this.getSASConfigFile().arrayValueExists(name, pathToAdd, prefix)) {
                            this.log.debug("EditSASConfigTask::replaceArrayValue() - removing short path value " + pathToAdd + "........... ");
                            this.getSASConfigFile().removeArrayOptionValue(name, pathToAdd);
                        }
                    }
                }
                if (newVal.startsWith("-Dlog4j.configuration=") || newVal.startsWith("-Dlog4j.configurationFile=")) {
                    pathToAdd = this.setPathToURL(newVal);
                    if (this.getSASConfigFile().arrayValueExists(name, pathToAdd, prefix)) {
                        this.log.debug("EditSASConfigTask::replaceArrayValue() - removing url path value " + pathToAdd + "........... ");
                        this.getSASConfigFile().removeArrayOptionValue(name, pathToAdd);
                    }
                }
            } else {
                listTag = "location";
                pathToAdd = quote + newVal + quote;
            }
            this.getSASConfigFile().addArrayOptionValue(name, listTag, pathToAdd, prefix);
        }
    }

    private void removeArrayValue(String name, String pattern, String value) {
        this.getSASConfigFile().removeArrayOptionValue(name, this.replacePathRefs(value));
    }

    private void replaceArrayValue(String name, String pattern, String value, String prefix) {
        this.log.info("Replacing a value in an option in config files");
        this.log.debug("EditSASConfigTask::replaceArrayValue() - name = " + name);
        this.log.debug("EditSASConfigTask::replaceArrayValue() - value = " + value);
        this.log.debug("EditSASConfigTask::replaceArrayValue() - pattern = " + pattern);
        if (this.getSASConfigFile().arrayValueExists(name, pattern, prefix)) {
            this.log.debug("EditSASConfigTask::replaceArrayValue() - removing pattern........... ");
            this.getSASConfigFile().removeArrayOptionValue(name, pattern);
        } else {
            this.log.debug("replaceArrayValue: value not found, adding value");
        }
        String newVal = this.replacePathRefs(value);
        newVal = this.resolveProperty(newVal);
        if (this.getSASConfigFile().arrayValueExists(name, newVal, prefix)) {
            this.log.debug("EditSASConfigTask::replaceArrayValue() - removing resolved value " + newVal + "........... ");
            this.getSASConfigFile().removeArrayOptionValue(name, newVal);
        }
        if (!this.getSASConfigFile().arrayValueExists(name, newVal, prefix)) {
            String pathToAdd = "";
            String listTag = "";
            if (name.equalsIgnoreCase("JREOPTIONS")) {
                listTag = "entry";
                pathToAdd = newVal;
                if (platform == WIN) {
                    if (!JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, SASWinAPI.libNames)) {
                        String missingLib = JNIUtils.getJniLib(SASWinAPI.libNames);
                        throw new InstallException(1, null, this.getBundle().messageString("Controller.MissingJNILib", missingLib), "Unable to load library: " + missingLib, null);
                    }
                    int start = newVal.indexOf(61);
                    if (start > 0) {
                        String path = newVal.substring(newVal.indexOf(61) + 1);
                        File pathToCheck = new File(path);
                        if (pathToCheck.exists()) {
                            pathToAdd = SASWinAPI.GetShortPath(path);
                            this.log.info("pathToCheck was found: " + pathToAdd);
                            pathToAdd = newVal.substring(0, start + 1) + pathToAdd;
                        } else {
                            this.log.info("pathToCheck was NOT FOUND: " + path);
                        }
                        if (this.getSASConfigFile().arrayValueExists(name, pathToAdd, prefix)) {
                            this.log.debug("EditSASConfigTask::replaceArrayValue() - removing short path value " + pathToAdd + "........... ");
                            this.getSASConfigFile().removeArrayOptionValue(name, pathToAdd);
                        }
                    }
                }
                if (newVal.startsWith("-Dlog4j.configuration=") || newVal.startsWith("-Dlog4j.configurationFile=")) {
                    pathToAdd = this.setPathToURL(newVal);
                    if (this.getSASConfigFile().arrayValueExists(name, pathToAdd, prefix)) {
                        this.log.debug("EditSASConfigTask::replaceArrayValue() - removing url path value " + pathToAdd + "........... ");
                        this.getSASConfigFile().removeArrayOptionValue(name, pathToAdd);
                    }
                }
            } else {
                listTag = "location";
                pathToAdd = quote + newVal + quote;
            }
            this.log.debug("EditSASConfigTask::replaceArrayValue() - Calling addArrayOptionValue() ");
            this.log.debug("EditSASConfigTask::replaceArrayValue() - name = " + name);
            this.log.debug("EditSASConfigTask::replaceArrayValue() - listTag = " + listTag);
            this.log.debug("EditSASConfigTask::replaceArrayValue() - pathToAdd = " + pathToAdd);
            this.log.debug("EditSASConfigTask::replaceArrayValue() - prefix = " + prefix);
            this.getSASConfigFile().addArrayOptionValue(name, listTag, pathToAdd, prefix);
        }
    }

    @Override
    public void rollback() {
        this.log.debug("in SASConfigEditor rollback");
        for (String cfgKey : this.getBackupConfigFile().keySet()) {
            this.log.info("Restoring SAS configuration files with backups");
            File cfgFile = new File(cfgKey);
            File bkupFile = new File(this.getBackupConfigFile().get(cfgKey));
            if (!bkupFile.exists() || !cfgFile.exists() || !cfgFile.canWrite()) continue;
            if (cfgFile.delete()) {
                if (!Utils.moveFile(bkupFile, cfgFile)) {
                    throw new InstallException(1, this, this.getBundle().messageString("SASConfigEditor.ConfigFileRestorationError", cfgFile.getAbsolutePath(), bkupFile.getAbsolutePath()), "Failure restoring " + cfgKey + " from " + this.getBackupConfigFile().get(cfgKey) + " during rollback", null);
                }
                this.log.info("Rollback successfully restored " + cfgFile.getAbsolutePath());
                continue;
            }
            this.log.info("Rollback failed to delete " + cfgFile.getAbsolutePath() + " Backup file " + bkupFile.getAbsolutePath() + " was not restored.");
        }
    }

    private void performActions(String mode) {
        String value;
        String name;
        String action;
        List<ArrayValue> arrayValueList = ((EditSASConfig)this.getData()).getArrayValue();
        List<OptionValue> optionValueList = ((EditSASConfig)this.getData()).getOptionValue();
        List<Substitution> substitutionList = ((EditSASConfig)this.getData()).getSubstitution();
        this.setLangCode(((EditSASConfig)this.getData()).getLanguage());
        this.log.debug("SASConfigEditor::performAction(" + mode + ")");
        this.log.debug("SASConfigEditor::performAction() - have " + arrayValueList.size() + " array values");
        for (ArrayValue arrayValue : arrayValueList) {
            action = this.fixParameter(arrayValue.getAction());
            name = this.fixParameter(arrayValue.getName());
            value = this.fixValue(arrayValue.getValue());
            String pattern = arrayValue.getPattern();
            String prefix = arrayValue.getPrefix();
            this.log.debug("action=" + action + ", name=" + name + ", value=" + value + ", pattern=" + pattern);
            if (ADD.equals(action)) {
                if ("preexecute".equalsIgnoreCase(mode)) {
                    if (this.checkParameter(name).booleanValue() && this.checkParameter(value, true).booleanValue()) continue;
                    this.log.info("Install.xml is missing a required parameter for arrayValue action " + action + ".");
                    continue;
                }
                if (!"execute".equalsIgnoreCase(mode)) continue;
                this.addArrayValue(name, pattern, value, prefix);
                continue;
            }
            if (REMOVE.equals(action)) {
                if ("preexecute".equalsIgnoreCase(mode)) {
                    if (this.checkParameter(name).booleanValue()) continue;
                    this.log.info("Install.xml is missing a required parameter for arrayValue action " + action + ".");
                    continue;
                }
                if (!"execute".equalsIgnoreCase(mode)) continue;
                this.removeArrayValue(name, pattern, value);
                continue;
            }
            if (!REPLACE.equals(action)) continue;
            if ("preexecute".equalsIgnoreCase(mode)) {
                if (this.checkParameter(name).booleanValue() && this.checkParameter(value, true).booleanValue() && this.checkParameter(pattern).booleanValue()) continue;
                this.log.info("Install.xml is missing a required parameter for arrayValue action " + action + ".");
                continue;
            }
            if (!"execute".equalsIgnoreCase(mode)) continue;
            this.replaceArrayValue(name, pattern, value, prefix);
        }
        this.log.debug("SASConfigEditor::performAction() - have " + optionValueList.size() + " option values");
        for (OptionValue optionValue : optionValueList) {
            action = this.fixParameter(optionValue.getAction());
            name = this.fixParameter(optionValue.getName());
            value = this.fixValue(optionValue.getValue());
            String prefix = this.fixValue(this.fixParameter(optionValue.getPrefix()));
            this.log.debug("action=" + action + ", name=" + name + ", value=" + value + ", prefix=" + prefix);
            if (ADD.equals(action)) {
                String localeLangCode;
                if ("preexecute".equalsIgnoreCase(mode)) {
                    if (this.checkParameter(name).booleanValue() && this.checkParameter(prefix, true).booleanValue()) continue;
                    this.log.info("Install.xml is missing a required parameter for option action " + action + ".");
                    continue;
                }
                if (!"execute".equalsIgnoreCase(mode)) continue;
                if (name.equalsIgnoreCase("LOCALE") && !this._sashome_locale.equals("")) {
                    localeLangCode = EditSASConfigTask.localeToLang2(this._sashome_locale, false);
                    if ("en".equalsIgnoreCase(this.getLangCode())) {
                        if (!this._sashome_locale.equalsIgnoreCase("en_US") && !EditSASConfigTask.isDBCS(localeLangCode)) {
                            value = this._sashome_locale;
                        }
                    } else if ("u8".equalsIgnoreCase(this.getLangCode())) {
                        value = this._sashome_locale;
                    } else if ("1d".equalsIgnoreCase(this.getLangCode()) || LIST_ITEM_THIRD.equalsIgnoreCase(this.getLangCode())) {
                        if (!this._sashome_locale.equalsIgnoreCase("en_US") && EditSASConfigTask.isDBCS(localeLangCode)) {
                            value = this._sashome_locale;
                        }
                    } else if (localeLangCode.equalsIgnoreCase(this.getLangCode())) {
                        value = this._sashome_locale;
                    }
                }
                if (name.equalsIgnoreCase("ENCODING") && !this._sashome_encoding.equals("")) {
                    localeLangCode = EditSASConfigTask.localeToLang2(this._sashome_locale, false);
                    if ("en".equalsIgnoreCase(this.getLangCode())) {
                        if (!(this._sashome_locale.equalsIgnoreCase("en_US") || this._sashome_encoding.equalsIgnoreCase(UTF8_Encoding) || EditSASConfigTask.isDBCS(localeLangCode))) {
                            value = this._sashome_encoding;
                        }
                    } else if ("1d".equalsIgnoreCase(this.getLangCode()) || LIST_ITEM_THIRD.equalsIgnoreCase(this.getLangCode())) {
                        if (!this._sashome_locale.equalsIgnoreCase("en_US") && EditSASConfigTask.isDBCS(localeLangCode)) {
                            value = this._sashome_encoding;
                        }
                    } else if (localeLangCode.equalsIgnoreCase(this.getLangCode())) {
                        value = this._sashome_encoding;
                    }
                }
                if (name.equalsIgnoreCase("FONTSLOC") && WINDOWS_OS && System.getenv("SystemRoot") != null) {
                    value = System.getenv("SystemRoot") + "\\Fonts";
                }
                this.addOption(name, prefix, value);
                continue;
            }
            if (REMOVE.equals(action)) {
                if ("preexecute".equalsIgnoreCase(mode)) {
                    if (this.checkParameter(name).booleanValue()) continue;
                    this.log.info("Install.xml is missing a required parameter for option action " + action + ".");
                    continue;
                }
                if (!"execute".equalsIgnoreCase(mode)) continue;
                this.removeOption(name, prefix, value);
                continue;
            }
            if (!REPLACE.equals(action)) continue;
            if ("preexecute".equalsIgnoreCase(mode)) {
                if (this.checkParameter(name).booleanValue() || !this.checkParameter(value, true).booleanValue()) continue;
                this.log.info("Install.xml is missing a required parameter for option action " + action + ".");
                continue;
            }
            if (!"execute".equalsIgnoreCase(mode)) continue;
            if (name.equalsIgnoreCase("FORMCHAR")) {
                value = this.getFormChars(this.getLangCode());
            }
            this.replaceOption(name, prefix, value);
        }
        this.log.debug("SASConfigEditor::performAction() - have " + substitutionList.size() + " substitution values");
        for (Substitution substitution : substitutionList) {
            String name2 = this.fixParameter(substitution.getName());
            String value2 = this.fixValue(substitution.getValue().getValue());
            String pattern = substitution.getPattern();
            this.log.debug("name=" + name2 + ", value=" + value2 + ", pattern=" + pattern);
            if ("preexecute".equalsIgnoreCase(mode)) {
                if (this.checkParameter(pattern).booleanValue() && this.checkParameter(value2, true).booleanValue()) continue;
                this.log.info("Install.xml is missing a required parameter for substitution " + name2 + " (" + pattern + "," + value2 + ").");
                continue;
            }
            if (!"execute".equalsIgnoreCase(mode)) continue;
            this.replaceText(name2, pattern, value2);
        }
    }

    public String getLangCode() {
        return this._langCode;
    }

    public void setLangCode(String langCode) {
        this._langCode = langCode;
    }

    public boolean isLangDBCS() {
        return this._langDBCS;
    }

    public void setLangDBCS(String langDBCS) {
        this._langDBCS = Boolean.parseBoolean(langDBCS);
    }

    public String getDbcstype() {
        return this._dbcstype;
    }

    public void setDbcstype(String typeDBCS) {
        this._dbcstype = typeDBCS;
    }

    public String getLangName() {
        return this._langName;
    }

    public void setLangName(String langName) {
        this._langName = langName;
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public String getConfigFile() {
        return this._configFile;
    }

    protected void setBackupConfigFile(HashMap<String, String> backupConfigFile) {
        this._backupConfigFile = backupConfigFile;
    }

    protected Map<String, String> getBackupConfigFile() {
        return this._backupConfigFile;
    }

    public boolean isQuoteValues() {
        return this._quoteValues;
    }

    public void setQuoteValues(boolean useQuotes) {
        this._quoteValues = useQuotes;
    }

    private File getNlsDir() {
        return this.nlsDir;
    }

    private void setNlsDir(File nlsDir) {
        this.nlsDir = nlsDir;
    }

    public String getLangDirPath() {
        return this._langDirPath;
    }

    public void setLangDirPath(String langDir) {
        this._langDirPath = langDir;
    }

    protected Map<String, String> getPathOptionDirs() {
        return this._pathOptionDirs;
    }

    protected void setPathOptionDirs(HashMap<String, String> pathOptionDirs) {
        this._pathOptionDirs = pathOptionDirs;
    }

    protected Map<String, String> getSasExtPaths() {
        return this._sasExtPaths;
    }

    protected void setSasExtPaths(HashMap<String, String> sasExtPaths) {
        this._sasExtPaths = sasExtPaths;
    }

    protected Map<String, String> getSasFormChars() {
        return this.sasFormChars;
    }

    protected void setSasFormChars(HashMap<String, String> sasFormCharValue) {
        this.sasFormChars = sasFormCharValue;
    }

    protected Map<String, String> getInstalledCfgFiles() {
        return this._installedCfgFiles;
    }

    protected String getInstallDir() {
        return this._installDir;
    }

    protected void setInstallDir() {
        this._installDir = Controller.defaultController().getProperty("ProductHome");
    }

    protected String getExtPath(String extKey) {
        return this.getSasExtPaths().get(extKey);
    }

    protected String getFormChars(String langKey) {
        String formChars = this.getSasFormChars().get(langKey);
        return formChars == null ? FORMCHAR_ANSI : formChars;
    }

    protected String[] getLangList() {
        return this._langList;
    }

    protected void setLangList(String[] langlist) {
        this._langList = langlist;
    }

    protected void buildConfigForLang(String langCode, String langName) {
        this.log.debug("In buildConfigForLang");
        File langDirPath = new File(this.getLangDirPath());
        Integer priority = 0;
        this.log.debug("in SASConfigEditor buildConfigForLang ");
        this.log.debug("   langCode = " + langCode);
        this.log.debug("   langName = " + langName);
        SASConfigFile cfgTemplate = this.getSASConfigFile();
        if (platform == WIN) {
            String sasext = cfgTemplate.getScalarOptionValue("sasext0");
            String nlsExtPath = sasext.contains("\\nls") ? "!sasext0" : ((sasext = cfgTemplate.getScalarOptionValue("sasext1")).contains("\\nls") ? "!sasext1" : "!sasroot");
            cfgTemplate.replaceAll("nls\\en", "nls\\" + langCode);
            if (this.isLangDBCS()) {
                this.log.debug("New language is DBCS");
                cfgTemplate.removeOption("LOCALE");
                cfgTemplate.addScalarOption("DBCS", "");
                cfgTemplate.addScalarOption("DBCSLANG", langName, "");
                priority = 2;
                cfgTemplate.addArrayOptionValue("location", "location", "\"!sasroot\\dbcs\\sasexe\"", "");
            } else {
                this.log.debug("New language is NOT DBCS");
                cfgTemplate.replaceScalarOptionValue("LOCALE", langName);
            }
            for (String key : this.getPathOptionDirs().keySet()) {
                String dirName = this.getPathOptionDirs().get(key);
                File dirPath = new File(langDirPath, dirName);
                if (dirPath.exists()) {
                    priority = key.equalsIgnoreCase(DIR_SASHELP) ? Integer.valueOf(1) : Integer.valueOf(0);
                    cfgTemplate.addArrayOptionValue(key, "location", "\"" + nlsExtPath + "\\" + langCode + "\\" + dirName + "\"", "");
                    continue;
                }
                this.log.debug(key + " does NOT use path " + dirPath.getAbsolutePath());
            }
        } else if (platform == UNX) {
            cfgTemplate.removeOption(DIR_SASHELP);
            this.log.debug("Creating Vector newArrayStuff for newLangID = " + langCode);
            Vector<String> newArrayStuff = new Vector<String>();
            this.log.debug("Adding /sascfg to newArrayStuff");
            newArrayStuff.add("'!SASROOT/nls/" + langCode + "/sascfg'");
            this.log.debug("Adding /sashelp to newArrayStuff");
            newArrayStuff.add(1, "'!SASROOT/nls/" + langCode + "/sashelp'");
            this.log.debug("Calling addArrayOption");
            cfgTemplate.addArrayOption(DIR_SASHELP, "location", "", newArrayStuff);
            if (this.isLangDBCS()) {
                this.log.debug("New language is DBCS");
                cfgTemplate.addScalarOption(LIST_ITEM_THIRD, "");
                cfgTemplate.addScalarOption("dbcslang", langName, "");
                cfgTemplate.addScalarOption("dbcstype", this.getDbcstype(), "");
                cfgTemplate.addScalarOption("location", "!SASROOT/dbcs/sasexe", "");
            } else {
                this.log.debug("New language is NOT DBCS");
                priority = null;
                cfgTemplate.addArrayOptionValue(DIR_SASHELP, "location", priority, "'!SASROOT/nls/en/sascfg'");
                cfgTemplate.addScalarOption("locale", langName, "");
            }
        }
    }

    protected boolean backupConfigFile(String srcCfgFile) {
        File cfgFile = new File(srcCfgFile);
        String cfgPath = cfgFile.getParent();
        String cfgFileNameExt = cfgFile.getName();
        File backupFilePath = new File(cfgPath);
        if (!cfgFileNameExt.endsWith(".cfg")) {
            this.log.info("Config file name not recognized");
        }
        String cfgFileName = cfgFileNameExt.substring(0, cfgFileNameExt.length() - 4);
        Integer extNum = 0;
        if (!cfgFile.exists()) {
            return false;
        }
        while (extNum < 1000) {
            File backupFile = extNum < 10 ? new File(backupFilePath, cfgFileName + ".00" + extNum.toString()) : (extNum < 100 ? new File(backupFilePath, cfgFileName + ".0" + extNum.toString()) : new File(backupFilePath, cfgFileName + "." + extNum.toString()));
            if (backupFile.exists()) {
                Integer n = extNum;
                Integer n2 = extNum = Integer.valueOf(extNum + 1);
                continue;
            }
            extNum = 1001;
            try {
                Utils.moveFile(cfgFile, backupFile);
                this.getController().getFS().copyFile(backupFile, cfgFile);
                this.getBackupConfigFile().put(cfgFile.getAbsolutePath(), backupFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.FileMoveError", cfgFile, backupFile), this.getEnBundle().messageString("InstallationTask.FileMoveError", cfgFile, backupFile), e);
            }
        }
        return true;
    }

    protected Boolean checkParameter(String param, boolean canBeEmpty) {
        return param != null && (param.length() > 0 || canBeEmpty);
    }

    protected Boolean checkParameter(String param) {
        return this.checkParameter(param, false);
    }

    private String fixValue(String value) {
        return value != null ? value : "";
    }

    private String fixParameter(String parameter) {
        return parameter != null ? parameter.toUpperCase(Locale.ENGLISH) : null;
    }

    protected String replacePathRefs(String source) {
        int pos;
        String val = source;
        while (val.toUpperCase(Locale.ENGLISH).contains(REF_SASROOT)) {
            String root = this.getSasExtPaths().get(REF_SASROOT);
            if (root == null) continue;
            pos = val.indexOf(REF_SASROOT);
            val = val.substring(0, pos) + root + val.substring(pos + REF_SASROOT.length());
            if (!root.contains(REF_SASROOT)) continue;
            break;
        }
        while (val.toUpperCase(Locale.ENGLISH).contains(REF_SASEXT)) {
            String ext = this.getSasExtPaths().get(REF_SASEXT);
            if (ext == null) continue;
            pos = val.indexOf(REF_SASEXT);
            val = val.substring(0, pos) + ext + val.substring(pos + REF_SASEXT.length());
            if (!ext.contains(REF_SASEXT)) continue;
            break;
        }
        while (val.toUpperCase(Locale.ENGLISH).contains(REF_SASNLS)) {
            String nls = this.getSasExtPaths().get(REF_SASNLS);
            if (nls == null) continue;
            pos = val.indexOf(REF_SASNLS);
            val = val.substring(0, pos) + nls + val.substring(pos + REF_SASNLS.length());
            if (!nls.contains(REF_SASNLS)) continue;
            break;
        }
        while (val.toUpperCase(Locale.ENGLISH).contains(REF_FORMCHAR)) {
            val = this.sasFormChars.get(this.getLangCode());
            if (!val.equals("")) continue;
            val = FORMCHAR_ANSI;
        }
        if (WINDOWS_OS) {
            while (val.toUpperCase(Locale.ENGLISH).contains(REF_PLATFORM)) {
                int pos1 = val.indexOf(REF_PLATFORM);
                int pos2 = pos1 + REF_PLATFORM.length();
                if (TaskHelper.getOS_Suffix().equals("wx6") && this.getController().getProperty("Host").equalsIgnoreCase("win")) {
                    val = val.substring(0, pos1) + SAS_WOW_TAG + val.substring(pos2, val.length());
                    continue;
                }
                val = val.substring(0, pos1) + val.substring(pos2, val.length());
            }
        }
        return val;
    }

    public static boolean isDBCS(String lang) {
        boolean isdbcs = false;
        for (String dbcslang : dbcsLangs) {
            if (!lang.equalsIgnoreCase(dbcslang)) continue;
            return true;
        }
        return isdbcs;
    }

    protected static String localeToLang2(String locale, boolean detectUTF8) {
        String lang = "";
        if (detectUTF8 && "utf-8".equalsIgnoreCase(Controller.installProperties.getProperty("sashome.encoding.name"))) {
            lang = "u8";
        } else if ("zh_CN".equalsIgnoreCase(locale)) {
            lang = "zh";
        } else if ("zh_HK".equalsIgnoreCase(locale) || "zh_TW".equalsIgnoreCase(locale)) {
            lang = "zt";
        } else if ("zh_MO".equalsIgnoreCase(locale) || "zh_SG".equalsIgnoreCase(locale)) {
            if (TaskHelper.isWindows()) {
                lang = "1d";
            } else if (TaskHelper.isUnix()) {
                lang = LIST_ITEM_THIRD;
            }
        } else {
            lang = locale.length() >= 2 ? locale.substring(0, 2) : "en";
        }
        return lang;
    }

    protected static String localeToLang2(String locale) {
        String lang = "";
        lang = EditSASConfigTask.localeToLang2(locale, true);
        return lang;
    }

    private int setDefaultConfig() {
        String sasroot = this.getController().getProperty("ProductHome");
        int returnCode = 0;
        String lang = "en";
        if (TaskHelper.isWindows()) {
            this.log.debug("EditSASConfigTask - SetDefaultConfigTask: Windows detected");
        } else if (TaskHelper.isUnix()) {
            this.log.debug("EditSASConfigTask - SetDefaultConfigTask: Unix detected");
        }
        this.log.info("EditSASConfigTask - SetDefaultConfigTask: Building config file in sasroot");
        this.log.info("EditSASConfigTask - SetDefaultConfigTask: Working with langCode " + this.getLangCode());
        String locale = Controller.installProperties.getProperty("sashome.locale.name");
        this.log.info("EditSASConfigTask - SetDefaultConfigTask: Locale property is " + locale);
        lang = EditSASConfigTask.localeToLang2(locale);
        this.log.info("EditSASConfigTask - SetDefaultConfigTask: lang is " + lang);
        File cfgFile = new File(this.nlsDir, lang);
        if (!cfgFile.exists()) {
            lang = lang.equalsIgnoreCase("1d") || lang.equalsIgnoreCase("u8") || lang.equalsIgnoreCase("ja") || lang.equalsIgnoreCase("ko") || lang.equalsIgnoreCase("zh") || lang.equalsIgnoreCase("zt") ? (TaskHelper.isWindows() ? "1d" : LIST_ITEM_THIRD) : "en";
            cfgFile = new File(this.nlsDir, lang);
        }
        cfgFile = new File(cfgFile, CONFIG_FILE_NAME);
        if (!TaskHelper.isUnix()) {
            String cfgLine = "-config \"" + cfgFile.getAbsolutePath() + "\"";
            this.log.debug("EditSASConfigTask - SetDefaultConfigTask: string to write: " + cfgLine);
            File defaultCfg = new File(sasroot, CONFIG_FILE_NAME);
            if (defaultCfg.exists()) {
                defaultCfg.delete();
            }
            try {
                if (defaultCfg.createNewFile()) {
                    this.log.info("EditSASConfigTask - SetDefaultConfigTask: File created: " + defaultCfg.getPath());
                    PrintWriter out = new PrintWriter(new FileWriter(defaultCfg));
                    out.println(cfgLine);
                    out.close();
                } else {
                    this.log.info("EditSASConfigTask - SetDefaultConfigTask: File not created");
                }
            }
            catch (IOException e) {
                this.log.error("Could not write to " + defaultCfg, (Throwable)e);
            }
            if (defaultCfg.exists()) {
                this.deleteAtUninstall(defaultCfg, this.getTarget());
            }
        }
        return returnCode;
    }

    protected String setPathToURL(String stringWithPath) {
        String pathToAdd = stringWithPath;
        try {
            this.log.debug("Coverting this path to URI: " + stringWithPath);
            int start = stringWithPath.indexOf(61);
            if (start > 0) {
                String path = stringWithPath.substring(stringWithPath.indexOf(61) + 1);
                File pathToCheck = new File(path);
                if (pathToCheck.exists()) {
                    pathToCheck = pathToCheck.getCanonicalFile();
                    URI uriPath = pathToCheck.toURI();
                    this.log.debug("addArrayValue: URI path is: " + uriPath.getPath());
                    pathToAdd = uriPath.toURL().toString();
                    this.log.debug("addArrayValue: path converted to URL: " + pathToAdd);
                    pathToAdd = stringWithPath.substring(0, start + 1) + pathToAdd;
                } else {
                    this.log.debug("Did not find path : " + pathToCheck.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            this.log.info("Unable to covert this path to URI: " + stringWithPath);
            this.log.info(e.getMessage());
        }
        return pathToAdd;
    }

    protected void doEditConfigFiles() {
        for (String key : this.getInstalledCfgFiles().keySet()) {
            this.setConfigFile(this.getInstalledCfgFiles().get(key));
            File destFile = new File(this.getConfigFile());
            this.log.debug("SASConfigEditor::execute() - working on file at " + destFile.getAbsolutePath());
            EntryData data = new EntryData(destFile.getAbsolutePath());
            this.notifySetup("Changed", data, "Preparing to update SAS config file.");
            try {
                this.setSASConfigFile(new SASConfigFile(destFile));
                boolean gotNLS = false;
                boolean gotEXT = false;
                Integer num = 0;
                while (num >= 0) {
                    String extFile = "sasext";
                    extFile = extFile.concat(num.toString());
                    if (this.getSASConfigFile().optionExists(extFile)) {
                        String extPath = this.getSASConfigFile().getScalarOptionValue(extFile);
                        this.getSasExtPaths().put(extFile, extPath);
                        if (extPath.toLowerCase().endsWith("nls\"")) {
                            if (!gotNLS) {
                                this.getSasExtPaths().put(REF_SASNLS, "!" + extFile);
                            }
                            gotNLS = true;
                        } else {
                            if (!gotEXT) {
                                this.getSasExtPaths().put(REF_SASEXT, "!" + extFile);
                            }
                            gotEXT = true;
                        }
                        Integer n = num;
                        Integer n2 = num = Integer.valueOf(num + 1);
                        continue;
                    }
                    num = -99;
                }
                if (this.getSASConfigFile().optionExists("sasroot")) {
                    this.getSasExtPaths().put("sasroot", this.getSASConfigFile().getScalarOptionValue("sasroot"));
                    this.getSasExtPaths().put(REF_SASROOT, "!sasroot");
                }
                this.log.debug("Calling performActions()");
                this.performActions("execute");
                this.log.debug("Calling writeConfigFile");
                this.getSASConfigFile().writeConfigFile();
                this.log.debug("Calling writeConfigFile - done()");
                if (EditSASConfigTask.localeToLang2(this._sashome_locale).equalsIgnoreCase(this.getLangCode()) || "en".equalsIgnoreCase(this.getLangCode())) {
                    this.setDefaultConfig();
                }
                this.notifyProgressComplete("Changed", data);
            }
            catch (Exception e) {
                throw new InstallException(3, this, this.getBundle().messageString("SASConfigEditor.GeneralError"), this.getEnBundle().messageString("SASConfigEditor.GeneralError"), e);
            }
        }
    }

    static {
        dbcsLangs = new String[]{"1d", LIST_ITEM_THIRD, "u8", "ja", "ko", "zh", "zt"};
        UNX = 0;
        WIN = 1;
        ADD = "ADD";
        REMOVE = "REMOVE";
        REPLACE = "REPLACE";
        WINDOWS_OS = TaskHelper.getOS() == 1;
    }
}

