/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.extension.ExtensionRegistrar;
import com.sas.tools.installs.it.AltskuProperties;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.HiveKeyRegistry;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.it.schema.extension.ExtensionsType;
import com.sas.tools.installs.it.schema.extension.InstalledExtensionType;
import com.sas.tools.installs.it.schema.extension.ObjectFactory;
import com.sas.tools.installs.it.schema.extension.ProductType;
import com.sas.tools.installs.it.schema.install.gen.EditFileTypeAssociations;
import com.sas.tools.installs.it.schema.install.gen.Extension;
import com.sas.tools.installs.it.schema.install.gen.InstallTaskData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;

public class EditFileTypeAssociationsTask
extends InstallationTask {
    private static final Object registrySync = new Object();
    private HiveKeyRegistry _winReg = null;
    public static final boolean WINDOWS_OS = TaskHelper.getOS() == 1;

    public EditFileTypeAssociationsTask() {
        if (WINDOWS_OS) {
            this._winReg = new WindowsRegistry();
        }
    }

    @Override
    public String descriptionForLog() {
        return null;
    }

    @Override
    public void preExecute() throws Exception {
    }

    private boolean isBasePackage() {
        return !this.getController().isHotfix() && !this.getController().isMaintenance();
    }

    private File getExtensionRegistryXml() {
        return new File(this.getInstallMisc(), "extensionRegistry.xml");
    }

    @Override
    public void execute() throws InstallException {
        Controller controller = this.getController();
        this._winReg.setUninstallLog(controller.metadataBackupDirectory(), "EditFileTypeAssociations");
        if (this.isUndo()) {
            this._winReg.uninstallRegistryKeys();
            try {
                this.updateExtensionRegistry();
            }
            catch (IOException e) {
                this.log.warn("Failed removing Extension Registry " + e.getMessage());
            }
            catch (JAXBException e) {
                this.log.warn("Failed removing Extension Registry " + e.getMessage());
            }
            return;
        }
        String product = controller.getProperty("ProductName");
        AltskuProperties props = new AltskuProperties(controller, controller.getAltSku());
        ExtensionRegistrar registrar = new ExtensionRegistrar(this._winReg, props);
        boolean result = true;
        List<Extension> extensions = ((EditFileTypeAssociations)this.getData()).getExtension();
        for (Extension extension : extensions) {
            this.log.info(product + ": register file extension: " + extension.getExtname());
            result = registrar.register(extension, ExtensionRegistrar.RegisterAction.BASIC);
        }
        if (result) {
            this.log.info("file extensions registered successfully");
        } else {
            this.log.warn("one or more errors occurred while registering file extension");
        }
        this._winReg.writeUninstallData();
        try {
            this.updateExtensionRegistry();
        }
        catch (IOException e) {
            this.log.warn("Failed update of Extension Registry " + e.getMessage());
        }
        catch (JAXBException e) {
            this.log.warn("Failed update of Extension Registry " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExtensionRegistry() throws IOException, JAXBException {
        Object object = registrySync;
        synchronized (object) {
            RegistryUpdate registry = new RegistryUpdate(this.getExtensionRegistryXml());
            List<Extension> extensions = ((EditFileTypeAssociations)this.getData()).getExtension();
            String product = this.getController().getProperty("12ByteCode");
            for (Extension extension : extensions) {
                if (!this.isUndo()) {
                    registry.updateProductExtension(product, extension);
                    continue;
                }
                if (!this.isBasePackage()) continue;
                registry.removeProductExtension(product, extension);
            }
            registry.save();
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
        if (!WINDOWS_OS) {
            this.log.info("Skipping rollback for EditFileTypeAssociations task running on non-Windows OS");
            return;
        }
        this._winReg.rollbackRegistryKeys();
    }

    @Override
    public boolean executeOnCurrentHost() {
        if (!WINDOWS_OS) {
            this.log.info("EditFileTypeAssociations task doesn't apply to non-Windows OS");
            return false;
        }
        return super.executeOnCurrentHost();
    }

    public class RegistryUpdate {
        private final File extensionRegistryFile;
        private final ObjectFactory factory = new ObjectFactory();
        private ExtensionsType extensionReg;

        public RegistryUpdate(File extensionRegistryFile) throws JAXBException {
            this.extensionRegistryFile = extensionRegistryFile;
            this.extensionReg = extensionRegistryFile.exists() ? SchemaUtils.unmarshal(extensionRegistryFile, ExtensionsType.class) : this.factory.createExtensionsType();
        }

        public void removeProductExtension(String product, Extension extension) {
            String extname = extension.getExtname();
            InstalledExtensionType installedExt = this.findExtension(extname);
            Iterator<InstallTaskData> i = installedExt.getProduct().iterator();
            while (i.hasNext()) {
                if (!i.next().getName().equals(product)) continue;
                i.remove();
            }
            if (installedExt.getProduct().size() == 0) {
                i = this.extensionReg.getInstalledExtension().iterator();
                while (i.hasNext()) {
                    if (installedExt != i.next()) continue;
                    i.remove();
                }
            }
        }

        public void updateProductExtension(String product, Extension extension) {
            String extname = extension.getExtname();
            InstalledExtensionType installedExt = this.findExtension(extname);
            boolean found = false;
            for (ProductType p : installedExt.getProduct()) {
                if (!p.getName().equals(product)) continue;
                p.setExtension(extension);
                found = true;
                break;
            }
            if (!found) {
                ProductType p = this.factory.createProductType();
                p.setName(product);
                p.setExtension(extension);
                installedExt.getProduct().add(p);
            }
        }

        public void save() throws IOException, JAXBException {
            FileWriter fw = new FileWriter(this.extensionRegistryFile);
            SchemaUtils.marshalExtensionsXml(this.extensionReg, fw);
            fw.close();
        }

        private InstalledExtensionType findExtension(String extname) {
            InstalledExtensionType installedExt = null;
            for (InstalledExtensionType ext : this.extensionReg.getInstalledExtension()) {
                if (!ext.getExtname().equals(extname)) continue;
                installedExt = ext;
            }
            if (installedExt == null) {
                installedExt = this.factory.createInstalledExtensionType();
                installedExt.setExtname(extname);
                this.extensionReg.getInstalledExtension().add(installedExt);
            }
            return installedExt;
        }
    }
}

