/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deploy.util.SASRuntimeWrapper;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.schema.install.gen.CreateUnixLink;
import com.sas.tools.installs.it.schema.install.gen.InstallType;
import com.sas.tools.installs.it.schema.install.gen.Project;
import com.sas.tools.installs.it.schema.install.gen.Target;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.schema.metadata.gen.EntryType;
import com.sas.tools.installs.it.tasks.EditSASConfigTask;
import com.sas.tools.installs.it.tasks.InstallationTask;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;

public class CreateUnixLinkTask
extends InstallationTask {
    protected List<EntryType> _modifiedEntries = new Vector<EntryType>();
    protected int _dataHash;

    @Override
    public void postExecute() throws Exception {
        if (this.getModifiedEntries().size() > 0) {
            this.getCurrentTaskData().getEntryData().clear();
            this.getCurrentTaskData().getEntryData().addAll(this.getModifiedEntries());
        }
    }

    public CreateUnixLink getCurrentTaskData() {
        Project uninstall = this.getController().getCurrentContext().getProject();
        for (Target target : uninstall.getTarget()) {
            for (InstallType task : target.getTasks()) {
                CreateUnixLink cul;
                if (!(task instanceof CreateUnixLink) || this.calculateDataHash(cul = (CreateUnixLink)task) != this.getDataHash()) continue;
                return cul;
            }
        }
        return null;
    }

    private void processRollbackData(boolean notifyOnly) {
        List<EntryType> rollbackEntries = this.getCurrentTaskData().getEntryData();
        if (rollbackEntries != null && rollbackEntries.size() > 0) {
            Vector<EntryData> directories = new Vector<EntryData>();
            for (EntryType entryType : rollbackEntries) {
                EntryData entryData = (EntryData)entryType;
                if (notifyOnly) {
                    entryData.notifyRestoreForTask(this);
                    continue;
                }
                if (entryType.getType().equals(EntryData.FILE)) {
                    entryData.performRestoreForTask(this);
                    continue;
                }
                directories.add(entryData);
            }
            TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
            for (EntryData entryData : directories) {
                sortedMap.put(entryData.getName(), entryData);
            }
            for (String key : sortedMap.keySet()) {
                EntryData entryData = (EntryData)sortedMap.get(key);
                if (null == entryData) continue;
                entryData.performRestoreForTask(this);
            }
        }
    }

    @Override
    public void execute() throws InstallException {
        if (this.getDirectoryToClone() != null && this.getCloneDirectoryPath() != null) {
            this.iterateAndClone(File.separator, false);
        } else {
            this.createLink(new File(this.getLinkName()), new File(this.getLinkTarget()), false);
        }
    }

    private File calculatedRelativeDestination(File link, File linkDestination) {
        int j;
        String[] linkDestinationSegments;
        String[] linkSegments = link.getAbsolutePath().split("/|\\\\");
        int maxLength = linkSegments.length > (linkDestinationSegments = linkDestination.getAbsolutePath().split("/|\\\\")).length ? linkSegments.length : linkDestinationSegments.length;
        for (int i = 0; i < maxLength && linkSegments[i].equals(linkDestinationSegments[i]); ++i) {
        }
        StringBuffer convertedDestinationPath = new StringBuffer();
        for (j = i; j < linkSegments.length - 1; ++j) {
            convertedDestinationPath.append(".." + File.separator);
        }
        for (j = i; j < linkDestinationSegments.length; ++j) {
            convertedDestinationPath.append(linkDestinationSegments[j] + File.separator);
        }
        return new File(convertedDestinationPath.toString());
    }

    private void createLink(File link, File linkDestination, boolean onlyNotify) {
        String linkTo = linkDestination.getPath();
        this.log.debug("createLink: link destination is: " + linkTo);
        if (((CreateUnixLink)this.getData()).isLinkRelativeToTarget()) {
            linkDestination = this.calculatedRelativeDestination(link, linkDestination);
        }
        EntryData entryData = new EntryData(link, !onlyNotify && !this.isUndo());
        entryData.setType(EntryData.FILE);
        if (!this.isUndo()) {
            if (linkTo.endsWith("sas_u8")) {
                if (!this.forceU8()) {
                    entryData.sendNotificationsForTask(this, "\nCreateUnixLink: Skipping symbolic link creation for " + link.getName() + ". utf-8 was not selected.");
                    return;
                }
                this.log.info("utf-8 flag detected - setting u8 as default");
            } else if (this.linkDbcs(linkTo)) {
                this.log.info("Dbcs language for the selected locale is not installed. Using English for DBCS for default");
            }
        }
        if (this.isUndo()) {
            if (onlyNotify) {
                entryData.notifyRestoreForTask(this);
            } else {
                entryData.performRestoreForTask(this);
                this.processRollbackData(onlyNotify);
            }
        } else if (onlyNotify) {
            entryData.sendNotificationsForTask(this);
            entryData.notifyBackupForTask(this);
        } else {
            entryData.performBackupForTask(this);
            File parent = link.getParentFile();
            if (!parent.exists()) {
                while (!parent.exists()) {
                    EntryType backupEntry = new EntryType();
                    backupEntry.setName(parent.getAbsolutePath());
                    backupEntry.setType(EntryData.DIRECTORY);
                    this.getModifiedEntries().add(backupEntry);
                    parent = parent.getParentFile();
                }
                if (!link.getParentFile().mkdirs()) {
                    throw new InstallException(1, this, this.getBundle().messageString("CreateUnixLink.DirectoryCreationFailure", parent, link.getName()), "Failure creating directory (" + parent + ") to hold symbolic link named " + link.getName(), null);
                }
            }
            this.notifyProgressStart("Added", entryData);
            try {
                Process p = SASRuntimeWrapper.getRuntime().exec(new String[]{"ln", "-s", linkDestination.getPath(), link.getAbsolutePath()});
                p.waitFor();
            }
            catch (Exception e) {
                throw new InstallException(1, this, this.getBundle().messageString("CreateUnixLink.GenericSystemError", parent, link.getName()), "System error while creating symbolic link", e);
            }
            entryData.setLink(true);
            this.notifyProgressComplete("Added", entryData);
        }
    }

    @Override
    protected boolean isLocaleConstraintMet(String locale) {
        boolean isMet = false;
        String langCode = this.getController().getProperty("ProductLanguage");
        String localeLangCode = EditSASConfigTask.localeToLang2(locale);
        this.log.debug("Product language code: " + langCode);
        this.log.debug("Selected locale: " + locale);
        this.log.debug("Selected locale language code: " + localeLangCode);
        this.log.debug("Link target: " + this.getLinkTarget());
        if (!this.linkDbcs(this.getLinkTarget()) && "en".equalsIgnoreCase(langCode)) {
            isMet = false;
        } else if (this.linkDbcs(this.getLinkTarget())) {
            isMet = true;
        } else {
            this.log.info("Checking for match of " + locale + " and " + langCode);
            if (locale.length() >= 2) {
                isMet = EditSASConfigTask.localeToLang2(locale).equalsIgnoreCase(langCode);
                this.log.debug("Using localeToLang2(), isMet = " + isMet);
            } else {
                this.log.info("Checking system locale, " + Locale.getDefault() + "for match. localeTwoLangCode is " + this.localeTwoLangCode(Locale.getDefault()));
                isMet = this.localeTwoLangCode(Locale.getDefault()).equalsIgnoreCase(langCode);
            }
            this.log.info("constraintMet is " + isMet);
            return isMet;
        }
        return isMet;
    }

    private boolean forceU8() {
        boolean forceU8 = false;
        if ("utf-8".equalsIgnoreCase(Controller.installProperties.getProperty("sashome.encoding.name"))) {
            forceU8 = true;
        }
        return forceU8;
    }

    private boolean linkDbcs(String linkTgt) {
        boolean forceDbcs = false;
        if (Controller.uninstall_mode) {
            return forceDbcs;
        }
        String langForLocale = EditSASConfigTask.localeToLang2(Controller.installProperties.getProperty("sashome.locale.name"));
        this.log.debug("linkDbcs: Link Target is: " + linkTgt);
        if (null == linkTgt) {
            return false;
        }
        if (!linkTgt.endsWith("sas_dbcs")) {
            this.log.debug("linkDbcs: not processing sas_dbcs link");
            forceDbcs = false;
        } else if (!EditSASConfigTask.isDBCS(langForLocale)) {
            this.log.debug("linkDbcs(): selected locale language " + langForLocale + " is not DBCS");
            forceDbcs = false;
        } else if (!Controller.installProperties.getProperty("selected.languages").contains(langForLocale)) {
            this.log.debug("linkDbcs(): language for selected locale " + langForLocale + " is not installed");
            forceDbcs = true;
        }
        return forceDbcs;
    }

    private String localeTwoLangCode(Locale locale) {
        String language = locale.getLanguage();
        String reigion = locale.getCountry();
        String twoLangCode = null;
        twoLangCode = language.equalsIgnoreCase("zh") ? (reigion.equalsIgnoreCase("CN") ? "zh" : (reigion.equalsIgnoreCase("TW") ? "zt" : (reigion.equalsIgnoreCase("HK") ? "zt" : "en"))) : language.toLowerCase(Locale.ENGLISH);
        return twoLangCode;
    }

    private void iterateAndClone(String relativePath, boolean onlyNotify) {
        if (this.isUndo()) {
            this.processRollbackData(onlyNotify);
        } else {
            File cloneTarget = new File(this.getDirectoryToClone() + relativePath);
            List<File> kids = Arrays.asList(cloneTarget.listFiles());
            for (File kid : kids) {
                EntryData entryData = new EntryData(new File(this.getController().getFS().append(this.getCloneDirectoryPath(), relativePath, kid.getName())), true);
                if (onlyNotify) {
                    if (kid.isFile()) {
                        entryData.sendNotificationsForTask(this, "Adding symbolic link " + entryData.getDestination().getAbsolutePath() + " -> " + kid.getAbsolutePath());
                    } else {
                        entryData.sendNotificationsForTask(this);
                    }
                } else {
                    entryData.performBackupForTask(this);
                    EntryType backupEntry = new EntryType();
                    if (kid.isFile()) {
                        this.getModifiedEntries().add(backupEntry);
                        this.createLink(entryData.getDestination(), kid, onlyNotify);
                        backupEntry.setType(EntryData.FILE);
                        backupEntry.setName(entryData.getDestination().getAbsolutePath());
                    } else {
                        backupEntry.setType(EntryData.DIRECTORY);
                    }
                }
                if (!kid.isDirectory() || !this.isClonedRecursively()) continue;
                this.iterateAndClone(relativePath + kid.getName() + File.separator, onlyNotify);
            }
        }
    }

    @Override
    public void preExecute() throws Exception {
        if (this.getDirectoryToClone() != null && this.getCloneDirectoryPath() != null) {
            if (!new File(this.getDirectoryToClone()).exists()) {
                return;
            }
            EntryData entryData = new EntryData();
            entryData.setDestination(new File(this.getCloneDirectoryPath()));
            entryData.sendNotificationsForTask(this);
            this.iterateAndClone(File.separator, true);
        } else {
            if (this.getLinkName() == null) {
                throw new InstallException(1, this, this.getBundle().messageString("CreateUnixLink.MissingNameParameter"), "Missing name parameter in symbolic link creation specification.", null);
            }
            if (this.getLinkTarget() == null) {
                throw new InstallException(1, this, this.getBundle().messageString("CreateUnixLink.MissingTargetParameter"), "Missing target parameter in symbolic link creation specification.", null);
            }
            this.createLink(new File(this.getLinkName()), new File(this.getLinkTarget()), true);
        }
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
        this.setUndo(true);
        if (this.getDirectoryToClone() != null && this.getCloneDirectoryPath() != null) {
            this.iterateAndClone(File.separator, false);
        } else {
            this.createLink(new File(this.getLinkName()), new File(this.getLinkTarget()), false);
        }
    }

    @Override
    public void setData(InstallType data) {
        super.setData(data);
        this.setDataHash(this.calculateDataHash((CreateUnixLink)data));
    }

    private String getLinkTarget() {
        String target = ((CreateUnixLink)this.getData()).getTarget();
        if (target != null) {
            return this.resolveProperty(target);
        }
        return null;
    }

    private String getLinkName() {
        String linkName = ((CreateUnixLink)this.getData()).getLinkname();
        if (linkName != null) {
            return this.resolveProperty(linkName);
        }
        return null;
    }

    private String getDirectoryToClone() {
        String directoryToClone = ((CreateUnixLink)this.getData()).getDirectoryToClone();
        if (directoryToClone != null) {
            return this.resolveProperty(directoryToClone);
        }
        return null;
    }

    private String getCloneDirectoryPath() {
        String cloneDirectoryPath = ((CreateUnixLink)this.getData()).getCloneDirectoryPath();
        if (cloneDirectoryPath != null) {
            return this.resolveProperty(cloneDirectoryPath);
        }
        return null;
    }

    private int calculateDataHash(CreateUnixLink o) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (o.getCloneDirectoryPath() == null ? 0 : o.getCloneDirectoryPath().hashCode());
        result = 31 * result + (o.isClonedRecursively() != false ? 1231 : 1237);
        result = 31 * result + (o.getDirectoryToClone() == null ? 0 : o.getDirectoryToClone().hashCode());
        result = 31 * result + (o.getLinkname() == null ? 0 : o.getLinkname().hashCode());
        result = 31 * result + (o.getTarget() == null ? 0 : o.getTarget().hashCode());
        return result;
    }

    private boolean isClonedRecursively() {
        return ((CreateUnixLink)this.getData()).isClonedRecursively();
    }

    @Override
    public String descriptionForLog() {
        return "CreateUnixLink:\n\tlinkName:  " + this.getLinkName() + "\n\ttarget:  " + this.getLinkTarget() + "\n\tcloneDirectoryPath:  " + this.getCloneDirectoryPath() + "\n\tdirectoryToClone:  " + this.getDirectoryToClone() + "\n\tclonedRecursively:  " + this.isClonedRecursively() + "\n\tconstrainBy:  " + this.getConstrainBy();
    }

    private List<EntryType> getModifiedEntries() {
        return this._modifiedEntries;
    }

    private int getDataHash() {
        return this._dataHash;
    }

    private void setDataHash(int dataHash) {
        this._dataHash = dataHash;
    }
}

