/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class ConfigureAutocadplgnTask
extends InstallationTask {
    private static final String ACAD_VERS_PROP = "task_configureAutocadplgn_AUTOCAD_CURVER";
    private static final String DSN_PROPERTY = "task_configureAutocadplgn_AUTOCAD_DSN";
    private static final String STORECAD_REGKEY_NAME = "MarketMAX StoreCAD Plus";
    private static final String APP_PATHS_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths";
    private static final String ACAD_LOAD_OSI_MENU_LISP1 = ";; The following line loads the Marketmax StoreCAD Plus menu for AutoCAD Release 14.";
    private static final String ACAD_LOAD_OSI_MENU_LISP1b = ";; Altering this line will affect Marketmax StoreCAD Plus functionality";
    private static final String ACAD_LOAD_OSI_MENU_LISP2 = "(load \"scpmenu.lsp\" \"\")";
    private static final String ACAD_LOAD_OSI_MENU_LISP3 = "(if init_osimenu (init_osimenu)) (princ)";
    private static final String ACAD_OSI_MENU_INIT1a = ";; The following line loads the Marketmax StoreCAD Plus menu for AutoCAD Release 14.";
    private static final String ACAD_OSI_MENU_INIT1b = ";; Altering this line will affect Marketmax StoreCAD Plus functionality";
    private static final String ACAD_OSI_MENU_INIT2 = "(if init_osimenu (init_osimenu)) (princ)";
    private static final String STORECAD_CONFIG1 = "[AppData/StoreCAD_Plus/Diagnostics]";
    private static final String STORECAD_CONFIG2 = "LoggingOnOff=1";
    private static String autocadVersion = "";
    private static String autocadRelease = "";
    private static String autocadRegSubKey = "";
    private static String autocadHome = "";
    private static String autocadPath = "";
    private static File autocadExe = null;
    private static String customerDSN = "";
    WindowsRegistry _winReg = new WindowsRegistry();

    @Override
    public String descriptionForLog() {
        return "Autocad Plug In";
    }

    @Override
    public void preExecute() throws Exception {
        String userDSN = "";
        if (!this.getController().getProperty("Host").equalsIgnoreCase("win")) {
            throw new InstallException(1, this, this.getBundle().messageString("ConfigureAutocadplgn.PlatformNotSupported"), this.getEnBundle().messageString("ConfigureAutocadplgn.PlatformNotSupported"), null);
        }
        this._winReg.setUninstallLog(this.getController().metadataBackupDirectory(), "ConfigureAutocadplgn");
        if (!this.isAutocadInstalled()) {
            throw new InstallException(1, this, this.getBundle().messageString("ConfigureAutocadplgn.AutocadNotFound"), this.getEnBundle().messageString("ConfigureAutocadplgn.AutocadNotFound"), null);
        }
        this.log.info("Autocad release " + autocadRelease + " was found at " + autocadHome);
        if (this.getController().getProperty("Host").equalsIgnoreCase("win")) {
            this._winReg.setBitMode(32);
        } else {
            this.log.info("Detected 'Host' property is: " + this.getController().getProperty("Host"));
        }
        if (this.isUndo()) {
            return;
        }
        userDSN = Controller.installProperties.getProperty("autocadplgn.install.userdsn");
        if (userDSN.length() == 0) {
            userDSN = "RSM";
        }
        this.getController().setProperty(DSN_PROPERTY, userDSN);
        this.setCustomerDSN(userDSN);
        if (!JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, WinRegAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib(WinRegAPI.libNames);
            throw new InstallException(2, null, this._bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        this.notifySetup("Installing Autocadplgn");
    }

    @Override
    public void execute() throws InstallException {
        if (this.isUndo()) {
            this._winReg.uninstallRegistryKeys();
            this.rollback();
            return;
        }
        int hKey = 8;
        String subKey = "SOFTWARE\\MarketMAX StoreCAD Plus";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this.setRegKeys();
        this.modifyACADStartupFiles();
    }

    private void setCustomerDSN(String dsn) {
        customerDSN = dsn;
    }

    private String getAutocadRegSubKey() {
        return autocadRegSubKey;
    }

    private void setAutocadRegSubKey(String subkey) {
        autocadRegSubKey = subkey;
    }

    private String getAutocadHome() {
        return autocadHome;
    }

    private String getAutocadVersion() {
        return autocadVersion;
    }

    private boolean isAutocadInstalled() {
        int hKey = 4;
        String subKey = "SOFTWARE\\Autodesk\\AutoCAD";
        String valueName = "curVer";
        boolean rtn = false;
        if (!this._winReg.keyExists(hKey, subKey)) {
            rtn = false;
        } else {
            autocadVersion = this._winReg.getValue(hKey, subKey, valueName);
            if (!this._winReg.keyExists(hKey, subKey = subKey.concat("\\" + autocadVersion))) {
                rtn = false;
            } else {
                autocadRelease = this._winReg.getValue(hKey, subKey, valueName);
                hKey = 8;
                if (!this._winReg.keyExists(hKey, subKey = subKey.concat("\\" + autocadRelease))) {
                    rtn = false;
                } else {
                    this.setAutocadRegSubKey(subKey);
                    this.getController().setProperty(ACAD_VERS_PROP, subKey);
                    autocadHome = this._winReg.getValue(hKey, subKey, "Location");
                    autocadPath = autocadHome.concat("\\acad.exe");
                    autocadExe = new File(autocadPath);
                    rtn = autocadExe.exists();
                }
            }
        }
        return rtn;
    }

    private void setRegKeys() {
        String valueName = "Path";
        int hKey = 8;
        String subKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\acad.exe";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        String addPath = this.resolveProperty("${ProductHome}");
        this.addPathToRegValue(hKey, subKey, valueName, addPath);
        hKey = 4;
        subKey = this.resolveProperty("${task_configureAutocadplgn_AUTOCAD_CURVER}\\Profiles");
        String value = this._winReg.getValue(hKey, subKey, "");
        subKey = subKey + "\\" + value + "\\General";
        this.addPathToRegValue(hKey, subKey, "ACAD", addPath);
    }

    protected void addPathToRegValue(int hive, String key, String name, String path) {
        int curType;
        if (!this._winReg.keyExists(hive, key)) {
            return;
        }
        String delimiter = ";";
        String curVal = "";
        curVal = this._winReg.getValue(hive, key, name);
        if (curVal == null || curVal.length() == 0) {
            delimiter = "";
        }
        if ((curType = this._winReg.getValueType(hive, key, name)) == 107) {
            this.log.info("Registry value " + name + " does not exist");
        } else {
            this.log.info("Registry value " + name + " exists with value '" + curVal + "'");
        }
        if (!this.isUndo()) {
            this.log.info("Adding value " + path);
            if (delimiter != null && delimiter.length() != 0) {
                String newVal = this.addValue(curVal, path, delimiter);
                this.log.info("Replacing current value with '" + newVal + "'");
                this._winReg.setValue(hive, key, name, newVal, curType);
            } else {
                this.log.info("Setting new variable to '" + path + "'");
                this._winReg.setValue(hive, key, name, path, 109);
            }
        } else {
            this.log.info("Removing value " + path);
            if (delimiter != null) {
                String newVal = this.removeValue(curVal, path, delimiter);
                this.log.info("Replacing current value with '" + newVal + "'");
                this._winReg.setValue(hive, key, name, newVal, curType);
            } else if (curVal.equals(path)) {
                this.log.info("Deleting variable " + name);
                this._winReg.deleteValue(hive, key, name);
            } else {
                this.log.warn("Variable has changed since installation, skipping deletion");
            }
        }
    }

    private String addValue(String curVal, String value, String delimiter) {
        if (value == null || value.length() == 0) {
            return curVal;
        }
        ArrayList<String> valueParts = new ArrayList<String>();
        boolean found = false;
        if (curVal == null || curVal.length() == 0) {
            return value;
        }
        for (String part : curVal.split(delimiter)) {
            if (part.equals(value)) {
                found = true;
                this.log.info("Found " + value + ", so won't add it");
            }
            valueParts.add(part);
        }
        if (!found) {
            valueParts.add(value);
            this.log.info("Didn't find " + value + ", adding");
        }
        return TaskHelper.join(valueParts, delimiter);
    }

    private String removeValue(String curVal, String value, String delimiter) {
        if (curVal == null || curVal.length() == 0) {
            return "";
        }
        ArrayList<String> valueParts = new ArrayList<String>();
        for (String part : curVal.split(delimiter)) {
            if (!part.equals(value)) {
                valueParts.add(part);
                continue;
            }
            this.log.info("Found " + value + ", removing");
        }
        return TaskHelper.join(valueParts, delimiter);
    }

    private void modifyACADStartupFiles() {
        String acadVers = this.getAutocadVersion();
        String tgtFileName = "";
        String nameOnly = "";
        StringBuffer _buffer = new StringBuffer();
        boolean lineExists = false;
        if (acadVers.equals("R17.0")) {
            nameOnly = "acad2007";
        } else if (acadVers.equals("R17.1")) {
            nameOnly = "acad2008";
        } else if (acadVers.equals("R17.2")) {
            nameOnly = "acad2009";
        }
        tgtFileName = nameOnly.concat(".lsp");
        try {
            EntryData enData;
            FileWriter fw;
            String line;
            BufferedReader in;
            File tgtFile = new File(this.getAutocadHome().concat("\\Support\\").concat(tgtFileName));
            if (tgtFile.exists()) {
                long lastModified = tgtFile.lastModified();
                BufferedReader in2 = new BufferedReader(new FileReader(tgtFile));
                String line2 = null;
                while ((line2 = in2.readLine()) != null) {
                    if (line2.contains("(if init_osimenu (init_osimenu)) (princ)")) {
                        lineExists = true;
                        break;
                    }
                    _buffer.append(line2);
                    _buffer.append("\n");
                }
                if (!lineExists) {
                    _buffer.append(";; The following line loads the Marketmax StoreCAD Plus menu for AutoCAD Release 14.");
                    _buffer.append("\n");
                    _buffer.append(";; Altering this line will affect Marketmax StoreCAD Plus functionality");
                    _buffer.append("\n");
                    _buffer.append(ACAD_LOAD_OSI_MENU_LISP2);
                    _buffer.append("\n");
                    _buffer.append("(if init_osimenu (init_osimenu)) (princ)");
                    _buffer.append("\n");
                }
                in2.close();
                if (!lineExists) {
                    FileWriter fw2 = new FileWriter(tgtFile);
                    EntryData enData2 = new EntryData(tgtFile);
                    this.notifySetup("Changed", enData2, null);
                    if (_buffer.length() > 0) {
                        fw2.write(_buffer.toString());
                    }
                    fw2.flush();
                    fw2.close();
                    tgtFile.setLastModified(lastModified);
                    this.notifyProgressComplete("Changed", enData2);
                }
            }
            _buffer = new StringBuffer();
            lineExists = false;
            int hKey = 4;
            String path = this._winReg.getValue(hKey, this.getAutocadRegSubKey(), "RoamableRootFolder");
            tgtFile = new File(path.concat("Support\\acad.mnl"));
            if (tgtFile.exists()) {
                long lastModified = tgtFile.lastModified();
                in = new BufferedReader(new FileReader(tgtFile));
                line = null;
                while ((line = in.readLine()) != null) {
                    if (line.contains("(if init_osimenu (init_osimenu)) (princ)")) {
                        lineExists = true;
                        break;
                    }
                    _buffer.append(line);
                    _buffer.append("\n");
                }
                if (!lineExists) {
                    _buffer.append(";; The following line loads the Marketmax StoreCAD Plus menu for AutoCAD Release 14.");
                    _buffer.append("\n");
                    _buffer.append(";; Altering this line will affect Marketmax StoreCAD Plus functionality");
                    _buffer.append("\n");
                    _buffer.append("(if init_osimenu (init_osimenu)) (princ)");
                    _buffer.append("\n");
                }
                in.close();
                if (!lineExists) {
                    fw = new FileWriter(tgtFile);
                    enData = new EntryData(tgtFile);
                    this.notifySetup("Changed", enData, null);
                    if (_buffer.length() > 0) {
                        fw.write(_buffer.toString());
                    }
                    fw.flush();
                    fw.close();
                    tgtFile.setLastModified(lastModified);
                    this.notifyProgressComplete("Changed", enData);
                }
            }
            _buffer = new StringBuffer();
            lineExists = false;
            hKey = 4;
            path = this._winReg.getValue(hKey, this.getAutocadRegSubKey(), "LocalRootFolder");
            tgtFile = new File(path.concat(nameOnly.concat(".cfg")));
            if (tgtFile.exists()) {
                long lastModified = tgtFile.lastModified();
                in = new BufferedReader(new FileReader(tgtFile));
                line = null;
                while ((line = in.readLine()) != null) {
                    if (line.contains(STORECAD_CONFIG1)) {
                        lineExists = true;
                        break;
                    }
                    _buffer.append(line);
                    _buffer.append("\n");
                }
                if (!lineExists) {
                    _buffer.append(STORECAD_CONFIG1);
                    _buffer.append("\n");
                    _buffer.append(STORECAD_CONFIG2);
                    _buffer.append("\n");
                }
                in.close();
                if (!lineExists) {
                    fw = new FileWriter(tgtFile);
                    enData = new EntryData(tgtFile);
                    this.notifySetup("Changed", enData, null);
                    if (_buffer.length() > 0) {
                        fw.write(_buffer.toString());
                    }
                    fw.flush();
                    fw.close();
                    tgtFile.setLastModified(lastModified);
                    this.notifyProgressComplete("Changed", enData);
                }
            }
        }
        catch (IOException e) {
            throw new InstallException(1, this, this.getBundle().messageString("ConfigureAutocadplgn.FileUpdateFailed"), this.getEnBundle().messageString("ConfigureAutocadplgn.FileUpdateFailed"), e);
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
        if (!this.isUndo()) {
            this._winReg.rollbackRegistryKeys();
        }
        int hKey = 4;
        String addPath = this.resolveProperty("${ProductHome}");
        String subKey = this.resolveProperty("${task_configureAutocadplgn_AUTOCAD_CURVER}\\Profiles");
        String valueName = "Path";
        String value = this._winReg.getValue(hKey, subKey, "");
        subKey = subKey + "\\" + value + "\\General";
        this.addPathToRegValue(hKey, subKey, "ACAD", addPath);
        hKey = 8;
        subKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\acad.exe";
        this.addPathToRegValue(hKey, subKey, valueName, addPath);
    }
}

