/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class BuildSASDesktopTask
extends InstallationTask {
    private File _sasexe = null;
    private File _deskdata = null;
    private String _configFile = null;
    private File _logFile = null;
    private static BuildSASDesktopTask _buildSASDesktop = null;
    private static String _SASRoot;
    private Vector<String> _languages = new Vector();
    private static List<String> _sascfgFiles;

    private void setCfgFileList() {
        _sascfgFiles.add("deskact.sas7bdat");
        _sascfgFiles.add("deskact.sas7bndx");
        _sascfgFiles.add("deskfd.sas7bdat");
        _sascfgFiles.add("deskfd.sas7bndx");
        _sascfgFiles.add("deskobj.sas7bdat");
        _sascfgFiles.add("deskobj.sas7bndx");
        _sascfgFiles.add("feeddet.sas7bdat");
        _sascfgFiles.add("feeddet.sas7bndx");
        _sascfgFiles.add("feeder.sas7bdat");
        _sascfgFiles.add("feeder.sas7bndx");
        _sascfgFiles.add("regstry.sas7bitm");
    }

    public BuildSASDesktopTask() {
        _buildSASDesktop = this;
        this.setController(Controller.defaultController());
        BuildSASDesktopTask.setSASRoot(this.getController().getProperty("home_base"));
        if (Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
            String key = Controller.defaultController().getAltSku().concat(this.getClass().getName());
            Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(this.getClass().getName(), "postInstall"));
            Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this.getClass(), "postInstall"));
        } else {
            BuildSASDesktopTask.postInstall();
        }
    }

    @Override
    public String descriptionForLog() {
        return "BuildSASDesktopTask";
    }

    @Override
    public void preExecute() {
        this.notifySetup("SAS Desktop will be created");
    }

    public static int postInstall() {
        int returnCode = 0;
        returnCode = TaskHelper.isUnix() ? _buildSASDesktop.unxPostInstallExecute() : _buildSASDesktop.winPostInstallExecute();
        return returnCode;
    }

    protected int unxPostInstallExecute() {
        this.setLangsToBuildUnix();
        new File(BuildSASDesktopTask.getSASRoot() + File.separator + "install" + File.separator + "admin" + File.separator + "tmp").mkdirs();
        this._logFile = new File(BuildSASDesktopTask.getSASRoot() + "/install/admin/logs/desktop_" + System.currentTimeMillis() + ".log");
        this.setCfgFileList();
        for (String lang : this.getLangsToBuild()) {
            this.log.info("Arguments: " + this.getUnixArgs(lang).toString());
            int results = 0;
            ProcessBuilder pb = new ProcessBuilder(this.getUnixArgs(lang));
            try {
                results = InstallationTask.executeProcess(pb, this.log);
            }
            catch (Exception e) {
                this.log.error(this.getBundle().messageString("SASDesktop.OperationFailed"), (Throwable)e);
                return -1;
            }
            this.processSASOutput(results, this._logFile.getAbsolutePath());
            if (results == 1) {
                this.log.info("There were warning(s) in the SAS log while building the SAS Desktop, please see the SAS log content above for more details");
            } else if (results == 2) {
                this.log.error("There were error(s) in the SAS log while building the SAS Desktop, please see the SAS log content above for more details");
            }
            if (Controller.installProperties.getProperty("sdm.postinstall") != "FALSE") continue;
            File sascfgDir = new File(BuildSASDesktopTask.getSASRoot() + "/nls/" + lang + "/sascfg");
            for (String cfgfile : _sascfgFiles) {
                File fileToDelete = new File(sascfgDir, cfgfile);
                this.log.debug("DEBUG: unxPostInstallExecute: Registering " + fileToDelete.getAbsolutePath() + " for uninstall");
                if (fileToDelete.exists()) {
                    this.deleteAtUninstall(fileToDelete, this.getTarget());
                    continue;
                }
                this.log.debug("DEBUG: unxPostInstallExecute: Did not find " + fileToDelete.getAbsolutePath());
            }
            this.deleteAtUninstall(sascfgDir, this.getTarget());
        }
        return 0;
    }

    protected int winPostInstallExecute() {
        int results = 0;
        this.setLangsToBuild();
        if (this.doSASDesktop()) {
            boolean deletedir = false;
            this.setCfgFileList();
            this.log.info("Building SAS Desktop for the following languages: " + this.getLangsToBuild().toString());
            for (String lang : this.getLangsToBuild()) {
                this.log.info("Building SAS Desktop for " + lang);
                String sascfgRelPath = Utils.joinPath("nls", lang, "SASCFG");
                File sascfgDir = new File(BuildSASDesktopTask.getSASRoot(), sascfgRelPath);
                if (!sascfgDir.exists()) {
                    if (!sascfgDir.mkdir()) {
                        this.log.info("Unable to create sascfg directory for the SAS Desktop build: " + sascfgDir.getAbsolutePath());
                        this.log.info("SAS Desktop for " + this.getController().getProperty("ProductLanguage") + " will not be built");
                        deletedir = false;
                        return -1;
                    }
                    deletedir = true;
                }
                this._configFile = Utils.joinPath(Utils.joinPath(BuildSASDesktopTask.getSASRoot(), "nls", lang), "sasv9.cfg");
                String logFilename = "sasdesk.log";
                this._logFile = new File(sascfgDir, logFilename);
                this.log.info("Arguments: " + this.getWinArgs().toString());
                ProcessBuilder pb = new ProcessBuilder(this.getWinArgs());
                try {
                    Process process = pb.start();
                    results = process.waitFor();
                }
                catch (Exception e) {
                    this.log.error(this.getBundle().messageString("SASDesktop.OperationFailed"), (Throwable)e);
                    return -1;
                }
                this.processSASOutput(results, this._logFile.getAbsolutePath());
                if (results == 1) {
                    this.log.info("There were warning(s) in the SAS log while building the SAS Desktop, please see the SAS log content above for more details");
                } else if (results == 2) {
                    this.log.error("There were error(s) in the SAS log while building the SAS Desktop, please see the SAS log content above for more details");
                }
                if (Controller.installProperties.getProperty("sdm.postinstall") != "FALSE") continue;
                for (String cfgfile : _sascfgFiles) {
                    File fileToDelete = new File(sascfgDir, cfgfile);
                    if (!fileToDelete.exists()) continue;
                    this.deleteAtUninstall(fileToDelete, this.getTarget());
                }
                if (!deletedir) continue;
                this.deleteAtUninstall(sascfgDir, this.getTarget());
            }
        } else {
            this.log.info("SAS Dekstop will not be built for " + this.getController().getProperty("ProductLanguage") + ", deskdata.sas=" + this._deskdata.getAbsolutePath() + ", sas.exe=" + this._sasexe.getAbsolutePath());
        }
        return results;
    }

    public void setLangsToBuild() {
        File topNlsfolder = new File(this.getController().getFS().append(BuildSASDesktopTask.getSASRoot(), "nls"));
        this.log.info("Scanning " + topNlsfolder.getAbsolutePath() + " for installed languages");
        File[] langDirs = topNlsfolder.listFiles();
        if (langDirs != null) {
            for (File lang : langDirs) {
                File cfgFile;
                if (!lang.isDirectory() || !(cfgFile = new File(this.getController().getFS().append(lang.getAbsolutePath(), "sasv9.cfg"))).isFile()) continue;
                this.getLangsToBuild().add(lang.getName());
            }
        }
    }

    public void setLangsToBuildUnix() {
        File enNlsDir = new File(this.getController().getFS().append(BuildSASDesktopTask.getSASRoot(), "nls", "en"));
        if (enNlsDir.isDirectory()) {
            this.getLangsToBuild().add(enNlsDir.getName());
        }
    }

    public Vector<String> getLangsToBuild() {
        return this._languages;
    }

    @Override
    public void execute() throws InstallException {
        if ("base".equalsIgnoreCase(this.getController().getProperty("12ByteCode"))) {
            BuildSASDesktopTask.setSASRoot(this.getController().getProperty("home_base"));
        }
    }

    protected List<String> getWinArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this._sasexe.getAbsolutePath());
        args.add(this._deskdata.getAbsolutePath());
        args.add("-CONFIG");
        args.add(this._configFile);
        args.add("-sasuser");
        args.add("\"" + this.getInstallMisc() + "\"");
        args.add("-icon");
        args.add("-nologo");
        args.add("-noterminal");
        args.add("-noprngetlist");
        args.add("-unbuflog");
        args.add("-noautoexec");
        args.add("-filesync");
        args.add("HOST");
        args.add("-log");
        args.add(this._logFile.getAbsolutePath());
        return args;
    }

    protected List<String> getUnixArgs(String lang) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(BuildSASDesktopTask.getSASRoot() + "/bin/sas_" + lang);
        args.add("-nodms");
        args.add("-noterminal");
        args.add("-set");
        args.add("sasroot");
        args.add(BuildSASDesktopTask.getSASRoot());
        args.add("-sasuser");
        args.add(this.getWorkArea());
        args.add("-msg");
        args.add(BuildSASDesktopTask.getSASRoot() + "/sasmsg");
        args.add("-work");
        args.add(this.getWorkArea());
        args.add("-log");
        args.add(this.getLog());
        args.add("-filelocks");
        args.add("none");
        args.add("-nonews");
        args.add("-nonotes");
        args.add("-nodate");
        args.add("-nostimer");
        args.add("-ls");
        args.add("78");
        args.add("-filesync");
        args.add("host");
        args.add("-ps");
        args.add("60");
        args.add("-setinit");
        args.add("-noautoexec");
        args.add(BuildSASDesktopTask.getSASRoot() + "/install/pgm/deskdata.sas");
        return args;
    }

    private String getLog() {
        return new File(BuildSASDesktopTask.getSASRoot() + "/install/admin/logs/desktop_" + System.currentTimeMillis() + ".log").getAbsolutePath();
    }

    private String getWorkArea() {
        return System.getProperty("java.io.tmpdir");
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
    }

    protected boolean doSASDesktop() {
        boolean doSASDesktop = false;
        File sasexe = new File(BuildSASDesktopTask.getSASRoot(), "sas.exe");
        File deskdata = new File(BuildSASDesktopTask.getSASRoot(), "core\\sasmacro\\deskdata.sas");
        if (sasexe.exists() && deskdata.exists()) {
            doSASDesktop = true;
            this._sasexe = sasexe;
            this._deskdata = deskdata;
        }
        return doSASDesktop;
    }

    public static String getSASRoot() {
        return _SASRoot;
    }

    public static void setSASRoot(String SASRoot) {
        _SASRoot = SASRoot;
    }

    static {
        _sascfgFiles = new ArrayList<String>();
    }
}

