/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.tasks.MergePicklistTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.CustMsgBox;
import com.sas.tools.installs.it.view.SSNResource;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Utils {
    protected static Logger log = (Logger)LogManager.getLogger(Utils.class);
    static char quote = (char)34;
    public static Set<File> writablePaths = Collections.synchronizedSet(new HashSet());

    public static String joinPath(String path1, String path2) {
        String sPath = "";
        String sTemp1 = path1;
        String sTemp2 = path2;
        while (sTemp1.endsWith(File.separator)) {
            sTemp1 = sTemp1.substring(0, sTemp1.length() - 1);
        }
        while (sTemp2.startsWith(File.separator)) {
            sTemp2 = sTemp2.substring(1, sTemp2.length());
        }
        sPath = sTemp1 + File.separator + sTemp2;
        return sPath;
    }

    public static String replaceProperty(String text, Map<String, String> keyRef, String openDelim, String closeDelim) {
        Pattern p = Pattern.compile(openDelim + "([^" + closeDelim + "]*)" + closeDelim);
        Matcher m = p.matcher(text);
        StringBuffer resolvedValue = new StringBuffer();
        boolean symbolFound = false;
        while (m.find()) {
            symbolFound = true;
            String symbolValue = m.group(1);
            String value = keyRef.get(symbolValue);
            if (value == null || value.length() == 0) {
                m.appendReplacement(resolvedValue, "");
                log.info("value is null or empty for the following line: " + text);
                continue;
            }
            log.info("text:  " + text + ", processing *" + symbolValue + "*");
            m.appendReplacement(resolvedValue, value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        }
        if (symbolFound) {
            m.appendTail(resolvedValue);
        } else {
            resolvedValue.append(text);
        }
        return resolvedValue.toString();
    }

    public static boolean isLink(File possibleLink) {
        try {
            File parent = possibleLink.getParentFile();
            String name = possibleLink.getName();
            File toTest = new File(parent.getCanonicalPath(), name);
            return !toTest.getAbsolutePath().equals(toTest.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean removeFile(File destination) {
        boolean isSuccess = true;
        if (destination != null && destination.exists()) {
            isSuccess = destination.delete();
            for (int retries = 1; !isSuccess && retries < 4; ++retries) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G hh:mm:ss");
                Date now = new Date();
                String dateString = formatter.format(now);
                log.info(dateString + "removing " + destination + " failed, so retrying after garbage collection and waiting three seconds.  " + retries + " retries");
                isSuccess = destination.delete();
            }
        }
        return isSuccess;
    }

    public static boolean moveFile(File source, File destination) {
        String sPath = destination.getAbsolutePath();
        File sPathFile = new File(sPath);
        if (!sPathFile.exists()) {
            sPathFile.mkdirs();
        }
        boolean isSuccess = Utils.removeFile(destination);
        int retries = 1;
        if (!isSuccess) {
            return isSuccess;
        }
        isSuccess = Utils.isWindows() ? Utils.copyAndDeleteSourceFile(source, destination) : source.renameTo(destination);
        for (retries = 1; !isSuccess && retries < 4; ++retries) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G hh:mm:ss");
            Date now = new Date();
            String dateString = formatter.format(now);
            log.info(dateString + "moving " + source + " to " + destination + " failed, so retrying after garbage collection and waiting three seconds.  " + retries + " retries");
            isSuccess = Utils.isWindows() ? Utils.copyAndDeleteSourceFile(source, destination) : source.renameTo(destination);
        }
        return isSuccess;
    }

    public static String attributeValueForXPath(Document document, String attributeName, String xpathExpression) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Object result = xpath.evaluate(xpathExpression, document, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        return ((Element)nodes.item(0)).getAttribute(attributeName);
    }

    public static String stringReplaceAll(String search, String find, String replace) {
        int searchIndex;
        if (replace == null) {
            throw new NullPointerException();
        }
        if (find.length() > 0 && (searchIndex = search.indexOf(find)) >= 0) {
            search = search.substring(0, searchIndex) + replace + Utils.stringReplaceAll(search.substring(searchIndex + find.length()), find, replace);
        }
        return search;
    }

    public static String fixPathSlashes(String pathToFix) {
        if (TaskHelper.getOS() == 1) {
            return pathToFix.replaceAll("/+", "\\\\");
        }
        return pathToFix.replaceAll("\\\\+", "/");
    }

    public static String canonicalizePath(String path) {
        try {
            path = Utils.fixPathSlashes(path);
            if (path.contains("/.") || path.contains("\\.")) {
                String[] partArray = path.split("/");
                String newPath = "";
                boolean useBackslash = false;
                if (partArray.length == 1) {
                    partArray = path.split("\\\\");
                    useBackslash = true;
                }
                for (int i = 0; i < partArray.length; ++i) {
                    if (".".equals(partArray[i])) continue;
                    if ("..".equals(partArray[i])) {
                        if (useBackslash) {
                            newPath = newPath.substring(0, newPath.lastIndexOf("\\"));
                            continue;
                        }
                        newPath = newPath.substring(0, newPath.lastIndexOf("/"));
                        continue;
                    }
                    newPath = useBackslash ? newPath + "\\" + partArray[i] : newPath + "/" + partArray[i];
                }
                path = newPath.substring(1);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new InstallException(3, null, "Invalid path", "Encountered Invalid Path", e);
        }
        return path;
    }

    public static String getMd5sum(File file) {
        String md5 = null;
        if (file != null && file.exists()) {
            try {
                md5 = Utils.getMd5sum(new FileInputStream(file));
            }
            catch (Exception e) {
                Controller.logStackTrace(e);
            }
        }
        return md5;
    }

    public static String getMd5sum(String fileName) {
        return Utils.getMd5sum(new File(fileName));
    }

    public static String getMd5sum(InputStream is) {
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("MD5");
            DigestInputStream dis = new DigestInputStream(is, digester);
            byte[] bytes = new byte[8192];
            int count = dis.read(bytes);
            while (count != -1 && count <= 8192) {
                count = dis.read(bytes);
            }
            dis.close();
            is.close();
        }
        catch (Exception e) {
            throw new InstallException(3, null, new SSNResource(Utils.class).messageString("Utils.ChecksumError"), "Error calculating checksum", e);
        }
        return Utils.md5sumToString(digester);
    }

    public static String md5sumToString(MessageDigest digester) {
        byte[] chk = digester.digest();
        String hexvalue = "";
        for (int i = 0; i < chk.length; ++i) {
            int bytevalue = chk[i] >= 0 ? chk[i] : 256 + chk[i];
            String hexvaluestring = Integer.toHexString(bytevalue);
            if (hexvaluestring.length() == 1) {
                hexvaluestring = "0" + hexvaluestring;
            }
            hexvalue = hexvalue + hexvaluestring;
        }
        return hexvalue;
    }

    public static String joinPath(String path1, String path2, String path3) {
        return Utils.joinPath(Utils.joinPath(path1, path2), path3);
    }

    public static String pathToURL(String path) {
        String prefix = "";
        String osName = System.getProperty("os.name");
        prefix = osName.startsWith("Windows") ? (path.startsWith("\\\\") ? "file:////" : "file:///") : "file://";
        return prefix + path;
    }

    public static String getUserDomain() {
        String domain = "";
        if (Utils.isWindows()) {
            try {
                Class<?> c = Class.forName("com.sun.security.auth.module.NTSystem");
                Method m = c.getMethod("getDomain", null);
                domain = (String)m.invoke(c.newInstance(), (Object[])null);
            }
            catch (Exception e) {
                log.error("Error retrieving domain name: " + e.getMessage());
            }
        }
        return domain;
    }

    public static boolean canWriteToPath(File path) {
        return Utils.canWriteToPath(path, false);
    }

    public static boolean canWriteToPath(File path, boolean useCachedResult) {
        boolean valid = false;
        if (useCachedResult && writablePaths.contains(path)) {
            valid = true;
        } else {
            File newPath = null;
            if (!path.exists()) {
                newPath = path;
                for (File parent = path.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
                    newPath = parent;
                }
            }
            boolean bl = valid = useCachedResult && writablePaths.contains(newPath);
            if (!valid) {
                if (path.isDirectory() || path.mkdirs()) {
                    try {
                        int count = 0;
                        String newName = "temp" + Integer.toString(count);
                        File newFile = new File(path, newName + ".tmp");
                        for (int i = 0; i < 999 && newFile.exists(); ++i) {
                            newName = "temp" + Integer.toString(++count);
                            newFile = new File(path, newName + ".tmp");
                        }
                        File.createTempFile(newName, null, path).delete();
                        valid = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (newPath != null) {
                    Utils.deleteFolder(newPath);
                }
            }
            if (!valid) {
                log.warn("Path " + path + " is not writeable");
            } else {
                writablePaths.add(path);
                writablePaths.add(newPath);
            }
        }
        return valid;
    }

    public static boolean canWriteToPath(String path) {
        return Utils.canWriteToPath(new File(path));
    }

    public static boolean deleteFolder(File folder) {
        return Utils.deleteFolder(folder, false);
    }

    public static boolean deleteFolder(File folder, boolean deleteOnExit) {
        boolean bValid = true;
        File[] files = folder.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (files[i].isDirectory()) {
                        Utils.deleteFolder(files[i], deleteOnExit);
                        continue;
                    }
                    if (deleteOnExit) {
                        files[i].deleteOnExit();
                        continue;
                    }
                    if (files[i].delete()) continue;
                    log.info("Error deleting file (" + files[i] + ")");
                    continue;
                }
                catch (Exception e) {
                    bValid = false;
                    log.info("Error deleting file (" + files[i] + ")");
                }
            }
        }
        if (deleteOnExit) {
            if (!Controller.silent) {
                JEditorPane content = new JEditorPane("text/html", "deleting " + folder + " on exit");
                content.setEditable(false);
                content.setPreferredSize(new Dimension(600, 200));
                CustMsgBox.showMessageDialog(null, new JScrollPane(content), "TEST", 1);
            }
            folder.deleteOnExit();
        } else {
            bValid = folder.delete();
            if (!bValid) {
                log.info("Error deleting folder (" + folder + ")");
            }
        }
        return bValid;
    }

    public static void getRecursiveListOfFilesFromFolder(File folder, Set<File> allFiles) {
        File[] files = folder.listFiles();
        if (files == null) {
            String msg = String.format("Warning, unable to read directroy %s.", folder.getAbsolutePath());
            log.warn(msg);
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                Utils.getRecursiveListOfFilesFromFolder(files[i], allFiles);
                continue;
            }
            File file = files[i];
            allFiles.add(file);
        }
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows");
    }

    public static String localeTwoLangCode(Locale locale) {
        String language = locale.getLanguage();
        String reigion = locale.getCountry();
        String twoLangCode = null;
        twoLangCode = language.equalsIgnoreCase("zh") ? (reigion.equalsIgnoreCase("CN") ? "zh" : (reigion.equalsIgnoreCase("TW") ? "zt" : "en")) : language.toLowerCase(Locale.ENGLISH);
        return twoLangCode;
    }

    public static String GetJarVersion(String file) {
        String version = null;
        File setupFile = new File(file);
        if (setupFile.isFile()) {
            try {
                JarFile jf = new JarFile(setupFile);
                version = jf.getManifest().getMainAttributes().getValue("Implementation-Version").trim();
            }
            catch (Exception e) {
                log.error("Error checking manifest for jar: " + setupFile, (Throwable)e);
            }
        }
        return version;
    }

    public static List<String> splitPath(File path) {
        ArrayList<String> splitPath = new ArrayList<String>();
        while (path != null) {
            splitPath.add(0, path.getName());
            path = path.getParentFile();
        }
        return splitPath;
    }

    public static boolean isChildOf(String child, String parent) {
        File childPath = new File(child);
        File parentDir = new File(parent);
        childPath = childPath.getAbsoluteFile();
        if (!(parentDir = parentDir.getAbsoluteFile()).isDirectory() || !childPath.exists() || parentDir.getAbsolutePath().length() >= childPath.getAbsolutePath().length()) {
            return false;
        }
        while (childPath.getParentFile() != null) {
            if (!parentDir.equals(childPath = new File(childPath.getParent()))) continue;
            return true;
        }
        return false;
    }

    public static String getFormattedLogMsg(Throwable e) {
        String logMsg = e.toString();
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            logMsg = logMsg + "\n" + stackTrace[i].toString();
        }
        return logMsg;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        Utils.copyFile(sourceFile, destFile, new byte[1024]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile, byte[] buffer) throws IOException {
        FileInputStream inStream = null;
        OutputStream outStream = null;
        try {
            int length;
            inStream = new FileInputStream(sourceFile);
            outStream = new FileOutputStream(destFile);
            while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                outStream.write(buffer, 0, length);
            }
        }
        finally {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public static boolean copyAndDeleteSourceFile(File sourceFile, File destFile) {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        boolean bResult = true;
        try {
            int length;
            inStream = new FileInputStream(sourceFile);
            outStream = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
            ((InputStream)inStream).close();
            ((OutputStream)outStream).close();
            Utils.isFileClosed(sourceFile);
            if (!MergePicklistTask.bPickListInUse) {
                if (!sourceFile.delete()) {
                    log.info("Error in deleting file " + sourceFile + ".");
                    bResult = false;
                } else {
                    log.info("File " + sourceFile + " is copied and moved successfully.");
                }
            }
        }
        catch (IOException e) {
            Controller.logStackTrace(e);
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isFileClosed(File file) {
        boolean closed = true;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel channel = null;
            try {
                channel = randomAccessFile.getChannel();
                log.info("File " + file + " is closed successfully.");
            }
            finally {
                randomAccessFile.close();
                if (channel != null) {
                    channel.close();
                }
            }
        }
        catch (FileNotFoundException ex) {
            closed = false;
            log.info("File " + file + " is not closed.");
        }
        catch (IOException ex) {
            Controller.logStackTrace(ex);
        }
        return closed;
    }

    public static boolean isProcessStillRunning(String sProcessName) {
        boolean stopped = false;
        int numberOfRuns = 0;
        try {
            String sTaskListExe = System.getenv("windir") + "\\system32\\tasklist.exe";
            File sTaskListExeFile = new File(sTaskListExe);
            if (!sTaskListExeFile.exists()) {
                throw new Exception();
            }
            log.info(" Running " + sTaskListExe + " to check if " + sProcessName + " is running.");
            while (!stopped) {
                String line;
                Process p = Runtime.getRuntime().exec(sTaskListExe);
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String pidInfo = "";
                if (numberOfRuns > 39) {
                    throw new Exception();
                }
                while ((line = input.readLine()) != null) {
                    pidInfo = pidInfo + line;
                }
                input.close();
                stopped = !pidInfo.contains(sProcessName);
                Thread.sleep(1000L);
                ++numberOfRuns;
            }
        }
        catch (Exception err) {
            Controller.logStackTrace(err);
        }
        return stopped;
    }

    public static boolean isRegAsmRunning() {
        boolean running = false;
        try {
            String line;
            String sTaskListExe = System.getenv("windir") + "\\system32\\tasklist.exe";
            File sTaskListExeFile = new File(sTaskListExe);
            if (!sTaskListExeFile.exists()) {
                throw new Exception();
            }
            Process p = Runtime.getRuntime().exec(sTaskListExe);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String pidInfo = "";
            while ((line = input.readLine()) != null) {
                pidInfo = pidInfo + line;
            }
            input.close();
            if (pidInfo.contains("RegAsm.exe")) {
                running = true;
            }
        }
        catch (Exception e) {
            Controller.logStackTrace(e);
        }
        return running;
    }

    private static byte[] readFileBytes(File ifile) {
        byte[] fileBytes = new byte[(int)ifile.length() < 1024 ? (int)ifile.length() : 1024];
        try {
            FileInputStream fileStream = new FileInputStream(ifile);
            int bytesRead = fileStream.read(fileBytes);
            if (bytesRead < 1) {
                log.error("Error: reading file " + ifile.getAbsolutePath());
            }
            fileStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileBytes;
    }

    private static Encoding checkFile(byte[] fileBytes) {
        int asciiCount = 0;
        int ebcdicCount = 0;
        for (byte i : fileBytes) {
            if (i == 10) {
                ++asciiCount;
                continue;
            }
            if (i != 21) continue;
            ++ebcdicCount;
        }
        int total = ebcdicCount + asciiCount;
        if (ebcdicCount * 100 / total > 10 && asciiCount * 100 / total > 10) {
            return Encoding.UNKNOWN;
        }
        if (ebcdicCount > asciiCount) {
            return Encoding.EBCDIC;
        }
        return Encoding.ASCII;
    }

    public static boolean isAscii(File fileToCheck) {
        byte[] fileBytes = Utils.readFileBytes(fileToCheck);
        if (fileBytes.length == 0) {
            log.error("Error: File contains 0 bytes");
            return false;
        }
        Encoding encoding = Utils.checkFile(fileBytes);
        return encoding == Encoding.ASCII;
    }

    public static boolean convertToEbcdic(File fileToConvert) {
        Path ipath = Paths.get(fileToConvert.getAbsolutePath(), new String[0]);
        Path opath = Paths.get(fileToConvert.getAbsolutePath() + "ebcdic", new String[0]);
        long fileSize = fileToConvert.length();
        long transferred = 0L;
        log.debug("Converting file " + fileToConvert.getAbsolutePath() + " from ASCII to EBCDIC");
        try {
            int nRead;
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
            InputStreamReader _reader = new InputStreamReader(Files.newInputStream(ipath, StandardOpenOption.READ), decoder);
            BufferedReader reader = new BufferedReader(_reader);
            CharsetEncoder encoder = Charset.forName("CP1047").newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("o".getBytes());
            OutputStreamWriter _writer = new OutputStreamWriter(Files.newOutputStream(opath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), encoder);
            BufferedWriter writer = new BufferedWriter(_writer);
            char[] buffer = new char[1024];
            while ((nRead = reader.read(buffer, 0, 1024)) >= 0) {
                writer.write(buffer, 0, nRead);
                transferred += (long)nRead;
            }
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            log.error("Error: Failed to convert ASCII file to EBCDIC");
            Controller.logStackTrace(e);
            return false;
        }
        if (transferred != fileSize) {
            log.error("Error: Tranfered number of bytes does not match size of input file.");
            return false;
        }
        try {
            Files.move(opath, ipath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            log.error("Error: Failed to replace original ASCII file with EBCDIC version");
            Controller.logStackTrace(e);
            return false;
        }
        return true;
    }

    public static void removeBlankLines(File file) {
        FileReader inFile = null;
        BufferedReader in = null;
        String crlf = System.getProperty("line.separator");
        try {
            inFile = new FileReader(file);
            in = new BufferedReader(inFile);
            String line = "";
            Vector<String> buffer = new Vector<String>();
            while (in.ready()) {
                line = in.readLine();
                if (line == null || line.isEmpty() || Utils.isLineAllWhiteSpace(line)) continue;
                buffer.add(line);
            }
            in.close();
            inFile.close();
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            for (String bufferLine : buffer) {
                if (bufferLine.endsWith(crlf)) {
                    output.write(bufferLine);
                    continue;
                }
                output.write(bufferLine + crlf);
            }
            output.close();
        }
        catch (Exception e) {
            log.info(e.getMessage());
            Controller.logStackTrace(e);
        }
    }

    private static boolean isLineAllWhiteSpace(String line) {
        return line.trim().isEmpty();
    }

    static enum Encoding {
        ASCII,
        EBCDIC,
        UNKNOWN;

    }
}

