/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.AuditLogger;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.listener.InstallationCompletionListener;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.listener.InstallationSetupListener;
import com.sas.tools.installs.it.listener.RebootListener;
import com.sas.tools.installs.it.listener.RollbackProgressListener;
import com.sas.tools.installs.it.listener.WarningListener;
import com.sas.tools.installs.it.schema.install.gen.InstallType;
import com.sas.tools.installs.it.schema.install.gen.Project;
import com.sas.tools.installs.it.schema.install.gen.Target;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.schema.ittasks.ItTasks;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class InstallationContext {
    protected Logger log = (Logger)LogManager.getLogger(this.getClass().getName());
    protected Controller _controller;
    protected List<InstallationCompletionListener> _installationCompletionListeners = new Vector<InstallationCompletionListener>();
    protected List<InstallationProgressListener> _installationProgressListeners = new Vector<InstallationProgressListener>();
    protected List<RollbackProgressListener> _rollbackProgressListeners = new Vector<RollbackProgressListener>();
    protected List<InstallationSetupListener> _installationSetupListeners = new Vector<InstallationSetupListener>();
    protected List<RebootListener> _rebootListeners = new Vector<RebootListener>();
    protected List<WarningListener> _warningListeners = new Vector<WarningListener>();
    protected Project _project;
    protected File _uninstallMetadata;
    protected File _payloadDir;
    protected Vector<String> _installLanguages = new Vector();
    protected String _uninstallableReason = null;
    protected AuditLogger _auditLogger;
    protected ItTasks _deployment;

    public InstallationContext() {
    }

    public InstallationContext(Controller controller) {
        this();
        this._controller = controller;
    }

    public void serializeUninstallMetadata(List<InstallationTask> tasks) throws Exception {
        if (this.getUninstallMetadata() == null) {
            return;
        }
        this.getProject().setMode("uninstall");
        this.migrateTasks(tasks);
        JAXBContext jc = JAXBContext.newInstance("com.sas.tools.installs.it.schema.install.gen", this.getClass().getClassLoader());
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
        m.marshal((Object)this.getProject(), new FileOutputStream(this.getUninstallMetadata()));
    }

    private void migrateTasks(List<InstallationTask> tasks) {
        HashMap<String, Target> targetMap = new HashMap<String, Target>();
        for (Target target : this.getProject().getTarget()) {
            targetMap.put(target.getName(), target);
        }
        block5: for (InstallationTask task : tasks) {
            InstallationTask.UninstallTarget uninstallTarget = task.getUninstallTarget();
            switch (uninstallTarget) {
                case SAME: {
                    break;
                }
                case PREINSTALL: 
                case INSTALL: 
                case POSTINSTALL: {
                    InstallType jaxbTask = task.getData();
                    String newTargetName = uninstallTarget.name().toLowerCase();
                    for (Target target : this.getProject().getTarget()) {
                        List<InstallType> targetTasks = target.getTasks();
                        if (newTargetName.equals(target.getName()) || !targetTasks.contains(jaxbTask)) continue;
                        ((Target)targetMap.get(newTargetName)).getTasks().add(jaxbTask);
                        targetTasks.remove(jaxbTask);
                    }
                    continue block5;
                }
                default: {
                    this.log.error("Unknown uninstall target value, skipping: " + (Object)((Object)uninstallTarget));
                }
            }
        }
    }

    public Controller getController() {
        return this._controller;
    }

    public void setController(Controller controller) {
        this._controller = controller;
    }

    public ItTasks getDeployment() {
        return this._deployment;
    }

    public void setDeployment(ItTasks deployment) {
        this._deployment = deployment;
    }

    public List<InstallationProgressListener> getInstallationProgressListeners() {
        return this._installationProgressListeners;
    }

    public void setInstallationProgressListeners(List<InstallationProgressListener> installationProgressListeners) {
        this._installationProgressListeners = installationProgressListeners;
    }

    public List<InstallationSetupListener> getInstallationSetupListeners() {
        return this._installationSetupListeners;
    }

    public List<RebootListener> getRebootListeners() {
        return this._rebootListeners;
    }

    public List<WarningListener> getWarningListeners() {
        return this._warningListeners;
    }

    public void setRebootListeners(List<RebootListener> rebootListeners) {
        this._rebootListeners = rebootListeners;
    }

    public void setInstallationSetupListeners(List<InstallationSetupListener> installationSetupListeners) {
        this._installationSetupListeners = installationSetupListeners;
    }

    protected List<RollbackProgressListener> getRollbackProgressListeners() {
        return this._rollbackProgressListeners;
    }

    protected void setRollbackProgressListeners(List<RollbackProgressListener> rollbackProgressListeners) {
        this._rollbackProgressListeners = rollbackProgressListeners;
    }

    public List<InstallationCompletionListener> getInstallationCompletionListeners() {
        return this._installationCompletionListeners;
    }

    public void setInstallationCompletionListeners(List<InstallationCompletionListener> installationCompletionListeners) {
        this._installationCompletionListeners = installationCompletionListeners;
    }

    public void addProgressListener(InstallationProgressListener listener) {
        this.getInstallationProgressListeners().add(listener);
    }

    public void removeProgressListener(InstallationProgressListener listener) {
        this.getInstallationProgressListeners().remove(listener);
    }

    public void addRollbackProgressListener(RollbackProgressListener listener) {
        this.getRollbackProgressListeners().add(listener);
    }

    public void removeRollbackProgressListener(RollbackProgressListener listener) {
        this.getRollbackProgressListeners().remove(listener);
    }

    public void addSetupListener(InstallationSetupListener listener) {
        this.getInstallationSetupListeners().add(listener);
    }

    public void removeSetupListener(InstallationSetupListener listener) {
        this.getInstallationSetupListeners().remove(listener);
    }

    public void addCompletionListener(InstallationCompletionListener listener) {
        this.getInstallationCompletionListeners().add(listener);
    }

    public void removeCompletionListener(InstallationCompletionListener listener) {
        this.getInstallationCompletionListeners().remove(listener);
    }

    public void addRebootListener(RebootListener listener) {
        this.getRebootListeners().add(listener);
    }

    public void removeRebootListener(RebootListener listener) {
        this.getRebootListeners().remove(listener);
    }

    public void addWarningListener(WarningListener listener) {
        this.getWarningListeners().add(listener);
    }

    public void removeWarningListener(WarningListener listener) {
        this.getWarningListeners().remove(listener);
    }

    public Project getProject() {
        return this._project;
    }

    public void setProject(Project project) {
        this._project = project;
    }

    public File getUninstallMetadata() {
        return this._uninstallMetadata;
    }

    public void setUninstallMetadata(File uninstallMetadata) {
        this._uninstallMetadata = uninstallMetadata;
    }

    public Vector<String> getInstallLanguages() {
        return this._installLanguages;
    }

    public void setInstallLanguages(Vector<String> installLanguages) {
        this._installLanguages = installLanguages;
    }

    public String getUninstallableReason() {
        return this._uninstallableReason;
    }

    public void setUninstallableReason(String uninstallableReason) {
        this._uninstallableReason = uninstallableReason;
    }

    public AuditLogger getAuditLogger() {
        return this._auditLogger;
    }

    public void setAuditLogger(AuditLogger auditLogger) {
        this._auditLogger = auditLogger;
    }

    public File getPayloadDir() {
        return this._payloadDir;
    }

    public void setPayloadDir(File payloadDir) {
        this._payloadDir = payloadDir;
        this.getController().setProperty("PayloadDir", payloadDir.getPath());
    }
}

