/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.tasks.InstallationTask;

public class InstallException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final int REMEDIATION_POSSIBLE = 0;
    public static final int UNRECOVERABLE_SYSTEM_ISSUE = 1;
    public static final int UNRECOVERABLE_PACKAGE_ISSUE = 2;
    public static final int UNRECOVERABLE_TOOL_ISSUE = 3;
    public static final int USER_CANCELLED = 4;
    private int _severity = 3;
    private InstallationTask _source;
    private String _logMessage;

    public InstallException() {
        this.setSeverity(0);
    }

    public InstallException(String message, Throwable originalException) {
        super(message, originalException);
    }

    public InstallException(int severity, InstallationTask source, String message, String logMessage, Throwable originalException) {
        super(message, originalException);
        this.setSeverity(severity);
        this.setSource(source);
        this.setLogMessage(logMessage);
    }

    public String logString() {
        String taskInfo;
        StringBuffer retval = new StringBuffer();
        if (this.getSeverity() == 0) {
            retval.append("There is a problem with the package being installed.  User remediation may be possible:\n" + this.getLogMessage());
        } else if (this.getSeverity() == 2) {
            retval.append("There is a problem with the package being installed:  " + this.getLogMessage());
        } else if (this.getSeverity() == 1) {
            retval.append("There is a problem that seems to be related to the system running the install:  " + this.getLogMessage());
        } else if (this.getSeverity() == 3) {
            retval.append("There is a problem that seems to be an issue with the installer:  " + this.getLogMessage());
        } else if (this.getSeverity() == 4) {
            retval.append("The user cancelled installation.  " + this.getLogMessage());
        }
        if (this.getSource() != null && (taskInfo = this.getSource().descriptionForLog()) != null) {
            retval.append("\nAdditional information about the task which threw the exception is shown below:\n" + taskInfo);
        }
        return retval.toString();
    }

    public int getSeverity() {
        return this._severity;
    }

    public void setSeverity(int severity) {
        this._severity = severity;
    }

    public InstallationTask getSource() {
        return this._source;
    }

    public void setSource(InstallationTask source) {
        this._source = source;
    }

    public String getLogMessage() {
        return this._logMessage;
    }

    public void setLogMessage(String logMessage) {
        this._logMessage = logMessage;
    }
}

